/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;

public abstract class LogicalObjectPropertiesDialog
extends AbstractPropertiesDialog {
    private JPanel pnEngineering;
    private JTable eTable;
    private List eList;

    public LogicalObjectPropertiesDialog(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    public LogicalObjectPropertiesDialog(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
    }

    protected JPanel getEngineeringPanel() {
        if (this.pnEngineering == null) {
            this.pnEngineering = this.createPage(PANEL_ENGINEERING_TO);
            this.eList = this.getEngineering();
            ETModel eTModel = new ETModel();
            this.eTable = new JTable(eTModel);
            this.eTable.setSelectionMode(0);
            TableColumn tableColumn = this.eTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(10);
            tableColumn = this.eTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(150);
            JScrollPane jScrollPane = new JScrollPane(this.eTable);
            this.pnEngineering.add(jScrollPane);
        }
        return this.pnEngineering;
    }

    private List getEngineering() {
        ArrayList<Object> arrayList;
        ArrayList<EngineerObject> arrayList2 = new ArrayList<EngineerObject>();
        Map map = this.getDesignObject().getEngineerTo();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList = objectArray[i];
            Object v = map.get(arrayList);
            RelationalDesign relationalDesign = (RelationalDesign)this.getDesignObject().getDesign().getRelationalDesigns().getById((String)((Object)arrayList));
            if (relationalDesign == null) continue;
            Boolean bl = "true".equals(v.toString());
            EngineerObject engineerObject = new EngineerObject(relationalDesign, bl);
            arrayList2.add(engineerObject);
        }
        Object[] objectArray2 = arrayList2.toArray();
        Arrays.sort(objectArray2, new ListComparator());
        arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray2.length; ++i) {
            arrayList.add(objectArray2[i]);
        }
        return arrayList;
    }

    protected void setEngineering() {
        this.getDesignObject().clearEngineerTo();
        for (EngineerObject engineerObject : this.eList) {
            this.getDesignObject().setEngineerTo(engineerObject.getDesign().getObjectID(), engineerObject.engineer);
        }
    }

    private class EngineerObject {
        private boolean engineer;
        private RelationalDesign design;

        public EngineerObject(RelationalDesign relationalDesign, boolean bl) {
            this.engineer = bl;
            this.design = relationalDesign;
        }

        public boolean isEngineer() {
            return this.engineer;
        }

        public void setEngineer(boolean bl) {
            this.engineer = bl;
        }

        public RelationalDesign getDesign() {
            return this.design;
        }
    }

    public class ETModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return LogicalObjectPropertiesDialog.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("LogicalObjectPropertiesDialog.Engineer");
            }
            if (n == 1) {
                return Messages.getString("LogicalObjectPropertiesDialog.RelationalDesign");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!LogicalObjectPropertiesDialog.this.isEditable()) {
                return false;
            }
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            EngineerObject engineerObject = (EngineerObject)LogicalObjectPropertiesDialog.this.eList.get(n);
            if (n2 == 0) {
                return engineerObject.isEngineer();
            }
            if (n2 == 1) {
                return engineerObject.getDesign().getName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            EngineerObject engineerObject = (EngineerObject)LogicalObjectPropertiesDialog.this.eList.get(n);
            if (n2 == 0) {
                engineerObject.setEngineer((Boolean)object);
            }
        }
    }

    private class ListComparator
    implements Comparator {
        private ListComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((EngineerObject)object).getDesign().getName().compareTo(((EngineerObject)object2).getDesign().getName());
        }
    }
}

