/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;

public class InheritanceRelationPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private InheritanceRelation relation;
    private JTextField tfLongName;
    private JComboBox cbSource;
    private JComboBox cbTarget;

    public InheritanceRelationPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("InheritanceRelationPropertiesDialogEx.InheritanceRelationProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof InheritanceRelation) {
            this.relation = (InheritanceRelation)designObject;
            this.initDefaults();
            this.tfLongName.setText(this.relation.toString());
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbSource, false);
            this.cbSource.setSelectedItem(this.relation.getSourceEntity());
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbTarget, false);
            this.cbTarget.setSelectedItem(this.relation.getTargetEntity());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.relation.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.relation.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.relation.setName(this.tfName.getText());
        this.relation.setComment(this.taComments.getText());
        this.relation.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.relation.setNotes(this.taNotes.getText());
        this.relation.setSourceEntity((Entity)this.cbSource.getSelectedItem());
        this.relation.setTargetEntity((Entity)this.cbTarget.getSelectedItem());
        this.relation.setSourceTV(this.relation.getSourceTVEntity());
        this.relation.setTargetTV(this.relation.getTargetTVEntity());
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        InheritanceRelationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.relation.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.relation.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
        this.tfLongName.setText(this.relation.toString());
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getEngineeringPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INHERITANCE_RELATION_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_LONG_NAME);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfLongName));
        JLabel jLabel2 = new JLabel(LB_SUPER_TYPE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbSource = new JComboBox();
        this.cbSource.setPreferredSize(this.getDefaultSize());
        this.cbSource.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbSource));
        JLabel jLabel3 = new JLabel(LB_SUB_TYPE);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbTarget = new JComboBox();
        this.cbTarget.setPreferredSize(this.getDefaultSize());
        this.cbTarget.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbTarget));
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        return null;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }
}

