/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.EntityViewSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;

public class EntityViewBuilder
extends JPanel {
    public static final String MODIFY_LABEL = Messages.getString("EntityViewBuilder.Modify");
    public static final String ADD_LABEL = Messages.getString("EntityViewBuilder.Add");
    protected JDialog dialog;
    protected JPanel buttonPanel;
    protected JTabbedPane tpane;
    protected JPanel general;
    protected JPanel tablesPanel = new JPanel(new SpringLayout());
    protected JPanel columnsPanel = new JPanel(new SpringLayout());
    protected JPanel wherePanel = new JPanel(new SpringLayout());
    protected JPanel groupByPanel = new JPanel(new SpringLayout());
    protected JPanel havingPanel = new JPanel(new SpringLayout());
    protected JPanel orderByPanel = new JPanel(new SpringLayout());
    protected JPanel previewPanel = new JPanel(new SpringLayout());
    protected JPanel ddlPanel = new JPanel(new SpringLayout());
    protected JTextArea sqlArea = new JTextArea();
    protected JTextArea defineDDLArea = new JTextArea();
    protected JTextArea whereArea = new JTextArea();
    protected JTextArea groupByArea = new JTextArea();
    protected JTextArea havingArea = new JTextArea();
    protected JCheckBox defineDDLChBox;
    protected JButton defineWhere;
    protected DefaultListModel allTablesModel;
    protected JList allTablesList;
    protected SelectedTablesTable selectedTablesTable;
    protected JButton bnAddTables;
    protected JButton bnRemoveTables;
    protected JButton bnMoveUpTable;
    protected JButton bnMoveDownTable;
    private List containerList = new ArrayList();
    protected DefaultListModel allColumnsModel;
    protected JList allColumnsList;
    protected JTable selectedColumnsTable;
    protected JButton bnAddColumns;
    protected JButton bnRemoveColumns;
    protected JButton bnNewExpression;
    private List attributeViewList = new ArrayList();
    protected DefaultListModel allColumnsOrderByModel;
    protected JList allColumnsOrderByList;
    protected SelectedOrderByColumnsTable selectedOrderByColumnsTable;
    protected JButton bnAddOrderByColumns;
    protected JButton bnRemoveOrderByColumns;
    protected JButton bnNewOrderByColumns;
    private List orderByList = new ArrayList();
    protected EntityView view;
    protected LogicalDesign design;
    private ContainerObject contObject;
    private List expressionList = new ArrayList();

    public EntityViewBuilder(ContainerObject containerObject) {
        this.contObject = containerObject;
    }

    public JDialog getDialog(ApplicationView applicationView) {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)applicationView.getFrame(), Messages.getString("EntityViewBuilder.ViewBuilder"));
            this.general = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.general, "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "East");
            this.tpane = new JTabbedPane();
            this.general.add((Component)this.tpane, "Center");
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Entities"), this.tablesPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Attributes"), this.columnsPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Where"), this.wherePanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.GroupBy"), this.groupByPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Having"), this.havingPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.OrderBy"), this.orderByPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Preview"), this.previewPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.DefineDDL"), this.ddlPanel);
            this.tpane.addChangeListener(new TabChangeListener());
            this.initTablesPane();
            this.initColumnsPane();
            this.initWherePane();
            this.initGroupByPane();
            this.initHavingPane();
            this.initOrderByPane();
            this.initPreviewPane();
            this.initDefineDDLPane();
            this.dialog.setModal(true);
            this.dialog.setSize(new Dimension(775, 355));
            this.dialog.setResizable(false);
        }
        CommonUtil.centerOnScreen(this.dialog);
        this.clear();
        this.initProperties(this.contObject);
        return this.dialog;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 5));
            JButton jButton = new JButton(Messages.getString("EntityViewBuilder.OK"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedTablesTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedColumnsTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedOrderByColumnsTable);
                    if (EntityViewBuilder.this.canExit()) {
                        EntityViewBuilder.this.setProperties();
                        EntityViewBuilder.this.dialog.dispose();
                    }
                }
            });
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            JButton jButton2 = new JButton(Messages.getString("EntityViewBuilder.Apply"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedTablesTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedColumnsTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedOrderByColumnsTable);
                    if (EntityViewBuilder.this.canExit()) {
                        EntityViewBuilder.this.setProperties();
                    }
                }
            });
            jButton2.setCursor(Cursor.getPredefinedCursor(12));
            jButton2.setMnemonic(65);
            JButton jButton3 = new JButton(Messages.getString("EntityViewBuilder.Cancel"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewBuilder.this.dialog.dispose();
                }
            });
            jButton3.setMnemonic(67);
            jButton3.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            this.buttonPanel.add((Component)jPanel, "North");
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel jPanel) {
        return (SpringLayout)jPanel.getLayout();
    }

    protected void initTablesPane() {
        this.initAllTablesList();
        this.initSelectedTablesList();
        this.initTablesButtons();
    }

    protected void initColumnsPane() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    protected void initWherePane() {
        JScrollPane jScrollPane = new JScrollPane(this.whereArea);
        jScrollPane.setPreferredSize(new Dimension(645, 285));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.wherePanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.wherePanel), jScrollPane, 10, 12);
    }

    protected void initGroupByPane() {
        JScrollPane jScrollPane = new JScrollPane(this.groupByArea);
        this.groupByArea.setEditable(false);
        jScrollPane.setPreferredSize(new Dimension(645, 285));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.groupByPanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.groupByPanel), jScrollPane, 10, 12);
    }

    protected void initHavingPane() {
        JScrollPane jScrollPane = new JScrollPane(this.havingArea);
        jScrollPane.setPreferredSize(new Dimension(645, 285));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.havingPanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.havingPanel), jScrollPane, 10, 12);
    }

    protected void initOrderByPane() {
        this.initAllColumnsOrderByList();
        this.initSelectedColumnsOrderByList();
        this.initColumnsOrderByButtons();
    }

    protected void initPreviewPane() {
        JScrollPane jScrollPane = new JScrollPane(this.sqlArea);
        jScrollPane.setPreferredSize(new Dimension(645, 285));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.previewPanel.add(jScrollPane);
        this.sqlArea.setEnabled(false);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.previewPanel), jScrollPane, 10, 12);
    }

    protected void initDefineDDLPane() {
        this.defineDDLChBox = new JCheckBox(Messages.getString("EntityViewBuilder.UserDefinedDDL"));
        this.defineDDLChBox.addActionListener(new CheckBoxListener());
        this.ddlPanel.add(this.defineDDLChBox);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), this.defineDDLChBox, 10, 12);
        JScrollPane jScrollPane = new JScrollPane(this.defineDDLArea);
        jScrollPane.setPreferredSize(new Dimension(645, 255));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.ddlPanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), jScrollPane, 10, 42);
    }

    protected void initAllTablesList() {
        JLabel jLabel = new JLabel(Messages.getString("EntityViewBuilder.AvailableEntities"));
        this.tablesPanel.add(jLabel);
        this.allTablesModel = new DefaultListModel();
        this.allTablesList = new JList(this.allTablesModel);
        ListSelectionModel listSelectionModel = this.allTablesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListTablesSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allTablesList);
        jScrollPane.setPreferredSize(new Dimension(210, 265));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tablesPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.tablesPanel), jLabel, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), jScrollPane, 10, 32);
    }

    protected void initSelectedTablesList() {
        this.selectedTablesTable = new SelectedTablesTable();
        this.selectedTablesTable.setModel(new SelectedTablesModel());
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        MoveUpDownListJTable moveUpDownListJTable = new MoveUpDownListJTable(this.containerList, this.selectedTablesTable);
        this.bnMoveUpTable = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveDownTable);
        jPanel.add((Component)jToolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedTablesTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedTablesHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedTablesTable);
        jScrollPane.setPreferredSize(new Dimension(325, 248));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        jPanel.add((Component)jScrollPane, "Center");
        this.tablesPanel.add(jPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), jPanel, 332, 14);
    }

    protected void initTablesButtons() {
        this.bnAddTables = new JButton(ADD_LABEL);
        this.bnAddTables.addActionListener(new AddTablesActionListener());
        this.bnAddTables.setPreferredSize(new Dimension(90, 26));
        this.bnAddTables.setEnabled(false);
        this.tablesPanel.add(this.bnAddTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnAddTables, 232, 32);
        this.bnRemoveTables = new JButton(Messages.getString("EntityViewBuilder.Remove"));
        this.bnRemoveTables.setEnabled(false);
        this.bnRemoveTables.addActionListener(new RemoveTablesActionListener());
        this.bnRemoveTables.setPreferredSize(new Dimension(90, 26));
        this.tablesPanel.add(this.bnRemoveTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnRemoveTables, 232, 62);
    }

    protected void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("EntityViewBuilder.AvailableAttributes"));
        this.columnsPanel.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new AllListColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(210, 265));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.columnsPanel), jLabel, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), jScrollPane, 10, 32);
    }

    protected void initSelectedColumnsList() {
        this.selectedColumnsTable = new JTable();
        this.selectedColumnsTable.setModel(new SelectedAttributesModel());
        this.selectedColumnsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn tableColumn = null;
        block5: for (int i = 0; i < 3; ++i) {
            tableColumn = this.selectedColumnsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setCellEditor(new ExpressionCellEditor());
                    tableColumn.setPreferredWidth(120);
                    continue block5;
                }
                case 1: {
                    tableColumn.setCellRenderer(new LabelTableCellRenderer());
                    tableColumn.setCellEditor(new TextCellEditor());
                    tableColumn.setPreferredWidth(60);
                    continue block5;
                }
                case 2: {
                    tableColumn.setCellRenderer(new CheckBoxTableCellRenderer());
                    tableColumn.setCellEditor(new CheckBoxEditor());
                    tableColumn.setPreferredWidth(40);
                }
            }
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        MoveUpDownListJTable moveUpDownListJTable = new MoveUpDownListJTable(this.attributeViewList, this.selectedColumnsTable);
        this.bnMoveUpTable = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveDownTable);
        jPanel.add((Component)jToolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(325, 248));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        jPanel.add((Component)jScrollPane, "Center");
        this.columnsPanel.add(jPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), jPanel, 332, 14);
    }

    protected void initColumnsButtons() {
        this.bnAddColumns = new JButton(ADD_LABEL);
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddColumns.setEnabled(false);
        this.columnsPanel.add(this.bnAddColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnAddColumns, 232, 32);
        this.bnNewExpression = new JButton(Messages.getString("EntityViewBuilder.New"));
        this.bnNewExpression.setEnabled(false);
        this.bnNewExpression.addActionListener(new NewExpressionActionListener());
        this.bnNewExpression.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnNewExpression);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnNewExpression, 232, 62);
        this.bnRemoveColumns = new JButton(Messages.getString("EntityViewBuilder.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.bnRemoveColumns.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnRemoveColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnRemoveColumns, 232, 92);
    }

    protected void initAllColumnsOrderByList() {
        JLabel jLabel = new JLabel(Messages.getString("EntityViewBuilder.AvailableAttributes"));
        this.orderByPanel.add(jLabel);
        this.allColumnsOrderByModel = new DefaultListModel();
        this.allColumnsOrderByList = new JList(this.allColumnsOrderByModel);
        this.allColumnsOrderByList.setCellRenderer(new AllListOrderByColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsOrderByList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsOrderBySelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsOrderByList);
        jScrollPane.setPreferredSize(new Dimension(210, 265));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.orderByPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.orderByPanel), jLabel, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), jScrollPane, 10, 32);
    }

    protected void initSelectedColumnsOrderByList() {
        this.selectedOrderByColumnsTable = new SelectedOrderByColumnsTable();
        this.selectedOrderByColumnsTable.setModel(new SelectedOrderByColumnsModel());
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        MoveUpDownListJTable moveUpDownListJTable = new MoveUpDownListJTable(this.orderByList, this.selectedOrderByColumnsTable);
        this.bnMoveUpTable = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveDownTable);
        jPanel.add((Component)jToolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedOrderByColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedOrderByColumnsHandler());
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this.selectedOrderByColumnsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(120);
                continue;
            }
            if (i != 1) continue;
            tableColumn.setPreferredWidth(60);
        }
        JScrollPane jScrollPane = new JScrollPane(this.selectedOrderByColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(325, 248));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        jPanel.add((Component)jScrollPane, "Center");
        this.orderByPanel.add(jPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), jPanel, 332, 14);
    }

    protected void initColumnsOrderByButtons() {
        this.bnAddOrderByColumns = new JButton(ADD_LABEL);
        this.bnAddOrderByColumns.addActionListener(new AddOrderByColumnsActionListener());
        this.bnAddOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddOrderByColumns.setEnabled(false);
        this.orderByPanel.add(this.bnAddOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnAddOrderByColumns, 232, 32);
        this.bnNewOrderByColumns = new JButton(Messages.getString("EntityViewBuilder.New"));
        this.bnNewOrderByColumns.setEnabled(false);
        this.bnNewOrderByColumns.addActionListener(new NewOrderByColumnsActionListener());
        this.bnNewOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnNewOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnNewOrderByColumns, 232, 62);
        this.bnRemoveOrderByColumns = new JButton(Messages.getString("EntityViewBuilder.Remove"));
        this.bnRemoveOrderByColumns.setEnabled(false);
        this.bnRemoveOrderByColumns.addActionListener(new RemoveOrderByColumnsActionListener());
        this.bnRemoveOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnRemoveOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnRemoveOrderByColumns, 232, 92);
    }

    private String appendQuotes(String string) {
        if (string.trim().indexOf(32) > -1) {
            return "\"" + string + "\"";
        }
        return string;
    }

    private boolean hasGroupBy() {
        for (AttributeElement attributeElement : this.attributeViewList) {
            if (!attributeElement.getGroupBy()) continue;
            return true;
        }
        return false;
    }

    protected String generateGroupBy() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (AttributeElement attributeElement : this.attributeViewList) {
            if (!attributeElement.getGroupBy()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.appendQuotes(this.getValue(attributeElement.getAttributeView())));
        }
        return stringBuffer.toString();
    }

    protected String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.selectedColumnsTable.getRowCount() > 0) {
            Object object;
            Object object2;
            this.stopTableCellEditing(this.selectedColumnsTable);
            stringBuffer = new StringBuffer("CREATE VIEW ");
            stringBuffer.append(this.appendQuotes(this.view.getName()));
            int n = 0;
            for (Object object3 : this.attributeViewList) {
                object2 = ((AttributeElement)object3).getAttributeView();
                object = ((AbstractViewElement)object2).getAlias().trim();
                if ("".equals(object)) {
                    object = ((AttributeElement)object3).getAlias();
                }
                if (((AbstractViewElement)object2).toString().trim().equalsIgnoreCase("")) continue;
                if (n == 0) {
                    stringBuffer.append("\n");
                    stringBuffer.append("  (");
                } else {
                    stringBuffer.append(",\n   ");
                }
                stringBuffer.append(' ');
                if (!((String)object).trim().equalsIgnoreCase("")) {
                    stringBuffer.append(this.appendQuotes((String)object));
                } else {
                    stringBuffer.append(this.appendQuotes(((AbstractViewElement)object2).getReferencedName()));
                }
                ++n;
            }
            stringBuffer.append(' ');
            stringBuffer.append(')');
            stringBuffer.append("\n");
            stringBuffer.append("AS SELECT\n   ");
            n = 0;
            for (Object object3 : this.attributeViewList) {
                object2 = ((AttributeElement)object3).getAlias().trim();
                object = ((AttributeElement)object3).getAttributeView();
                if (((AttributeElement)object3).getAttributeView().toString().equalsIgnoreCase("")) continue;
                if (n > 0) {
                    stringBuffer.append(",\n   ");
                }
                stringBuffer.append(' ');
                if (((AttributeElement)object3).getAttributeView().getEntityAlias().equalsIgnoreCase("")) {
                    if (!((AbstractViewElement)object).getExpression().equals("")) {
                        stringBuffer.append(this.appendQuotes(((AbstractViewElement)object).getExpression()));
                        if (!"".equals(object2)) {
                            stringBuffer.append(" ").append((String)object2);
                        }
                    } else if (((AttributeElement)object3).getAlias().equalsIgnoreCase("")) {
                        stringBuffer.append(this.appendQuotes(((AttributeElement)object3).getAttributeView().getAlias()));
                    } else {
                        stringBuffer.append(this.appendQuotes(((AttributeElement)object3).getAttributeView().getName()));
                    }
                } else {
                    String string = ((AttributeElement)object3).getAttributeView().getEntityAlias().trim();
                    if (!((AbstractViewElement)object).getExpression().equals("")) {
                        stringBuffer.append(this.appendQuotes(((AbstractViewElement)object).getExpression()));
                        if (!"".equals(object2)) {
                            stringBuffer.append(" ").append((String)object2);
                        }
                    } else if (!"".equals(string)) {
                        stringBuffer.append(this.appendQuotes(string) + "." + this.appendQuotes(((AttributeElement)object3).getAttributeView().getReferencedName()));
                    } else {
                        stringBuffer.append(this.appendQuotes(((AttributeElement)object3).getAttributeView().getReferencedName()));
                    }
                }
                ++n;
            }
            if (this.containerList.size() > 0) {
                if (this.containerList.size() > 0) {
                    stringBuffer.append("\n");
                    stringBuffer.append(" FROM \n");
                }
                n = 0;
                for (Object object3 : this.containerList) {
                    if (n > 0) {
                        stringBuffer.append(",\n    ");
                    } else {
                        stringBuffer.append("    ");
                    }
                    if (((ContainerElement)object3).getContainerObject() != null) {
                        object2 = ((ContainerElement)object3).getContainerObject().getName();
                        object = ((ContainerElement)object3).getContainerAlias();
                        stringBuffer.append(this.appendQuotes((String)object2));
                        if (!((String)object2).trim().equalsIgnoreCase((String)object)) {
                            stringBuffer.append(' ');
                            stringBuffer.append(this.appendQuotes((String)object));
                        }
                    }
                    ++n;
                }
            }
            if (!this.whereArea.getText().trim().equalsIgnoreCase("")) {
                stringBuffer.append("\n");
                stringBuffer.append(" WHERE \n");
                stringBuffer.append("    ");
                stringBuffer.append(this.whereArea.getText());
            }
            if (this.hasGroupBy()) {
                stringBuffer.append("\n");
                stringBuffer.append(" GROUP BY \n");
                stringBuffer.append(this.generateGroupBy());
            }
            if (!this.havingArea.getText().trim().equalsIgnoreCase("")) {
                stringBuffer.append("\n");
                stringBuffer.append(" HAVING \n");
                stringBuffer.append("    ");
                stringBuffer.append(this.havingArea.getText());
            }
            if (this.orderByList.size() > 0) {
                stringBuffer.append("\n");
                stringBuffer.append(" ORDER BY \n");
                n = 0;
                for (Object object3 : this.orderByList) {
                    object2 = "";
                    object = ((OrderByElement)object3).getSort();
                    for (AttributeElement attributeElement : this.attributeViewList) {
                        if (!((OrderByElement)object3).getContainedObject().getName().equalsIgnoreCase(attributeElement.getAttributeView().getName())) continue;
                        object2 = attributeElement.getAlias();
                        break;
                    }
                    if (((String)object2).equalsIgnoreCase("")) {
                        object2 = ((OrderByElement)object3).getContainedObject().getName();
                    }
                    if (n > 0) {
                        stringBuffer.append(",\n   ");
                    } else {
                        stringBuffer.append("   ");
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(this.appendQuotes((String)object2));
                    stringBuffer.append(' ');
                    stringBuffer.append((String)object);
                    ++n;
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public void initProperties(ContainerObject containerObject) {
        if (containerObject instanceof EntityView) {
            Object object;
            DesignObject designObject;
            this.view = (EntityView)containerObject;
            this.design = (LogicalDesign)this.view.getDesignPart();
            EntitySet entitySet = this.design.getEntitySet();
            EntityViewSet entityViewSet = this.design.getEntityViewSet();
            Iterator iterator = entitySet.iterator();
            while (iterator.hasNext()) {
                this.allTablesModel.addElement(iterator.next());
            }
            iterator = entityViewSet.iterator();
            while (iterator.hasNext()) {
                designObject = (EntityView)iterator.next();
                if (designObject == this.view) continue;
                this.allTablesModel.addElement(designObject);
            }
            for (int i = 0; i < this.view.getElements().length; ++i) {
                designObject = (AttributeView)this.view.getElements()[i];
                if (this.view.getGroupByList().contains(designObject)) {
                    this.attributeViewList.add(new AttributeElement((AttributeView)designObject, ((AbstractViewElement)designObject).getAlias(), true));
                } else {
                    this.attributeViewList.add(new AttributeElement((AttributeView)designObject, ((AbstractViewElement)designObject).getAlias(), false));
                }
                if (((AbstractViewElement)designObject).getExpression().equalsIgnoreCase("")) continue;
                object = new ColumnAlias((ContainedObject)designObject, ((AbstractViewElement)designObject).getTableAlias());
                this.expressionList.add(object);
                this.allColumnsOrderByModel.addElement(object);
            }
            this.enableAll(!this.view.getUserDefined());
            this.whereArea.setText(this.view.getWhere());
            this.groupByArea.setText(this.view.getGroupBy());
            this.havingArea.setText(this.view.getHaving());
            if (!this.view.getUserDefined()) {
                for (Object object2 : this.view.getUsedContainers()) {
                    object = ((AbstractView.ContainerHolder)object2).getAlias();
                    ContainerObject containerObject2 = ((AbstractView.ContainerHolder)object2).getContainer();
                    if (containerObject2 != null) {
                        ContainedObject[] containedObjectArray = containerObject2.getElements();
                        for (int i = 0; i < containedObjectArray.length; ++i) {
                            ContainedObject containedObject = containedObjectArray[i];
                            this.allColumnsModel.addElement(new ColumnAlias(containedObject, (String)object));
                            this.allColumnsOrderByModel.addElement(new ColumnAlias(containedObject, (String)object));
                        }
                    }
                    if (containerObject2 != null) {
                        this.containerList.add(new ContainerElement(containerObject2, (String)object));
                        continue;
                    }
                    this.view.getContainerMap().remove(object);
                }
                for (Object object2 : this.view.getOrderByList()) {
                    this.orderByList.add(new OrderByElement((ContainedObject)object2, this.view.getOrderByMap().get(((ModelIDObject)object2).getObjectID()).toString()));
                }
                this.sqlArea.setText(this.generateSQL());
                this.defineDDLChBox.setSelected(false);
                this.defineDDLArea.setEnabled(false);
                this.defineDDLArea.setText("");
            } else {
                this.defineDDLChBox.setSelected(true);
                this.defineDDLArea.setEnabled(true);
                this.defineDDLArea.setText(this.view.getUserDefinedSQL());
            }
        }
    }

    protected void setProperties() {
        this.stopTableCellEditing(this.selectedTablesTable);
        this.stopTableCellEditing(this.selectedColumnsTable);
        this.stopTableCellEditing(this.selectedOrderByColumnsTable);
        if (this.view != null) {
            if (this.defineDDLChBox.isSelected()) {
                this.view.setUserDefined(true);
                String string = this.defineDDLArea.getText();
                if (!this.getViewName(string).trim().equalsIgnoreCase("")) {
                    this.view.setName(this.getViewName(string));
                }
                this.view.setUserDefinedSQL(string);
                this.view.removeAllElements();
                this.view.removeAllFromElements();
                this.view.removeAllFromOrderBy();
                this.view.removeAllGroupByList();
                this.view.setWhere("");
                this.view.setGroupBy("");
                this.view.setHaving("");
                this.view.getElements(string.replaceAll("\n", " ").replaceAll("   ", " ").replaceAll("  ", " "));
            } else {
                Object object2;
                this.view.setUserDefined(false);
                this.view.setUserDefinedSQL(this.generateSQL());
                this.view.removeAllFromElements();
                for (Object object2 : this.containerList) {
                    this.view.addToContainers(((ContainerElement)object2).getContainerObject(), ((ContainerElement)object2).getContainerAlias());
                }
                object2 = new ArrayList();
                for (Object object3 : this.view.getElementsCollection()) {
                    if (((ContainedObject)object3).getName().trim().equalsIgnoreCase("")) continue;
                    boolean bl = false;
                    for (AttributeElement attributeElement : this.attributeViewList) {
                        if (!attributeElement.getAttributeView().getName().equalsIgnoreCase(((ContainedObject)object3).getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    ((ArrayList)object2).add(object3);
                }
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    this.view.clear((AttributeView)iterator.next());
                }
                this.view.removeAllElements();
                this.view.removeAllGroupByList();
                for (Object object3 : this.attributeViewList) {
                    if (((AttributeElement)object3).getAttributeView().getName().equalsIgnoreCase("")) continue;
                    if (((AttributeElement)object3).getAttributeView().getReferencedColumnView() != null) {
                        if (((AttributeElement)object3).getAlias().equalsIgnoreCase("")) {
                            ((AttributeElement)object3).getAttributeView().setAlias(((AttributeView)((AttributeElement)object3).getAttributeView().getReferencedColumnView()).getAlias());
                        } else {
                            ((AttributeElement)object3).getAttributeView().setAlias(((AttributeElement)object3).getAlias());
                        }
                    } else {
                        ((AttributeElement)object3).getAttributeView().setAlias(((AttributeElement)object3).getAlias());
                    }
                    this.view.add(((AttributeElement)object3).getAttributeView());
                    if (!((AttributeElement)object3).getGroupBy()) continue;
                    this.view.addGroupByList(((AttributeElement)object3).getAttributeView());
                }
                this.view.removeAllFromOrderBy();
                for (Object object3 : this.orderByList) {
                    this.view.addToOrderBy(((OrderByElement)object3).getContainedObject(), ((OrderByElement)object3).getSort());
                }
                this.view.setWhere(this.whereArea.getText());
                this.view.setGroupBy(this.generateGroupBy());
                this.view.setHaving(this.havingArea.getText());
            }
            this.view.setDirty(true);
        }
    }

    protected void clear() {
        this.allTablesModel.clear();
        Iterator iterator = this.containerList.iterator();
        while (iterator.hasNext()) {
            this.containerList.remove(0);
        }
        this.allColumnsModel.clear();
        int n = this.selectedColumnsTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.attributeViewList.remove(0);
        }
        this.allColumnsOrderByModel.clear();
        iterator = this.orderByList.iterator();
        while (iterator.hasNext()) {
            this.orderByList.remove(0);
        }
    }

    private String getViewName(String string) {
        StringTokenizer stringTokenizer;
        String string2 = "";
        String string3 = "";
        String[] stringArray = string.split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("VIEW")) continue;
            string3 = stringArray[i + 1];
            break;
        }
        if ((stringTokenizer = new StringTokenizer(string3, ".")).countTokens() == 2) {
            string2 = stringTokenizer.nextToken().trim();
            string2 = Token.getValBetweenSquareBrackets(string2);
            string3 = stringTokenizer.nextToken().trim();
            string3 = Token.getValBetweenSquareBrackets(string3);
        }
        return string3;
    }

    private void enableAll(boolean bl) {
        this.whereArea.setEnabled(bl);
        this.groupByArea.setEnabled(bl);
        this.havingArea.setEnabled(bl);
        this.allTablesList.setEnabled(bl);
        this.allColumnsList.setEnabled(bl);
        this.bnNewExpression.setEnabled(bl);
        this.selectedTablesTable.setEnabled(bl);
        this.selectedColumnsTable.setEnabled(bl);
        this.selectedOrderByColumnsTable.setEnabled(bl);
        this.bnNewOrderByColumns.setEnabled(bl);
        this.allColumnsOrderByList.setEnabled(bl);
        if (!bl) {
            this.allTablesList.setSelectedIndices(new int[0]);
            this.allColumnsList.setSelectedIndices(new int[0]);
            this.allColumnsOrderByList.setSelectedIndices(new int[0]);
            this.selectedTablesTable.clearSelection();
            this.selectedColumnsTable.clearSelection();
            this.selectedOrderByColumnsTable.clearSelection();
        }
    }

    protected boolean canExit() {
        Object object;
        Object object2;
        Object object3;
        int n = 1;
        Object[] objectArray = this.containerList.toArray();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            n = i + 1;
            ContainerElement containerElement = (ContainerElement)objectArray[i];
            object3 = containerElement.getContainerObject();
            object2 = containerElement.getContainerAlias();
            for (int j = n; j < objectArray.length; ++j) {
                object = ((ContainerElement)objectArray[j]).getContainerObject();
                String string = ((ContainerElement)objectArray[j]).getContainerAlias();
                if (!string.equalsIgnoreCase("") && !((String)object2).equalsIgnoreCase("") && string.equalsIgnoreCase((String)object2)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.EntitiesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (!string.equalsIgnoreCase("") || !((String)object2).equalsIgnoreCase("") || !((DesignObject)object3).getName().equalsIgnoreCase(((DesignObject)object).getName())) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.EntitiesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        Object[] objectArray2 = this.attributeViewList.toArray();
        for (int i = 0; i <= objectArray2.length - 1; ++i) {
            n = i + 1;
            object3 = (AttributeElement)objectArray2[i];
            object2 = ((AttributeElement)object3).getAttributeView();
            String string = ((AttributeElement)object3).getAlias();
            object = ((AbstractViewElement)object2).getExpression();
            if (!this.checkExpression((String)object, string)) {
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributeExpressionsWithoutAlias"), Messages.getString("EntityViewBuilder.EmptyAlias"), 0);
                return false;
            }
            for (int j = n; j <= objectArray2.length - 1; ++j) {
                AttributeView attributeView = ((AttributeElement)objectArray2[j]).getAttributeView();
                String string2 = ((AttributeElement)objectArray2[j]).getAlias();
                if (string2.equalsIgnoreCase("") && string.equalsIgnoreCase("")) {
                    if (!((AbstractViewElement)object2).getReferencedName().equalsIgnoreCase(attributeView.getReferencedName())) continue;
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (string2.equalsIgnoreCase(string)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if ((!string.equalsIgnoreCase("") || !string2.equalsIgnoreCase(((ContainedObject)object2).getName())) && (!string2.equalsIgnoreCase("") || !string.equalsIgnoreCase(attributeView.getName()))) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        return true;
    }

    public List getAttributeViewList() {
        return this.attributeViewList;
    }

    public List getContainerList() {
        return this.containerList;
    }

    public void setContainerList(List list) {
        this.containerList = list;
    }

    private String getValue(AttributeView attributeView) {
        String string = attributeView.getReferencedName();
        ContainerObject containerObject = attributeView.getReferencedContainer();
        if (!attributeView.getEntityAlias().equalsIgnoreCase("")) {
            return string + "(" + attributeView.getEntityAlias() + ")";
        }
        if (containerObject != null) {
            return string + "(" + containerObject.getName() + ")";
        }
        if (!attributeView.getExpression().equalsIgnoreCase("")) {
            return attributeView.getExpression();
        }
        return string;
    }

    private void checkOrderByModel() {
        for (ColumnAlias columnAlias : this.expressionList) {
            if (this.allColumnsOrderByModel.contains(columnAlias)) continue;
            this.allColumnsOrderByModel.addElement(columnAlias);
        }
    }

    private ColumnAlias getColumnAlias(AttributeView attributeView) {
        for (ColumnAlias columnAlias : this.expressionList) {
            if (columnAlias.getCol() != attributeView) continue;
            return columnAlias;
        }
        return null;
    }

    private void checkModelsForValues(ContainerElement containerElement, String string, String string2) {
        ColumnAlias columnAlias;
        for (int i = 0; i < this.allColumnsModel.size(); ++i) {
            columnAlias = (ColumnAlias)this.allColumnsModel.elementAt(i);
            if (!columnAlias.getTableAlias().equalsIgnoreCase(string) || !columnAlias.getCol().getContainer().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) continue;
            columnAlias.setTableAlias(string2);
            this.allColumnsModel.setElementAt(columnAlias, i);
        }
        containerElement.setContainerAlias(string2);
        for (AttributeElement attributeElement : this.attributeViewList) {
            if ((!attributeElement.getAttributeView().getTableAlias().equalsIgnoreCase(string) || attributeElement.getAttributeView().getEntity() == null || !attributeElement.getAttributeView().getEntity().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) && (attributeElement.getAttributeView().getView() == null || !attributeElement.getAttributeView().getView().getName().equalsIgnoreCase(containerElement.getContainerObject().getName()))) continue;
            attributeElement.getAttributeView().setEntityAlias(string2);
        }
        for (int i = 0; i < this.allColumnsOrderByModel.size(); ++i) {
            columnAlias = (ColumnAlias)this.allColumnsOrderByModel.elementAt(i);
            if (!columnAlias.getTableAlias().equalsIgnoreCase(string) || !columnAlias.getCol().getContainer().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) continue;
            columnAlias.setTableAlias(string2);
            this.allColumnsOrderByModel.setElementAt(columnAlias, i);
        }
        for (OrderByElement orderByElement : this.orderByList) {
            if ((!((AttributeView)orderByElement.getContainedObject()).getTableAlias().equalsIgnoreCase(string) || ((AttributeView)orderByElement.getContainedObject()).getEntity() == null || !((AttributeView)orderByElement.getContainedObject()).getEntity().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) && (((AttributeView)orderByElement.getContainedObject()).getView() == null || !((AttributeView)orderByElement.getContainedObject()).getView().getName().equalsIgnoreCase(containerElement.getContainerObject().getName()))) continue;
            ((AttributeView)orderByElement.getContainedObject()).setTableAlias(string2);
        }
    }

    private boolean checkExpression(String string, String string2) {
        return string.equalsIgnoreCase("") || !string2.equalsIgnoreCase("");
    }

    private void stopTableCellEditing(JTable jTable) {
        int n = jTable.getEditingRow();
        int n2 = jTable.getEditingColumn();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor().stopCellEditing();
        }
    }

    class OrderByElement {
        ContainedObject containedObject;
        String sort;

        public OrderByElement(ContainedObject containedObject, String string) {
            this.containedObject = containedObject;
            this.sort = string;
        }

        public ContainedObject getContainedObject() {
            return this.containedObject;
        }

        public void setContainedObject(ContainedObject containedObject) {
            this.containedObject = containedObject;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String string) {
            this.sort = string;
        }
    }

    class ContainerElement {
        ContainerObject containerObject;
        String containerAlias;

        public ContainerElement(ContainerObject containerObject, String string) {
            this.containerObject = containerObject;
            this.containerAlias = string;
        }

        public ContainerObject getContainerObject() {
            return this.containerObject;
        }

        public void setContainerObject(ContainerObject containerObject) {
            this.containerObject = containerObject;
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public void setContainerAlias(String string) {
            this.containerAlias = string;
        }
    }

    class AttributeElement {
        AttributeView attributeView;
        String alias;
        boolean groupBy;

        public AttributeElement(AttributeView attributeView, String string, boolean bl) {
            this.attributeView = attributeView;
            this.alias = string;
            this.groupBy = bl;
        }

        public AttributeView getAttributeView() {
            return this.attributeView;
        }

        public void setAttributeView(AttributeView attributeView) {
            this.attributeView = attributeView;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String string) {
            this.alias = string;
        }

        public boolean getGroupBy() {
            return this.groupBy;
        }

        public void setGroupBy(boolean bl) {
            this.groupBy = bl;
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityViewBuilder.this.defineDDLArea.setEnabled(EntityViewBuilder.this.defineDDLChBox.isSelected());
            EntityViewBuilder.this.enableAll(!EntityViewBuilder.this.defineDDLChBox.isSelected());
            if (EntityViewBuilder.this.defineDDLChBox.isSelected()) {
                EntityViewBuilder.this.defineDDLArea.setText(EntityViewBuilder.this.generateSQL());
            } else {
                EntityViewBuilder.this.defineDDLArea.setText("");
            }
        }
    }

    public class TabChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (EntityViewBuilder.this.tpane.getSelectedComponent() == EntityViewBuilder.this.tpane.getComponentAt(6)) {
                EntityViewBuilder.this.sqlArea.setText(EntityViewBuilder.this.generateSQL());
            } else if (EntityViewBuilder.this.tpane.getSelectedComponent() == EntityViewBuilder.this.tpane.getComponentAt(3)) {
                EntityViewBuilder.this.groupByArea.setText(EntityViewBuilder.this.generateGroupBy());
            }
        }
    }

    class ColumnAlias {
        ContainedObject col;
        String tableAlias;

        public ColumnAlias(ContainedObject containedObject, String string) {
            this.col = containedObject;
            this.tableAlias = string;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public void setTableAlias(String string) {
            this.tableAlias = string;
        }

        public ContainedObject getCol() {
            return this.col;
        }

        public void setCol(ContainedObject containedObject) {
            this.col = containedObject;
        }
    }

    class AllListOrderByColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListOrderByColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ColumnAlias columnAlias = (ColumnAlias)object;
            String string = columnAlias.getTableAlias();
            String string2 = columnAlias.getCol().getName();
            StringBuffer stringBuffer = null;
            stringBuffer = !string.equalsIgnoreCase("") ? new StringBuffer(string).append(".").append(string2) : new StringBuffer(string2);
            this.setText(stringBuffer.toString());
            this.setOpaque(true);
            if (bl) {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getSelectionBackground());
            } else {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getBackground());
            }
            if (!jList.isEnabled()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CharSequence charSequence;
            ColumnAlias columnAlias = (ColumnAlias)object;
            String string = columnAlias.getTableAlias();
            String string2 = columnAlias.getCol().getName();
            if (columnAlias.getCol() instanceof AttributeView && !"".equals(charSequence = ((AttributeView)columnAlias.getCol()).getAlias().trim())) {
                string2 = charSequence;
            }
            charSequence = null;
            charSequence = !string.equalsIgnoreCase("") ? new StringBuffer(string).append(".").append(string2) : new StringBuffer(columnAlias.getCol().getContainer().getName()).append(".").append(string2);
            this.setText(((StringBuffer)charSequence).toString());
            this.setOpaque(true);
            if (bl) {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getSelectionBackground());
            } else {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getBackground());
            }
            if (!jList.isEnabled()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsOrderBySelectionHandler
    implements ListSelectionListener {
        AllListColumnsOrderBySelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (EntityViewBuilder.this.allColumnsOrderByList.getSelectedIndex() == -1) {
                    EntityViewBuilder.this.bnAddOrderByColumns.setEnabled(false);
                } else {
                    EntityViewBuilder.this.bnAddOrderByColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveOrderByColumnsActionListener
    implements ActionListener {
        RemoveOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EntityViewBuilder.this.orderByList.size() > 0) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = EntityViewBuilder.this.selectedOrderByColumnsTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(EntityViewBuilder.this.orderByList.get(nArray[i]));
                }
                for (OrderByElement orderByElement : arrayList) {
                    EntityViewBuilder.this.orderByList.remove(orderByElement);
                }
                EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                EntityViewBuilder.this.selectedOrderByColumnsTable.clearSelection();
            }
        }
    }

    class NewOrderByColumnsActionListener
    implements ActionListener {
        NewOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AttributeView attributeView = new AttributeView(EntityViewBuilder.this.design);
            attributeView.setExpression("");
            attributeView.setName("");
            attributeView.setDesign(EntityViewBuilder.this.view.getDesign());
            attributeView.setContainer(EntityViewBuilder.this.view);
            EntityViewBuilder.this.orderByList.add(new OrderByElement(attributeView, ""));
            EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
        }
    }

    class AddOrderByColumnsActionListener
    implements ActionListener {
        AddOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EntityViewBuilder.this.allColumnsOrderByModel.isEmpty()) {
                Object[] objectArray = EntityViewBuilder.this.allColumnsOrderByList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ColumnAlias columnAlias = (ColumnAlias)objectArray[i];
                    ContainedObject containedObject = columnAlias.getCol();
                    if (containedObject instanceof Attribute) {
                        AttributeView attributeView = new AttributeView(EntityViewBuilder.this.design);
                        attributeView.setReferencedAttribute((Attribute)containedObject);
                        attributeView.setName(((Attribute)containedObject).getName());
                        attributeView.setDesign(EntityViewBuilder.this.view.getDesign());
                        attributeView.setEntity((Entity)containedObject.getContainer());
                        attributeView.setContainer(EntityViewBuilder.this.view);
                        attributeView.setEntityAlias(columnAlias.getTableAlias());
                        attributeView.setDataType(((Attribute)containedObject).getDataType().toString());
                        EntityViewBuilder.this.orderByList.add(new OrderByElement(attributeView, "ASC"));
                        EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                        continue;
                    }
                    if (!(containedObject instanceof AttributeView)) continue;
                    EntityViewBuilder.this.orderByList.add(new OrderByElement(containedObject, "ASC"));
                    EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                }
            }
        }
    }

    class AllListColumnsSelectionHandler
    implements ListSelectionListener {
        AllListColumnsSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (EntityViewBuilder.this.allColumnsList.getSelectedIndex() == -1) {
                    EntityViewBuilder.this.bnAddColumns.setEnabled(false);
                } else {
                    EntityViewBuilder.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveColumnsActionListener
    implements ActionListener {
        RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EntityViewBuilder.this.attributeViewList.size() > 0) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = EntityViewBuilder.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(EntityViewBuilder.this.attributeViewList.get(nArray[i]));
                }
                for (AttributeElement attributeElement : arrayList) {
                    EntityViewBuilder.this.attributeViewList.remove(attributeElement);
                    ColumnAlias columnAlias = EntityViewBuilder.this.getColumnAlias(attributeElement.getAttributeView());
                    if (columnAlias == null) continue;
                    EntityViewBuilder.this.expressionList.remove(columnAlias);
                    EntityViewBuilder.this.allColumnsOrderByModel.removeElement(columnAlias);
                    for (int i = EntityViewBuilder.this.orderByList.size() - 1; i >= 0; --i) {
                        OrderByElement orderByElement = (OrderByElement)EntityViewBuilder.this.orderByList.get(i);
                        if (orderByElement.getContainedObject() != columnAlias.getCol()) continue;
                        EntityViewBuilder.this.orderByList.remove(orderByElement);
                        EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                    }
                }
                EntityViewBuilder.this.selectedColumnsTable.updateUI();
                EntityViewBuilder.this.selectedColumnsTable.clearSelection();
            }
        }
    }

    class NewExpressionActionListener
    implements ActionListener {
        NewExpressionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AttributeView attributeView = new AttributeView(EntityViewBuilder.this.design);
            attributeView.setExpression("");
            attributeView.setName("");
            attributeView.setDesign(EntityViewBuilder.this.view.getDesign());
            attributeView.setContainer(EntityViewBuilder.this.view);
            EntityViewBuilder.this.attributeViewList.add(new AttributeElement(attributeView, attributeView.getAlias(), false));
            EntityViewBuilder.this.selectedColumnsTable.updateUI();
            EntityViewBuilder.this.expressionList.add(new ColumnAlias(attributeView, attributeView.getAlias()));
        }
    }

    class AddColumnsActionListener
    implements ActionListener {
        AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EntityViewBuilder.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = EntityViewBuilder.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    AttributeView attributeView;
                    ColumnAlias columnAlias = (ColumnAlias)objectArray[i];
                    ContainedObject containedObject = columnAlias.getCol();
                    if (containedObject instanceof Attribute) {
                        attributeView = new AttributeView(EntityViewBuilder.this.design);
                        attributeView.setReferencedAttribute((Attribute)containedObject);
                        attributeView.setName(((Attribute)containedObject).getName());
                        attributeView.setDesign(EntityViewBuilder.this.view.getDesign());
                        attributeView.setEntity((Entity)containedObject.getContainer());
                        attributeView.setContainer(EntityViewBuilder.this.view);
                        attributeView.setEntityAlias(columnAlias.getTableAlias());
                        attributeView.setDataType(((Attribute)containedObject).getDataType().toString());
                        EntityViewBuilder.this.attributeViewList.add(new AttributeElement(attributeView, attributeView.getAlias(), false));
                        EntityViewBuilder.this.selectedColumnsTable.updateUI();
                        continue;
                    }
                    if (!(containedObject instanceof AttributeView)) continue;
                    attributeView = new AttributeView(EntityViewBuilder.this.design);
                    attributeView.setReferencedAttribute(((AttributeView)containedObject).getReferencedAttribute());
                    attributeView.setName(containedObject.getName());
                    attributeView.setDesign(EntityViewBuilder.this.view.getDesign());
                    attributeView.setReferencedColumnView(containedObject);
                    attributeView.setView((EntityView)containedObject.getContainer());
                    attributeView.setContainer(EntityViewBuilder.this.view);
                    attributeView.setEntityAlias(columnAlias.getTableAlias());
                    EntityViewBuilder.this.attributeViewList.add(new AttributeElement(attributeView, attributeView.getAlias(), false));
                    EntityViewBuilder.this.selectedColumnsTable.updateUI();
                }
            }
        }
    }

    class SelectedTablesTable
    extends JTable {
        SelectedTablesTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (!EntityViewBuilder.this.defineDDLChBox.isSelected()) {
                if (n2 == 1) {
                    return new TextCellEditor();
                }
                return super.getCellEditor();
            }
            return null;
        }
    }

    class SelectedTablesModel
    extends AbstractTableModel {
        SelectedTablesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityViewBuilder.this.containerList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EntityViewBuilder.Entities");
            }
            if (n == 1) {
                return Messages.getString("EntityViewBuilder.Alias");
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ContainerElement containerElement = (ContainerElement)EntityViewBuilder.this.containerList.get(n);
            if (n2 == 0) {
                containerElement.setContainerObject((ContainerObject)object);
            }
            if (n2 == 1) {
                String string = containerElement.getContainerAlias();
                EntityViewBuilder.this.checkModelsForValues(containerElement, string, (String)object);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ContainerElement containerElement = (ContainerElement)EntityViewBuilder.this.containerList.get(n);
            if (n2 == 0) {
                return containerElement.getContainerObject();
            }
            if (n2 == 1) {
                return containerElement.getContainerAlias();
            }
            return new Integer(n * n2);
        }
    }

    class SelectedTablesHandler
    implements ListSelectionListener {
        SelectedTablesHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (EntityViewBuilder.this.selectedTablesTable.getSelectedRow() > -1) {
                EntityViewBuilder.this.bnRemoveTables.setEnabled(true);
            } else {
                EntityViewBuilder.this.bnRemoveTables.setEnabled(false);
            }
        }
    }

    class ComboCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        ComboCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(new String[]{"ASC", "DESC"}));
            return this.cbox;
        }
    }

    class ExpressionCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        ExpressionCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof AttributeView) {
                if (!((AttributeView)object).getExpression().equalsIgnoreCase("")) {
                    this.tfield.setText(((AttributeView)object).getExpression());
                } else {
                    this.tfield.setText(((AttributeView)object).getName());
                }
            } else {
                this.tfield.setText(object == null ? "" : "" + object.toString());
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        TextCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof AttributeView && ((AttributeView)object).getEntityAlias().equalsIgnoreCase(EntityViewBuilder.this.view.getName())) {
                this.tfield.setText(((AttributeView)object).getExpression());
            } else {
                this.tfield.setText(object == null ? "" : "" + object.toString());
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class SelectedOrderByColumnsTable
    extends JTable {
        SelectedOrderByColumnsTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (!EntityViewBuilder.this.defineDDLChBox.isSelected()) {
                if (n2 == 0) {
                    return new TextCellEditor();
                }
                return new ComboCellEditor();
            }
            return null;
        }
    }

    class SelectedOrderByColumnsModel
    extends AbstractTableModel {
        SelectedOrderByColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityViewBuilder.this.orderByList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EntityViewBuilder.AttributesExpression");
            }
            if (n == 1) {
                return Messages.getString("EntityViewBuilder.Sort");
            }
            return "";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            OrderByElement orderByElement = (OrderByElement)EntityViewBuilder.this.orderByList.get(n);
            if (n2 == 0) {
                return orderByElement.getContainedObject();
            }
            if (n2 == 1) {
                return orderByElement.getSort();
            }
            return new Integer(n * n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            OrderByElement orderByElement = (OrderByElement)EntityViewBuilder.this.orderByList.get(n);
            return n2 != 0 || ((AttributeView)orderByElement.getContainedObject()).getTable() == null && ((AttributeView)orderByElement.getContainedObject()).getView() == null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            OrderByElement orderByElement = (OrderByElement)EntityViewBuilder.this.orderByList.get(n);
            if (n2 == 0) {
                if (object instanceof AttributeView) {
                    orderByElement.setContainedObject((AttributeView)object);
                } else {
                    AttributeView attributeView = (AttributeView)orderByElement.getContainedObject();
                    attributeView.setExpression((String)object);
                    attributeView.setName((String)object);
                }
            } else if (n2 == 1) {
                orderByElement.setSort((String)object);
            }
        }
    }

    class SelectedOrderByColumnsHandler
    implements ListSelectionListener {
        SelectedOrderByColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (EntityViewBuilder.this.selectedOrderByColumnsTable.getSelectedRow() > -1) {
                EntityViewBuilder.this.bnRemoveOrderByColumns.setEnabled(true);
            } else {
                EntityViewBuilder.this.bnRemoveOrderByColumns.setEnabled(false);
            }
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            if (object instanceof AttributeView && ((AttributeView)object).getEntityAlias().equalsIgnoreCase(EntityViewBuilder.this.view.getName())) {
                this.setText(((AttributeView)object).getExpression());
            } else {
                this.setText(object == null ? "" : "" + object.toString());
            }
            return this;
        }
    }

    class CheckBoxEditor
    extends DefaultCellEditor {
        JCheckBox cbox;

        CheckBoxEditor() {
            super(new JCheckBox());
            this.cbox = (JCheckBox)this.getComponent();
            this.cbox.setHorizontalAlignment(0);
        }
    }

    class SelectedAttributesModel
    extends AbstractTableModel {
        SelectedAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EntityViewBuilder.this.attributeViewList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EntityViewBuilder.AttributesExpression");
            }
            if (n == 1) {
                return Messages.getString("EntityViewBuilder.Alias");
            }
            if (n == 2) {
                return Messages.getString("EntityViewBuilder.Groupby");
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            AttributeElement attributeElement;
            return n2 != 0 || (attributeElement = (AttributeElement)EntityViewBuilder.this.attributeViewList.get(n)).getAttributeView().getEntity() == null && attributeElement.getAttributeView().getView() == null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AttributeElement attributeElement = (AttributeElement)EntityViewBuilder.this.attributeViewList.get(n);
            if (n2 == 0) {
                return EntityViewBuilder.this.getValue(attributeElement.getAttributeView());
            }
            if (n2 == 1) {
                return attributeElement.getAlias();
            }
            if (n2 == 2) {
                return attributeElement.getGroupBy();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AttributeElement attributeElement = (AttributeElement)EntityViewBuilder.this.attributeViewList.get(n);
            if (n2 == 0) {
                if (object instanceof AttributeView) {
                    attributeElement.setAttributeView((AttributeView)object);
                } else {
                    AttributeView attributeView = attributeElement.getAttributeView();
                    attributeView.setExpression((String)object);
                    attributeView.setName((String)object);
                    EntityViewBuilder.this.checkOrderByModel();
                }
            } else if (n2 == 1) {
                attributeElement.setAlias((String)object);
            } else if (n2 == 2) {
                attributeElement.setGroupBy((Boolean)object);
            }
        }
    }

    class SelectedColumnsHandler
    implements ListSelectionListener {
        SelectedColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (EntityViewBuilder.this.selectedColumnsTable.getSelectedRow() > -1) {
                EntityViewBuilder.this.bnRemoveColumns.setEnabled(true);
            } else {
                EntityViewBuilder.this.bnRemoveColumns.setEnabled(false);
            }
        }
    }

    class AllListTablesSelectionHandler
    implements ListSelectionListener {
        AllListTablesSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (EntityViewBuilder.this.allTablesList.getSelectedIndex() == -1) {
                    EntityViewBuilder.this.bnAddTables.setEnabled(false);
                    EntityViewBuilder.this.bnMoveUpTable.setEnabled(false);
                    EntityViewBuilder.this.bnMoveDownTable.setEnabled(false);
                } else {
                    EntityViewBuilder.this.bnAddTables.setEnabled(true);
                    EntityViewBuilder.this.bnMoveUpTable.setEnabled(true);
                    EntityViewBuilder.this.bnMoveDownTable.setEnabled(true);
                }
            }
        }
    }

    class RemoveTablesActionListener
    implements ActionListener {
        RemoveTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EntityViewBuilder.this.containerList.size() > 0) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = EntityViewBuilder.this.selectedTablesTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(EntityViewBuilder.this.containerList.get(nArray[i]));
                }
                for (ContainerElement containerElement : arrayList) {
                    Object object;
                    Object object22;
                    Iterator iterator;
                    ContainedObject containedObject;
                    int n;
                    ContainerObject containerObject = containerElement.getContainerObject();
                    if (containerObject instanceof Entity) {
                        for (n = 0; n < containerObject.getElements().length; ++n) {
                            containedObject = (Attribute)containerObject.getElements()[n];
                            iterator = EntityViewBuilder.this.allColumnsModel.elements();
                            while (iterator.hasMoreElements()) {
                                object22 = (ColumnAlias)iterator.nextElement();
                                if (((ColumnAlias)object22).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object22).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsModel.removeElement(object22);
                            }
                            for (Object object22 : EntityViewBuilder.this.attributeViewList) {
                                if (((AttributeElement)object22).getAttributeView().getReferencedColumn() != containedObject || ((AttributeElement)object22).getAttributeView().getView() != null && ((AttributeElement)object22).getAttributeView().getView() != EntityViewBuilder.this.view || ((AttributeElement)object22).getAttributeView().getContainer() != containerObject && ((AttributeElement)object22).getAttributeView().getContainer() != EntityViewBuilder.this.view) continue;
                                EntityViewBuilder.this.attributeViewList.remove(object22);
                                EntityViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            object22 = EntityViewBuilder.this.allColumnsOrderByModel.elements();
                            while (object22.hasMoreElements()) {
                                object = (ColumnAlias)object22.nextElement();
                                if (((ColumnAlias)object).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsOrderByModel.removeElement(object);
                            }
                            for (Object object22 : EntityViewBuilder.this.orderByList) {
                                object = (AttributeView)((OrderByElement)object22).getContainedObject();
                                if (((AbstractViewElement)object).getReferencedColumn() != containedObject || ((AbstractViewElement)object).getView() != null && ((AbstractViewElement)object).getView() != EntityViewBuilder.this.view || ((ContainedObject)object).getContainer() != containerObject && ((ContainedObject)object).getContainer() != EntityViewBuilder.this.view) continue;
                                EntityViewBuilder.this.orderByList.remove(object22);
                                EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    } else if (containerObject instanceof EntityView) {
                        for (n = 0; n < containerObject.getElements().length; ++n) {
                            containedObject = (AttributeView)containerObject.getElements()[n];
                            iterator = EntityViewBuilder.this.allColumnsModel.elements();
                            while (iterator.hasMoreElements()) {
                                object22 = (ColumnAlias)iterator.nextElement();
                                if (((ColumnAlias)object22).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object22).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsModel.removeElement(object22);
                            }
                            for (Object object22 : EntityViewBuilder.this.attributeViewList) {
                                if (((AttributeElement)object22).getAttributeView().getReferencedColumn() != ((AbstractViewElement)containedObject).getReferencedColumn() || !containerElement.getContainerAlias().equalsIgnoreCase(((AttributeElement)object22).getAttributeView().getTableAlias())) continue;
                                EntityViewBuilder.this.attributeViewList.remove(object22);
                                EntityViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            object22 = EntityViewBuilder.this.allColumnsOrderByModel.elements();
                            while (object22.hasMoreElements()) {
                                object = (ColumnAlias)object22.nextElement();
                                if (((ColumnAlias)object).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsOrderByModel.removeElement(object);
                            }
                            for (Object object22 : EntityViewBuilder.this.orderByList) {
                                if (((AttributeView)((OrderByElement)object22).getContainedObject()).getReferencedColumn() != ((AbstractViewElement)containedObject).getReferencedColumn() || !containerElement.getContainerAlias().equalsIgnoreCase(((AttributeView)((OrderByElement)object22).getContainedObject()).getTableAlias())) continue;
                                EntityViewBuilder.this.orderByList.remove(object22);
                                EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    }
                    EntityViewBuilder.this.containerList.remove(containerElement);
                    EntityViewBuilder.this.selectedTablesTable.updateUI();
                }
            }
        }
    }

    class AddTablesActionListener
    implements ActionListener {
        AddTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EntityViewBuilder.this.allTablesModel.isEmpty()) {
                Object[] objectArray = EntityViewBuilder.this.allTablesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ContainedObject containedObject;
                    int n;
                    ContainerObject containerObject = (ContainerObject)objectArray[i];
                    String string = this.generateAlias(containerObject);
                    EntityViewBuilder.this.containerList.add(new ContainerElement(containerObject, string));
                    EntityViewBuilder.this.selectedTablesTable.updateUI();
                    if (containerObject instanceof Entity) {
                        for (n = 0; n < containerObject.getElements().length; ++n) {
                            containedObject = (Attribute)containerObject.getElements()[n];
                            EntityViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(containedObject, string));
                            EntityViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(containedObject, string));
                        }
                        continue;
                    }
                    if (!(containerObject instanceof EntityView)) continue;
                    for (n = 0; n < containerObject.getElements().length; ++n) {
                        containedObject = (AttributeView)containerObject.getElements()[n];
                        EntityViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(containedObject, string));
                        EntityViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(containedObject, string));
                    }
                }
            }
        }

        private String generateAlias(ContainerObject containerObject) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = EntityViewBuilder.this.containerList.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((ContainerElement)iterator.next()).getContainerAlias());
            }
            if (!arrayList.contains(containerObject.getName())) {
                return containerObject.getName();
            }
            StringBuffer stringBuffer = new StringBuffer(containerObject.getName());
            String string = containerObject.getName();
            stringBuffer.append("v");
            int n = stringBuffer.length();
            for (int i = 1; i <= arrayList.size(); ++i) {
                stringBuffer.setLength(n);
                stringBuffer.append(i);
                string = stringBuffer.toString();
                if (arrayList.contains(string)) continue;
                return string;
            }
            return null;
        }
    }
}

