/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.HierarchicalStrategy;
import oracle.dbtools.crest.model.design.impact.ImpA_Entity;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeCaseType;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeMaxNameLength;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeValidCharacters;
import oracle.dbtools.crest.model.designrules.logical.DREntityCaseType;
import oracle.dbtools.crest.model.designrules.logical.DREntityMaxNameLength;
import oracle.dbtools.crest.model.designrules.logical.DREntityValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.AttributePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.logical.AttributesNamingStandards;
import oracle.dbtools.crest.swingui.editor.logical.KeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.ide.Ide;

public class EntityPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private static final String INTERVAL_STRING = " ";
    private Entity entity;
    private JTextField tfShortName;
    private JTextField tfSynonym;
    private JTextField tfAbbreviation;
    private JTextField tfDisplaySynonym;
    private JTextField tfLongName;
    private JComboBox cbEngStrategy;
    private JComboBox cbBasedOnST;
    private JComboBox cbSuperType;
    private JTextField tfSource;
    private JComboBox cbType;
    private JTextField tfScope;
    private JPanel pnAttributes;
    private List attributesList;
    private JTable tbAttributes;
    private JTable coTable;
    private JButton bnCOAdd;
    private JButton bnCORemove;
    private JButton bnCOUp;
    private JButton bnCODown;
    private JButton bnCOCopy;
    private JButton bnCOPaste;
    private int attrCounter = 0;
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();
    private int counter = 0;
    private JPanel pnRelations;
    private List relationsList;
    private JTable tbRelations;
    private JPanel pnKeys;
    private List<KeyObject> keysList;
    private JTable itable;
    private JPanel pnVolumes;
    private JTextField tfMinVolume;
    private JTextField tfExpected;
    private JTextField tfMaximum;
    private JTextField tfGrowthPercent;
    private static final String[] YMD = new String[]{Messages.getString("EntityPropertiesDialogEx.Year"), Messages.getString("EntityPropertiesDialogEx.Month"), Messages.getString("EntityPropertiesDialogEx.Day")};
    private static final String[] YMD_INTERNAL = new String[]{"Year", "Month", "Day"};
    private JComboBox cbYearMonthDay;
    private static final String[] NF = new String[]{Messages.getString("EntityPropertiesDialogEx.None"), Messages.getString("EntityPropertiesDialogEx.First"), Messages.getString("EntityPropertiesDialogEx.Second"), Messages.getString("EntityPropertiesDialogEx.Third"), Messages.getString("EntityPropertiesDialogEx.Fourth")};
    private static final String[] NF_INTERNAL = new String[]{"None", "First", "Second", "Third", "Fourth"};
    private JComboBox cbNormalForm;
    private JComboBox cbAdequatelyNormalized;
    private final Map keyMap = new HashMap();
    private JCheckBox chTypeSubst;
    private StructuredType st_type;
    private ClassificationType classType = null;
    private JTree tree;
    private JTextArea taColumnComments;
    private JTextArea taColumnNotes;
    private JTextArea taColumnCommentsInRDBMS;
    private JTextField tfColumnName;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JComboBox cbDatatype;
    private ActionListener cbDatatypeActionListener;
    private JTextField ifDTSize;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JPanel pnDType;
    private JPanel pnDTSize;
    private JPanel pnDTScale;
    private JPanel pnRef;
    private Attribute selectedAttribute = null;
    private JCheckBox chbPK;
    private JCheckBox chbFK;
    private JCheckBox chbMandatory;
    private ActionListener chbPKActionListener;
    private boolean sizeEnabled = false;
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private boolean initialUseDomainPreferredList = true;
    private boolean initialUseLogicalTypePreferredList = true;
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List currentPreferredDomainList = new ArrayList();
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private boolean precisionEnabled = false;
    private JCheckBox chbReference;
    private JComboBox cbUnits;
    private ButtonGroup group;
    private final int INIT = 0;
    private final int ADD = 1;
    private final int DELETE = 2;
    private final int INIT_SELECTED = 3;
    private int distinctTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().size();
    private int structuredTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().size();
    private int collectionTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().size();
    private String storedColumnDefaultDatatype = this.getAppView().getSettings().getColumnDefaultDatatype().trim();
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private TreeMap typesRDBMSSites = new TreeMap();
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private LogicalDesign.EntHolder currentEntHolder;
    private JPanel pnOverlapping;
    private JTable attribsJTable;
    private static final String ATTRIBUTES_TAB_NAME = Messages.getString("EntityPropertiesDialogEx.Attributes");
    JButton btnAddKey;

    public EntityPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("EntityPropertiesDialogEx.EntityProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 540;
    }

    @Override
    protected int getMinimumWidth() {
        return 880;
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedAttribute();
        String string = component.getName();
        if (string.equals(ATTRIBUTES_TAB_NAME)) {
            this.selectFirstRow(this.coTable, this.attributesList);
        }
        super.showComponent(component);
    }

    protected boolean selectFirstRow(JTable jTable, List list) {
        if (jTable.getSelectedRow() == -1 && list.size() > 0) {
            jTable.updateUI();
            jTable.changeSelection(0, 1, false, false);
            jTable.requestFocus();
            return true;
        }
        return false;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Entity) {
            String string;
            Object object;
            Object object2;
            ArrayList<StructuredType> arrayList;
            this.entity = (Entity)designObject;
            this.currentEntHolder = ((LogicalDesign)this.entity.getDesignPart()).getOverlappingKeys_EntHolder(this.entity);
            if (this.currentEntHolder != null) {
                Collections.sort(this.currentEntHolder.attrHolders, new StringComparator());
                arrayList = this.currentEntHolder.attrHolders.iterator();
                object2 = this.entity.getFoldedAttributesMap();
                while (arrayList.hasNext()) {
                    boolean bl = false;
                    object = (LogicalDesign.AttrHolder)arrayList.next();
                    string = (String)object2.get(((LogicalDesign.AttrHolder)object).attr1.getObjectID());
                    if (string != null && string.equals(((LogicalDesign.AttrHolder)object).attr2.getObjectID())) {
                        bl = true;
                    }
                    if (!bl && (string = (String)object2.get(((LogicalDesign.AttrHolder)object).attr2.getObjectID())) != null && string.equals(((LogicalDesign.AttrHolder)object).attr1.getObjectID())) {
                        bl = true;
                    }
                    ((LogicalDesign.AttrHolder)object).overlap = bl;
                }
            }
            this.attribsJTable.updateUI();
            this.preserveKeysStructure(this.entity);
            this.initDefaults();
            this.tfShortName.setText(this.entity.getShortName());
            this.tfSynonym.setText(this.entity.getSynonym());
            this.tfDisplaySynonym.setText(this.entity.getSynonymToDisplay());
            this.tfLongName.setText(this.entity.getLongName());
            this.fillComboItems(HierarchicalStrategy.STRATEGY_NAMES_DISPLAY, this.cbEngStrategy, false);
            this.cbEngStrategy.setSelectedItem(this.translate(this.entity.getFwdEngineeringStrategyName(), HierarchicalStrategy.STRATEGY_NAMES_INTERNAL, HierarchicalStrategy.STRATEGY_NAMES_DISPLAY));
            arrayList = new ArrayList();
            object2 = this.entity.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
            while (object2.hasNext()) {
                StructuredType structuredType = (StructuredType)object2.next();
                if (!structuredType.isInstantiable() && !structuredType.hasInstantiableSubtype()) continue;
                arrayList.add(structuredType);
            }
            this.fillComboItems(arrayList.toArray(), this.cbBasedOnST, true);
            this.cbBasedOnST.setSelectedItem(this.entity.getBasedOnStructuredType());
            if (this.entity.isBST()) {
                this.cbSuperType.setEnabled(false);
                this.st_type = this.entity.getBasedOnStructuredType();
            } else {
                this.cbSuperType.removeAllItems();
                object2 = this.entity.getDesign().getLogicalDesign().getEntitySet().iterator();
                arrayList = new ArrayList<StructuredType>();
                while (object2.hasNext()) {
                    Entity entity = (Entity)object2.next();
                    if (entity.isBST() || entity == this.entity) continue;
                    arrayList.add((StructuredType)((Object)entity));
                }
                this.fillComboItems(arrayList.toArray(), this.cbSuperType, true);
                this.cbSuperType.setSelectedItem(this.entity.getHierarchicalParent());
            }
            this.cbSuperType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (EntityPropertiesDialogEx.this.cbSuperType.getSelectedItem() != null) {
                        Entity entity = (Entity)EntityPropertiesDialogEx.this.cbSuperType.getSelectedItem();
                        EntityPropertiesDialogEx.this.cbEngStrategy.setSelectedItem(EntityPropertiesDialogEx.this.translate(entity.getFwdEngineeringStrategyName(), HierarchicalStrategy.STRATEGY_NAMES_INTERNAL, HierarchicalStrategy.STRATEGY_NAMES_DISPLAY));
                    }
                }
            });
            this.tfSource.setText(this.entity.getSource());
            this.fillComboItems(this.getDesignObject().getDesign().getDLSettings().getClassificationTypeNames(), this.cbType, false);
            this.cbType.setSelectedItem(this.getDesignObject().getDesign().getDLSettings().getClassificationTypeNameByID(this.entity.getTypeID()));
            this.tfScope.setText(this.entity.getScope());
            if (this.cbType.getSelectedItem() != null && ((String)this.cbType.getSelectedItem()).equalsIgnoreCase(ContainerObject.TYPE_TEMPORARY)) {
                this.tfScope.setEnabled(true);
            } else {
                this.tfScope.setEnabled(false);
                this.tfScope.setText("");
            }
            this.tfAbbreviation.setText(this.entity.getPreferredAbbreviation());
            this.attributesList.addAll(Arrays.asList(this.entity.getElements()));
            this.relationsList.addAll(this.entity.getRelations());
            this.keysList.addAll(Arrays.asList(this.entity.getKeys()));
            if (this.entity.isBST() && !this.entity.isRoot()) {
                this.btnAddKey.setEnabled(false);
            }
            this.chTypeSubst.setSelected(this.entity.isAllowTypeSubstitution());
            if (!this.entity.isBST() || this.entity.isBST() && this.entity.getSubTypeSubstitutions().size() > 0) {
                this.chTypeSubst.setEnabled(false);
            }
            this.tfMinVolume.setText(this.entity.getMinVolumes());
            this.tfExpected.setText(this.entity.getExpectedVolumes());
            this.tfMaximum.setText(this.entity.getMaxVolumes());
            this.tfGrowthPercent.setText(this.entity.getGrowthPercent());
            this.cbYearMonthDay.setSelectedItem(this.translate(this.entity.getGrowthType(), YMD_INTERNAL, YMD));
            this.cbNormalForm.setSelectedItem(this.translate(this.entity.getNormalForm(), NF_INTERNAL, NF));
            this.cbAdequatelyNormalized.setSelectedItem(this.translate(this.entity.getAdequatelyNormalized(), YES_NO_INTERNAL, YES_NO));
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 0);
            Iterator iterator = this.getDesignObject().getDesign().getDefaultRDBMSTypeSet().iterator();
            while (iterator.hasNext()) {
                object = (RDBMSType)iterator.next();
                this.typesRDBMSSites.put(((RDBMSType)object).getType(), ((RDBMSType)object).getName());
            }
            this.dynamicPropertiesList.clear();
            object2 = this.entity.getPropertyNames();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string = this.entity.getProperty((String)object);
                DynamicProperty dynamicProperty = new DynamicProperty((String)object, string);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void preserveKeysStructure(ContainerWithKeyObject containerWithKeyObject) {
        this.keyMap.clear();
        KeyObject[] keyObjectArray = containerWithKeyObject.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
            ContainedObject[] containedObjectArray = keyObjectArray[i].getElements();
            for (int j = 0; j < containedObjectArray.length; ++j) {
                arrayList.add(containedObjectArray[j]);
            }
            this.keyMap.put(keyObjectArray[i], arrayList);
        }
    }

    @Override
    protected void setProperties() {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        int n;
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        this.entity.setName(this.tfName.getText());
        this.entity.setComment(this.taComments.getText());
        this.entity.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.entity.setNotes(this.taNotes.getText());
        this.entity.setSynonym(this.tfSynonym.getText());
        this.entity.setSynonymToDisplay(this.tfDisplaySynonym.getText());
        this.entity.setShortName(this.tfShortName.getText());
        this.entity.setSource(this.tfSource.getText());
        this.entity.setScope(this.tfScope.getText());
        this.entity.setHierarchicalParent((Entity)this.cbSuperType.getSelectedItem());
        this.entity.applyEngineeringStrategyToHierarchy(this.translate((String)this.cbEngStrategy.getSelectedItem(), HierarchicalStrategy.STRATEGY_NAMES_DISPLAY, HierarchicalStrategy.STRATEGY_NAMES_INTERNAL));
        this.classType = this.entity.getDesign().getDLSettings().getClassificationTypeByName((String)this.cbType.getSelectedItem());
        if (this.classType != null) {
            this.entity.setTypeID(this.classType.getTypeID());
        } else {
            this.entity.setTypeID("");
        }
        StructuredType structuredType = (StructuredType)this.cbBasedOnST.getSelectedItem();
        if (this.entity.getBasedOnStructuredType() != structuredType) {
            this.entity.setBasedOnStructuredType(structuredType);
            this.reloadKeys();
        }
        this.entity.setPreferredAbbreviation(this.tfAbbreviation.getText());
        Object[] objectArray = this.keysList.toArray();
        CandidateKey[] candidateKeyArray = (CandidateKey[])this.entity.getKeySet().toArray();
        for (n = 0; n < candidateKeyArray.length; ++n) {
            CandidateKey candidateKey = candidateKeyArray[n];
            if (this.keysList.contains(candidateKey) || candidateKey.isOidKey()) continue;
            boolean bl = candidateKey.isPK();
            object4 = null;
            if (bl) {
                object4 = candidateKey.getRelations();
            }
            candidateKey.remove();
            if (!bl || object4 == null) continue;
            object32 = object4.iterator();
            while (object32.hasNext()) {
                object2 = (Relation)object32.next();
                object = (TVRelation)((Relation)object2).getViewFor(this.getAppView().getCurrentDPV());
                if (object == null) continue;
                ((TVRelation)object).resetEdgeParams();
            }
        }
        n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object5 = objectArray[i];
            if (!(object5 instanceof CandidateKey)) continue;
            object4 = (CandidateKey)object5;
            if (((KeyObject)object4).isPK()) {
                n = 1;
            }
            if (this.entity.getKeySet().contains((CandidateKey)object5)) continue;
            object32 = new ArrayList();
            object32.addAll(((CandidateKey)object4).getNewElementsCollection());
            ((CandidateKey)object4).getNewElementsCollection().clear();
            ((CandidateKey)object4).getElementsCollection().clear();
            this.entity.add((CandidateKey)object5);
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (DesignObject)object2.next();
                if (object instanceof Relation) {
                    ObjectListener objectListener;
                    Relation relation = (Relation)object;
                    if (relation.isOneToOne()) {
                        objectListener = relation.getOtherEntity(this.entity);
                        if (relation.getDominantRole() != objectListener) {
                            relation.setDominantRole((Entity)objectListener);
                        }
                    }
                    if (((KeyObject)object4).isPK()) {
                        relation.setIdentifying(true);
                        objectListener = (TVRelation)relation.getViewFor(this.getAppView().getCurrentDPV());
                        if (objectListener != null) {
                            ((TVRelation)objectListener).resetEdgeParams();
                        }
                    }
                }
                ((CandidateKey)object4).getNewElementsCollection().add(object);
            }
            ((CandidateKey)object4).updateElementsCollection();
        }
        if (!this.entity.isBST()) {
            int n2;
            if (n == 0) {
                this.entity.setPK(null);
            }
            Object[] objectArray2 = this.attributesList.toArray();
            Attribute[] attributeArray = (Attribute[])this.entity.getElements();
            for (n2 = 0; n2 < attributeArray.length; ++n2) {
                object32 = attributeArray[n2];
                if (this.attributesList.contains(object32)) continue;
                ((ContainedObject)object32).remove();
            }
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                object32 = (Attribute)objectArray2[n2];
                if (!this.entity.getAttributeSet().contains((ModelObject)object32)) {
                    this.entity.getAttributeSet().add((DesignObject)object32);
                    this.entity.add((ContainedObject)object32);
                }
                ((ContainedObject)object32).moveToIndex(n2);
            }
        } else {
            this.attributesList.clear();
            this.attributesList.addAll(Arrays.asList(this.entity.getElements()));
            this.relationsList.clear();
            this.relationsList.addAll(this.entity.getRelations());
            this.reloadKeys();
        }
        this.entity.setMinVolumes(this.tfMinVolume.getText());
        this.entity.setExpectedVolumes(this.tfExpected.getText());
        this.entity.setMaxVolumes(this.tfMaximum.getText());
        this.entity.setGrowthPercent(this.tfGrowthPercent.getText());
        this.entity.setGrowthType(this.translate((String)this.cbYearMonthDay.getSelectedItem(), YMD, YMD_INTERNAL));
        this.entity.setNormalForm(this.translate((String)this.cbNormalForm.getSelectedItem(), NF, NF_INTERNAL));
        this.entity.setAdequatelyNormalized(this.translate((String)this.cbAdequatelyNormalized.getSelectedItem(), YES_NO, YES_NO_INTERNAL));
        this.entity.setAllowTypeSubstitution(this.chTypeSubst.isSelected());
        this.preserveKeysStructure(this.entity);
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.tfLongName.setText(this.entity.getLongName());
        this.checkNamingOptions();
        this.tbAttributes.updateUI();
        this.coTable.updateUI();
        this.itable.updateUI();
        for (int i = 0; i < this.relationsList.size(); ++i) {
            Relation relation = (Relation)this.relationsList.get(i);
            for (Object object32 : relation.getAllTVRelations()) {
                if (object32 == null) continue;
                ((TVRelation)object32).resetEdgeParams();
            }
        }
        if (this.currentEntHolder != null) {
            Map map = this.entity.getFoldedAttributesMap();
            map.clear();
            for (LogicalDesign.AttrHolder attrHolder : this.currentEntHolder.attrHolders) {
                if (!attrHolder.overlap) continue;
                object32 = (Attribute)this.entity.getElementByID(attrHolder.attr1.getObjectID());
                object2 = (Attribute)this.entity.getElementByID(attrHolder.attr2.getObjectID());
                if (object32 == null || object2 == null) continue;
                map.put(attrHolder.attr1.getObjectID(), attrHolder.attr2.getObjectID());
            }
        }
        EntityPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.entity.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.entity.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DREntityMaxNameLength(), this.entity);
        this.checkDesignRule(new DREntityCaseType(), this.entity);
        this.checkDesignRule(new DREntityValidCharacters(), this.entity);
        DRAttributeMaxNameLength dRAttributeMaxNameLength = new DRAttributeMaxNameLength();
        DRAttributeCaseType dRAttributeCaseType = new DRAttributeCaseType();
        DRAttributeValidCharacters dRAttributeValidCharacters = new DRAttributeValidCharacters();
        for (Attribute attribute : this.attributesList) {
            this.checkDesignRule(dRAttributeMaxNameLength, attribute);
            this.checkDesignRule(dRAttributeCaseType, attribute);
            this.checkDesignRule(dRAttributeValidCharacters, attribute);
        }
    }

    private void reloadKeys() {
        this.keysList.clear();
        this.keysList.addAll(Arrays.asList(this.entity.getKeys()));
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getKeysPanel());
        this.addToTree(defaultMutableTreeNode, this.getRelationsPanel());
        this.addToTree(defaultMutableTreeNode, this.getVolumesPanel());
        this.addToTree(defaultMutableTreeNode, this.getEngineeringPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getOverlappingPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "ENTITY_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SHORT_NAME);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfShortName = new JTextField();
        this.tfShortName.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfShortName));
        JLabel jLabel2 = new JLabel(LB_SYNOMYMS);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfSynonym));
        JLabel jLabel3 = new JLabel(LB_SYNONYM_TO_DISPLAY);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfDisplaySynonym = new JTextField();
        this.tfDisplaySynonym.setPreferredSize(this.getDefaultSize());
        this.tfDisplaySynonym.setToolTipText(Messages.getString("EntityPropertiesDialogEx.DisplayName"));
        jLabel3.setToolTipText(Messages.getString("EntityPropertiesDialogEx.DisplayName"));
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfDisplaySynonym));
        JLabel jLabel4 = new JLabel(LB_PREF_ABBREVIATION);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfAbbreviation = new JTextField();
        this.tfAbbreviation.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfAbbreviation));
        JLabel jLabel5 = new JLabel(LB_LONG_NAME);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.tfLongName));
        JLabel jLabel6 = new JLabel(LB_FWD_ENGINEER_STRATEGY);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.cbEngStrategy = new JComboBox();
        this.cbEngStrategy.setPreferredSize(this.getDefaultSize());
        this.cbEngStrategy.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.cbEngStrategy));
        JLabel jLabel7 = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.cbBasedOnST = new JComboBox();
        this.cbBasedOnST.setPreferredSize(this.getDefaultSize());
        this.cbBasedOnST.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.cbBasedOnST));
        this.cbBasedOnST.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem() != null) {
                    EntityPropertiesDialogEx.this.cbSuperType.removeAllItems();
                    EntityPropertiesDialogEx.this.cbSuperType.setEnabled(false);
                    Object object = EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem();
                    if (EntityPropertiesDialogEx.this.st_type != null && object != null) {
                        EntityPropertiesDialogEx.this.keysList.clear();
                        EntityPropertiesDialogEx.this.itable.updateUI();
                    }
                    EntityPropertiesDialogEx.this.st_type = (StructuredType)object;
                    if (EntityPropertiesDialogEx.this.isEditable()) {
                        EntityPropertiesDialogEx.this.bnCOAdd.setEnabled(false);
                        EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                    }
                } else {
                    EntityPropertiesDialogEx.this.cbSuperType.removeAllItems();
                    Iterator iterator = EntityPropertiesDialogEx.this.entity.getDesign().getLogicalDesign().getEntitySet().iterator();
                    ArrayList<Entity> arrayList = new ArrayList<Entity>();
                    while (iterator.hasNext()) {
                        Entity entity = (Entity)iterator.next();
                        if (entity.isBST() || entity == EntityPropertiesDialogEx.this.entity) continue;
                        arrayList.add(entity);
                    }
                    EntityPropertiesDialogEx.this.fillComboItems(arrayList.toArray(), EntityPropertiesDialogEx.this.cbSuperType, true);
                    EntityPropertiesDialogEx.this.cbSuperType.setEnabled(true);
                    if (EntityPropertiesDialogEx.this.isEditable()) {
                        EntityPropertiesDialogEx.this.bnCOAdd.setEnabled(true);
                        EntityPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                    }
                }
                EntityPropertiesDialogEx.this.enableAttributeOptions(true, 3);
            }
        });
        JLabel jLabel8 = new JLabel(LB_SUPER_TYPE);
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.cbSuperType = new JComboBox();
        this.cbSuperType.setPreferredSize(this.getDefaultSize());
        this.cbSuperType.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.cbSuperType));
        JLabel jLabel9 = new JLabel(LB_SOURCE);
        jLabel9.setPreferredSize(this.getDefaultSize());
        this.tfSource = new JTextField();
        this.tfSource.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel9, this.tfSource));
        JLabel jLabel10 = new JLabel(LB_CL_TYPE);
        jLabel10.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox();
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.cbType.setMaximumRowCount(8);
        this.cbType.addActionListener(new TypeListener());
        this.addRowToGeneralPanel(this.createRow(jLabel10, this.cbType));
        JLabel jLabel11 = new JLabel(LB_SCOPE);
        jLabel11.setPreferredSize(this.getDefaultSize());
        this.tfScope = new JTextField();
        this.tfScope.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel11, this.tfScope));
        JLabel jLabel12 = new JLabel(Messages.getString("EntityPropertiesDialogEx.AllowTypeSubstitution"));
        jLabel12.setPreferredSize(this.getDefaultSize());
        this.chTypeSubst = new JCheckBox();
        this.chTypeSubst.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel12, this.chTypeSubst));
    }

    private CandidateKey getPK() {
        for (CandidateKey candidateKey : this.keysList) {
            if (!candidateKey.isPK()) continue;
            return candidateKey;
        }
        return null;
    }

    private CandidateKey createAndAddKey(boolean bl) {
        CandidateKey candidateKey = new CandidateKey(this.entity.getDesignPart());
        candidateKey.setName(this.generateKeyName());
        candidateKey.setDesign(this.entity.getDesign());
        candidateKey.setContainerObject(this.entity);
        candidateKey.setDesignObjectSet(this.entity.getKeySet());
        this.keysList.add(candidateKey);
        if (bl) {
            candidateKey.setPK(true);
            this.entity.setPK(candidateKey);
        }
        this.itable.updateUI();
        return candidateKey;
    }

    private void updatePKStatus(Attribute attribute, boolean bl) {
        CandidateKey candidateKey = this.getPK();
        if (candidateKey == null && bl) {
            candidateKey = this.createAndAddKey(true);
            candidateKey.setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(this.tfName.getText().trim(), this.entity.getDesign().getDLSettings().getNamingStandardRule()));
        }
        if (candidateKey != null && !bl) {
            candidateKey.remove(attribute);
            return;
        }
        if (candidateKey != null && bl) {
            if (!candidateKey.contains(attribute)) {
                candidateKey.add(attribute);
            }
            if (attribute.getNullsAllowed()) {
                attribute.setNullsAllowed(false);
            }
        }
    }

    protected String generateKeyName() {
        String string = "Key";
        int n = 0;
        int n2 = this.keysList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.keyExists(string2)) {
            n = ++this.counter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean keyExists(String string) {
        for (int i = 0; i < this.keysList.size(); ++i) {
            CandidateKey candidateKey = (CandidateKey)this.keysList.get(i);
            if (!string.equalsIgnoreCase(candidateKey.getName())) continue;
            return true;
        }
        return false;
    }

    protected String generateAttributeName() {
        String string = "Attribute";
        int n = 0;
        int n2 = this.attributesList.size();
        if (n2 != 0) {
            n = this.attrCounter = n2 + 1;
        } else {
            ++this.attrCounter;
            n = this.attrCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.attributeExists(string2)) {
            n = ++this.attrCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    protected String generatePastedAttributeName(String string) {
        Object object2;
        if (!this.attributeExists(string)) {
            return string;
        }
        int n = 0;
        for (Object object2 : this.attributesList) {
            String string2 = ((ContainedObject)object2).getName();
            if (string2.indexOf(string) < 0) continue;
            ++n;
        }
        object2 = string.concat("_").concat(Integer.toString(n));
        while (this.attributeExists((String)object2)) {
            object2 = string.concat("_").concat(Integer.toString(++n));
        }
        return object2;
    }

    private boolean attributeExists(String string) {
        for (int i = 0; i < this.attributesList.size(); ++i) {
            Attribute attribute = (Attribute)this.attributesList.get(i);
            if (!string.equalsIgnoreCase(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    private void deleteAttribute(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
        int[] nArray = jTable.getSelectedRows();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            Object object;
            int n3 = nArray[i];
            if (n3 != -1 && this.attributesList.size() > 0 && n3 < this.attributesList.size() && !((Attribute)(object = (Attribute)this.attributesList.get(n3))).isFKAttribute()) {
                arrayList.add(object);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                this.attributesList.remove(e);
            }
            this.tbAttributes.clearSelection();
            this.tbAttributes.updateUI();
            this.coTable.clearSelection();
            this.coTable.updateUI();
            this.selectedAttribute = null;
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 2);
        }
    }

    protected JPanel getAttributesPanel() {
        Serializable serializable;
        Serializable serializable2;
        if (this.pnAttributes == null) {
            this.pnAttributes = new JPanel(new BorderLayout());
            this.attributesList = new ArrayList();
            serializable2 = new DataModel();
            this.tbAttributes = new AttributeTable((TableModel)((Object)serializable2));
            this.tbAttributes.setSelectionMode(1);
            serializable = this.tbAttributes.getColumnModel().getColumn(0);
            ((TableColumn)serializable).setPreferredWidth(30);
            ((TableColumn)serializable).setMaxWidth(50);
            ((TableColumn)serializable).setMinWidth(25);
            serializable = this.tbAttributes.getColumnModel().getColumn(1);
            ((TableColumn)serializable).setPreferredWidth(295);
            serializable = this.tbAttributes.getColumnModel().getColumn(2);
            ((TableColumn)serializable).setCellRenderer(new DataTypeCellRenderer());
            ((TableColumn)serializable).setPreferredWidth(275);
            serializable = this.tbAttributes.getColumnModel().getColumn(3);
            ((TableColumn)serializable).setMaxWidth(30);
            ((TableColumn)serializable).setMinWidth(30);
            ((TableColumn)serializable).setCellRenderer(new StatusCellRenderer());
            serializable = this.tbAttributes.getColumnModel().getColumn(4);
            ((TableColumn)serializable).setMaxWidth(30);
            ((TableColumn)serializable).setMinWidth(30);
            ((TableColumn)serializable).setCellRenderer(new StatusCellRenderer());
            serializable = this.tbAttributes.getColumnModel().getColumn(5);
            ((TableColumn)serializable).setMaxWidth(30);
            ((TableColumn)serializable).setMinWidth(30);
            ((TableColumn)serializable).setCellRenderer(new StatusCellRenderer());
            serializable = this.tbAttributes.getColumnModel().getColumn(6);
            ((TableColumn)serializable).setPreferredWidth(170);
            serializable = this.tbAttributes.getColumnModel().getColumn(7);
            ((TableColumn)serializable).setPreferredWidth(220);
            serializable = this.tbAttributes.getColumnModel().getColumn(8);
            ((TableColumn)serializable).setPreferredWidth(170);
            JScrollPane jScrollPane = new JScrollPane(this.tbAttributes);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.pnAttributes.add(jPanel);
        }
        serializable2 = new JTabbedPane();
        ((JTabbedPane)serializable2).addTab(Messages.getString("EntityPropertiesDialogEx.Details"), this.createExtendedAttributePanel());
        ((JTabbedPane)serializable2).addTab(Messages.getString("EntityPropertiesDialogEx.Overview"), this.pnAttributes);
        serializable = this.createPage(ATTRIBUTES_TAB_NAME);
        ((Container)serializable).add((Component)serializable2);
        ((JTabbedPane)serializable2).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
            }
        });
        return serializable;
    }

    private void setAttributeSelected() {
        int n = this.coTable.getSelectedRow();
        if (n != -1 && this.attributesList.size() > 0 && n < this.attributesList.size()) {
            Attribute attribute = (Attribute)this.attributesList.get(n);
            this.initSelectedAttributeOptions(attribute, true);
        }
    }

    private void enableAttributeOptions(boolean bl, int n) {
        boolean bl2 = this.cbBasedOnST.getSelectedItem() != null;
        boolean bl3 = bl && !bl2;
        this.tfColumnName.setEnabled(bl3);
        this.rbDomain.setEnabled(bl3);
        this.rbLogical.setEnabled(bl3);
        if (n == 0) {
            this.rbStructured.setEnabled(bl3);
            this.rbDistinct.setEnabled(bl3);
            this.rbCollection.setEnabled(bl3);
        } else if (n == 1 || n == 2 || n == 3) {
            if (this.structuredTypesCount > 0) {
                this.rbStructured.setEnabled(bl3);
            } else {
                this.rbStructured.setEnabled(false);
            }
            if (this.distinctTypesCount > 0) {
                this.rbDistinct.setEnabled(bl3);
            } else {
                this.rbDistinct.setEnabled(false);
            }
            if (this.collectionTypesCount > 0) {
                this.rbCollection.setEnabled(bl3);
            } else {
                this.rbCollection.setEnabled(false);
            }
            if (this.rbStructured.isSelected() && !this.rbStructured.isEnabled() || this.rbDistinct.isSelected() && !this.rbDistinct.isEnabled() || this.rbCollection.isSelected() && !this.rbCollection.isEnabled()) {
                this.rbDomain.setSelected(true);
            }
        }
        this.cbDatatype.setEnabled(bl3);
        this.ifDTSize.setEnabled(bl3);
        this.cbUnits.setEnabled(bl3);
        this.ifDTPrecision.setEnabled(bl3);
        this.ifDTScale.setEnabled(bl3);
        this.chbPK.setEnabled(bl3);
        this.chbMandatory.setEnabled(bl);
        this.taColumnComments.setEnabled(bl);
        this.taColumnCommentsInRDBMS.setEnabled(bl);
        this.taColumnNotes.setEnabled(bl);
        this.chbReference.setEnabled(bl);
        if (!bl) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.tfColumnName.setText("");
            this.ifDTSize.setText("");
            this.cbUnits.setSelectedIndex(0);
            this.ifDTPrecision.setText("");
            this.ifDTScale.setText("");
            this.taColumnComments.setText("");
            this.taColumnCommentsInRDBMS.setText("");
            this.taColumnNotes.setText("");
        }
    }

    private void disableFKColumnOptions(Attribute attribute) {
        if (this.isEditable()) {
            boolean bl = !attribute.isFKElement();
            boolean bl2 = !ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && !attribute.isFKElement();
            boolean bl3 = this.cbBasedOnST.getSelectedItem() != null;
            boolean bl4 = bl && !bl3;
            this.rbDomain.setEnabled(bl4);
            this.rbLogical.setEnabled(bl4);
            if (!bl) {
                this.rbDistinct.setEnabled(bl4);
                this.rbStructured.setEnabled(bl4);
                this.rbCollection.setEnabled(bl4);
            } else {
                if (this.structuredTypesCount > 0) {
                    this.rbStructured.setEnabled(bl4);
                } else {
                    this.rbStructured.setEnabled(false);
                }
                if (this.distinctTypesCount > 0) {
                    this.rbDistinct.setEnabled(bl4);
                } else {
                    this.rbDistinct.setEnabled(false);
                }
                if (this.collectionTypesCount > 0) {
                    this.rbCollection.setEnabled(bl4);
                } else {
                    this.rbCollection.setEnabled(false);
                }
            }
            this.taColumnComments.setEditable(bl2);
            this.taColumnCommentsInRDBMS.setEditable(bl2);
            this.taColumnNotes.setEditable(bl2);
            this.cbDatatype.setEnabled(bl4);
            this.ifDTSize.setEnabled(bl4);
            this.cbUnits.setEnabled(bl4);
            this.ifDTPrecision.setEnabled(bl4);
            this.ifDTScale.setEnabled(bl4);
            this.chbMandatory.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDTComboBox() {
        block61: {
            block62: {
                block60: {
                    this.cbDatatype.removeAllItems();
                    this.pnDType.removeAll();
                    this.pnDType.updateUI();
                    if (!this.rbDomain.isSelected()) break block60;
                    Domain domain = null;
                    if (this.selectedAttribute != null) {
                        domain = this.selectedAttribute.getDomain();
                    }
                    if (domain == null) {
                        domain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> arrayList = new ArrayList<Domain>();
                        List list = this.getCurrentPreferredDomains();
                        arrayList.addAll(list);
                        if (list.size() > 0) {
                            for (Domain domain2 : list) {
                                if (domain == null) continue;
                                if (!domain2.getObjectID().equalsIgnoreCase(domain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(domain)) continue;
                                    this.additionalPreferredDomains.add(domain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(domain)) {
                                    this.additionalPreferredDomains.remove(domain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(domain)) {
                            this.additionalPreferredDomains.add(domain);
                        }
                        arrayList.addAll(this.additionalPreferredDomains);
                        for (Domain domain2 : arrayList) {
                            this.cbDatatype.addItem(domain2);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = domain2;
                            }
                            if (!((Object)domain2).toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = domain2;
                        }
                        this.cbDatatype.setSelectedItem(domain);
                        this.getAppView().getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator iterator = this.getDesignObject().getDesign().getDomainSet().iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            this.cbDatatype.addItem(e);
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        this.cbDatatype.setSelectedItem(domain);
                        this.getAppView().getSettings().setUsePreferredDomains(false);
                    }
                    break block61;
                }
                if (!this.rbLogical.isSelected()) break block62;
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                try {
                    String[] stringArray;
                    this.cbDatatype.removeActionListener(this.cbDatatypeActionListener);
                    this.selLogicalDatatype = null;
                    if (this.selectedAttribute != null) {
                        this.selLogicalDatatype = this.selectedAttribute.getLogicalDatatype();
                        string = this.selectedAttribute.getDataTypeParameter("size");
                        string2 = this.selectedAttribute.getDataTypeParameter("precision");
                        string3 = this.selectedAttribute.getDataTypeParameter("scale");
                        stringArray = string.split(INTERVAL_STRING);
                        if (stringArray.length == 2) {
                            string = stringArray[0];
                            string4 = stringArray[1];
                        }
                    }
                    if (this.initialUseLogicalTypePreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                        this.initialUseLogicalTypePreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        stringArray = new ArrayList();
                        List list = this.getCurrentPreferredLogicalDatatypes();
                        stringArray.addAll(list);
                        if (list.size() > 0) {
                            for (LogicalDatatype logicalDatatype : list) {
                                if (this.selLogicalDatatype == null) continue;
                                if (!logicalDatatype.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                    this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                    continue;
                                }
                                if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                    this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                            this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                        }
                        stringArray.addAll(this.additionalPreferredLogicalTypes);
                        for (Object e : stringArray) {
                            this.cbDatatype.addItem(e);
                            if (this.logicalDefaultDataType == null) {
                                this.logicalDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = e;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
                    } else {
                        stringArray = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                        while (stringArray.hasNext()) {
                            Object e = stringArray.next();
                            this.cbDatatype.addItem(e);
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = e;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
                    }
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                }
                catch (Throwable throwable) {
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    if (this.ifDTSize.isEnabled()) {
                        try {
                            this.ifDTSize.setText(string != null && string != "" ? string : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTPrecision.isEnabled()) {
                        try {
                            this.ifDTPrecision.setValue((long)Integer.parseInt(string2 != null && string2 != "" ? string2 : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTScale.isEnabled()) {
                        try {
                            this.ifDTScale.setValue((long)Integer.parseInt(string3 != null && string3 != "" ? string3 : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.cbUnits.isEnabled()) {
                        this.cbUnits.setSelectedItem(string4);
                    }
                    throw throwable;
                }
                if (this.ifDTSize.isEnabled()) {
                    try {
                        this.ifDTSize.setText(string != null && string != "" ? string : null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTPrecision.isEnabled()) {
                    try {
                        this.ifDTPrecision.setValue((long)Integer.parseInt(string2 != null && string2 != "" ? string2 : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTScale.isEnabled()) {
                    try {
                        this.ifDTScale.setValue((long)Integer.parseInt(string3 != null && string3 != "" ? string3 : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.cbUnits.isEnabled()) {
                    this.cbUnits.setSelectedItem(string4);
                }
                break block61;
            }
            if (this.rbDistinct.isSelected()) {
                Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                while (iterator.hasNext()) {
                    this.cbDatatype.addItem(iterator.next());
                }
            } else if (this.rbStructured.isSelected()) {
                Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                while (iterator.hasNext()) {
                    this.cbDatatype.addItem(iterator.next());
                }
                this.pnDType.add(this.pnRef);
                this.chbReference.setSelected(false);
            } else if (this.rbCollection.isSelected()) {
                Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                while (iterator.hasNext()) {
                    this.cbDatatype.addItem(iterator.next());
                }
            }
        }
        this.cbDatatype.updateUI();
    }

    private void setPreviousSelectedAttribute() {
        if (this.selectedAttribute != null) {
            String string;
            int n = 0;
            String string2 = string = this.tfColumnName.getText();
            while (this.attributeExists(string2) && !this.selectedAttribute.getName().equalsIgnoreCase(this.tfColumnName.getText())) {
                string2 = string.concat("_").concat(Integer.toString(++n));
            }
            this.selectedAttribute.setName(string2);
            if (this.rbDomain.isSelected()) {
                Object object = this.cbDatatype.getSelectedItem();
                if (object instanceof Domain) {
                    Domain domain = (Domain)object;
                    this.selectedAttribute.setUse((short)0);
                    this.selectedAttribute.setDomain(domain);
                    if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                        this.selectedAttribute.setUseDomainConstraints(true);
                    }
                }
            } else if (this.rbLogical.isSelected()) {
                int n2;
                this.selectedAttribute.setDataTypeParameter("size", "");
                this.selectedAttribute.setDataTypeParameter("precision", "");
                this.selectedAttribute.setDataTypeParameter("scale", "");
                this.selectedAttribute.setUse((short)1);
                this.selectedAttribute.setLogicalDatatype((LogicalDatatype)this.cbDatatype.getSelectedItem());
                Map map = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                String string3 = (String)map.get("precision_default_value");
                int n3 = string3 != "" && string3 != null ? new Integer((String)map.get("precision_default_value")) : 0;
                String string4 = (String)map.get("size_default_value");
                String string5 = (String)map.get("scale_default_value");
                int n4 = n2 = string5 != "" && string5 != null ? new Integer((String)map.get("scale_default_value")) : 0;
                if (this.sizeEnabled) {
                    String string6 = this.ifDTSize.getText();
                    if (string6 != "" && !string6.equals(string4)) {
                        if (this.cbUnits.getSelectedIndex() > 0) {
                            this.selectedAttribute.setDataTypeParameter("size", String.valueOf(string6) + ' ' + this.cbUnits.getSelectedItem());
                        } else {
                            this.selectedAttribute.setDataTypeParameter("size", String.valueOf(string6));
                        }
                    } else {
                        this.selectedAttribute.setDataTypeParameter("size", "");
                        this.selectedAttribute.setDataTypeParameter("precision", "");
                        this.selectedAttribute.setDataTypeParameter("scale", "");
                    }
                } else if (this.precisionEnabled) {
                    this.selectedAttribute.setDataTypeParameter("size", "");
                    if (this.ifDTPrecision.getIntValue() != n3 || this.ifDTScale.getIntValue() != n2) {
                        this.selectedAttribute.setDataTypeParameter("precision", String.valueOf(this.ifDTPrecision.getIntValue()));
                        this.selectedAttribute.setDataTypeParameter("scale", String.valueOf(this.ifDTScale.getIntValue()));
                    } else {
                        this.selectedAttribute.setDataTypeParameter("precision", "");
                        this.selectedAttribute.setDataTypeParameter("scale", "");
                    }
                }
            } else if (this.rbDistinct.isSelected()) {
                this.selectedAttribute.setUse((short)2);
                this.selectedAttribute.setDistinctType((DistinctType)this.cbDatatype.getSelectedItem());
            } else if (this.rbStructured.isSelected()) {
                this.selectedAttribute.setUse((short)3);
                this.selectedAttribute.setStructuredType((StructuredType)this.cbDatatype.getSelectedItem());
                this.selectedAttribute.setReference(this.chbReference.isSelected());
            } else if (this.rbCollection.isSelected()) {
                this.selectedAttribute.setUse((short)4);
                this.selectedAttribute.setCollectionType((CollectionType)this.cbDatatype.getSelectedItem());
            }
            this.selectedAttribute.setComment(this.taColumnComments.getText());
            this.selectedAttribute.setCommentInRDBMS(this.taColumnCommentsInRDBMS.getText());
            this.selectedAttribute.setNotes(this.taColumnNotes.getText());
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
        }
    }

    private void initSelectedAttributeOptions(Attribute attribute, boolean bl) {
        if (bl && this.selectedAttribute == attribute) {
            return;
        }
        if (bl) {
            this.setPreviousSelectedAttribute();
        }
        this.selectedAttribute = attribute;
        if (this.isEditable()) {
            this.enableAttributeOptions(true, 3);
        } else {
            this.enableAttributeOptions(false, 3);
        }
        this.tfColumnName.setText(attribute.getName());
        short s = attribute.getUse();
        switch (s) {
            case 0: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDomain());
                break;
            }
            case 1: {
                this.rbLogical.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getLogicalDatatype());
                try {
                    if (this.isEditable()) {
                        this.cbUnits.setEnabled(true);
                    }
                    String string = attribute.getSize();
                    String[] stringArray = string.split(INTERVAL_STRING);
                    this.ifDTSize.setText(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.cbUnits.setSelectedItem(stringArray[1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.ifDTPrecision.setValue(Integer.parseInt(attribute.getPrecision()) > 0 ? Integer.valueOf(Integer.parseInt(attribute.getPrecision())) : null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.ifDTScale.setValue(Integer.parseInt(attribute.getScale()) > 0 ? Integer.valueOf(Integer.parseInt(attribute.getScale())) : null);
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                this.rbDistinct.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDistinctType());
                break;
            }
            case 3: {
                this.rbStructured.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getStructuredType());
                this.chbReference.setSelected(attribute.isReference());
                break;
            }
            case 4: {
                this.rbCollection.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getCollectionType());
                break;
            }
            default: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDomain());
            }
        }
        this.chbPK.setSelected(this.isPK(attribute));
        this.chbFK.setSelected(attribute.isFKElement());
        this.chbMandatory.setSelected(!attribute.getNullsAllowed());
        this.taColumnComments.setText(attribute.getComment());
        this.taColumnCommentsInRDBMS.setText(attribute.getCommentInRDBMS());
        this.taColumnNotes.setText(attribute.getNotes());
        this.disableFKColumnOptions(attribute);
        if (this.isPK(attribute) || attribute.isFKElement()) {
            this.chbMandatory.setEnabled(false);
        }
        this.coTable.updateUI();
        boolean bl2 = this.getAppView().getSettings().isKeepFKNamesSynchronized();
        if (attribute.isFKAttribute() && bl2) {
            this.tfColumnName.setEnabled(false);
        } else {
            this.tfColumnName.selectAll();
            this.tfColumnName.requestFocus();
        }
    }

    private boolean isPK(ContainedObject containedObject) {
        for (KeyObject keyObject : this.keysList) {
            if (!keyObject.isPK() || !keyObject.contains(containedObject)) continue;
            return true;
        }
        return false;
    }

    private void addAttribute(ActionEvent actionEvent) {
        boolean bl = false;
        boolean bl2 = false;
        if (actionEvent != null) {
            bl = (actionEvent.getModifiers() & 1) == 1;
            bl2 = (actionEvent.getModifiers() & 2) == 2;
        }
        int n = this.coTable.getSelectedRow();
        int n2 = this.attributesList.size();
        Attribute attribute = new Attribute(this.entity.getDesignPart());
        attribute.setName(this.generateAttributeName());
        attribute.setDesign(this.entity.getDesign());
        attribute.setContainer(this.entity);
        attribute.setDesignObjectSet(this.entity.getAttributeSet());
        int n3 = n2;
        if (n > -1) {
            if (bl) {
                if (n2 == 0) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(n, attribute);
                    n3 = n;
                }
            } else if (bl2) {
                if (n2 == 0 || n2 - 1 == n) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(n + 1, attribute);
                    n3 = n + 1;
                }
            } else {
                this.attributesList.add(attribute);
            }
        } else {
            this.attributesList.add(attribute);
        }
        this.tbAttributes.updateUI();
        this.coTable.updateUI();
        this.tbAttributes.changeSelection(n3, 1, false, false);
        this.coTable.changeSelection(n3, 1, false, false);
        this.initSelectedAttributeOptions(attribute, true);
        Enumeration<AbstractButton> enumeration = this.group.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getText().trim().equalsIgnoreCase(this.storedColumnDefaultDatatype)) continue;
            jRadioButton.setSelected(true);
            this.updateDTComboBox();
            this.setDefaultDatatype();
        }
        this.enableAttributeOptions(true, 1);
    }

    private void setDefaultDatatype() {
        if (this.rbDomain.isSelected()) {
            this.cbDatatype.setSelectedItem(this.domainDefaultDataType);
        } else if (this.rbLogical.isSelected()) {
            this.cbDatatype.setSelectedItem(this.logicalDefaultDataType);
        }
    }

    private void coCopyAttributes() {
        this.getAppView().clearCopiedObjects();
        int[] nArray = this.coTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= -1 || n >= this.attributesList.size()) continue;
            this.getAppView().addCopiedObject((Attribute)this.attributesList.get(n));
        }
        this.bnCOPaste.setEnabled(this.getAppView().getCopiedObjects().size() > 0);
    }

    private void coPasteAttributes() {
        List list = this.getAppView().getCopiedObjects();
        for (Object e : list) {
            if (!(e instanceof Attribute)) continue;
            Attribute attribute = (Attribute)e;
            Attribute attribute2 = new Attribute(this.entity.getDesignPart());
            attribute2.setName(this.generatePastedAttributeName(attribute.getName()));
            String string = attribute2.getName();
            attribute2.setDesign(this.entity.getDesign());
            attribute2.setContainer(this.entity);
            attribute2.setDesignObjectSet(this.entity.getAttributeSet());
            this.attributesList.add(attribute2);
            attribute.copy(attribute2);
            attribute2.setName(string);
        }
        if (list.size() > 0) {
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
            this.tbAttributes.changeSelection(this.attributesList.size() - 1, 1, false, false);
            this.coTable.changeSelection(this.attributesList.size() - 1, 1, false, false);
        }
    }

    private JPanel createExtendedAttributePanel() {
        Object object;
        Object object2;
        Object object3;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.coTable = new JTable(new AttributeModel());
        this.coTable.setSelectionMode(2);
        TableColumn tableColumn = this.coTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(25);
        this.coTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Attribute attribute;
                int n;
                if (mouseEvent.getClickCount() == 1) {
                    EntityPropertiesDialogEx.this.setAttributeSelected();
                } else if (mouseEvent.getClickCount() == 2 && (n = EntityPropertiesDialogEx.this.coTable.getSelectedRow()) != -1 && EntityPropertiesDialogEx.this.attributesList.size() > 0 && n < EntityPropertiesDialogEx.this.attributesList.size() && !(attribute = (Attribute)EntityPropertiesDialogEx.this.attributesList.get(n)).isDialogVisible()) {
                    attribute.showModal = true;
                    AttributePropertiesDialogEx attributePropertiesDialogEx = new AttributePropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), attribute, EntityPropertiesDialogEx.this.chbUsePreferredList.isSelected());
                    attributePropertiesDialogEx.initProperties(attribute);
                    attributePropertiesDialogEx.show();
                    if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                        EntityPropertiesDialogEx.this.initSelectedAttributeOptions(EntityPropertiesDialogEx.this.selectedAttribute, false);
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.coTable);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setPreferredSize(new Dimension(250, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_PROPERTIES);
        jButton.addActionListener(new COPropertiesAction());
        if (this.isEditable()) {
            object3 = new MoveUpDownListJTable(this.attributesList, this.coTable);
            object2 = "<html><body>" + Messages.getString("EntityPropertiesDialogEx.AddTip1") + "<p>" + Messages.getString("EntityPropertiesDialogEx.AddTip2") + "<p>" + Messages.getString("EntityPropertiesDialogEx.AddTip3") + "</body>" + "</html>";
            this.bnCOAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.bnCOAdd.setToolTipText((String)object2);
            this.bnCOAdd.addActionListener(new COAddAction());
            this.bnCORemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnCORemove.setToolTipText(BTN_REMOVE);
            this.bnCORemove.addActionListener(new CORemoveAction());
            this.bnCOUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.bnCOUp.setToolTipText(BTN_MOVE_UP);
            this.bnCOUp.addActionListener(new MoveUpDownListJTable.MoveUpAction((MoveUpDownListJTable)object3));
            this.bnCODown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.bnCODown.setToolTipText(BTN_MOVE_DOWN);
            this.bnCODown.addActionListener(new MoveUpDownListJTable.MoveDownAction((MoveUpDownListJTable)object3));
            this.bnCOCopy = new JButton(gUIConfiguration.getIcon("COPY_ICON", this.getPreferredIconSize()));
            this.bnCOCopy.setToolTipText(Messages.getString("EntityPropertiesDialogEx.CopyAttributes"));
            this.bnCOCopy.addActionListener(new COCopyAction());
            this.bnCOPaste = new JButton(gUIConfiguration.getIcon("PASTE_ICON", this.getPreferredIconSize()));
            this.bnCOPaste.setToolTipText(Messages.getString("EntityPropertiesDialogEx.PasteAttributes"));
            this.bnCOPaste.addActionListener(new COPasteAction());
            this.coTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (EntityPropertiesDialogEx.this.attributesList.isEmpty()) {
                        EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        jButton.setEnabled(false);
                        EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        if (EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem() != null) {
                            EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                        } else {
                            EntityPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                            EntityPropertiesDialogEx.this.bnCOUp.setEnabled(true);
                            EntityPropertiesDialogEx.this.bnCODown.setEnabled(true);
                        }
                        jButton.setEnabled(true);
                        EntityPropertiesDialogEx.this.setAttributeSelected();
                    }
                }
            });
            this.coTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (EntityPropertiesDialogEx.this.attributesList.isEmpty()) {
                        EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        jButton.setEnabled(false);
                        EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        if (EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem() != null) {
                            EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                        } else {
                            EntityPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                            EntityPropertiesDialogEx.this.bnCOUp.setEnabled(true);
                            EntityPropertiesDialogEx.this.bnCODown.setEnabled(true);
                        }
                        jButton.setEnabled(true);
                    }
                }
            });
            object = this.coTable.getSelectionModel();
            object.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                        if (EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem() == null) {
                            if (listSelectionModel.isSelectionEmpty()) {
                                EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                                jButton.setEnabled(false);
                            } else {
                                EntityPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                                jButton.setEnabled(true);
                            }
                        } else {
                            EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                        }
                    }
                }
            });
        }
        object3 = new JToolBar(0);
        ((JToolBar)object3).setFloatable(false);
        ((Container)object3).add(jButton);
        if (this.isEditable()) {
            ((JToolBar)object3).addSeparator();
            ((Container)object3).add(this.bnCOAdd);
            ((Container)object3).add(this.bnCORemove);
            ((Container)object3).add(this.bnCOUp);
            ((Container)object3).add(this.bnCODown);
            ((JToolBar)object3).addSeparator();
            ((Container)object3).add(this.bnCOCopy);
            ((Container)object3).add(this.bnCOPaste);
        }
        jPanel2.add((Component)object3);
        object2 = new JPanel(new BorderLayout());
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.AttributesL")));
        ((Container)object2).add((Component)jPanel2, "North");
        ((Container)object2).add(jScrollPane);
        jPanel.add((Component)object2, "Center");
        this.coTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    EntityPropertiesDialogEx.this.deleteAttribute(EntityPropertiesDialogEx.this.coTable);
                }
            }
        });
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.AttributeProperties")));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(60, 20);
        Dimension dimension2 = new Dimension(120, 20);
        JLabel jLabel = new JLabel(LB_NAME);
        jLabel.setPreferredSize(dimension2);
        this.tfColumnName = new JTextField();
        this.tfColumnName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    EntityPropertiesDialogEx.this.moveUp();
                } else if (keyEvent.getKeyCode() == 40) {
                    EntityPropertiesDialogEx.this.moveDown();
                }
            }
        });
        Dimension dimension3 = new Dimension(200, 20);
        Dimension dimension4 = new Dimension(260, 20);
        this.tfColumnName.setPreferredSize(dimension4);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.createRow(jLabel, this.tfColumnName), "North");
        jPanel4.add((Component)new JPanel(), "Center");
        jPanel3.add((Component)jPanel4, "North");
        RBActionListener rBActionListener = new RBActionListener();
        this.rbDomain = new JRadioButton(LB_DOMAIN);
        this.rbLogical = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Collection"));
        this.rbDomain.addActionListener(rBActionListener);
        this.rbLogical.addActionListener(rBActionListener);
        this.rbDistinct.addActionListener(rBActionListener);
        this.rbStructured.addActionListener(rBActionListener);
        this.rbCollection.addActionListener(rBActionListener);
        this.group = new ButtonGroup();
        this.group.add(this.rbDomain);
        this.group.add(this.rbLogical);
        this.group.add(this.rbDistinct);
        this.group.add(this.rbStructured);
        this.group.add(this.rbCollection);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 0));
        jPanel5.add(this.rbDomain);
        jPanel5.add(this.rbLogical);
        jPanel5.add(this.rbDistinct);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 0));
        jPanel6.add(this.rbStructured);
        jPanel6.add(this.rbCollection);
        jPanel6.add(new JPanel());
        JLabel jLabel2 = new JLabel(LB_DATATYPE);
        jLabel2.setPreferredSize(dimension2);
        JPanel jPanel7 = new JPanel(new GridLayout(0, 1));
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(dimension2);
        jPanel7.add(this.createRow(jLabel2, jPanel5));
        jPanel7.add(this.createRow(jLabel3, jPanel6));
        jPanel3.add((Component)jPanel7, "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 10));
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel8, "Center");
        jPanel3.add((Component)jPanel9, "South");
        JLabel jLabel4 = new JLabel(LB_TYPE);
        jLabel4.setPreferredSize(dimension2);
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setPreferredSize(dimension3);
        this.cbDatatype.setMaximumRowCount(20);
        this.cbDatatypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                if (EntityPropertiesDialogEx.this.rbLogical.isSelected()) {
                    EntityPropertiesDialogEx.this.updateLogicalDatatypeOptions();
                    LogicalDatatype logicalDatatype = (LogicalDatatype)EntityPropertiesDialogEx.this.cbDatatype.getSelectedItem();
                    if (logicalDatatype != null) {
                        String string = logicalDatatype.getName();
                        Design design = EntityPropertiesDialogEx.this.getDesignObject().getDesign();
                        LogicalDatatype logicalDatatype2 = (LogicalDatatype)design.getLogicalDatatypeSet().getByName(string);
                        MDDataType mDDataType = logicalDatatype2.createDataType(design.getSelectedRDBMSType().getName(), new HashMap());
                        String string2 = mDDataType.getName();
                        bl = LogicalDatatype.canBeUsedForPK(string2);
                    }
                } else if (EntityPropertiesDialogEx.this.rbStructured.isSelected() && EntityPropertiesDialogEx.this.selectedAttribute != null && !EntityPropertiesDialogEx.this.selectedAttribute.isOid() || EntityPropertiesDialogEx.this.rbCollection.isSelected()) {
                    bl = false;
                }
                if (!bl) {
                    EntityPropertiesDialogEx.this.removeSelectedColumnFromPK();
                    EntityPropertiesDialogEx.this.removeSelectedColumnFromUK();
                } else {
                    EntityPropertiesDialogEx.this.chbPK.setEnabled(EntityPropertiesDialogEx.this.isEditable() && EntityPropertiesDialogEx.this.selectedAttribute != null);
                }
            }
        };
        this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
        JLabel jLabel5 = new JLabel(Messages.getString("EntityPropertiesDialogEx.Preferred"));
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setPreferredSize(new Dimension(jLabel5.getPreferredSize().width + 10, jLabel5.getPreferredSize().height));
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JPanel(), "North");
        jPanel4.add((Component)this.createRow(jLabel4, this.cbDatatype), "Center");
        jPanel4.add((Component)this.createRow(jLabel5, this.chbUsePreferredList), "East");
        jPanel8.add((Component)jPanel4, "North");
        this.pnDType = new JPanel(new BorderLayout());
        this.pnDType.setPreferredSize(new Dimension(200, 50));
        JLabel jLabel6 = new JLabel(' ' + LB_SIZE);
        jLabel6.setHorizontalAlignment(2);
        jLabel6.setPreferredSize(dimension2);
        this.ifDTSize = new JTextField();
        this.ifDTSize.setPreferredSize(dimension4);
        this.pnDTSize = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTSize.add(this.createRow(jLabel6, this.ifDTSize));
        this.pnDType.add((Component)this.pnDTSize, "North");
        jPanel8.add((Component)this.pnDType, "Center");
        JLabel jLabel7 = new JLabel(Messages.getString("EntityPropertiesDialogEx.Units"));
        jLabel7.setHorizontalAlignment(2);
        jLabel7.setPreferredSize(dimension2);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(new Dimension(60, 20));
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)this.createRow(jLabel7, this.cbUnits), "West");
        jPanel10.add((Component)new JPanel(), "Center");
        this.pnDTSize.add(jPanel10);
        JLabel jLabel8 = new JLabel(LB_PRECISION);
        jLabel8.setHorizontalAlignment(2);
        jLabel8.setPreferredSize(dimension2);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setPreferredSize(dimension4);
        this.pnDTScale = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTScale.add(this.createRow(jLabel8, this.ifDTPrecision));
        JLabel jLabel9 = new JLabel(LB_SCALE);
        jLabel9.setHorizontalAlignment(2);
        jLabel9.setPreferredSize(dimension2);
        this.ifDTScale = new JIntegerField();
        this.ifDTScale.setPreferredSize(dimension4);
        this.pnDTScale.add(this.createRow(jLabel9, this.ifDTScale));
        this.pnRef = new JPanel(new GridLayout(0, 1, 0, 10));
        JLabel jLabel10 = new JLabel("");
        jLabel10.setHorizontalAlignment(0);
        jLabel10.setPreferredSize(dimension);
        this.chbReference = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.Reference"));
        this.ifDTSize.setPreferredSize(dimension4);
        this.pnRef.add(this.createRow(jLabel10, this.chbReference));
        JPanel jPanel11 = new JPanel(new GridLayout(0, 1));
        jPanel9.add((Component)jPanel11, "South");
        jPanel11.add(new JPanel());
        this.chbPK = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.PK"));
        this.chbPKActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                    EntityPropertiesDialogEx.this.updatePKStatus(EntityPropertiesDialogEx.this.selectedAttribute, EntityPropertiesDialogEx.this.chbPK.isSelected());
                    if (EntityPropertiesDialogEx.this.chbPK.isSelected()) {
                        EntityPropertiesDialogEx.this.chbMandatory.setSelected(true);
                        EntityPropertiesDialogEx.this.chbMandatory.setEnabled(false);
                    } else {
                        EntityPropertiesDialogEx.this.chbMandatory.setEnabled(true);
                    }
                }
            }
        };
        this.chbPK.addActionListener(this.chbPKActionListener);
        this.chbFK = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.FK"));
        this.chbFK.setEnabled(false);
        this.chbMandatory = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.Mandatory"));
        this.chbMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                    EntityPropertiesDialogEx.this.selectedAttribute.setNullsAllowed(!EntityPropertiesDialogEx.this.chbMandatory.isSelected());
                }
            }
        });
        JPanel jPanel12 = new JPanel(new GridLayout(1, 0));
        jPanel12.add(this.chbPK);
        jPanel12.add(this.chbFK);
        jPanel12.add(this.chbMandatory);
        jLabel3 = new JLabel("");
        jLabel3.setPreferredSize(dimension);
        jPanel11.add(this.createRow(jLabel3, jPanel12));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.taColumnComments = new JTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnNotes = new JTextArea();
        this.taColumnNotes.setLineWrap(true);
        this.taColumnNotes.setWrapStyleWord(true);
        this.taColumnCommentsInRDBMS = new JTextArea();
        this.taColumnCommentsInRDBMS.setLineWrap(true);
        this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
        jTabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.Comments"), new JScrollPane(this.taColumnComments));
        jTabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.CommentsInRDBMS"), new JScrollPane(this.taColumnCommentsInRDBMS));
        jTabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.Notes"), new JScrollPane(this.taColumnNotes));
        jTabbedPane.setPreferredSize(new Dimension(300, 100));
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        jPanel13.add(jPanel3);
        ((Container)object).add((Component)jPanel13, "North");
        ((Container)object).add((Component)jTabbedPane, "Center");
        jPanel.add((Component)object, "East");
        this.updateDTComboBox();
        return jPanel;
    }

    private void removeSelectedColumnFromPK() {
        this.chbPK.setSelected(false);
        this.chbPK.setEnabled(false);
        CandidateKey candidateKey = this.getPK();
        if (candidateKey != null && candidateKey.contains(this.selectedAttribute)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("EntityPropertiesDialogEx.PKAttributeRemoved"), Messages.getString("EntityPropertiesDialogEx.PKAttributesAssignment"), 2);
        }
        this.chbPKActionListener.actionPerformed(null);
    }

    private void removeSelectedColumnFromUK() {
        StringBuilder stringBuilder = new StringBuilder();
        for (KeyObject keyObject : this.keysList) {
            if (!keyObject.contains(this.selectedAttribute)) continue;
            keyObject.remove(this.selectedAttribute);
            this.logIndexColumnRemoved(keyObject.getName(), stringBuilder);
        }
        if (stringBuilder.length() > 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.UKAttributeRemoved"), stringBuilder.toString()), Messages.getString("EntityPropertiesDialogEx.UKAttributesAssignment"), 2);
        }
    }

    private void logIndexColumnRemoved(String string, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }

    private void moveUp() {
        int n = this.coTable.getSelectedRow();
        if (n > 0) {
            this.coTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            this.setAttributeSelected();
        }
    }

    private void moveDown() {
        int n = this.coTable.getSelectedRow();
        if (n > -1) {
            if (n < this.attributesList.size() - 1) {
                this.coTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                this.setAttributeSelected();
            } else if (!ApplicationView.IS_VIEWER && n == this.attributesList.size() - 1) {
                this.addAttribute(null);
            }
        }
    }

    private void updateLogicalDatatypeOptions() {
        this.ifDTSize.setText("");
        this.ifDTPrecision.setText("");
        this.ifDTScale.setText("");
        this.cbUnits.setSelectedIndex(0);
        this.cbUnits.setEnabled(false);
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        this.sizeEnabled = false;
        this.precisionEnabled = false;
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbDatatype.getSelectedItem();
        if (logicalDatatype != null) {
            Map map = logicalDatatype.getLTDefaultValues();
            if (map != null) {
                this.precisionDefaultValue = (String)map.get("precision_default_value");
                this.sizeDefaultValue = (String)map.get("size_default_value");
                this.scaleDefaultValue = (String)map.get("scale_default_value");
            }
            Map map2 = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(this.entity.getSelectedRDBMSType().getName(), map2);
            if (mDDataType instanceof MDImplicitSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.ifDTPrecision.setText(this.precisionDefaultValue);
                this.ifDTPrecision.setEnabled(false);
                this.ifDTScale.setText(this.scaleDefaultValue);
                this.ifDTScale.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
            } else if (mDDataType instanceof MDPackedSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.add((Component)this.pnDTScale, "North");
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = true;
                try {
                    if (mDDataType.getPrecision() != 0) {
                        this.ifDTPrecision.setText("" + mDDataType.getPrecision());
                    }
                    if (this.isEditable()) {
                        this.ifDTPrecision.setEnabled(true);
                        if (this.ifDTPrecision.getText().trim().length() == 0) {
                            this.ifDTPrecision.setText(this.precisionDefaultValue);
                        }
                    }
                }
                catch (Exception exception) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.getScale() != 0) {
                        this.ifDTScale.setText("" + mDDataType.getScale());
                    }
                    if (this.isEditable()) {
                        this.ifDTScale.setEnabled(true);
                        if (this.ifDTScale.getText().trim().length() == 0) {
                            this.ifDTScale.setText(this.scaleDefaultValue);
                        }
                    }
                }
                catch (Exception exception) {
                    this.ifDTScale.setEnabled(false);
                }
            } else {
                try {
                    if (mDDataType.hasSize()) {
                        if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                            String string = mDDataType.getSize();
                            String[] stringArray = string.split(INTERVAL_STRING);
                            this.ifDTSize.setText(stringArray[0]);
                            if (stringArray.length == 2) {
                                this.cbUnits.setSelectedItem(stringArray[1]);
                            }
                        } else {
                            this.ifDTSize.setText(this.sizeDefaultValue);
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                        }
                        if (this.isEditable()) {
                            this.ifDTSize.setEnabled(true);
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTSize, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = true;
                        this.precisionEnabled = false;
                    } else {
                        this.ifDTSize.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTSize.setEnabled(false);
                }
                try {
                    if (mDDataType.hasPrecision()) {
                        if (mDDataType.getPrecision() != 0) {
                            this.ifDTPrecision.setText("" + mDDataType.getPrecision());
                        }
                        if (this.isEditable()) {
                            this.ifDTPrecision.setEnabled(true);
                            if (this.ifDTPrecision.getText().trim().length() == 0) {
                                this.ifDTPrecision.setText(this.precisionDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTPrecision.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.hasScale()) {
                        if (mDDataType.getScale() != 0) {
                            this.ifDTScale.setText("" + mDDataType.getScale());
                        }
                        if (this.isEditable()) {
                            this.ifDTScale.setEnabled(true);
                            if (this.ifDTScale.getText().trim().length() == 0) {
                                this.ifDTScale.setText(this.scaleDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTScale.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTScale.setEnabled(false);
                }
            }
        }
    }

    protected JPanel getRelationsPanel() {
        if (this.pnRelations == null) {
            Object object;
            this.pnRelations = this.createPage(Messages.getString("EntityPropertiesDialogEx.76"));
            this.relationsList = new ArrayList();
            RelationsModel relationsModel = new RelationsModel();
            this.tbRelations = new RelationTable(relationsModel);
            this.tbRelations.setSelectionMode(0);
            TableColumn tableColumn = this.tbRelations.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(400);
            this.tbRelations.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Relation relation;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = EntityPropertiesDialogEx.this.tbRelations.getSelectedRow()) != -1 && EntityPropertiesDialogEx.this.relationsList.size() > 0 && n < EntityPropertiesDialogEx.this.relationsList.size() && !(relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(n)).isDialogVisible()) {
                        relation.showModal = ((EntityPropertiesDialogEx)EntityPropertiesDialogEx.this).entity.showModal;
                        relation.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.tbRelations);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new RelationPropertiesAction());
            if (this.isEditable()) {
                this.tbRelations.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (EntityPropertiesDialogEx.this.relationsList.isEmpty()) {
                            jButton.setEnabled(false);
                        } else {
                            jButton.setEnabled(true);
                        }
                    }
                });
                this.tbRelations.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (EntityPropertiesDialogEx.this.relationsList.isEmpty()) {
                            jButton.setEnabled(false);
                        } else {
                            jButton.setEnabled(true);
                        }
                    }
                });
                object = this.tbRelations.getSelectionModel();
                object.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (!listSelectionEvent.getValueIsAdjusting()) {
                            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                            if (listSelectionModel.isSelectionEmpty()) {
                                jButton.setEnabled(false);
                            } else {
                                jButton.setEnabled(true);
                            }
                        }
                    }
                });
            }
            object = new JToolBar(0);
            ((JToolBar)object).setFloatable(false);
            ((Container)object).add(jButton);
            jPanel.add((Component)object);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnRelations.add(jPanel2);
        }
        return this.pnRelations;
    }

    private void deleteKey() {
        int n = this.itable.getSelectedRow();
        if (n != -1 && this.keysList.size() > 0 && n < this.keysList.size()) {
            this.keysList.remove(n);
            this.itable.updateUI();
        }
    }

    protected JPanel getKeysPanel() {
        if (this.pnKeys == null) {
            JComponent jComponent;
            this.pnKeys = this.createPage(Messages.getString("EntityPropertiesDialogEx.Keys"));
            this.keysList = new ArrayList<KeyObject>();
            KeyModel keyModel = new KeyModel();
            this.itable = new JTable(keyModel);
            this.itable.setSelectionMode(0);
            TableColumn tableColumn = this.itable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(800);
            this.itable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    CandidateKey candidateKey;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = EntityPropertiesDialogEx.this.itable.getSelectedRow()) != -1 && EntityPropertiesDialogEx.this.keysList.size() > 0 && n < EntityPropertiesDialogEx.this.keysList.size() && !(candidateKey = (CandidateKey)EntityPropertiesDialogEx.this.keysList.get(n)).isDialogVisible()) {
                        candidateKey.showModal = true;
                        KeyPropertiesDialogEx keyPropertiesDialogEx = new KeyPropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), candidateKey);
                        keyPropertiesDialogEx.setAttributesList(EntityPropertiesDialogEx.this.attributesList);
                        keyPropertiesDialogEx.initProperties(candidateKey);
                        keyPropertiesDialogEx.show();
                        EntityPropertiesDialogEx.this.itable.updateUI();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.itable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new KeyPropertiesAction());
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                this.btnAddKey = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddKey.setToolTipText(BTN_ADD);
                this.btnAddKey.addActionListener(new AddKeyAction());
                jComponent = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_REMOVE);
                ((AbstractButton)jComponent).addActionListener(new RemoveKeyAction());
                this.itable.getSelectionModel().addListSelectionListener(new ListSelectionListener((JButton)jComponent, jButton){
                    final /* synthetic */ JButton val$btnRemove;
                    final /* synthetic */ JButton val$btnProperties;
                    {
                        this.val$btnRemove = jButton;
                        this.val$btnProperties = jButton2;
                    }

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (EntityPropertiesDialogEx.this.keysList.isEmpty()) {
                            this.val$btnRemove.setEnabled(false);
                            this.val$btnProperties.setEnabled(false);
                        } else {
                            KeyObject keyObject = (KeyObject)EntityPropertiesDialogEx.this.keysList.get(EntityPropertiesDialogEx.this.itable.getSelectedRow());
                            if (keyObject.isOidKey()) {
                                this.val$btnRemove.setEnabled(false);
                                this.val$btnProperties.setEnabled(false);
                            } else {
                                this.val$btnRemove.setEnabled(true);
                                this.val$btnProperties.setEnabled(true);
                            }
                        }
                    }
                });
                this.itable.addPropertyChangeListener(new PropertyChangeListener((JButton)jComponent, jButton){
                    final /* synthetic */ JButton val$btnRemove;
                    final /* synthetic */ JButton val$btnProperties;
                    {
                        this.val$btnRemove = jButton;
                        this.val$btnProperties = jButton2;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (EntityPropertiesDialogEx.this.keysList.isEmpty()) {
                            this.val$btnRemove.setEnabled(false);
                            this.val$btnProperties.setEnabled(false);
                        } else {
                            this.val$btnRemove.setEnabled(true);
                            this.val$btnProperties.setEnabled(true);
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAddKey);
                jToolBar.add(jComponent);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnKeys.add(jComponent);
            this.itable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 127) {
                        EntityPropertiesDialogEx.this.deleteKey();
                    }
                }
            });
        }
        return this.pnKeys;
    }

    protected JPanel getVolumesPanel() {
        if (this.pnVolumes == null) {
            this.pnVolumes = this.createPage(Messages.getString("EntityPropertiesDialogEx.VolumeProperties"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.setBorder(BorderFactory.createTitledBorder(LB_VOLUMES));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_MIN_VOLUME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfMinVolume = new JTextField();
            this.tfMinVolume.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel, this.tfMinVolume));
            JLabel jLabel2 = new JLabel(LB_EXPECTED);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfExpected = new JTextField();
            this.tfExpected.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel2, this.tfExpected));
            JLabel jLabel3 = new JLabel(LB_MAXIMUM);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.tfMaximum = new JTextField();
            this.tfMaximum.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel3, this.tfMaximum));
            jPanel2.add((Component)jPanel3, "North");
            JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jPanel6 = new JPanel(new BorderLayout(10, 10));
            jPanel6.setBorder(BorderFactory.createTitledBorder(LB_GROWTH_RATE));
            JLabel jLabel4 = new JLabel(LB_GROWTH_PERCENT);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.tfGrowthPercent = new JTextField();
            this.tfGrowthPercent.setPreferredSize(this.getDefaultSize());
            jPanel5.add(this.createRow(jLabel4, this.tfGrowthPercent));
            JLabel jLabel5 = new JLabel(LB_YEAR_MONTH_DAY);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbYearMonthDay = new JComboBox<String>(YMD);
            this.cbYearMonthDay.setPreferredSize(this.getDefaultSize());
            this.cbYearMonthDay.setMaximumRowCount(8);
            jPanel5.add(this.createRow(jLabel5, this.cbYearMonthDay));
            JPanel jPanel7 = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jPanel8 = new JPanel(new BorderLayout(10, 10));
            JLabel jLabel6 = new JLabel(LB_NORMAL_FORM);
            jLabel6.setPreferredSize(this.getDefaultSize());
            this.cbNormalForm = new JComboBox<String>(NF);
            this.cbNormalForm.setPreferredSize(this.getDefaultSize());
            this.cbNormalForm.setMaximumRowCount(8);
            jPanel7.add((Component)this.createRow(jLabel6, this.cbNormalForm), "North");
            JLabel jLabel7 = new JLabel(LB_ADEQUATELY_NORMALIZED);
            jLabel7.setPreferredSize(this.getDefaultSize());
            this.cbAdequatelyNormalized = new JComboBox<String>(YES_NO);
            this.cbAdequatelyNormalized.setPreferredSize(this.getDefaultSize());
            this.cbAdequatelyNormalized.setMaximumRowCount(8);
            jPanel7.add((Component)this.createRow(jLabel7, this.cbAdequatelyNormalized), "Center");
            jPanel6.add((Component)jPanel5, "North");
            jPanel4.add((Component)jPanel6, "North");
            jPanel8.add((Component)jPanel7, "North");
            jPanel4.add((Component)jPanel8, "Center");
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel4, "Center");
            this.pnVolumes.add((Component)jPanel, "Center");
        }
        return this.pnVolumes;
    }

    protected JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = EntityPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (EntityPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            EntityPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            EntityPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_Entity(this.entity, null, true), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    @Override
    protected boolean canExit() {
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        if (super.canExit()) {
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        for (KeyObject keyObject : this.keysList) {
            if (((CandidateKey)keyObject).getNewElementsCollection().size() != 0) continue;
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.IncompleteUIDdefinition"), keyObject.getName()), Messages.getString("EntityPropertiesDialogEx.UIDColumnsAssignment"), 0);
            return false;
        }
        return true;
    }

    public boolean containsElement(ComboBoxModel comboBoxModel, Object object) {
        int n = comboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = comboBoxModel.getElementAt(i);
            if (!e.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addEditModeButtons() {
        JButton jButton = new JButton(new AbstractAction(Messages.getString("EntityPropertiesDialogEx.NamingRules")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributesNamingStandards attributesNamingStandards = new AttributesNamingStandards(EntityPropertiesDialogEx.this.getAppView(), EntityPropertiesDialogEx.this.entity);
                attributesNamingStandards.getDialog().setVisible(true);
            }
        });
        jButton.setMnemonic(78);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.pnButtons.add(jButton);
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator iterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            PreferredDomain preferredDomain = new PreferredDomain();
            preferredDomain.setObjectId(domain.getObjectID());
            List<PreferredDomain> list = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain preferredDomain2 : list) {
                if (!preferredDomain.getObjectId().equalsIgnoreCase(preferredDomain2.getObjectId())) continue;
                this.currentPreferredDomainList.add(domain);
            }
        }
        return this.currentPreferredDomainList;
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator iterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)iterator.next();
            List<LogicalDatatype> list = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype logicalDatatype2 : list) {
                if (!logicalDatatype.getObjectID().equalsIgnoreCase(logicalDatatype2.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(logicalDatatype);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    protected JPanel getOverlappingPanel() {
        if (this.pnOverlapping == null) {
            DisabledCellRenderer disabledCellRenderer = new DisabledCellRenderer();
            this.pnOverlapping = this.createPage(PANEL_OVERLAPPED_ATTRIBUTES);
            OverlappedAttributesModel overlappedAttributesModel = new OverlappedAttributesModel();
            this.attribsJTable = new JTable(overlappedAttributesModel);
            this.attribsJTable.setSelectionMode(0);
            this.attribsJTable.setAutoCreateRowSorter(true);
            TableColumn tableColumn = this.attribsJTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(150);
            tableColumn.setWidth(150);
            tableColumn.setMaxWidth(150);
            tableColumn = this.attribsJTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(150);
            tableColumn.setWidth(150);
            tableColumn.setMaxWidth(150);
            tableColumn.setCellRenderer(disabledCellRenderer);
            tableColumn = this.attribsJTable.getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(new OverlappedCellRenderer());
            JScrollPane jScrollPane = new JScrollPane(this.attribsJTable);
            this.pnOverlapping.add(jScrollPane);
        }
        return this.pnOverlapping;
    }

    class DisabledCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        DisabledCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setSelected(bl3);
            this.setEnabled(false);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            return this;
        }
    }

    class OverlappedCellRenderer
    extends JLabel
    implements TableCellRenderer {
        OverlappedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.getModel() instanceof OverlappedAttributesModel && EntityPropertiesDialogEx.this.currentEntHolder != null) {
                LogicalDesign.AttrHolder attrHolder = (LogicalDesign.AttrHolder)((EntityPropertiesDialogEx)EntityPropertiesDialogEx.this).currentEntHolder.attrHolders.get(n);
                this.setOpaque(true);
                String string = (String)object;
                this.setText(string);
                if (attrHolder.relatedHolders.size() > 1) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(jTable.getForeground());
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    public class OverlappedAttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (EntityPropertiesDialogEx.this.currentEntHolder != null) {
                return ((EntityPropertiesDialogEx)EntityPropertiesDialogEx.this).currentEntHolder.attrHolders.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Overlap");
            }
            if (n == 1) {
                return oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.InPK");
            }
            if (n == 2) {
                return oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.AttributesPairs");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0 && EntityPropertiesDialogEx.this.currentEntHolder != null) {
                LogicalDesign.AttrHolder attrHolder = (LogicalDesign.AttrHolder)((EntityPropertiesDialogEx)EntityPropertiesDialogEx.this).currentEntHolder.attrHolders.get(n);
                return !attrHolder.readOnly;
            }
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0 || n == 1) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            LogicalDesign.AttrHolder attrHolder = (LogicalDesign.AttrHolder)((EntityPropertiesDialogEx)EntityPropertiesDialogEx.this).currentEntHolder.attrHolders.get(n);
            if (n2 == 0) {
                return attrHolder.overlap;
            }
            if (n2 == 1) {
                return attrHolder.inpk;
            }
            if (n2 == 2) {
                return attrHolder.toString();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            LogicalDesign.AttrHolder attrHolder = (LogicalDesign.AttrHolder)((EntityPropertiesDialogEx)EntityPropertiesDialogEx.this).currentEntHolder.attrHolders.get(n);
            if (n2 == 0) {
                boolean bl;
                attrHolder.overlap = bl = ((Boolean)object).booleanValue();
                this.setRelatedReadOnly(attrHolder, bl);
                attrHolder.readOnly = false;
                this.fireTableDataChanged();
            }
        }

        private void setRelatedReadOnly(LogicalDesign.AttrHolder attrHolder, boolean bl) {
            for (LogicalDesign.AttrHolder attrHolder2 : attrHolder.relatedHolders) {
                attrHolder2.readOnly = bl;
            }
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
            EntityPropertiesDialogEx.this.updateDTComboBox();
        }
    }

    class StatusCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        StatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(0);
            this.setEnabled(false);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    private class RemoveKeyAction
    implements ActionListener {
        private RemoveKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.deleteKey();
        }
    }

    private class AddKeyAction
    implements ActionListener {
        private AddKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.createAndAddKey(false);
        }
    }

    private class KeyPropertiesAction
    implements ActionListener {
        private KeyPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CandidateKey candidateKey;
            int n = EntityPropertiesDialogEx.this.itable.getSelectedRow();
            if (n != -1 && EntityPropertiesDialogEx.this.keysList.size() > 0 && n < EntityPropertiesDialogEx.this.keysList.size() && !(candidateKey = (CandidateKey)EntityPropertiesDialogEx.this.keysList.get(n)).isDialogVisible()) {
                candidateKey.showModal = true;
                KeyPropertiesDialogEx keyPropertiesDialogEx = new KeyPropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), candidateKey);
                keyPropertiesDialogEx.setAttributesList(EntityPropertiesDialogEx.this.attributesList);
                keyPropertiesDialogEx.initProperties(candidateKey);
                keyPropertiesDialogEx.show();
                EntityPropertiesDialogEx.this.itable.updateUI();
            }
        }
    }

    public class KeyModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.keysList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (n == 1) {
                return Messages.getString("EntityPropertiesDialogEx.PUID");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CandidateKey candidateKey = (CandidateKey)EntityPropertiesDialogEx.this.keysList.get(n);
            if (n2 == 0) {
                return candidateKey.getName();
            }
            if (n2 == 1) {
                return candidateKey.isPK();
            }
            return new Integer(n * n2);
        }
    }

    private class RelationPropertiesAction
    implements ActionListener {
        private RelationPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntityPropertiesDialogEx.this.tbRelations.getSelectedRow();
            if (n != -1 && EntityPropertiesDialogEx.this.relationsList.size() > 0 && n < EntityPropertiesDialogEx.this.relationsList.size()) {
                Relation relation;
                int n2 = EntityPropertiesDialogEx.this.tbRelations.getEditingColumn();
                int n3 = EntityPropertiesDialogEx.this.tbRelations.getEditingRow();
                if (n2 > -1 && n3 > -1) {
                    EntityPropertiesDialogEx.this.tbRelations.getCellEditor(n3, n2).stopCellEditing();
                }
                if (!(relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(n)).isDialogVisible()) {
                    relation.showModal = ((EntityPropertiesDialogEx)EntityPropertiesDialogEx.this).entity.showModal;
                    relation.showPropertyDialog();
                }
            }
        }
    }

    class RelationTable
    extends JTable {
        RelationTable(TableModel tableModel) {
            super(tableModel);
        }
    }

    public class RelationsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.relationsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Relation relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(n);
            if (n2 == 0) {
                return relation.getName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string;
            Relation relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(n);
            if (n2 == 0 && !"".equals(string = (String)object)) {
                relation.setName(string);
            }
        }
    }

    private class RBActionListener
    implements ActionListener {
        private RBActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.updateDTComboBox();
            EntityPropertiesDialogEx.this.setDefaultDatatype();
        }
    }

    public class AttributeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return EntityPropertiesDialogEx.INTERVAL_STRING;
            }
            if (n == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (n == 2) {
                return Messages.getString("EntityPropertiesDialogEx.DataType");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Integer.class;
            }
            if (n == 1) {
                return String.class;
            }
            if (n == 2) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Attribute attribute = (Attribute)EntityPropertiesDialogEx.this.attributesList.get(n);
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (n2 == 1) {
                return attribute.getName();
            }
            if (n2 == 2) {
                return attribute.getGenericDatatypeString();
            }
            return new Integer(n * n2);
        }
    }

    private class COPasteAction
    extends AbstractAction {
        private COPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.coPasteAttributes();
            EntityPropertiesDialogEx.this.setAttributeSelected();
        }
    }

    private class COCopyAction
    extends AbstractAction {
        private COCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
            EntityPropertiesDialogEx.this.coCopyAttributes();
        }
    }

    private class CORemoveAction
    implements ActionListener {
        private CORemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.deleteAttribute(EntityPropertiesDialogEx.this.coTable);
        }
    }

    private class COAddAction
    implements ActionListener {
        private COAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntityPropertiesDialogEx.this.addAttribute(actionEvent);
        }
    }

    private class COPropertiesAction
    implements ActionListener {
        private COPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntityPropertiesDialogEx.this.coTable.getSelectedRow();
            if (n != -1) {
                Attribute attribute;
                EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
                if (EntityPropertiesDialogEx.this.attributesList.size() > 0 && n < EntityPropertiesDialogEx.this.attributesList.size() && !(attribute = (Attribute)EntityPropertiesDialogEx.this.attributesList.get(n)).isDialogVisible()) {
                    attribute.showModal = true;
                    AttributePropertiesDialogEx attributePropertiesDialogEx = new AttributePropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), attribute, EntityPropertiesDialogEx.this.chbUsePreferredList.isSelected());
                    attributePropertiesDialogEx.initProperties(attribute);
                    attributePropertiesDialogEx.show();
                    if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                        EntityPropertiesDialogEx.this.initSelectedAttributeOptions(EntityPropertiesDialogEx.this.selectedAttribute, false);
                    }
                }
            }
        }
    }

    class DataTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        DataTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Attribute attribute = (Attribute)object;
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(attribute.getGenericDatatypeString());
            return this;
        }
    }

    class AttributeTable
    extends JTable {
        AttributeTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            int n3 = this.convertColumnIndexToModel(n2);
            Attribute attribute = (Attribute)EntityPropertiesDialogEx.this.attributesList.get(n);
            if (n3 == 3) {
                TableModel tableModel = this.getModel();
                boolean bl = (Boolean)tableModel.getValueAt(n, 3);
                if (!bl) {
                    string = MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.Attribute"), attribute.getName());
                } else {
                    CandidateKey candidateKey = EntityPropertiesDialogEx.this.getPK();
                    String string2 = "";
                    if (candidateKey != null) {
                        string2 = "<html><body>" + MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.PrimaryKey"), candidateKey.getName()) + "<p>" + Messages.getString("EntityPropertiesDialogEx.PrimaryKeyAttr");
                        for (Attribute attribute2 : candidateKey.getElementsCollection()) {
                            string2 = string2 + "<p>" + "  " + attribute2.getName();
                        }
                        string2 = string2 + "</body>" + "</html>";
                    }
                    string = string2;
                }
            } else if (n3 != 4) {
                string = super.getToolTipText(mouseEvent);
            }
            return string;
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return EntityPropertiesDialogEx.INTERVAL_STRING;
            }
            if (n == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (n == 2) {
                return Messages.getString("EntityPropertiesDialogEx.DataType");
            }
            if (n == 3) {
                return Messages.getString("EntityPropertiesDialogEx.PKColName");
            }
            if (n == 4) {
                return Messages.getString("EntityPropertiesDialogEx.FKColName");
            }
            if (n == 5) {
                return "M";
            }
            if (n == 6) {
                return Messages.getString("EntityPropertiesDialogEx.Comments");
            }
            if (n == 7) {
                return Messages.getString("EntityPropertiesDialogEx.CommentsInRDBMS");
            }
            if (n == 8) {
                return Messages.getString("EntityPropertiesDialogEx.Notes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Attribute attribute = (Attribute)EntityPropertiesDialogEx.this.attributesList.get(n);
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (n2 == 1) {
                return attribute.getName();
            }
            if (n2 == 2) {
                return attribute;
            }
            if (n2 == 3) {
                CandidateKey candidateKey = EntityPropertiesDialogEx.this.getPK();
                if (candidateKey != null) {
                    return candidateKey.contains(attribute);
                }
                return Boolean.FALSE;
            }
            if (n2 == 4) {
                return attribute.isFKElement();
            }
            if (n2 == 5) {
                return !attribute.getNullsAllowed();
            }
            if (n2 == 6) {
                return attribute.getComment();
            }
            if (n2 == 7) {
                return attribute.getCommentInRDBMS();
            }
            if (n2 == 8) {
                return attribute.getNotes();
            }
            return new Integer(n * n2);
        }
    }

    private class TypeListener
    implements ActionListener {
        private TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EntityPropertiesDialogEx.this.cbType.getSelectedItem() != null && ((String)EntityPropertiesDialogEx.this.cbType.getSelectedItem()).equalsIgnoreCase(ContainerObject.TYPE_TEMPORARY)) {
                EntityPropertiesDialogEx.this.tfScope.setEnabled(true);
            } else {
                EntityPropertiesDialogEx.this.tfScope.setEnabled(false);
                EntityPropertiesDialogEx.this.tfScope.setText("");
            }
        }
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }
}

