/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_Attribute;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeCaseType;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeMaxNameLength;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.swingui.editor.DatatypeDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.LogicalTypeDialog;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.OSEnvironment;

public class AttributePropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private static final String EMPTY_VALUE = "";
    private Attribute attribute;
    private JTextField tfSynonym;
    private JTextField tfAbbreviation;
    private JTextField tfLongName;
    private JCheckBox chAllowNulls;
    private JButton bnDataType;
    private JComboBox cbScope;
    private JComboBox cbTypeSubstitution;
    private JTextField tfEntity;
    private JTextField tfConstraintName;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private JComboBox cbSourceType;
    private JTextField tfFormulaDesc;
    private List permittedTypes;
    private StructuredType currentST = null;
    private List subTypes;
    private JPanel pnLevels;
    private JTable lTable;
    private static final String VIEW_EDIT = Messages.getString("AttributePropertiesDialogEx.ViewEdit");
    private JTextField tfSource;
    private JTree tree;
    private boolean usePreferredList = false;
    private JPanel pnConstraint;
    private JCheckBox chUseDomainConstraints;
    private JButton btnConstraint;
    private JButton btnAVT;
    private JButton btnValueList;
    private CECheckConstraint checkEditor = null;
    private ValueListEditorEx valuesEditor = null;
    private Dimension labelSize = null;

    public AttributePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject, boolean bl) {
        super(applicationView, designObject);
        this.usePreferredList = bl;
        this.initGeneral();
    }

    public AttributePropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject, boolean bl) {
        super(dialog, applicationView, designObject);
        this.usePreferredList = bl;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AttributePropertiesDialogEx.AttributeProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 650 : 630;
    }

    @Override
    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 580 : 520;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Attribute) {
            Object object;
            Iterator iterator;
            this.attribute = (Attribute)designObject;
            this.initDefaults();
            boolean bl = !ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && !this.attribute.isFKElement();
            this.taComments.setEditable(bl);
            this.taCommentsInRDBMS.setEditable(bl);
            this.taNotes.setEditable(bl);
            boolean bl2 = this.getAppView().getSettings().isKeepFKNamesSynchronized();
            if (this.attribute.isFKAttribute() && bl2) {
                this.tfName.setEnabled(false);
            }
            this.tfSynonym.setText(this.attribute.getSynonym());
            this.tfAbbreviation.setText(this.attribute.getPreferredAbbreviation());
            this.tfLongName.setText(this.attribute.getLongName());
            this.chAllowNulls.setSelected(this.attribute.getNullsAllowed());
            if (this.attribute.isPKElement() || this.attribute.isUnique() || this.attribute.isFKAttribute()) {
                this.chAllowNulls.setEnabled(false);
            }
            this.bnDataType.setEnabled(this.isEditable() && !this.attribute.getContainer().isBST());
            this.bnDataType.setText(this.attribute.getGenericDatatypeString());
            this.tfEntity.setText(this.attribute.getContainer().getName());
            this.tfConstraintName.setText(this.attribute.getConstraintName());
            this.setDefaultValueUI();
            this.chUseDomainConstraints.setSelected(this.attribute.getUseDomainConstraints());
            this.fillComboItems(ContainedObject.SOURCE_TYPE_STATES_DISPLAY, this.cbSourceType, false);
            String string = this.translate(this.attribute.getSourceType(), ContainedObject.SOURCE_TYPE_STATES_INTERNAL, ContainedObject.SOURCE_TYPE_STATES_DISPLAY);
            this.cbSourceType.setSelectedItem(string);
            if (string != null && (string.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || string.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE))) {
                this.tfFormulaDesc.setEnabled(true);
                this.tfFormulaDesc.setText(this.attribute.getFormulaDesc());
            } else {
                this.tfFormulaDesc.setEnabled(false);
                this.tfFormulaDesc.setText(EMPTY_VALUE);
            }
            if (this.attribute.isReference()) {
                iterator = ((LogicalDesign)this.attribute.getDesignPart()).getEntitySet().iterator();
                while (iterator.hasNext()) {
                    object = (Entity)iterator.next();
                    if (((ContainerObject)object).getBasedOnStructuredType() != this.attribute.getStructuredType()) continue;
                    this.cbScope.addItem(object);
                }
                this.cbScope.setSelectedItem(this.attribute.getScope());
            }
            this.cbScope.setEnabled(this.attribute.isReference());
            this.tfSource.setText(this.attribute.getSource());
            if (this.attribute.isAllowSubtypeSubstitution()) {
                if (this.attribute.isRestrictedTypeSubstitution()) {
                    this.cbTypeSubstitution.setSelectedItem("RESTRICTED");
                } else {
                    this.cbTypeSubstitution.setSelectedItem("ALL");
                }
            } else {
                this.cbTypeSubstitution.setSelectedItem("NONE");
            }
            if (this.attribute.getDataType() instanceof StructuredType && !this.attribute.isReference()) {
                this.cbTypeSubstitution.setEnabled(true);
                this.currentST = (StructuredType)this.attribute.getDataType();
                this.permittedTypes.addAll(this.attribute.getPermittedSubTypes());
                this.subTypes = this.currentST.getAllInstantiableSubTypes(true);
            } else {
                this.cbTypeSubstitution.setEnabled(false);
            }
            if (this.attribute.getCheck() != null) {
                this.btnConstraint.setText(this.isEditable() ? VIEW_EDIT : Messages.getString("AttributePropertiesDialogEx.View"));
            }
            this.btnConstraint.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.btnAVT.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.btnValueList.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            iterator = this.attribute.getPropertyNames();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string2 = this.attribute.getProperty((String)object);
                DynamicProperty dynamicProperty = new DynamicProperty((String)object, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.attribute.setName(this.tfName.getText());
        this.attribute.setComment(this.taComments.getText());
        this.attribute.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.attribute.setNotes(this.taNotes.getText());
        this.attribute.setConstraintName(this.tfConstraintName.getText());
        if (this.cbDefaultValue.isVisible()) {
            this.attribute.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            this.attribute.setDefaultValue(this.tfDefaultValue.getText());
        }
        this.attribute.setSynonym(this.tfSynonym.getText());
        this.attribute.setNullsAllowed(this.chAllowNulls.isSelected());
        this.attribute.setPreferredAbbreviation(this.tfAbbreviation.getText());
        this.attribute.setUseDomainConstraints(this.chUseDomainConstraints.isSelected());
        this.attribute.setSourceType(this.translate((String)this.cbSourceType.getSelectedItem(), ContainedObject.SOURCE_TYPE_STATES_DISPLAY, ContainedObject.SOURCE_TYPE_STATES_INTERNAL));
        this.attribute.setFormulaDesc(this.tfFormulaDesc.getText());
        if (this.cbScope.getSelectedItem() != null) {
            this.attribute.setScopeId(((ContainerObject)this.cbScope.getSelectedItem()).getObjectID());
        } else {
            this.attribute.setScopeId(null);
        }
        String string = (String)this.cbTypeSubstitution.getSelectedItem();
        if ("NONE".equals(string)) {
            this.attribute.setAllowSubtypeSubstitution(false);
            this.attribute.setRestrictedTypeSubstitution(false);
        } else if ("ALL".equals(string)) {
            this.attribute.setRestrictedTypeSubstitution(false);
            this.attribute.setAllowSubtypeSubstitution(true);
        } else {
            this.attribute.setRestrictedTypeSubstitution(true);
            this.attribute.setAllowSubtypeSubstitution(true);
        }
        if (this.attribute.getCheck() != null && this.attribute.getCheck().isEmpty()) {
            this.attribute.setCheck(null);
        }
        if (this.attribute.getValueList() != null && this.attribute.getValueList().isEmpty()) {
            this.attribute.setValueList(null);
        }
        if (this.attribute.getCheck() != null) {
            this.btnConstraint.setText(VIEW_EDIT);
        }
        this.attribute.setSource(this.tfSource.getText());
        List list = this.attribute.getPermittedSubTypes();
        list.clear();
        list.addAll(this.permittedTypes);
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        AttributePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.attribute.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.attribute.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
        this.tfLongName.setText(this.attribute.getLongName());
        this.checkNamingOptions();
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRAttributeMaxNameLength(), this.attribute);
        this.checkDesignRule(new DRAttributeCaseType(), this.attribute);
        this.checkDesignRule(new DRAttributeValidCharacters(), this.attribute);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getConstraintPanel());
        this.addToTree(defaultMutableTreeNode, this.getPermittedSubtypesPanel());
        this.addToTree(defaultMutableTreeNode, this.getEngineeringPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "ATTRIBUTE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(LB_PREF_ABBREVIATION);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfAbbreviation = new JTextField();
        this.tfAbbreviation.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfAbbreviation));
        JLabel jLabel3 = new JLabel(LB_LONG_NAME);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfLongName));
        JLabel jLabel4 = new JLabel(LB_ALLOW_NULLS);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.chAllowNulls = new JCheckBox();
        this.chAllowNulls.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.chAllowNulls));
        JLabel jLabel5 = new JLabel(LB_DATA_TYPE);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(new Dimension(FIELD_WIDTH + 80, 20));
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatatypeDialog datatypeDialog = new DatatypeDialog(AttributePropertiesDialogEx.this, AttributePropertiesDialogEx.this.getAppView(), AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.bnDataType);
                datatypeDialog.initProperties(AttributePropertiesDialogEx.this.usePreferredList);
                datatypeDialog.showDialog();
                if (AttributePropertiesDialogEx.this.attribute.getDataType() instanceof StructuredType && !AttributePropertiesDialogEx.this.attribute.isReference() && AttributePropertiesDialogEx.this.attribute.getDataType() != AttributePropertiesDialogEx.this.currentST) {
                    AttributePropertiesDialogEx.this.currentST = (StructuredType)AttributePropertiesDialogEx.this.attribute.getDataType();
                    AttributePropertiesDialogEx.this.subTypes = AttributePropertiesDialogEx.this.currentST.getAllInstantiableSubTypes(true);
                }
                AttributePropertiesDialogEx.this.bnDataType.setText(AttributePropertiesDialogEx.this.attribute.getGenericDatatypeString());
            }
        });
        this.bnDataType.addChangeListener(new DatatypeListener());
        JPanel jPanel = this.createRow(jLabel5, this.bnDataType);
        JButton jButton = new JButton("...");
        jButton.setToolTipText(Messages.getString("AttributePropertiesDialogEx.DatatypeProperties"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignObject designObject = null;
                if (AttributePropertiesDialogEx.this.attribute.getUse() == 0) {
                    designObject = AttributePropertiesDialogEx.this.attribute.getDomain();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 2) {
                    designObject = AttributePropertiesDialogEx.this.attribute.getDistinctType();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 3) {
                    designObject = AttributePropertiesDialogEx.this.attribute.getStructuredType();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 4) {
                    designObject = AttributePropertiesDialogEx.this.attribute.getCollectionType();
                }
                if (designObject != null) {
                    designObject.showModal = ((AttributePropertiesDialogEx)AttributePropertiesDialogEx.this).attribute.showModal;
                    designObject.showPropertyDialog();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 1) {
                    LogicalTypeDialog logicalTypeDialog = !AttributePropertiesDialogEx.this.isEditable() ? new LogicalTypeDialog(AttributePropertiesDialogEx.this.getAppView(), AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.attribute.getSelectedRDBMSType().getName(), AttributePropertiesDialogEx.this.usePreferredList) : new LogicalTypeDialog(AttributePropertiesDialogEx.this.getAppView(), AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.bnDataType, AttributePropertiesDialogEx.this.attribute.getSelectedRDBMSType().getName(), AttributePropertiesDialogEx.this.usePreferredList);
                    logicalTypeDialog.setVisible(true);
                }
                AttributePropertiesDialogEx.this.bnDataType.setText(AttributePropertiesDialogEx.this.attribute.getGenericDatatypeString());
            }
        });
        this.addRowToGeneralPanel(this.createRow(jPanel, jButton, true));
        JLabel jLabel6 = new JLabel(LB_ENTITY);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.tfEntity = new JTextField();
        this.tfEntity.setPreferredSize(this.getDefaultSize());
        this.tfEntity.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.tfEntity));
        JLabel jLabel7 = new JLabel(LB_SOURCE_NAME);
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.tfSource = new JTextField();
        this.tfSource.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.tfSource));
        JLabel jLabel8 = new JLabel(LB_SOURCE_TYPE);
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.cbSourceType = new JComboBox();
        this.cbSourceType.setPreferredSize(this.getDefaultSize());
        this.cbSourceType.setMaximumRowCount(8);
        this.cbSourceType.addActionListener(new SourceTypeListener());
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.cbSourceType));
        JLabel jLabel9 = new JLabel(LB_FORMULA_DESC);
        jLabel9.setPreferredSize(this.getDefaultSize());
        this.tfFormulaDesc = new JTextField();
        this.tfFormulaDesc.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel9, this.tfFormulaDesc));
        JLabel jLabel10 = new JLabel(LB_SCOPE);
        jLabel10.setPreferredSize(this.getDefaultSize());
        this.cbScope = new JComboBox();
        this.cbScope.setPreferredSize(this.getDefaultSize());
        this.cbScope.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel10, this.cbScope));
        JLabel jLabel11 = new JLabel(LB_SUBTYPE_SUBSTITUTION);
        jLabel11.setPreferredSize(this.getDefaultSize());
        this.cbTypeSubstitution = new JComboBox<String>(ContainedObjectWithDomain.SUBST_OPTIONS);
        this.cbTypeSubstitution.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel11, this.cbTypeSubstitution));
    }

    protected JPanel getPermittedSubtypesPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("AttributePropertiesDialogEx.PermittedSubtypes"));
            this.permittedTypes = new ArrayList();
            this.subTypes = new ArrayList();
            this.lTable = new JTable(new DataModel());
            this.lTable.setSelectionMode(0);
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AttributePropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && AttributePropertiesDialogEx.this.subTypes.size() > 0 && n < AttributePropertiesDialogEx.this.subTypes.size()) {
                        DesignObject designObject = (DesignObject)AttributePropertiesDialogEx.this.subTypes.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.lTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AttributePropertiesDialogEx.this.lTable.getSelectedRow();
                    if (n != -1 && AttributePropertiesDialogEx.this.subTypes.size() > 0 && n < AttributePropertiesDialogEx.this.subTypes.size()) {
                        DesignObject designObject = (DesignObject)AttributePropertiesDialogEx.this.subTypes.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnLevels.add(jPanel2);
        }
        return this.pnLevels;
    }

    private Dimension getLabelDefaultSize() {
        if (this.labelSize == null) {
            this.labelSize = new Dimension(200, 20);
        }
        return this.labelSize;
    }

    protected JPanel getConstraintPanel() {
        if (this.pnConstraint == null) {
            this.pnConstraint = this.createPage(Messages.getString("AttributePropertiesDialogEx.DefaultAndConstraint"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(Messages.getString("AttributePropertiesDialogEx.ConstraintName"));
            jLabel.setPreferredSize(this.getLabelDefaultSize());
            this.tfConstraintName = new JTextField();
            this.tfConstraintName.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel, this.tfConstraintName));
            JLabel jLabel2 = new JLabel(LB_DEFAULT_VALUE);
            jLabel2.setPreferredSize(this.getLabelDefaultSize());
            JPanel jPanel3 = new JPanel();
            OverlayLayout overlayLayout = new OverlayLayout(jPanel3);
            jPanel3.setLayout(overlayLayout);
            this.cbDefaultValue = new JComboBox();
            this.cbDefaultValue.setPreferredSize(this.getDefaultSize());
            this.cbDefaultValue.setVisible(false);
            jPanel3.add(this.cbDefaultValue);
            this.tfDefaultValue = new JTextField();
            this.tfDefaultValue.setPreferredSize(this.getDefaultSize());
            this.tfDefaultValue.setVisible(true);
            jPanel3.add(this.tfDefaultValue);
            jPanel2.add(this.createRow(jLabel2, jPanel3));
            JLabel jLabel3 = new JLabel(LB_USE_DOMAIN_CONSTRAINTS);
            jLabel3.setPreferredSize(this.getLabelDefaultSize());
            this.chUseDomainConstraints = new JCheckBox();
            this.chUseDomainConstraints.setPreferredSize(this.getDefaultSize());
            this.chUseDomainConstraints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AttributePropertiesDialogEx.this.btnConstraint.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    AttributePropertiesDialogEx.this.btnAVT.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    AttributePropertiesDialogEx.this.btnValueList.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    if (AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected()) {
                        AttributePropertiesDialogEx.this.attribute.setCheck(null);
                    }
                }
            });
            jPanel2.add(this.createRow(jLabel3, this.chUseDomainConstraints));
            JLabel jLabel4 = new JLabel(LB_CONSTRAINT);
            jLabel4.setPreferredSize(this.getLabelDefaultSize());
            this.btnConstraint = new JButton();
            this.btnConstraint.setHorizontalAlignment(0);
            this.btnConstraint.setPreferredSize(this.getDefaultSize());
            this.btnConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    if (AttributePropertiesDialogEx.this.attribute.getCheck() == null) {
                        CheckConstraint checkConstraint = new CheckConstraint();
                        AttributePropertiesDialogEx.this.attribute.setCheck(checkConstraint);
                    }
                    if (AttributePropertiesDialogEx.this.attribute.getCheck().getDesign() == null) {
                        AttributePropertiesDialogEx.this.attribute.getCheck().setDesign(AttributePropertiesDialogEx.this.attribute.getDesign());
                    }
                    if (AttributePropertiesDialogEx.this.checkEditor == null) {
                        AttributePropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)AttributePropertiesDialogEx.this, AttributePropertiesDialogEx.this.getAppView(), !AttributePropertiesDialogEx.this.isEditable());
                    }
                    AttributePropertiesDialogEx.this.checkEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute.getCheck());
                    AttributePropertiesDialogEx.this.checkEditor.doEditing(AttributePropertiesDialogEx.this.attribute.getCheck());
                }
            });
            jPanel2.add(this.createRow(jLabel4, this.btnConstraint));
            JLabel jLabel5 = new JLabel(LB_RANGES);
            jLabel5.setPreferredSize(this.getLabelDefaultSize());
            this.btnAVT = new JButton(LB_VALUES);
            this.btnAVT.setPreferredSize(this.getDefaultSize());
            this.btnAVT.setHorizontalAlignment(0);
            this.btnAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    AVTEditor aVTEditor = new AVTEditor((Dialog)AttributePropertiesDialogEx.this, !AttributePropertiesDialogEx.this.isEditable());
                    aVTEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.attribute.getLogicalDatatype());
                    aVTEditor.doEditing(AttributePropertiesDialogEx.this.attribute);
                }
            });
            jPanel2.add(this.createRow(jLabel5, this.btnAVT));
            JLabel jLabel6 = new JLabel(LB_VALUE_LIST);
            jLabel6.setPreferredSize(this.getLabelDefaultSize());
            this.btnValueList = new JButton(LB_VALUES);
            this.btnValueList.setPreferredSize(this.getDefaultSize());
            this.btnValueList.setHorizontalAlignment(0);
            this.btnValueList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    if (AttributePropertiesDialogEx.this.attribute.getValueList() == null) {
                        ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
                        AttributePropertiesDialogEx.this.attribute.setValueList(constraintEnumeration);
                    }
                    if (AttributePropertiesDialogEx.this.valuesEditor == null) {
                        AttributePropertiesDialogEx.this.valuesEditor = new ValueListEditorEx((Dialog)AttributePropertiesDialogEx.this, !AttributePropertiesDialogEx.this.isEditable());
                    }
                    AttributePropertiesDialogEx.this.valuesEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute.getValueList());
                    AttributePropertiesDialogEx.this.valuesEditor.doEditing(AttributePropertiesDialogEx.this.attribute);
                }
            });
            jPanel2.add(this.createRow(jLabel6, this.btnValueList));
            jPanel.add((Component)jPanel2, "North");
            this.pnConstraint.add(jPanel);
        }
        return this.pnConstraint;
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.setDefaultValueUI();
    }

    private void setDefaultValueUI() {
        Object[] objectArray = this.attribute.getValues().toArray();
        if (objectArray != null && objectArray.length > 0) {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = EMPTY_VALUE;
            int n = 0;
            String string = this.attribute.getDefaultValue();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i + 1] = objectArray[i];
                if (string == null || !string.equals(objectArray[i].toString())) continue;
                n = i + 1;
            }
            this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(objectArray2));
            this.cbDefaultValue.setSelectedIndex(n);
            this.cbDefaultValue.setVisible(true);
            this.tfDefaultValue.setVisible(false);
        } else {
            this.tfDefaultValue.setText(this.attribute.getDefaultValue());
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    @Override
    protected void onCancel() {
        if (this.attribute.getCheck() != null && this.attribute.getCheck().isEmpty()) {
            this.attribute.setCheck(null);
        }
        super.onCancel();
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = AttributePropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (AttributePropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            AttributePropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            AttributePropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_Attribute(this.attribute, null, true), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AttributePropertiesDialogEx.this.subTypes.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AttributePropertiesDialogEx.Permitted");
            }
            if (n == 1) {
                return Messages.getString("AttributePropertiesDialogEx.Name");
            }
            return AttributePropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StructuredType structuredType = (StructuredType)AttributePropertiesDialogEx.this.subTypes.get(n);
            if (n2 == 1) {
                return structuredType.getName();
            }
            if (n2 == 0) {
                return AttributePropertiesDialogEx.this.permittedTypes.contains(structuredType);
            }
            return AttributePropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            StructuredType structuredType = (StructuredType)AttributePropertiesDialogEx.this.subTypes.get(n);
            if (n2 == 0) {
                if (((Boolean)object).booleanValue()) {
                    if (!AttributePropertiesDialogEx.this.permittedTypes.contains(structuredType)) {
                        AttributePropertiesDialogEx.this.permittedTypes.add(structuredType);
                    }
                } else {
                    AttributePropertiesDialogEx.this.permittedTypes.remove(structuredType);
                }
            }
        }
    }

    private class DatatypeListener
    implements ChangeListener {
        private DatatypeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AttributePropertiesDialogEx.this.cbScope.setEnabled(AttributePropertiesDialogEx.this.attribute.isReference());
            AttributePropertiesDialogEx.this.cbScope.removeAllItems();
            if (AttributePropertiesDialogEx.this.attribute.isReference()) {
                if (AttributePropertiesDialogEx.this.attribute.getScope() != null) {
                    AttributePropertiesDialogEx.this.cbScope.addItem(null);
                }
                Iterator iterator = ((LogicalDesign)AttributePropertiesDialogEx.this.attribute.getDesignPart()).getEntitySet().iterator();
                while (iterator.hasNext()) {
                    Entity entity = (Entity)iterator.next();
                    if (entity.getBasedOnStructuredType() != AttributePropertiesDialogEx.this.attribute.getStructuredType()) continue;
                    AttributePropertiesDialogEx.this.cbScope.addItem(entity);
                }
                AttributePropertiesDialogEx.this.cbScope.setSelectedItem(AttributePropertiesDialogEx.this.attribute.getScope());
            }
            AttributePropertiesDialogEx.this.cbTypeSubstitution.setEnabled(AttributePropertiesDialogEx.this.attribute.getDataType() instanceof StructuredType && !AttributePropertiesDialogEx.this.attribute.isReference());
        }
    }

    private class SourceTypeListener
    implements ActionListener {
        private SourceTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)AttributePropertiesDialogEx.this.cbSourceType.getSelectedItem();
            if (string != null) {
                if (string.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || string.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE)) {
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setEnabled(true);
                } else {
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setEnabled(false);
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setText(AttributePropertiesDialogEx.EMPTY_VALUE);
                }
            }
        }
    }
}

