/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.ide.Ide;

public class TypeElementPropertiesDialogEx
extends AbstractPropertiesDialog {
    private TypeElement typeElement;
    private JButton bnDataType;
    private SelectDataTypeDialog datatypeDialog = null;
    private TypeElement temp;
    private JCheckBox chMandatory;
    private boolean usePreferredList = false;

    public TypeElementPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject, boolean bl) {
        super(applicationView, designObject);
        this.usePreferredList = bl;
        this.initGeneral();
    }

    public TypeElementPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject, boolean bl) {
        super(dialog, applicationView, designObject);
        this.usePreferredList = bl;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TypeElementPropertiesDialogEx.AttributeProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof TypeElement) {
            this.typeElement = (TypeElement)designObject;
            this.initDefaults(false);
            this.bnDataType.setText(this.typeElement.getDataType());
            this.chMandatory.setSelected(this.typeElement.isMandatory());
            this.temp = new TypeElement(this.typeElement.getDesignPart(), this.typeElement.getStructuredType());
            this.temp.setDesign(this.typeElement.getDesign());
            this.typeElement.copyDataType(this.temp);
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.typeElement.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.typeElement.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.typeElement.setName(this.tfName.getText());
        this.typeElement.setComment(this.taComments.getText());
        this.typeElement.setNotes(this.taNotes.getText());
        this.typeElement.setMandatory(this.chMandatory.isSelected());
        this.temp.copyDataType(this.typeElement);
        this.typeElement.updateReference();
        TypeElementPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.typeElement.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.typeElement.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "STRUCTUREDTYPE_ATTRIBUTE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_DATATYPE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(this.getDefaultSize());
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypeElement typeElement = new TypeElement(TypeElementPropertiesDialogEx.this.typeElement.getDesignPart(), TypeElementPropertiesDialogEx.this.typeElement.getStructuredType());
                typeElement.setDesign(TypeElementPropertiesDialogEx.this.typeElement.getDesign());
                TypeElementPropertiesDialogEx.this.temp.copyDataType(typeElement);
                TypeElementPropertiesDialogEx.this.datatypeDialog = new SelectDataTypeDialog(TypeElementPropertiesDialogEx.this.getAppView(), typeElement, TypeElementPropertiesDialogEx.this.bnDataType);
                TypeElementPropertiesDialogEx.this.datatypeDialog.initProperties(TypeElementPropertiesDialogEx.this.usePreferredList);
                int n = TypeElementPropertiesDialogEx.this.datatypeDialog.showDialog();
                while (n == 1 && !TypeElementPropertiesDialogEx.this.hasValidContainment(TypeElementPropertiesDialogEx.this.typeElement.getStructuredType(), typeElement)) {
                    n = TypeElementPropertiesDialogEx.this.datatypeDialog.showDialog();
                }
                if (n == 1 && TypeElementPropertiesDialogEx.this.hasValidContainment(TypeElementPropertiesDialogEx.this.typeElement.getStructuredType(), typeElement)) {
                    typeElement.copyDataType(TypeElementPropertiesDialogEx.this.temp);
                } else {
                    TypeElementPropertiesDialogEx.this.bnDataType.setText(TypeElementPropertiesDialogEx.this.temp.getDataType());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.bnDataType));
        JLabel jLabel2 = new JLabel(LB_MANDATORY);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chMandatory = new JCheckBox();
        this.chMandatory.setPreferredSize(this.getDefaultSize());
        this.chMandatory.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chMandatory));
    }

    private boolean hasValidContainment(StructuredType structuredType, TypeElement typeElement) {
        DesignObject designObject;
        TypeElement typeElement2 = typeElement;
        if (typeElement.getType() instanceof CollectionType && ((TypeElement)(designObject = ((CollectionType)typeElement.getType()).getElementType())).getType() instanceof StructuredType) {
            typeElement2 = designObject;
        }
        if (typeElement2.getType() instanceof StructuredType) {
            designObject = (StructuredType)typeElement2.getType();
            if (!typeElement2.isReference()) {
                if (structuredType.isParentOf((StructuredType)designObject) || ((StructuredType)designObject).isParentOf(structuredType)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypeElementPropertiesDialogEx.TypePartOf"), designObject.getName(), structuredType.getName()), Messages.getString("TypeElementPropertiesDialogEx.ForbidenSelfContainment"), 0);
                    return false;
                }
                if (((StructuredType)designObject).containsElementOfStructuredType(structuredType)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypeElementPropertiesDialogEx.CyclicContainment"), designObject.getName()), Messages.getString("TypeElementPropertiesDialogEx.ForbidenCyclicContainment"), 0);
                    return false;
                }
            }
        }
        return true;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }
}

