/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignUtilities;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.MethodPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.datatypes.TypeElementPropertiesDialogEx;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.ide.Ide;

public class StructuredTypePropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private StructuredType structuredType;
    private JComboBox cbSuperType;
    private JCheckBox chFinal;
    private JCheckBox chInstantiable;
    private JTable tbAttributes;
    private JTable coTable;
    private List<TypeElement> attributesList;
    private JTable mtable;
    private List mList;
    private int attrCounter = 0;
    private int methodCounter = 0;
    private JPanel pnAttributes;
    private JPanel pnMethods;
    private JButton btnMProperties;
    private JButton btnMRemove;
    private JButton btnMUp;
    private JButton btnMDown;
    private TypeElement selectedAttribute = null;
    private JTextField tfColumnName;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JRadioButton rbDomain;
    private JComboBox cbDatatype;
    private JTextField ifDTSize;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JPanel pnDType;
    private JPanel pnDTSize;
    private JPanel pnDTScale;
    private JPanel pnRef;
    private boolean sizeEnabled = false;
    private boolean precisionEnabled = false;
    private JCheckBox chbReference;
    private JTextArea taColumnComments;
    private JTextArea taColumnNotes;
    private JTextArea taColumnCommentsInRDBMS;
    private JCheckBox chbMandatory;
    private JButton bnCOAdd;
    private JButton bnCORemove;
    private JButton bnCOUp;
    private JButton bnCODown;
    private JButton bnCOCopy;
    private JButton bnCOPaste;
    private ButtonGroup attributeTypeGroup;
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private List currentPreferredLogicalTypeList = new ArrayList();
    private boolean initialUseLogicalTypePreferredList = true;
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private final int INIT = 0;
    private final int ADD = 1;
    private final int DELETE = 2;
    private final int INIT_SELECTED = 3;
    private int distinctTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().size();
    private int structuredTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().size();
    private int collectionTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().size();
    private Object logicalDefaultDataType;
    private int lastSelectedRowIndex = 0;
    private JTable usedInEntitiesTable;
    private List<Entity> usedInEntitiesList;
    private JTable usedInTablesTable;
    private List<Table> usedInTablesList;
    private JTable usedInViewsTable;
    private List<TableView> usedInViewsList;
    private JTable usedInStructuredTypesTable;
    private List<StructuredType> usedInStructuredTypesList;
    private JTable usedInStructuredTypesAttributesTable;
    private List<TypeElement> usedInStructuredTypesAttributesList;
    private JTable usedInCollectionTypesTable;
    private List<CollectionType> usedInCollectionTypesList;
    private TreeMap typesRDBMSSites = new TreeMap();
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private boolean initialUseDomainPreferredList = true;
    private List currentPreferredDomainList = new ArrayList();
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private Object domainDefaultDataType;
    private JComboBox cbUnits;

    public StructuredTypePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertiesDialogEx.StructuredTypeProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 540;
    }

    @Override
    protected int getMinimumWidth() {
        return 800;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof StructuredType) {
            this.structuredType = (StructuredType)designObject;
            this.initDefaults(false);
            this.fillComboItems(this.getStructuredTypes(), this.cbSuperType, true);
            this.cbSuperType.setSelectedItem(this.structuredType.getParentType());
            this.chFinal.setSelected(this.structuredType.isFinal());
            this.chInstantiable.setSelected(this.structuredType.isInstantiable());
            this.attributesList.addAll(Arrays.asList(this.structuredType.getElements()));
            this.mList.addAll(Arrays.asList(this.structuredType.getMethods()));
            this.initUsedInAttributes(this.structuredType, (short)3);
            this.initUsedInColumns();
            this.initUsedInEntities();
            this.initUsedInTables();
            this.initUsedInViews();
            this.initUsedInStructuredTypes();
            this.initUsedInStructuredTypeAttributes();
            this.initUsedInCollectionTypes();
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 0);
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.structuredType.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.structuredType.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void initUsedInEntities() {
        this.usedInEntitiesList = DesignUtilities.extractUsedInEntities(this.getDesignObject().getDesign(), this.datatypeObject, (short)3);
    }

    private void initUsedInTables() {
        this.usedInTablesList = DesignUtilities.extractUsedInTables(this.getDesignObject().getDesign(), this.datatypeObject, (short)3);
    }

    private void initUsedInViews() {
        this.usedInViewsList = DesignUtilities.extractUsedInViews(this.getDesignObject().getDesign(), this.datatypeObject);
    }

    private void initUsedInStructuredTypes() {
        this.usedInStructuredTypesList = DesignUtilities.extractUsedInStructuredTypes(this.getDesignObject().getDesign(), this.datatypeObject);
    }

    private void initUsedInStructuredTypeAttributes() {
        this.usedInStructuredTypesAttributesList = DesignUtilities.extractUsedInStructuredTypeAttributes(this.getDesignObject().getDesign(), this.datatypeObject);
    }

    private void initUsedInCollectionTypes() {
        this.usedInCollectionTypesList = DesignUtilities.extractUsedInCollectionTypes(this.getDesignObject().getDesign(), this.datatypeObject);
    }

    private Object[] getStructuredTypes() {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        Iterator iterator = ((DataTypesDesign)this.structuredType.getDesignPart()).getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (this.structuredType.isParentOf(structuredType) || structuredType.isFinal()) continue;
            arrayList.add(structuredType);
        }
        return arrayList.toArray();
    }

    @Override
    protected void setProperties() {
        Object object3;
        int n;
        DesignObject designObject;
        Object object2;
        int n2;
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        this.structuredType.setName(this.tfName.getText());
        this.structuredType.setComment(this.taComments.getText());
        this.structuredType.setNotes(this.taNotes.getText());
        this.structuredType.setParentType((StructuredType)this.cbSuperType.getSelectedItem(), true);
        this.structuredType.setFinal(this.chFinal.isSelected());
        this.structuredType.setInstantiable(this.chInstantiable.isSelected());
        TypeElement[] typeElementArray = this.structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            TypeElement typeElement = typeElementArray[i];
            if (this.attributesList.contains(typeElement)) continue;
            typeElement.remove();
        }
        Object[] objectArray = this.attributesList.toArray();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object2 = objectArray[n2];
            if (!(object2 instanceof TypeElement)) continue;
            designObject = (TypeElement)object2;
            if (this.structuredType.contains((TypeElement)object2)) continue;
            this.structuredType.add((TypeElement)designObject);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object2 = objectArray[n2];
            if (!(object2 instanceof TypeElement)) continue;
            designObject = (TypeElement)object2;
            this.structuredType.moveElementToIndex(designObject, n2);
            ((TypeElement)designObject).updateReference();
        }
        Method[] methodArray = this.structuredType.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            designObject = methodArray[i];
            if (this.mList.contains(designObject)) continue;
            ((Method)designObject).remove();
        }
        Object[] objectArray2 = this.mList.toArray();
        for (n = 0; n < objectArray2.length; ++n) {
            object3 = objectArray2[n];
            if (!(object3 instanceof Method) || this.structuredType.containsMethod((Method)object3)) continue;
            this.structuredType.addMethod((Method)object3);
        }
        for (n = 0; n < objectArray2.length; ++n) {
            object3 = objectArray2[n];
            if (!(object3 instanceof Method)) continue;
            this.structuredType.moveMethodToIndex((Method)object3, n);
        }
        this.setResponsibleParties();
        this.setDocuments();
        StructuredTypePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.structuredType.clearProperties();
        for (Object object3 : this.dynamicPropertiesList) {
            this.structuredType.setProperty(((DynamicProperty)object3).getName(), ((DynamicProperty)object3).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMethodsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getUsedInPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "STRUCTUREDTYPE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SUPER_TYPE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbSuperType = new JComboBox();
        this.cbSuperType.setPreferredSize(this.getDefaultSize());
        this.cbSuperType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.cbSuperType));
        JLabel jLabel2 = new JLabel(LB_FINAL);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chFinal = new JCheckBox();
        this.chFinal.setPreferredSize(this.getDefaultSize());
        this.chFinal.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chFinal));
        JLabel jLabel3 = new JLabel(LB_INSTANTIABLE);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chInstantiable = new JCheckBox();
        this.chInstantiable.setPreferredSize(this.getDefaultSize());
        this.chInstantiable.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chInstantiable));
        Iterator iterator = this.getDesignObject().getDesign().getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            RDBMSType rDBMSType = (RDBMSType)iterator.next();
            this.typesRDBMSSites.put(rDBMSType.getType(), rDBMSType.getName());
        }
    }

    @Override
    protected JPanel getUsedInPanel() {
        JPanel jPanel = super.getUsedInPanel();
        this.usedInEntitiesList = new ArrayList<Entity>(0);
        this.usedInTablesList = new ArrayList<Table>(0);
        this.usedInViewsList = new ArrayList<TableView>(0);
        this.usedInStructuredTypesList = new ArrayList<StructuredType>(0);
        this.usedInStructuredTypesAttributesList = new ArrayList<TypeElement>(0);
        this.usedInCollectionTypesList = new ArrayList<CollectionType>(0);
        this.tabbedPaneUsedIn.insertTab(Messages.getString("StructuredTypePropertiesDialogEx.Entities"), null, this.getEntitiesTab(), null, 0);
        this.tabbedPaneUsedIn.insertTab(Messages.getString("StructuredTypePropertiesDialogEx.Tables"), null, this.getTablesTab(), null, 2);
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Views"), this.getViewsTab());
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.StructuredTypes"), this.getStructuredTypesTab());
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.AttributesST"), this.getStructuredTypesAttributesTab());
        this.tabbedPaneUsedIn.addTab(Messages.getString("StructuredTypePropertiesDialogEx.CollectionTypes"), this.getCollectionTypesTab());
        this.tabbedPaneUsedIn.setSelectedIndex(0);
        return jPanel;
    }

    protected JPanel getEntitiesTab() {
        this.usedInEntitiesTable = new JTable(new UsedInEntitiesTableModel());
        return this.createUsedInPanel(this.usedInEntitiesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showEntitiesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showEntitiesTabProperties();
            }
        });
    }

    protected JPanel getTablesTab() {
        this.usedInTablesTable = new JTable(new UsedInTablesTableModel());
        return this.createUsedInPanel(this.usedInTablesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showTablesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showTablesTabProperties();
            }
        });
    }

    protected JPanel getViewsTab() {
        this.usedInViewsTable = new JTable(new UsedInViewsTableModel());
        return this.createUsedInPanel(this.usedInViewsTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showViewsTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showViewsTabProperties();
            }
        });
    }

    protected JPanel getStructuredTypesTab() {
        this.usedInStructuredTypesTable = new JTable(new UsedInStructuredTypesTableModel());
        return this.createUsedInPanel(this.usedInStructuredTypesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showStructuredTypesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showStructuredTypesTabProperties();
            }
        });
    }

    protected JPanel getStructuredTypesAttributesTab() {
        this.usedInStructuredTypesAttributesTable = new JTable(new UsedInStructuredTypeAttributesTableModel());
        return this.createUsedInPanel(this.usedInStructuredTypesAttributesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showStructuredTypesAttributesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showStructuredTypesAttributesTabProperties();
            }
        });
    }

    protected JPanel getCollectionTypesTab() {
        this.usedInCollectionTypesTable = new JTable(new UsedInCollectionTypesTableModel());
        return this.createUsedInPanel(this.usedInCollectionTypesTable, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StructuredTypePropertiesDialogEx.this.showCollectionTypesTabProperties();
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructuredTypePropertiesDialogEx.this.showCollectionTypesTabProperties();
            }
        });
    }

    protected void showObjectsTabProperties(JTable jTable, List<? extends DesignObject> list) {
        int n = jTable.getSelectedRow();
        if (n > -1) {
            if (jTable.getColumnCount() == 1) {
                list.get(n).showPropertyDialog();
            } else if (jTable.getColumnCount() == 2) {
                if (jTable.getSelectedColumn() == 0) {
                    list.get(n).getDesignPart().showPropertyDialog();
                } else if (jTable.getSelectedColumn() == 1) {
                    list.get(n).showPropertyDialog();
                }
            }
        }
    }

    protected void showTablesTabProperties() {
        this.showObjectsTabProperties(this.usedInTablesTable, this.usedInTablesList);
    }

    protected void showEntitiesTabProperties() {
        this.showObjectsTabProperties(this.usedInEntitiesTable, this.usedInEntitiesList);
    }

    protected void showViewsTabProperties() {
        this.showObjectsTabProperties(this.usedInViewsTable, this.usedInViewsList);
    }

    protected void showStructuredTypesTabProperties() {
        this.showObjectsTabProperties(this.usedInStructuredTypesTable, this.usedInStructuredTypesList);
    }

    protected void showStructuredTypesAttributesTabProperties() {
        int n = this.usedInStructuredTypesAttributesTable.getSelectedRow();
        if (n > -1) {
            if (this.usedInStructuredTypesAttributesTable.getSelectedColumn() == 0) {
                this.usedInStructuredTypesAttributesList.get(n).getStructuredType().showPropertyDialog();
            } else if (this.usedInStructuredTypesAttributesTable.getSelectedColumn() == 1) {
                this.usedInStructuredTypesAttributesList.get(n).showPropertyDialog();
            }
        }
    }

    protected void showCollectionTypesTabProperties() {
        this.showObjectsTabProperties(this.usedInCollectionTypesTable, this.usedInCollectionTypesList);
    }

    protected JPanel getAttributesPanel() {
        Serializable serializable;
        Serializable serializable2;
        if (this.pnAttributes == null) {
            this.pnAttributes = new JPanel(new BorderLayout());
            this.attributesList = new ArrayList<TypeElement>();
            serializable2 = new DataModel();
            this.tbAttributes = new JTable((TableModel)((Object)serializable2));
            this.tbAttributes.setSelectionMode(1);
            serializable = this.tbAttributes.getColumnModel().getColumn(0);
            ((TableColumn)serializable).setPreferredWidth(30);
            ((TableColumn)serializable).setMaxWidth(50);
            ((TableColumn)serializable).setMinWidth(25);
            serializable = this.tbAttributes.getColumnModel().getColumn(1);
            ((TableColumn)serializable).setPreferredWidth(180);
            serializable = this.tbAttributes.getColumnModel().getColumn(2);
            ((TableColumn)serializable).setCellRenderer(new DataTypeCellRenderer());
            ((TableColumn)serializable).setPreferredWidth(140);
            serializable = this.tbAttributes.getColumnModel().getColumn(3);
            ((TableColumn)serializable).setCellRenderer(new StatusCellRenderer());
            JScrollPane jScrollPane = new JScrollPane(this.tbAttributes);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.pnAttributes.add(jPanel);
        }
        serializable2 = new JTabbedPane();
        ((JTabbedPane)serializable2).addTab(Messages.getString("StructuredTypePropertiesDialogEx.Details"), this.createExtendedAttributePanel());
        ((JTabbedPane)serializable2).addTab(Messages.getString("StructuredTypePropertiesDialogEx.Overview"), this.pnAttributes);
        serializable = this.createPage(Messages.getString("StructuredTypePropertiesDialogEx.Attributes"));
        ((Container)serializable).add((Component)serializable2);
        ((JTabbedPane)serializable2).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                StructuredTypePropertiesDialogEx.this.setPreviousSelectedAttribute();
            }
        });
        return serializable;
    }

    private void setPreviousSelectedAttribute() {
        if (this.selectedAttribute != null) {
            if (!this.hasValidContainmentBeforeSave()) {
                this.coTable.changeSelection(this.lastSelectedRowIndex, 0, false, false);
            } else {
                this.selectedAttribute.setName(this.tfColumnName.getText());
                if (this.rbDomain.isSelected()) {
                    this.selectedAttribute.setType((Domain)this.cbDatatype.getSelectedItem());
                } else if (this.rbLogical.isSelected()) {
                    int n;
                    this.selectedAttribute.setType((LogicalDatatype)this.cbDatatype.getSelectedItem());
                    Map map = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                    String string = (String)map.get("precision_default_value");
                    int n2 = string != "" && string != null ? new Integer((String)map.get("precision_default_value")) : 0;
                    String string2 = (String)map.get("size_default_value");
                    int n3 = string2 != "" && string2 != null ? new Integer((String)map.get("size_default_value")) : 0;
                    String string3 = (String)map.get("scale_default_value");
                    int n4 = n = string3 != "" && string3 != null ? new Integer((String)map.get("scale_default_value")) : 0;
                    if (this.sizeEnabled) {
                        if (!this.ifDTSize.getText().equals(n3)) {
                            this.selectedAttribute.setSize(this.ifDTSize.getText());
                            if (this.cbUnits.getSelectedIndex() > 0) {
                                this.selectedAttribute.setUnits((String)this.cbUnits.getSelectedItem());
                            }
                        } else {
                            this.selectedAttribute.setSize("");
                        }
                        this.selectedAttribute.setPrecision(0);
                        this.selectedAttribute.setScale(0);
                    } else if (this.precisionEnabled) {
                        this.selectedAttribute.setSize("");
                        if (this.ifDTPrecision.getIntValue() != n2 || this.ifDTScale.getIntValue() != n) {
                            this.selectedAttribute.setPrecision(this.ifDTPrecision.getIntValue());
                            this.selectedAttribute.setScale(this.ifDTScale.getIntValue());
                        } else {
                            this.selectedAttribute.setPrecision(0);
                            this.selectedAttribute.setScale(0);
                        }
                    } else {
                        this.selectedAttribute.setSize("");
                        this.selectedAttribute.setPrecision(0);
                        this.selectedAttribute.setScale(0);
                    }
                } else if (this.rbDistinct.isSelected()) {
                    this.selectedAttribute.setType((DistinctType)this.cbDatatype.getSelectedItem());
                } else if (this.rbStructured.isSelected()) {
                    this.selectedAttribute.setType((StructuredType)this.cbDatatype.getSelectedItem());
                    this.selectedAttribute.setReference(this.chbReference.isSelected());
                } else if (this.rbCollection.isSelected()) {
                    this.selectedAttribute.setType((CollectionType)this.cbDatatype.getSelectedItem());
                }
                this.selectedAttribute.setComment(this.taColumnComments.getText());
                this.selectedAttribute.setCommentInRDBMS(this.taColumnCommentsInRDBMS.getText());
                this.selectedAttribute.setNotes(this.taColumnNotes.getText());
                this.coTable.updateUI();
                this.tbAttributes.updateUI();
            }
        }
        this.lastSelectedRowIndex = this.coTable.getSelectedRow();
    }

    private void setAttributeSelected() {
        int n = this.coTable.getSelectedRow();
        if (n != -1 && this.attributesList.size() > 0 && n < this.attributesList.size()) {
            TypeElement typeElement = this.attributesList.get(n);
            this.initSelectedAttributeOptions(typeElement, true);
        }
    }

    private void enableAttributeOptions(boolean bl, int n) {
        boolean bl2 = this.cbSuperType.getSelectedItem() != null;
        boolean bl3 = bl && !bl2;
        this.tfColumnName.setEnabled(bl);
        this.rbLogical.setEnabled(bl);
        this.rbDomain.setEnabled(bl3);
        if (n == 0) {
            this.rbStructured.setEnabled(bl);
            this.rbDistinct.setEnabled(bl);
            this.rbCollection.setEnabled(bl);
        } else if (n == 1 || n == 2 || n == 3) {
            if (this.structuredTypesCount > 0) {
                this.rbStructured.setEnabled(bl);
            } else {
                this.rbStructured.setEnabled(!bl);
            }
            if (this.distinctTypesCount > 0) {
                this.rbDistinct.setEnabled(bl);
            } else {
                this.rbDistinct.setEnabled(!bl);
            }
            if (this.collectionTypesCount > 0) {
                this.rbCollection.setEnabled(bl);
            } else {
                this.rbCollection.setEnabled(!bl);
            }
            if (this.rbStructured.isSelected() && !this.rbStructured.isEnabled() || this.rbDistinct.isSelected() && !this.rbDistinct.isEnabled() || this.rbCollection.isSelected() && !this.rbCollection.isEnabled()) {
                this.rbDomain.setSelected(true);
            }
        }
        this.cbDatatype.setEnabled(bl);
        this.ifDTSize.setEnabled(bl);
        boolean bl4 = this.structuredType.getSelectedRDBMSType().getType() > 5 && this.structuredType.getSelectedRDBMSType().getType() < 10;
        this.cbUnits.setEnabled(bl4 && bl3);
        this.ifDTPrecision.setEnabled(bl);
        this.ifDTScale.setEnabled(bl);
        this.chbMandatory.setEnabled(bl);
        this.taColumnComments.setEnabled(bl);
        this.taColumnCommentsInRDBMS.setEnabled(bl);
        this.taColumnNotes.setEnabled(bl);
        this.chbReference.setEnabled(bl);
        if (!bl) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.tfColumnName.setText("");
            this.ifDTSize.setText("");
            this.cbUnits.setSelectedIndex(0);
            this.ifDTPrecision.setText("");
            this.ifDTScale.setText("");
            this.taColumnComments.setText("");
            this.taColumnCommentsInRDBMS.setText("");
            this.taColumnNotes.setText("");
        }
    }

    private void updateDTComboBox() {
        this.cbDatatype.removeAllItems();
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        if (this.rbDomain.isSelected()) {
            Domain domain = null;
            if (this.selectedAttribute != null) {
                domain = this.selectedAttribute.getDomain();
            }
            if (domain == null) {
                domain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
            }
            if (this.initialUseDomainPreferredList) {
                this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                this.initialUseDomainPreferredList = false;
            }
            if (this.chbUsePreferredList.isSelected()) {
                ArrayList<Domain> arrayList = new ArrayList<Domain>();
                List list = this.getCurrentPreferredDomains();
                arrayList.addAll(list);
                if (list.size() > 0) {
                    for (Domain domain2 : list) {
                        if (domain == null) continue;
                        if (!domain2.getObjectID().equalsIgnoreCase(domain.getObjectID())) {
                            if (this.additionalPreferredDomains.contains(domain)) continue;
                            this.additionalPreferredDomains.add(domain);
                            continue;
                        }
                        if (this.additionalPreferredDomains.contains(domain)) {
                            this.additionalPreferredDomains.remove(domain);
                        }
                        break;
                    }
                } else if (!this.additionalPreferredDomains.contains(domain)) {
                    this.additionalPreferredDomains.add(domain);
                }
                arrayList.addAll(this.additionalPreferredDomains);
                for (Domain domain2 : arrayList) {
                    this.cbDatatype.addItem(domain2);
                    if (this.domainDefaultDataType == null) {
                        this.domainDefaultDataType = domain2;
                    }
                    if (!((Object)domain2).toString().equalsIgnoreCase("unknown")) continue;
                    this.domainDefaultDataType = domain2;
                }
                this.cbDatatype.setSelectedItem(domain);
                this.getAppView().getSettings().setUsePreferredDomains(true);
            } else {
                Iterator iterator = this.getDesignObject().getDesign().getDomainSet().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    this.cbDatatype.addItem(e);
                    if (!e.toString().equalsIgnoreCase("unknown")) continue;
                    this.domainDefaultDataType = e;
                }
                this.cbDatatype.setSelectedItem(domain);
                this.getAppView().getSettings().setUsePreferredDomains(false);
            }
        } else if (this.rbLogical.isSelected()) {
            String string = "";
            int n = 0;
            int n2 = 0;
            String string2 = "";
            this.selLogicalDatatype = null;
            if (this.selectedAttribute != null) {
                this.selLogicalDatatype = this.selectedAttribute.getType() instanceof Domain ? ((Domain)this.selectedAttribute.getType()).getLogicalDatatype() : (LogicalDatatype)this.selectedAttribute.getType();
                string = this.selectedAttribute.getSize();
                n = this.selectedAttribute.getPrecision();
                n2 = this.selectedAttribute.getScale();
                string2 = this.selectedAttribute.getUnits();
            }
            if (this.initialUseLogicalTypePreferredList) {
                this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                this.initialUseLogicalTypePreferredList = false;
            }
            if (this.chbUsePreferredList.isSelected()) {
                ArrayList<LogicalDatatype> arrayList = new ArrayList<LogicalDatatype>();
                List list = this.getCurrentPreferredLogicalDatatypes();
                arrayList.addAll(list);
                if (list.size() > 0) {
                    for (LogicalDatatype logicalDatatype : list) {
                        if (this.selLogicalDatatype == null) continue;
                        if (!logicalDatatype.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                            if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                            this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                            continue;
                        }
                        if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                            this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                        }
                        break;
                    }
                } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                    this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                }
                arrayList.addAll(this.additionalPreferredLogicalTypes);
                for (LogicalDatatype logicalDatatype : arrayList) {
                    this.cbDatatype.addItem(logicalDatatype);
                    if (this.logicalDefaultDataType == null) {
                        this.logicalDefaultDataType = logicalDatatype;
                    }
                    if (!((Object)logicalDatatype).toString().equalsIgnoreCase("unknown")) continue;
                    this.logicalDefaultDataType = logicalDatatype;
                }
                this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
            } else {
                Iterator iterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    this.cbDatatype.addItem(e);
                    if (!e.toString().equalsIgnoreCase("unknown")) continue;
                    this.logicalDefaultDataType = e;
                }
                this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
            }
            if (this.ifDTSize.isEnabled() && !string.equals("")) {
                try {
                    this.ifDTSize.setText(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.ifDTPrecision.isEnabled() && n > 0) {
                try {
                    this.ifDTPrecision.setValue((long)n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.ifDTScale.isEnabled() && n2 > 0) {
                try {
                    this.ifDTScale.setValue((long)n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.cbUnits.isEnabled()) {
                this.cbUnits.setSelectedItem(string2);
            }
        } else if (this.rbDistinct.isSelected()) {
            Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
            while (iterator.hasNext()) {
                this.cbDatatype.addItem(iterator.next());
            }
        } else if (this.rbStructured.isSelected()) {
            Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
            while (iterator.hasNext()) {
                this.cbDatatype.addItem(iterator.next());
            }
            this.pnDType.add(this.pnRef);
            this.chbReference.setSelected(false);
        } else if (this.rbCollection.isSelected()) {
            Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
            while (iterator.hasNext()) {
                this.cbDatatype.addItem(iterator.next());
            }
        }
        this.cbDatatype.updateUI();
    }

    private void initSelectedAttributeOptions(TypeElement typeElement, boolean bl) {
        if (bl && this.selectedAttribute == typeElement) {
            return;
        }
        if (bl) {
            this.setPreviousSelectedAttribute();
        }
        this.selectedAttribute = typeElement;
        if (this.isEditable()) {
            this.enableAttributeOptions(true, 3);
        } else {
            this.enableAttributeOptions(false, 3);
        }
        this.tfColumnName.setText(typeElement.getName());
        if (typeElement.getType() instanceof Domain) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(typeElement.getType());
        } else if (typeElement.getType() instanceof LogicalDatatype) {
            this.rbLogical.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(typeElement.getType());
            this.cbUnits.setSelectedItem(typeElement.getUnits());
            this.ifDTSize.setText(typeElement.getSize());
            this.ifDTPrecision.setText(typeElement.getPrecision() > 0 ? new Integer(typeElement.getPrecision()).toString() : null);
            this.ifDTScale.setText(typeElement.getScale() > 0 ? new Integer(typeElement.getScale()).toString() : null);
        } else if (typeElement.getType() instanceof DistinctType) {
            this.rbDistinct.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(typeElement.getType());
        } else if (typeElement.getType() instanceof StructuredType) {
            this.rbStructured.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(typeElement.getType());
            this.chbReference.setSelected(typeElement.isReference());
        } else if (typeElement.getType() instanceof CollectionType) {
            this.rbCollection.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(typeElement.getType());
        } else {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.cbDatatype.setSelectedItem(typeElement.getDomain());
        }
        this.chbMandatory.setSelected(typeElement.isMandatory());
        this.taColumnComments.setText(typeElement.getComment());
        this.taColumnCommentsInRDBMS.setText(typeElement.getCommentInRDBMS());
        this.taColumnNotes.setText(typeElement.getNotes());
        this.coTable.updateUI();
        this.tfColumnName.selectAll();
        this.tfColumnName.requestFocus();
    }

    private void addAttribute(ActionEvent actionEvent) {
        boolean bl = false;
        boolean bl2 = false;
        if (actionEvent != null) {
            bl = (actionEvent.getModifiers() & 1) == 1;
            bl2 = (actionEvent.getModifiers() & 2) == 2;
        }
        int n = this.coTable.getSelectedRow();
        int n2 = this.attributesList.size();
        TypeElement typeElement = new TypeElement(this.structuredType.getDesignPart(), this.structuredType);
        typeElement.setName(this.generateName());
        typeElement.setDesign(this.structuredType.getDesign());
        int n3 = n2;
        if (n > -1) {
            if (bl) {
                if (n2 == 0) {
                    this.attributesList.add(typeElement);
                } else {
                    this.attributesList.add(n, typeElement);
                    n3 = n;
                }
            } else if (bl2) {
                if (n2 == 0 || n2 - 1 == n) {
                    this.attributesList.add(typeElement);
                } else {
                    this.attributesList.add(n + 1, typeElement);
                    n3 = n + 1;
                }
            } else {
                this.attributesList.add(typeElement);
            }
        } else {
            this.attributesList.add(typeElement);
        }
        this.tbAttributes.updateUI();
        this.coTable.updateUI();
        this.tbAttributes.changeSelection(n3, 1, false, false);
        this.coTable.changeSelection(n3, 1, false, false);
        this.initSelectedAttributeOptions(typeElement, true);
        String string = this.getAppView().getSettings().getColumnDefaultDatatype().trim();
        Enumeration<AbstractButton> enumeration = this.attributeTypeGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getText().trim().equalsIgnoreCase(string)) continue;
            jRadioButton.setSelected(true);
            this.updateDTComboBox();
            this.setDefaultDatatype();
        }
        this.enableAttributeOptions(true, 1);
    }

    private void setDefaultDatatype() {
        if (this.rbDomain.isSelected()) {
            this.cbDatatype.setSelectedItem(this.domainDefaultDataType);
        } else if (this.rbLogical.isSelected()) {
            this.cbDatatype.setSelectedItem(this.logicalDefaultDataType);
        }
    }

    private void deleteAttribute(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
        int[] nArray = jTable.getSelectedRows();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n3 = nArray[i];
            if (n3 != -1 && this.attributesList.size() > 0 && n3 < this.attributesList.size()) {
                TypeElement typeElement = this.attributesList.get(n3);
                arrayList.add(typeElement);
            }
            for (Object e : arrayList) {
                this.attributesList.remove(e);
            }
            this.tbAttributes.clearSelection();
            this.tbAttributes.updateUI();
            this.coTable.clearSelection();
            this.coTable.updateUI();
            this.selectedAttribute = null;
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 2);
        }
    }

    private void coCopyAttributes() {
        this.getAppView().clearCopiedObjects();
        int[] nArray = this.coTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= -1 || n >= this.attributesList.size()) continue;
            this.getAppView().addCopiedObject(this.attributesList.get(n));
        }
        this.bnCOPaste.setEnabled(this.getAppView().getCopiedObjects().size() > 0);
    }

    private void coPasteAttributes() {
        List list = this.getAppView().getCopiedObjects();
        for (Object e : list) {
            if (!(e instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)e;
            TypeElement typeElement2 = new TypeElement(this.structuredType.getDesignPart(), this.structuredType);
            typeElement2.setName(this.generatePastedAttributeName(typeElement.getName()));
            String string = typeElement2.getName();
            typeElement2.setDesign(this.structuredType.getDesign());
            this.attributesList.add(typeElement2);
            typeElement.copy(typeElement2);
            typeElement2.setName(string);
        }
        if (list.size() > 0) {
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
            this.tbAttributes.changeSelection(this.attributesList.size() - 1, 1, false, false);
            this.coTable.changeSelection(this.attributesList.size() - 1, 1, false, false);
        }
    }

    private void updateLogicalDatatypeOptions() {
        this.ifDTSize.setText("");
        this.ifDTPrecision.setText("");
        this.ifDTScale.setText("");
        this.cbUnits.setSelectedIndex(0);
        this.cbUnits.setEnabled(false);
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        this.sizeEnabled = false;
        this.precisionEnabled = false;
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbDatatype.getSelectedItem();
        if (logicalDatatype != null) {
            Map map = logicalDatatype.getLTDefaultValues();
            if (map != null) {
                this.precisionDefaultValue = (String)map.get("precision_default_value");
                this.sizeDefaultValue = (String)map.get("size_default_value");
                this.scaleDefaultValue = (String)map.get("scale_default_value");
            }
            Map map2 = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(this.structuredType.getSelectedRDBMSType().getName(), map2);
            if (mDDataType instanceof MDImplicitSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.ifDTPrecision.setText(this.precisionDefaultValue);
                this.ifDTPrecision.setEnabled(false);
                this.ifDTScale.setText(this.scaleDefaultValue);
                this.ifDTScale.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
            } else if (mDDataType instanceof MDPackedSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.add((Component)this.pnDTScale, "North");
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = true;
                try {
                    if (mDDataType.getPrecision() != 0) {
                        this.ifDTPrecision.setText("" + mDDataType.getPrecision());
                    }
                    if (this.isEditable()) {
                        this.ifDTPrecision.setEnabled(true);
                        if (this.ifDTPrecision.getText().trim().length() == 0) {
                            this.ifDTPrecision.setText(this.precisionDefaultValue);
                        }
                    }
                }
                catch (Exception exception) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.getScale() != 0) {
                        this.ifDTScale.setText("" + mDDataType.getScale());
                    }
                    if (this.isEditable()) {
                        this.ifDTScale.setEnabled(true);
                        if (this.ifDTScale.getText().trim().length() == 0) {
                            this.ifDTScale.setText(this.scaleDefaultValue);
                        }
                    }
                }
                catch (Exception exception) {
                    this.ifDTScale.setEnabled(false);
                }
            } else {
                try {
                    if (mDDataType.hasSize()) {
                        if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                            if (this.structuredType.getSelectedRDBMSType().getType() > 5 && this.structuredType.getSelectedRDBMSType().getType() < 10) {
                                if (this.isEditable()) {
                                    this.cbUnits.setEnabled(true);
                                }
                                String string = mDDataType.getSize();
                                String[] stringArray = string.split(" ");
                                this.ifDTSize.setText(stringArray[0]);
                                if (stringArray.length == 2) {
                                    this.cbUnits.setSelectedItem(stringArray[1]);
                                }
                            } else {
                                this.cbUnits.setEnabled(false);
                                this.ifDTSize.setText(mDDataType.getSize());
                            }
                        } else {
                            this.ifDTSize.setText(this.sizeDefaultValue);
                            if (this.structuredType.getSelectedRDBMSType().getType() > 5 && this.structuredType.getSelectedRDBMSType().getType() < 10) {
                                if (this.isEditable()) {
                                    this.cbUnits.setEnabled(true);
                                }
                            } else {
                                this.cbUnits.setEnabled(false);
                            }
                        }
                        if (this.isEditable()) {
                            this.ifDTSize.setEnabled(true);
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTSize, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = true;
                        this.precisionEnabled = false;
                    } else {
                        this.ifDTSize.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTSize.setEnabled(false);
                }
                try {
                    if (mDDataType.hasPrecision()) {
                        if (mDDataType.getPrecision() != 0) {
                            this.ifDTPrecision.setText("" + mDDataType.getPrecision());
                        }
                        if (this.isEditable()) {
                            this.ifDTPrecision.setEnabled(true);
                            if (this.ifDTPrecision.getText().trim().length() == 0) {
                                this.ifDTPrecision.setText(this.precisionDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTPrecision.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.hasScale()) {
                        if (mDDataType.getScale() != 0) {
                            this.ifDTScale.setText("" + mDDataType.getScale());
                        }
                        if (this.isEditable()) {
                            this.ifDTScale.setEnabled(true);
                            if (this.ifDTScale.getText().trim().length() == 0) {
                                this.ifDTScale.setText(this.scaleDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTScale.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTScale.setEnabled(false);
                }
            }
        }
    }

    private JPanel createExtendedAttributePanel() {
        Object object;
        Object object2;
        Object object3;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.coTable = new JTable(new AttributeModel());
        this.coTable.setSelectionMode(2);
        TableColumn tableColumn = this.coTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(25);
        this.coTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TypeElement typeElement;
                int n;
                if (mouseEvent.getClickCount() == 1) {
                    StructuredTypePropertiesDialogEx.this.setAttributeSelected();
                } else if (mouseEvent.getClickCount() == 2 && (n = StructuredTypePropertiesDialogEx.this.coTable.getSelectedRow()) != -1 && StructuredTypePropertiesDialogEx.this.attributesList.size() > 0 && n < StructuredTypePropertiesDialogEx.this.attributesList.size() && !(typeElement = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(n)).isDialogVisible()) {
                    typeElement.showModal = true;
                    TypeElementPropertiesDialogEx typeElementPropertiesDialogEx = new TypeElementPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), typeElement, StructuredTypePropertiesDialogEx.this.chbUsePreferredList.isSelected());
                    typeElementPropertiesDialogEx.initProperties(typeElement);
                    typeElementPropertiesDialogEx.show();
                    if (StructuredTypePropertiesDialogEx.this.selectedAttribute != null) {
                        StructuredTypePropertiesDialogEx.this.initSelectedAttributeOptions(StructuredTypePropertiesDialogEx.this.selectedAttribute, false);
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.coTable);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setPreferredSize(new Dimension(250, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_PROPERTIES);
        jButton.addActionListener(new COPropertiesAction());
        if (this.isEditable()) {
            object3 = new MoveUpDownListJTable(this.attributesList, this.coTable);
            object2 = "<html><body>" + Messages.getString("StructuredTypePropertiesDialogEx.AddTip1") + "<p>" + Messages.getString("StructuredTypePropertiesDialogEx.AddTip2") + "<p>" + Messages.getString("StructuredTypePropertiesDialogEx.AddTip3") + "</body>" + "</html>";
            this.bnCOAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.bnCOAdd.setToolTipText((String)object2);
            this.bnCOAdd.addActionListener(new COAddAction());
            this.bnCORemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnCORemove.setToolTipText(BTN_REMOVE);
            this.bnCORemove.addActionListener(new CORemoveAction());
            this.bnCOUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.bnCOUp.setToolTipText(BTN_MOVE_UP);
            this.bnCOUp.addActionListener(new MoveUpDownListJTable.MoveUpAction((MoveUpDownListJTable)object3));
            this.bnCODown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.bnCODown.setToolTipText(BTN_MOVE_DOWN);
            this.bnCODown.addActionListener(new MoveUpDownListJTable.MoveDownAction((MoveUpDownListJTable)object3));
            this.bnCOCopy = new JButton(gUIConfiguration.getIcon("COPY_ICON", this.getPreferredIconSize()));
            this.bnCOCopy.setToolTipText(Messages.getString("StructuredTypePropertiesDialogEx.CopyAttributes"));
            this.bnCOCopy.addActionListener(new COCopyAction());
            this.bnCOPaste = new JButton(gUIConfiguration.getIcon("PASTE_ICON", this.getPreferredIconSize()));
            this.bnCOPaste.setToolTipText(Messages.getString("StructuredTypePropertiesDialogEx.PasteAttributes"));
            this.bnCOPaste.addActionListener(new COPasteAction());
            this.coTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (StructuredTypePropertiesDialogEx.this.attributesList.isEmpty()) {
                        StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        jButton.setEnabled(false);
                        StructuredTypePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        StructuredTypePropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                        StructuredTypePropertiesDialogEx.this.bnCOUp.setEnabled(true);
                        StructuredTypePropertiesDialogEx.this.bnCODown.setEnabled(true);
                        jButton.setEnabled(true);
                        StructuredTypePropertiesDialogEx.this.setAttributeSelected();
                    }
                }
            });
            this.coTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (StructuredTypePropertiesDialogEx.this.attributesList.isEmpty()) {
                        StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        jButton.setEnabled(false);
                        StructuredTypePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        StructuredTypePropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                        StructuredTypePropertiesDialogEx.this.bnCOUp.setEnabled(true);
                        StructuredTypePropertiesDialogEx.this.bnCODown.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            object = this.coTable.getSelectionModel();
            object.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                        if (listSelectionModel.isSelectionEmpty()) {
                            StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            jButton.setEnabled(false);
                        } else {
                            StructuredTypePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                            jButton.setEnabled(true);
                        }
                    }
                }
            });
        }
        object3 = new JToolBar(0);
        ((JToolBar)object3).setFloatable(false);
        ((Container)object3).add(jButton);
        if (this.isEditable()) {
            ((JToolBar)object3).addSeparator();
            ((Container)object3).add(this.bnCOAdd);
            ((Container)object3).add(this.bnCORemove);
            ((Container)object3).add(this.bnCOUp);
            ((Container)object3).add(this.bnCODown);
            ((JToolBar)object3).addSeparator();
            ((Container)object3).add(this.bnCOCopy);
            ((Container)object3).add(this.bnCOPaste);
        }
        jPanel2.add((Component)object3);
        object2 = new JPanel(new BorderLayout());
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(Messages.getString("StructuredTypePropertiesDialogEx.Attributes")));
        ((Container)object2).add((Component)jPanel2, "North");
        ((Container)object2).add(jScrollPane);
        jPanel.add((Component)object2, "Center");
        this.coTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    StructuredTypePropertiesDialogEx.this.deleteAttribute(StructuredTypePropertiesDialogEx.this.coTable);
                }
            }
        });
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(Messages.getString("StructuredTypePropertiesDialogEx.AtrributeProperties")));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(60, 20);
        JLabel jLabel = new JLabel(LB_NAME);
        jLabel.setHorizontalAlignment(0);
        jLabel.setPreferredSize(dimension);
        this.tfColumnName = new JTextField();
        this.tfColumnName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    StructuredTypePropertiesDialogEx.this.moveUp();
                } else if (keyEvent.getKeyCode() == 40) {
                    StructuredTypePropertiesDialogEx.this.moveDown();
                }
            }
        });
        Dimension dimension2 = new Dimension(200, 20);
        Dimension dimension3 = new Dimension(260, 20);
        this.tfColumnName.setPreferredSize(dimension3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.createRow(jLabel, this.tfColumnName), "North");
        jPanel4.add((Component)new JPanel(), "Center");
        jPanel3.add((Component)jPanel4, "North");
        RBActionListener rBActionListener = new RBActionListener();
        this.rbDomain = new JRadioButton(LB_DOMAIN);
        this.rbLogical = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("StructuredTypePropertiesDialogEx.Collection"));
        this.rbDomain.addActionListener(rBActionListener);
        this.rbLogical.addActionListener(rBActionListener);
        this.rbDistinct.addActionListener(rBActionListener);
        this.rbStructured.addActionListener(rBActionListener);
        this.rbCollection.addActionListener(rBActionListener);
        this.attributeTypeGroup = new ButtonGroup();
        this.attributeTypeGroup.add(this.rbDomain);
        this.attributeTypeGroup.add(this.rbLogical);
        this.attributeTypeGroup.add(this.rbDistinct);
        this.attributeTypeGroup.add(this.rbStructured);
        this.attributeTypeGroup.add(this.rbCollection);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 0));
        jPanel5.add(this.rbDomain);
        jPanel5.add(this.rbLogical);
        jPanel5.add(this.rbDistinct);
        jPanel5.add(new JPanel());
        JPanel jPanel6 = new JPanel(new GridLayout(1, 0));
        jPanel6.add(this.rbStructured);
        jPanel6.add(this.rbCollection);
        jPanel6.add(new JPanel());
        JLabel jLabel2 = new JLabel(LB_DATATYPE);
        jLabel2.setPreferredSize(dimension);
        JPanel jPanel7 = new JPanel(new GridLayout(0, 1));
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(dimension);
        jPanel7.add(this.createRow(jLabel2, jPanel5));
        jPanel7.add(this.createRow(jLabel3, jPanel6));
        jPanel3.add((Component)jPanel7, "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 10));
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel8, "Center");
        jPanel3.add((Component)jPanel9, "South");
        JLabel jLabel4 = new JLabel(LB_TYPE);
        jLabel4.setHorizontalAlignment(0);
        jLabel4.setPreferredSize(dimension);
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setPreferredSize(dimension2);
        this.cbDatatype.setMaximumRowCount(20);
        this.cbDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StructuredTypePropertiesDialogEx.this.rbLogical.isSelected()) {
                    StructuredTypePropertiesDialogEx.this.updateLogicalDatatypeOptions();
                }
            }
        });
        JLabel jLabel5 = new JLabel(Messages.getString("StructuredTypePropertiesDialogEx.Preferred"));
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setPreferredSize(dimension);
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JPanel(), "North");
        jPanel4.add((Component)this.createRow(jLabel4, this.cbDatatype), "Center");
        jPanel4.add((Component)this.createRow(jLabel5, this.chbUsePreferredList), "East");
        jPanel8.add((Component)jPanel4, "North");
        this.pnDType = new JPanel(new BorderLayout());
        this.pnDType.setPreferredSize(new Dimension(200, 50));
        JLabel jLabel6 = new JLabel(' ' + LB_SIZE);
        jLabel6.setHorizontalAlignment(0);
        jLabel6.setPreferredSize(dimension);
        this.ifDTSize = new JTextField();
        this.ifDTSize.setPreferredSize(dimension3);
        this.pnDTSize = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTSize.add(this.createRow(jLabel6, this.ifDTSize));
        this.pnDType.add((Component)this.pnDTSize, "North");
        jPanel8.add((Component)this.pnDType, "Center");
        JLabel jLabel7 = new JLabel(Messages.getString("StructuredTypePropertiesDialogEx.Units"));
        jLabel7.setHorizontalAlignment(0);
        jLabel7.setPreferredSize(dimension);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(new Dimension(60, 20));
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)this.createRow(jLabel7, this.cbUnits), "West");
        jPanel10.add((Component)new JPanel(), "Center");
        this.pnDTSize.add(jPanel10);
        JLabel jLabel8 = new JLabel(LB_PRECISION);
        jLabel8.setPreferredSize(dimension);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setPreferredSize(dimension3);
        this.pnDTScale = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTScale.add(this.createRow(jLabel8, this.ifDTPrecision));
        JLabel jLabel9 = new JLabel(LB_SCALE);
        jLabel9.setHorizontalAlignment(0);
        jLabel9.setPreferredSize(dimension);
        this.ifDTScale = new JIntegerField();
        this.ifDTScale.setPreferredSize(dimension3);
        this.pnDTScale.add(this.createRow(jLabel9, this.ifDTScale));
        this.pnRef = new JPanel(new GridLayout(0, 1, 0, 10));
        JLabel jLabel10 = new JLabel("");
        jLabel10.setHorizontalAlignment(0);
        jLabel10.setPreferredSize(dimension);
        this.chbReference = new JCheckBox(Messages.getString("StructuredTypePropertiesDialogEx.Reference"));
        this.ifDTSize.setPreferredSize(dimension3);
        this.pnRef.add(this.createRow(jLabel10, this.chbReference));
        JPanel jPanel11 = new JPanel(new GridLayout(0, 1));
        jPanel9.add((Component)jPanel11, "South");
        jPanel11.add(new JPanel());
        this.chbMandatory = new JCheckBox(Messages.getString("StructuredTypePropertiesDialogEx.Mandatory"));
        this.chbMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StructuredTypePropertiesDialogEx.this.selectedAttribute != null) {
                    StructuredTypePropertiesDialogEx.this.selectedAttribute.setMandatory(StructuredTypePropertiesDialogEx.this.chbMandatory.isSelected());
                }
            }
        });
        JPanel jPanel12 = new JPanel(new GridLayout(1, 0));
        jPanel12.add(this.chbMandatory);
        jLabel3 = new JLabel("");
        jLabel3.setPreferredSize(dimension);
        jPanel11.add(this.createRow(jLabel3, jPanel12));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.taColumnComments = new JTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnNotes = new JTextArea();
        this.taColumnNotes.setLineWrap(true);
        this.taColumnNotes.setWrapStyleWord(true);
        this.taColumnCommentsInRDBMS = new JTextArea();
        this.taColumnCommentsInRDBMS.setLineWrap(true);
        this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
        jTabbedPane.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Comments"), new JScrollPane(this.taColumnComments));
        jTabbedPane.addTab(Messages.getString("StructuredTypePropertiesDialogEx.CommentsInRDBMS"), new JScrollPane(this.taColumnCommentsInRDBMS));
        jTabbedPane.addTab(Messages.getString("StructuredTypePropertiesDialogEx.Notes"), new JScrollPane(this.taColumnNotes));
        jTabbedPane.setPreferredSize(new Dimension(300, 100));
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        jPanel13.add(jPanel3);
        ((Container)object).add((Component)jPanel13, "North");
        ((Container)object).add((Component)jTabbedPane, "Center");
        jPanel.add((Component)object, "East");
        this.updateDTComboBox();
        return jPanel;
    }

    private void moveUp() {
        int n = this.coTable.getSelectedRow();
        if (n > 0) {
            this.coTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            this.setAttributeSelected();
        }
    }

    private void moveDown() {
        int n = this.coTable.getSelectedRow();
        if (n > -1) {
            if (n < this.attributesList.size() - 1) {
                this.coTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                this.setAttributeSelected();
            } else if (!ApplicationView.IS_VIEWER && n == this.attributesList.size() - 1) {
                this.addAttribute(null);
            }
        }
    }

    protected String generateName() {
        String string = Messages.getString("StructuredTypePropertiesDialogEx.Attribute");
        int n = 0;
        int n2 = this.attributesList.size();
        if (n2 != 0) {
            n = this.attrCounter = n2 + 1;
        } else {
            ++this.attrCounter;
            n = this.attrCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.attributeExists(string2)) {
            n = ++this.attrCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    protected String generatePastedAttributeName(String string) {
        void var4_6;
        if (!this.attributeExists(string)) {
            return string;
        }
        int n = 0;
        for (TypeElement object2 : this.attributesList) {
            String string2 = object2.getName();
            if (string2.indexOf(string) < 0) continue;
            ++n;
        }
        String string3 = string.concat("_").concat(Integer.toString(n));
        while (this.attributeExists((String)var4_6)) {
            String string4 = string.concat("_").concat(Integer.toString(++n));
        }
        return var4_6;
    }

    private boolean attributeExists(String string) {
        for (int i = 0; i < this.attributesList.size(); ++i) {
            TypeElement typeElement = this.attributesList.get(i);
            if (!string.equalsIgnoreCase(typeElement.getName())) continue;
            return true;
        }
        return false;
    }

    protected String generateMethodName() {
        String string = "Method";
        int n = 0;
        int n2 = this.mList.size();
        if (n2 != 0) {
            n = this.methodCounter = n2 + 1;
        } else {
            ++this.methodCounter;
            n = this.methodCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.methodExists(string2)) {
            n = ++this.methodCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean methodExists(String string) {
        for (int i = 0; i < this.mList.size(); ++i) {
            Method method = (Method)this.mList.get(i);
            if (!string.equalsIgnoreCase(method.getName())) continue;
            return true;
        }
        return false;
    }

    protected JPanel getMethodsPanel() {
        if (this.pnMethods == null) {
            JComponent jComponent;
            this.pnMethods = this.createPage(Messages.getString("StructuredTypePropertiesDialogEx.Methods"));
            this.mList = new ArrayList();
            MethodModel methodModel = new MethodModel();
            this.mtable = new JTable(methodModel);
            this.mtable.setSelectionMode(0);
            this.mtable.setFocusTraversalKeysEnabled(false);
            JScrollPane jScrollPane = new JScrollPane(this.mtable);
            JPanel jPanel = new JPanel(new GridLayout(1, 0));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnMProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnMProperties.setToolTipText(BTN_PROPERTIES);
            this.btnMProperties.addActionListener(new MethodPropertiesAction());
            this.btnMProperties.setEnabled(false);
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnMProperties);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new AddMethodAction());
                this.btnMRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnMRemove.setToolTipText(BTN_REMOVE);
                this.btnMRemove.addActionListener(new RemoveMethodAction());
                this.btnMRemove.setEnabled(false);
                this.btnMUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
                this.btnMUp.setToolTipText(BTN_MOVE_UP);
                this.btnMUp.addActionListener(new MoveMethodUpAction());
                this.btnMUp.setEnabled(false);
                this.btnMDown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
                this.btnMDown.setToolTipText(BTN_MOVE_DOWN);
                this.btnMDown.addActionListener(new MoveMethodDownAction());
                this.btnMDown.setEnabled(false);
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(this.btnMRemove);
                jToolBar.add(this.btnMUp);
                jToolBar.add(this.btnMDown);
            }
            this.mtable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Method method;
                    int n = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
                    if (n != -1) {
                        StructuredTypePropertiesDialogEx.this.btnMProperties.setEnabled(true);
                        if (StructuredTypePropertiesDialogEx.this.isEditable()) {
                            StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(true);
                            StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(true);
                            StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(true);
                        }
                    }
                    if (mouseEvent.getClickCount() == 2 && n != -1 && StructuredTypePropertiesDialogEx.this.mList.size() > 0 && n < StructuredTypePropertiesDialogEx.this.mList.size() && !(method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(n)).isDialogVisible()) {
                        method.showModal = ((StructuredTypePropertiesDialogEx)StructuredTypePropertiesDialogEx.this).structuredType.showModal || StructuredTypePropertiesDialogEx.this.structuredType.showForFirstTime();
                        MethodPropertiesDialogEx methodPropertiesDialogEx = new MethodPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), method);
                        methodPropertiesDialogEx.initProperties(method);
                        methodPropertiesDialogEx.show();
                    }
                }
            });
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnMethods.add(jComponent);
        }
        return this.pnMethods;
    }

    public boolean moveMethodToIndex(DesignObject designObject, int n) {
        if (this.mList.contains(designObject) && this.mList.size() > n && n >= 0) {
            this.mList.remove(designObject);
            this.mList.add(n, designObject);
            return true;
        }
        return false;
    }

    private boolean hasValidContainmentBeforeSave() {
        return this.hasValidContainment((DesignObject)this.cbDatatype.getSelectedItem(), this.tfColumnName.getText(), this.chbReference.isSelected());
    }

    private boolean hasValidContainment(DesignObject designObject, String string, boolean bl) {
        if (bl) {
            return true;
        }
        if (designObject instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)designObject;
            if (this.structuredType.isParentOf(structuredType) || structuredType.isParentOf(this.structuredType)) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("StructuredTypePropertiesDialogEx.ElementPartOf"), string, this.structuredType.getName()), Messages.getString("StructuredTypePropertiesDialogEx.ForbidenSelfContainment"), 0);
                return false;
            }
            if (structuredType.containsElementOfStructuredType(this.structuredType)) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("StructuredTypePropertiesDialogEx.CyclicContainment"), string), Messages.getString("StructuredTypePropertiesDialogEx.ForbidenCyclicContainment"), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canExit() {
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        if (super.canExit()) {
            return this.hasValidContainmentBeforeSave();
        }
        return false;
    }

    public boolean containsElement(ComboBoxModel comboBoxModel, Object object) {
        int n = comboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = comboBoxModel.getElementAt(i);
            if (!e.equals(object)) continue;
            return true;
        }
        return false;
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator iterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)iterator.next();
            List<LogicalDatatype> list = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype logicalDatatype2 : list) {
                if (!logicalDatatype.getObjectID().equalsIgnoreCase(logicalDatatype2.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(logicalDatatype);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator iterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            PreferredDomain preferredDomain = new PreferredDomain();
            preferredDomain.setObjectId(domain.getObjectID());
            List<PreferredDomain> list = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain preferredDomain2 : list) {
                if (!preferredDomain.getObjectId().equalsIgnoreCase(preferredDomain2.getObjectId())) continue;
                this.currentPreferredDomainList.add(domain);
            }
        }
        return this.currentPreferredDomainList;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructuredTypePropertiesDialogEx.this.setPreviousSelectedAttribute();
            StructuredTypePropertiesDialogEx.this.updateDTComboBox();
        }
    }

    private class MoveMethodDownAction
    implements ActionListener {
        private MoveMethodDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (n > -1 && n < StructuredTypePropertiesDialogEx.this.mList.size()) {
                Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(n);
                StructuredTypePropertiesDialogEx.this.moveMethodToIndex(method, n + 1);
                StructuredTypePropertiesDialogEx.this.mtable.changeSelection(n + 1, 0, false, false);
                StructuredTypePropertiesDialogEx.this.mtable.updateUI();
            }
        }
    }

    private class MoveMethodUpAction
    implements ActionListener {
        private MoveMethodUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (n > -1 && n < StructuredTypePropertiesDialogEx.this.mList.size()) {
                Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(n);
                StructuredTypePropertiesDialogEx.this.moveMethodToIndex(method, n - 1);
                StructuredTypePropertiesDialogEx.this.mtable.changeSelection(n - 1, 0, false, false);
                StructuredTypePropertiesDialogEx.this.mtable.updateUI();
            }
        }
    }

    private class RemoveMethodAction
    implements ActionListener {
        private RemoveMethodAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (n != -1 && StructuredTypePropertiesDialogEx.this.mList.size() > 0 && n < StructuredTypePropertiesDialogEx.this.mList.size()) {
                Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(n);
                StructuredTypePropertiesDialogEx.this.mList.remove(method);
                StructuredTypePropertiesDialogEx.this.mtable.updateUI();
                if (StructuredTypePropertiesDialogEx.this.mList.size() > 0) {
                    StructuredTypePropertiesDialogEx.this.mtable.removeRowSelectionInterval(0, StructuredTypePropertiesDialogEx.this.mList.size() - 1);
                }
                StructuredTypePropertiesDialogEx.this.btnMProperties.setEnabled(false);
                if (StructuredTypePropertiesDialogEx.this.isEditable()) {
                    StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(false);
                    StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(false);
                    StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(false);
                }
            }
        }
    }

    private class AddMethodAction
    implements ActionListener {
        private AddMethodAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Method method = new Method(StructuredTypePropertiesDialogEx.this.structuredType.getDesignPart(), StructuredTypePropertiesDialogEx.this.structuredType);
            method.setName(StructuredTypePropertiesDialogEx.this.generateMethodName());
            method.setDesign(StructuredTypePropertiesDialogEx.this.structuredType.getDesign());
            StructuredTypePropertiesDialogEx.this.mList.add(method);
            StructuredTypePropertiesDialogEx.this.mtable.updateUI();
            if (StructuredTypePropertiesDialogEx.this.mtable.getSelectedRowCount() > 0) {
                StructuredTypePropertiesDialogEx.this.btnMProperties.setEnabled(true);
                if (StructuredTypePropertiesDialogEx.this.isEditable()) {
                    StructuredTypePropertiesDialogEx.this.btnMRemove.setEnabled(true);
                    StructuredTypePropertiesDialogEx.this.btnMUp.setEnabled(true);
                    StructuredTypePropertiesDialogEx.this.btnMDown.setEnabled(true);
                }
            }
        }
    }

    private class MethodPropertiesAction
    implements ActionListener {
        private MethodPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Method method;
            int n = StructuredTypePropertiesDialogEx.this.mtable.getSelectedRow();
            if (n != -1 && StructuredTypePropertiesDialogEx.this.mList.size() > 0 && n < StructuredTypePropertiesDialogEx.this.mList.size() && !(method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(n)).isDialogVisible()) {
                method.showModal = ((StructuredTypePropertiesDialogEx)StructuredTypePropertiesDialogEx.this).structuredType.showModal || StructuredTypePropertiesDialogEx.this.structuredType.showForFirstTime();
                MethodPropertiesDialogEx methodPropertiesDialogEx = new MethodPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), method);
                methodPropertiesDialogEx.initProperties(method);
                methodPropertiesDialogEx.show();
            }
        }
    }

    public class MethodModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.mList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Method method = (Method)StructuredTypePropertiesDialogEx.this.mList.get(n);
            if (n2 == 0) {
                return method.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class RBActionListener
    implements ActionListener {
        private RBActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructuredTypePropertiesDialogEx.this.updateDTComboBox();
            StructuredTypePropertiesDialogEx.this.setDefaultDatatype();
        }
    }

    private class COPasteAction
    extends AbstractAction {
        private COPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructuredTypePropertiesDialogEx.this.coPasteAttributes();
            StructuredTypePropertiesDialogEx.this.setAttributeSelected();
        }
    }

    private class COCopyAction
    extends AbstractAction {
        private COCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructuredTypePropertiesDialogEx.this.setPreviousSelectedAttribute();
            StructuredTypePropertiesDialogEx.this.coCopyAttributes();
        }
    }

    private class CORemoveAction
    implements ActionListener {
        private CORemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructuredTypePropertiesDialogEx.this.deleteAttribute(StructuredTypePropertiesDialogEx.this.coTable);
        }
    }

    private class COAddAction
    implements ActionListener {
        private COAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructuredTypePropertiesDialogEx.this.addAttribute(actionEvent);
        }
    }

    private class COPropertiesAction
    implements ActionListener {
        private COPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TypeElement typeElement;
            int n = StructuredTypePropertiesDialogEx.this.coTable.getSelectedRow();
            if (n != -1 && StructuredTypePropertiesDialogEx.this.attributesList.size() > 0 && n < StructuredTypePropertiesDialogEx.this.attributesList.size() && !(typeElement = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(n)).isDialogVisible()) {
                typeElement.showModal = true;
                TypeElementPropertiesDialogEx typeElementPropertiesDialogEx = new TypeElementPropertiesDialogEx((Dialog)StructuredTypePropertiesDialogEx.this, StructuredTypePropertiesDialogEx.this.getAppView(), typeElement, StructuredTypePropertiesDialogEx.this.chbUsePreferredList.isSelected());
                typeElementPropertiesDialogEx.initProperties(typeElement);
                typeElementPropertiesDialogEx.show();
                if (StructuredTypePropertiesDialogEx.this.selectedAttribute != null) {
                    StructuredTypePropertiesDialogEx.this.initSelectedAttributeOptions(StructuredTypePropertiesDialogEx.this.selectedAttribute, false);
                }
            }
        }
    }

    class UsedInCollectionTypesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInCollectionTypesTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return Messages.getString("StructuredTypePropertiesDialogEx.CollectionType");
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInCollectionTypesList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CollectionType collectionType = (CollectionType)StructuredTypePropertiesDialogEx.this.usedInCollectionTypesList.get(n);
            if (n2 == 0) {
                return collectionType.getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    class UsedInStructuredTypeAttributesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInStructuredTypeAttributesTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.StructuredType");
            }
            return Messages.getString("StructuredTypePropertiesDialogEx.AttributeST");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInStructuredTypesAttributesList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TypeElement typeElement = (TypeElement)StructuredTypePropertiesDialogEx.this.usedInStructuredTypesAttributesList.get(n);
            if (n2 == 0) {
                return typeElement.getStructuredType().getName();
            }
            if (n2 == 1) {
                return typeElement.getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    class UsedInStructuredTypesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInStructuredTypesTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return Messages.getString("StructuredTypePropertiesDialogEx.StructuredType");
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInStructuredTypesList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StructuredType structuredType = (StructuredType)StructuredTypePropertiesDialogEx.this.usedInStructuredTypesList.get(n);
            if (n2 == 0) {
                return structuredType.getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    class UsedInViewsTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInViewsTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Model");
            }
            return Messages.getString("StructuredTypePropertiesDialogEx.View");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInViewsList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableView tableView = (TableView)StructuredTypePropertiesDialogEx.this.usedInViewsList.get(n);
            if (n2 == 0) {
                return tableView.getDesignPart().getName();
            }
            if (n2 == 1) {
                return tableView.getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    class UsedInTablesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInTablesTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Model");
            }
            return Messages.getString("StructuredTypePropertiesDialogEx.Table");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInTablesList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Table table = (Table)StructuredTypePropertiesDialogEx.this.usedInTablesList.get(n);
            if (n2 == 0) {
                return table.getDesignPart().getName();
            }
            if (n2 == 1) {
                return table.getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    class UsedInEntitiesTableModel
    extends AbstractDatatypePropertiesDialog.UsedInObjectModel {
        UsedInEntitiesTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return Messages.getString("StructuredTypePropertiesDialogEx.Entity");
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.usedInEntitiesList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Entity entity = (Entity)StructuredTypePropertiesDialogEx.this.usedInEntitiesList.get(n);
            if (n2 == 0) {
                return entity.getName();
            }
            return super.getValueAt(n, n2);
        }
    }

    public class AttributeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return " ";
            }
            if (n == 1) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Name");
            }
            if (n == 2) {
                return Messages.getString("StructuredTypePropertiesDialogEx.DataType");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Integer.class;
            }
            if (n == 1) {
                return String.class;
            }
            if (n == 2) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TypeElement typeElement = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(n);
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (n2 == 1) {
                return typeElement.getName();
            }
            if (n2 == 2) {
                return typeElement.getDataType();
            }
            return new Integer(n * n2);
        }
    }

    class StatusCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        StatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(0);
            this.setEnabled(false);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    class DataTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        DataTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TypeElement typeElement = (TypeElement)object;
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(typeElement.getDataType());
            return this;
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return StructuredTypePropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return " ";
            }
            if (n == 1) {
                return Messages.getString("StructuredTypePropertiesDialogEx.Name");
            }
            if (n == 2) {
                return Messages.getString("StructuredTypePropertiesDialogEx.DataType");
            }
            if (n == 3) {
                return "M";
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TypeElement typeElement = (TypeElement)StructuredTypePropertiesDialogEx.this.attributesList.get(n);
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (n2 == 1) {
                return typeElement.getName();
            }
            if (n2 == 2) {
                return typeElement;
            }
            if (n2 == 3) {
                return typeElement.isMandatory();
            }
            return new Integer(n * n2);
        }
    }
}

