/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SelectLogicalTypeDialog
extends CustomDialog {
    private JDialog dialog;
    private DataTypeObject object;
    private JPanel buttonPanel;
    private JPanel general;
    private JButton bnLogicalType;
    private String selectedRdbmsSite;
    private JComboBox cbLogicalType;
    private JTextField ifSize;
    private JIntegerField ifPrecision;
    private JIntegerField ifScale;
    protected static final int FIELD_WIDTH = 18;
    private static final String EMPTY_STRING = "";
    private static Dimension dim = new Dimension(205, 20);
    private boolean usePreferredList = false;
    private TreeMap typesRDBMSSites = new TreeMap();
    private int precisionDefaultValue;
    private int scaleDefaultValue;
    private int sizeDefaultValue;

    public SelectLogicalTypeDialog(ApplicationView applicationView, DataTypeObject dataTypeObject, JButton jButton, String string, boolean bl) {
        super(applicationView);
        this.usePreferredList = bl;
        this.object = dataTypeObject;
        this.bnLogicalType = jButton;
        this.selectedRdbmsSite = string;
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.add((Component)this.general, "Center");
        JPanel jPanel = this.getButtonPanel();
        this.add((Component)jPanel, "South");
        this.general.setPreferredSize(new Dimension(350, 140));
    }

    private void initGeneral() {
        Iterator iterator = this.object.getDesign().getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            RDBMSType rDBMSType = (RDBMSType)iterator.next();
            this.typesRDBMSSites.put(rDBMSType.getType(), rDBMSType.getName());
        }
        this.initSize();
        this.initPrecision();
        this.initScale();
        this.initLogicalType();
    }

    private void initLogicalType() {
        JLabel jLabel = new JLabel(Messages.getString("SelectLogicalTypeDialog.LogicalType"));
        this.general.add(jLabel);
        this.cbLogicalType = new JComboBox<Object>(this.object.getDesign().getLogicalDatatypeSet().toArray());
        this.general.add(this.cbLogicalType);
        this.cbLogicalType.setBackground(Color.WHITE);
        this.cbLogicalType.setFont(new Font(this.cbLogicalType.getFont().getName(), 0, this.cbLogicalType.getFont().getSize()));
        this.cbLogicalType.setPreferredSize(dim);
        this.cbLogicalType.setMaximumRowCount(20);
        this.cbLogicalType.addActionListener(new DatatypeListener());
        this.cbLogicalType.setSelectedItem(this.object.getDesign().getLogicalDatatypeSet().getDefaultType());
        this.setLabelConstraints(jLabel, 15);
        this.setObjectConstraints(this.cbLogicalType, 15);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("SelectLogicalTypeDialog.Size"));
        this.general.add(jLabel);
        this.ifSize = new JTextField();
        this.ifSize.setPreferredSize(dim);
        this.general.add(this.ifSize);
        this.setLabelConstraints(jLabel, 45);
        this.setObjectConstraints(this.ifSize, 45);
    }

    private void initPrecision() {
        JLabel jLabel = new JLabel(Messages.getString("SelectLogicalTypeDialog.Precision"));
        this.general.add(jLabel);
        this.ifPrecision = new JIntegerField();
        this.ifPrecision.setPreferredSize(dim);
        this.general.add(this.ifPrecision);
        this.setLabelConstraints(jLabel, 75);
        this.setObjectConstraints(this.ifPrecision, 75);
    }

    private void initScale() {
        JLabel jLabel = new JLabel(Messages.getString("SelectLogicalTypeDialog.Scale"));
        this.general.add(jLabel);
        this.ifScale = new JIntegerField();
        this.ifScale.setPreferredSize(dim);
        this.general.add(this.ifScale);
        this.setLabelConstraints(jLabel, 105);
        this.setObjectConstraints(this.ifScale, 105);
    }

    public void initProperties() {
        if (this.object.getType() != null && this.object.getType() instanceof LogicalDatatype) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)this.object.getType();
            Map map = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(this.selectedRdbmsSite, map);
            this.cbLogicalType.removeAllItems();
            if (this.usePreferredList) {
                Iterator<LogicalDatatype> iterator = this.getApplicationView().getSettings().getPreferredLogicaltypes().iterator();
                while (iterator.hasNext()) {
                    this.cbLogicalType.addItem(iterator.next());
                }
            } else {
                Iterator iterator = this.object.getDesign().getLogicalDatatypeSet().iterator();
                while (iterator.hasNext()) {
                    this.cbLogicalType.addItem(iterator.next());
                }
            }
            this.cbLogicalType.setSelectedItem(this.object.getType());
            if (mDDataType instanceof MDImplicitSized) {
                this.ifSize.setEnabled(false);
                this.ifPrecision.setEnabled(false);
                this.ifScale.setEnabled(false);
            } else if (mDDataType instanceof MDPackedSized) {
                this.ifSize.setEnabled(false);
                try {
                    if (this.object.getPrecision() > 0) {
                        this.ifPrecision.setValue(this.object.getPrecision() > 0 ? (long)this.object.getPrecision() : 0L);
                    } else if (mDDataType.getPrecision() != 0) {
                        this.ifPrecision.setValue(mDDataType.getPrecision() > 0 ? (long)mDDataType.getPrecision() : 0L);
                    }
                    mDDataType.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.object.getScale() > 0) {
                        this.ifScale.setValue(this.object.getScale() > 0 ? (long)this.object.getScale() : 0L);
                    } else if (mDDataType.getScale() != 0) {
                        this.ifScale.setValue(mDDataType.getScale() > 0 ? (long)mDDataType.getScale() : 0L);
                    }
                    mDDataType.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifScale.setEnabled(false);
                }
            } else {
                try {
                    if (!this.object.getSize().equals(EMPTY_STRING)) {
                        this.ifSize.setText(this.object.getSize());
                    } else if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                        this.ifSize.setText(mDDataType.getSize());
                    }
                    mDDataType.getSize();
                    this.ifSize.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifSize.setEnabled(false);
                }
                try {
                    if (this.object.getPrecision() > 0) {
                        this.ifPrecision.setValue(this.object.getPrecision() > 0 ? (long)this.object.getPrecision() : 0L);
                    } else if (mDDataType.getPrecision() != 0) {
                        this.ifPrecision.setValue(mDDataType.getPrecision() > 0 ? (long)mDDataType.getPrecision() : 0L);
                    }
                    mDDataType.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.object.getScale() > 0) {
                        this.ifScale.setValue(this.object.getScale() > 0 ? (long)this.object.getScale() : 0L);
                    } else if (mDDataType.getScale() != 0) {
                        this.ifScale.setValue(mDDataType.getScale() > 0 ? (long)mDDataType.getScale() : 0L);
                    }
                    mDDataType.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception exception) {
                    this.ifScale.setEnabled(false);
                }
            }
        }
    }

    private void setProperties() {
        this.object.setType((DesignObject)this.cbLogicalType.getSelectedItem());
        Map map = ((LogicalDatatype)this.cbLogicalType.getSelectedItem()).getLTDefaultValues();
        String string = (String)map.get("precision_default_value");
        this.precisionDefaultValue = string != EMPTY_STRING && string != null ? new Integer((String)map.get("precision_default_value")) : 0;
        String string2 = (String)map.get("size_default_value");
        String string3 = (String)map.get("scale_default_value");
        this.scaleDefaultValue = string3 != EMPTY_STRING && string3 != null ? new Integer((String)map.get("scale_default_value")) : 0;
        try {
            if (!this.ifSize.getText().equals(string2)) {
                this.object.setSize(this.ifSize.getText());
            } else {
                this.object.setSize(EMPTY_STRING);
            }
        }
        catch (Exception exception) {
            this.object.setSize(EMPTY_STRING);
        }
        try {
            if (this.ifPrecision.getIntValue() != this.precisionDefaultValue || this.ifScale.getIntValue() != this.scaleDefaultValue) {
                this.object.setPrecision(this.ifPrecision.getIntValue());
                this.object.setScale(this.ifScale.getIntValue());
            } else {
                this.object.setPrecision(0);
                this.object.setScale(0);
            }
        }
        catch (Exception exception) {
            this.object.setPrecision(0);
            this.object.setScale(0);
        }
        this.bnLogicalType.setText(this.object.getDataType());
    }

    protected void setLabelConstraints(JLabel jLabel, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(Component component, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setX(Spring.constant(125));
        constraints.setY(Spring.constant(n));
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            JButton jButton = new JButton(Messages.getString("SelectLogicalTypeDialog.OK"));
            jButton.setMnemonic(79);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectLogicalTypeDialog.this.setProperties();
                    SelectLogicalTypeDialog.this.close();
                }
            });
            JButton jButton2 = new JButton(Messages.getString("SelectLogicalTypeDialog.Cancel"));
            jButton2.setMnemonic(67);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectLogicalTypeDialog.this.close();
                }
            });
            JButton jButton3 = new JButton(this.getHelpAction());
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            this.buttonPanel.add(jButton3);
        }
        return this.buttonPanel;
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectLogicalTypeDialog.SelectLogicalType"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "LOGICAL_DATATYPE_DIALOG";
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectLogicalTypeDialog.this.ifSize.setText(SelectLogicalTypeDialog.EMPTY_STRING);
            SelectLogicalTypeDialog.this.ifPrecision.setText(SelectLogicalTypeDialog.EMPTY_STRING);
            SelectLogicalTypeDialog.this.ifScale.setText(SelectLogicalTypeDialog.EMPTY_STRING);
            LogicalDatatype logicalDatatype = (LogicalDatatype)SelectLogicalTypeDialog.this.cbLogicalType.getSelectedItem();
            if (logicalDatatype != null) {
                Map map = logicalDatatype.getLTDefaultValues();
                String string = (String)map.get("precision_default_value");
                SelectLogicalTypeDialog.this.precisionDefaultValue = string != SelectLogicalTypeDialog.EMPTY_STRING && string != null ? new Integer((String)map.get("precision_default_value")) : 0;
                String string2 = (String)map.get("size_default_value");
                String string3 = (String)map.get("scale_default_value");
                SelectLogicalTypeDialog.this.scaleDefaultValue = string3 != SelectLogicalTypeDialog.EMPTY_STRING && string3 != null ? new Integer((String)map.get("scale_default_value")) : 0;
                Map map2 = logicalDatatype.getToPhysical();
                MDDataType mDDataType = logicalDatatype.createDataType(SelectLogicalTypeDialog.this.selectedRdbmsSite, map2);
                if (mDDataType instanceof MDImplicitSized) {
                    SelectLogicalTypeDialog.this.ifSize.setEnabled(false);
                    SelectLogicalTypeDialog.this.ifPrecision.setEnabled(false);
                    SelectLogicalTypeDialog.this.ifScale.setEnabled(false);
                } else if (mDDataType instanceof MDPackedSized) {
                    SelectLogicalTypeDialog.this.ifSize.setText(SelectLogicalTypeDialog.EMPTY_STRING);
                    SelectLogicalTypeDialog.this.ifSize.setEnabled(false);
                    try {
                        if (mDDataType.getPrecision() != 0) {
                            SelectLogicalTypeDialog.this.ifPrecision.setValue((long)mDDataType.getPrecision());
                        } else {
                            SelectLogicalTypeDialog.this.ifPrecision.setValue(SelectLogicalTypeDialog.this.precisionDefaultValue > 0 ? (long)SelectLogicalTypeDialog.this.precisionDefaultValue : 0L);
                        }
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(true);
                    }
                    catch (Exception exception) {
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(false);
                    }
                    try {
                        if (mDDataType.getScale() != 0) {
                            SelectLogicalTypeDialog.this.ifScale.setValue((long)mDDataType.getScale());
                        } else {
                            SelectLogicalTypeDialog.this.ifScale.setValue(SelectLogicalTypeDialog.this.scaleDefaultValue > 0 ? (long)SelectLogicalTypeDialog.this.scaleDefaultValue : 0L);
                        }
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(true);
                    }
                    catch (Exception exception) {
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(false);
                    }
                } else {
                    try {
                        if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                            SelectLogicalTypeDialog.this.ifSize.setText(mDDataType.getSize());
                        }
                        SelectLogicalTypeDialog.this.ifSize.setEnabled(true);
                    }
                    catch (Exception exception) {
                        SelectLogicalTypeDialog.this.ifSize.setEnabled(false);
                    }
                    try {
                        if (mDDataType.getPrecision() != 0) {
                            SelectLogicalTypeDialog.this.ifPrecision.setValue((long)mDDataType.getPrecision());
                        }
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(true);
                    }
                    catch (Exception exception) {
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(false);
                    }
                    try {
                        if (mDDataType.getScale() != 0) {
                            SelectLogicalTypeDialog.this.ifScale.setValue((long)mDDataType.getScale());
                        }
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(true);
                    }
                    catch (Exception exception) {
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(false);
                    }
                }
            }
        }
    }
}

