/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class CollectionTypePropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private CollectionType collectionType;
    private JButton bnDataType;
    private TypeElement typeElement;
    private SelectDataTypeDialog datatypeDialog = null;
    private String[] TYPES = new String[]{"ARRAY", "COLLECTION"};
    private JComboBox cbCollectionType;
    private JIntegerField ifMaxElement;

    public CollectionTypePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("CollectionTypePropertiesDialogEx.CollectionTypeProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof CollectionType) {
            this.collectionType = (CollectionType)designObject;
            this.initDefaults(false);
            this.cbCollectionType.setSelectedItem(this.collectionType.getType());
            try {
                this.ifMaxElement.setValue((long)this.collectionType.getMaxElement());
            }
            catch (NumberFormatException numberFormatException) {
                this.ifMaxElement.setValue(1L);
            }
            this.ifMaxElement.setEnabled(!this.isCollectionTypeSelected() && this.isEditable());
            this.typeElement = new TypeElement(this.collectionType.getDesignPart(), null);
            this.typeElement.setDesign(this.collectionType.getDesign());
            this.typeElement.setParent(this.collectionType);
            this.collectionType.getElementType().copyDataType(this.typeElement);
            this.bnDataType.setText(this.typeElement.getDataType());
            this.initUsedInAttributes(this.collectionType, (short)4);
            this.initUsedInColumns();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.collectionType.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.collectionType.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.collectionType.setName(this.tfName.getText());
        this.collectionType.setComment(this.taComments.getText());
        this.collectionType.setNotes(this.taNotes.getText());
        this.typeElement.copyDataType(this.collectionType.getElementType());
        this.collectionType.getElementType().setTypeID(this.typeElement.getTypeID());
        this.collectionType.setType((String)this.cbCollectionType.getSelectedItem());
        if (this.ifMaxElement.isEnabled()) {
            this.collectionType.setMaxElement(this.ifMaxElement.getIntValue());
        }
        this.setResponsibleParties();
        this.setDocuments();
        CollectionTypePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.collectionType.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.collectionType.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getUsedInPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "COLLECTIONTYPE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_COLLECTIONTYPE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbCollectionType = new JComboBox<String>(this.TYPES);
        this.cbCollectionType.setPreferredSize(this.getDefaultSize());
        this.cbCollectionType.setMaximumRowCount(8);
        this.cbCollectionType.setEnabled(this.isEditable());
        this.cbCollectionType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CollectionTypePropertiesDialogEx.this.ifMaxElement.setEnabled(!CollectionTypePropertiesDialogEx.this.isCollectionTypeSelected());
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.cbCollectionType));
        JLabel jLabel2 = new JLabel(LB_MAX_ELEMENTS);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.ifMaxElement = new JIntegerField();
        this.ifMaxElement.setPreferredSize(this.getDefaultSize());
        this.ifMaxElement.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.ifMaxElement));
        JLabel jLabel3 = new JLabel(LB_DATATYPE);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(this.getDefaultSize());
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CollectionTypePropertiesDialogEx.this.datatypeDialog = new SelectDataTypeDialog(CollectionTypePropertiesDialogEx.this.getAppView(), CollectionTypePropertiesDialogEx.this.typeElement, CollectionTypePropertiesDialogEx.this.bnDataType);
                CollectionTypePropertiesDialogEx.this.datatypeDialog.initProperties(false);
                CollectionTypePropertiesDialogEx.this.datatypeDialog.showDialog();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.bnDataType));
    }

    private boolean isCollectionTypeSelected() {
        if (this.cbCollectionType.getSelectedItem().equals(this.TYPES[1])) {
            this.ifMaxElement.setValue(1L);
            return true;
        }
        return false;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }
}

