/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddContactDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.ContactPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class ResponsiblePartyPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfResponsibility;
    private BIResponsibleParty party;
    private JComboBox cbParent;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;
    private JTable refTable = null;

    public ResponsiblePartyPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public ResponsiblePartyPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject, JTable jTable) {
        super(dialog, applicationView, designObject);
        this.refTable = jTable;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_RESPONSIBILITY);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfResponsibility = new JTextField();
        this.tfResponsibility.setPreferredSize(this.getDefaultSize());
        this.tfResponsibility.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfResponsibility));
        JLabel jLabel2 = new JLabel(LB_PARENT_DOCUMENT);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbParent = new JComboBox();
        this.cbParent.setFont(this.cbParent.getFont().deriveFont(0));
        this.cbParent.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbParent));
    }

    @Override
    public String getCaption() {
        return Messages.getString("ResponsiblePartyPropertiesDialogEx.ResponsiblePartyProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof BIResponsibleParty) {
            Object object;
            this.party = (BIResponsibleParty)designObject;
            this.tfName.setText(this.party.getName());
            this.tfResponsibility.setText(this.party.getResponsibility());
            ArrayList<BIResponsibleParty> arrayList = new ArrayList<BIResponsibleParty>();
            Iterator iterator = this.party.getDesign().getBusinessInfoDesign().getResPartySet().iterator();
            while (iterator.hasNext()) {
                object = (BIResponsibleParty)iterator.next();
                if (object == this.party || this.hasThisPartyAsAncestor((BIResponsibleParty)object)) continue;
                arrayList.add((BIResponsibleParty)object);
            }
            this.fillComboItems(arrayList.toArray(), this.cbParent, true);
            this.cbParent.setSelectedItem(this.party.getParentParty());
            this.cList.addAll(this.party.getContacts());
            this.taComments.setText(this.party.getComment());
            this.tfObjectID.setText(this.party.getObjectID());
            this.tfCreationTime.setText(this.party.getCreationTime());
            this.tfCreator.setText(this.party.getCreator().getName());
            this.tfDesign.setText(this.party.getOwnerDesignName());
            if (this.party.getGenerator() != null) {
                this.tfGeneratorName.setText(this.party.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.party.getChanger().getName());
            this.tfLastChangedTime.setText(this.party.getChangeTime());
            this.dynamicPropertiesList.clear();
            object = this.party.getPropertyNames();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = this.party.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private boolean hasThisPartyAsAncestor(BIResponsibleParty bIResponsibleParty) {
        BIResponsibleParty bIResponsibleParty2 = bIResponsibleParty.getParentParty();
        if (bIResponsibleParty2 == null) {
            return false;
        }
        if (bIResponsibleParty2 == this.party) {
            return true;
        }
        return this.hasThisPartyAsAncestor(bIResponsibleParty2);
    }

    @Override
    protected void setProperties() {
        this.party.setName(this.tfName.getText());
        this.party.setComment(this.taComments.getText());
        this.party.setResponsibility(this.tfResponsibility.getText());
        this.party.setParentParty((BIResponsibleParty)this.cbParent.getSelectedItem());
        this.party.clearContacts();
        for (Object object : this.cList) {
            this.party.addContact((BIContact)object);
        }
        if (this.refTable != null) {
            this.refTable.updateUI();
        }
        ResponsiblePartyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.party.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.party.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getContactsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "RESPONSIBLE_PARTY_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            JComponent jComponent;
            this.pnContacts = this.createPage(Messages.getString("ResponsiblePartyPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ResponsiblePartyPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && ResponsiblePartyPropertiesDialogEx.this.cList.size() > 0 && n < ResponsiblePartyPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)ResponsiblePartyPropertiesDialogEx.this.cList.get(n);
                        designObject.showModal = ((ResponsiblePartyPropertiesDialogEx)ResponsiblePartyPropertiesDialogEx.this).party.showModal || ResponsiblePartyPropertiesDialogEx.this.party.showForFirstTime();
                        ContactPropertiesDialogEx contactPropertiesDialogEx = new ContactPropertiesDialogEx((Dialog)ResponsiblePartyPropertiesDialogEx.this, ResponsiblePartyPropertiesDialogEx.this.getAppView(), designObject);
                        contactPropertiesDialogEx.initProperties(designObject);
                        contactPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.cTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ResponsiblePartyPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ResponsiblePartyPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (n != -1 && ResponsiblePartyPropertiesDialogEx.this.cList.size() > 0 && n < ResponsiblePartyPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)ResponsiblePartyPropertiesDialogEx.this.cList.get(n);
                        designObject.showModal = ((ResponsiblePartyPropertiesDialogEx)ResponsiblePartyPropertiesDialogEx.this).party.showModal || ResponsiblePartyPropertiesDialogEx.this.party.showForFirstTime();
                        ContactPropertiesDialogEx contactPropertiesDialogEx = new ContactPropertiesDialogEx((Dialog)ResponsiblePartyPropertiesDialogEx.this, ResponsiblePartyPropertiesDialogEx.this.getAppView(), designObject);
                        contactPropertiesDialogEx.initProperties(designObject);
                        contactPropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(Messages.getString("ResponsiblePartyPropertiesDialogEx.Add"));
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddContactDialog addContactDialog = new AddContactDialog(ResponsiblePartyPropertiesDialogEx.this.getAppView(), ResponsiblePartyPropertiesDialogEx.this.party.getDesign(), ResponsiblePartyPropertiesDialogEx.this.cList);
                        addContactDialog.show();
                        ResponsiblePartyPropertiesDialogEx.this.cTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(Messages.getString("ResponsiblePartyPropertiesDialogEx.Remove"));
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ResponsiblePartyPropertiesDialogEx.this.cTable.getSelectedRow();
                        if (n != -1 && ResponsiblePartyPropertiesDialogEx.this.cList.size() > 0 && n < ResponsiblePartyPropertiesDialogEx.this.cList.size()) {
                            ResponsiblePartyPropertiesDialogEx.this.cList.remove(n);
                            ResponsiblePartyPropertiesDialogEx.this.cTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnContacts.add(jComponent);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ResponsiblePartyPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ResponsiblePartyPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ResponsiblePartyPropertiesDialogEx.this.cList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }
}

