/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class EmailPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfEmailAddress;
    private JTextField tfEmailType;
    private BIEmail email;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;

    public EmailPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public EmailPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_EMAIL_ADDRESS);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfEmailAddress = new JTextField();
        this.tfEmailAddress.setPreferredSize(this.getDefaultSize());
        this.tfEmailAddress.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfEmailAddress));
        JLabel jLabel2 = new JLabel(LB_EMAIL_TYPE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfEmailType = new JTextField();
        this.tfEmailType.setPreferredSize(this.getDefaultSize());
        this.tfEmailType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfEmailType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("EmailPropertiesDialogEx.EmailProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof BIEmail) {
            this.email = (BIEmail)designObject;
            this.tfName.setText(this.email.getName());
            this.tfEmailAddress.setText(this.email.getEmailAddress());
            this.tfEmailType.setText(this.email.getType());
            this.cList.addAll(this.email.getContacts());
            this.taComments.setText(this.email.getComment());
            this.tfObjectID.setText(this.email.getObjectID());
            this.tfCreationTime.setText(this.email.getCreationTime());
            this.tfCreator.setText(this.email.getCreator().getName());
            this.tfDesign.setText(this.email.getOwnerDesignName());
            if (this.email.getGenerator() != null) {
                this.tfGeneratorName.setText(this.email.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.email.getChanger().getName());
            this.tfLastChangedTime.setText(this.email.getChangeTime());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.email.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.email.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.email.setName(this.tfName.getText());
        this.email.setComment(this.taComments.getText());
        this.email.setEmailAddress(this.tfEmailAddress.getText());
        this.email.setType(this.tfEmailType.getText());
        EmailPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.email.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.email.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getContactsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "EMAIL_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("EmailPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = EmailPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && EmailPropertiesDialogEx.this.cList.size() > 0 && n < EmailPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)EmailPropertiesDialogEx.this.cList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.cTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("EmailPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = EmailPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (n != -1 && EmailPropertiesDialogEx.this.cList.size() > 0 && n < EmailPropertiesDialogEx.this.cList.size()) {
                        DesignObject designObject = (DesignObject)EmailPropertiesDialogEx.this.cList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnContacts.add(jPanel2);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return EmailPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("EmailPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)EmailPropertiesDialogEx.this.cList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }
}

