/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddEmailDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddLocationDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPhoneDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddUrlDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.EmailPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.LocationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;
import oracle.dbtools.crest.swingui.editor.businessinfo.PhonePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.UrlPropertiesDialogEx;

public class ContactPropertiesDialogEx
extends AbstractPropertiesDialog {
    private BIContact contact;
    private JTable eTable;
    private List eList;
    private JTable lTable;
    private List lList;
    private JTable pTable;
    private List pList;
    private JTable tTable;
    private List tList;
    private JTable uTable;
    private List uList;
    private JPanel pnEmails;
    private JPanel pnLocations;
    private JPanel pnParties;
    private JPanel pnPhones;
    private JPanel pnUrls;

    public ContactPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    public ContactPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
    }

    @Override
    public String getCaption() {
        return Messages.getString("ContactPropertiesDialogEx.ContactProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof BIContact) {
            this.contact = (BIContact)designObject;
            this.tfName.setText(this.contact.getName());
            this.lList.addAll(this.contact.getLocations());
            this.eList.addAll(this.contact.getEmails());
            this.pList.addAll(this.contact.getParties());
            this.tList.addAll(this.contact.getPhones());
            this.uList.addAll(this.contact.getUrls());
            this.taComments.setText(this.contact.getComment());
            this.tfObjectID.setText(this.contact.getObjectID());
            this.tfCreationTime.setText(this.contact.getCreationTime());
            this.tfCreator.setText(this.contact.getCreator().getName());
            this.tfDesign.setText(this.contact.getOwnerDesignName());
            if (this.contact.getGenerator() != null) {
                this.tfGeneratorName.setText(this.contact.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.contact.getChanger().getName());
            this.tfLastChangedTime.setText(this.contact.getChangeTime());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.contact.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.contact.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.contact.setName(this.tfName.getText());
        this.contact.setComment(this.taComments.getText());
        this.contact.clearEmails();
        for (Object object : this.eList) {
            this.contact.addEmail((BIEmail)object);
        }
        this.contact.clearLocations();
        for (Object object : this.lList) {
            this.contact.addLocation((BILocation)object);
        }
        this.contact.clearPhones();
        for (Object object : this.tList) {
            this.contact.addPhone((BIPhone)object);
        }
        this.contact.clearUrls();
        for (Object object : this.uList) {
            this.contact.addUrl((BIResourceLocator)object);
        }
        ContactPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.contact.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.contact.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getEmailsPanel());
        this.addToTree(defaultMutableTreeNode, this.getLocationsPanel());
        this.addToTree(defaultMutableTreeNode, this.getPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getPhonesPanel());
        this.addToTree(defaultMutableTreeNode, this.getUrlsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "CONTACT_PROPERTIES_DIALOG";
    }

    private JPanel getEmailsPanel() {
        if (this.pnEmails == null) {
            JComponent jComponent;
            this.pnEmails = this.createPage(Messages.getString("ContactPropertiesDialogEx.Emails"));
            this.eList = new ArrayList();
            this.eTable = new JTable(new EmailTableModel());
            this.eTable.setSelectionMode(0);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ContactPropertiesDialogEx.this.eTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.eList.size() > 0 && n < ContactPropertiesDialogEx.this.eList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.eList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        EmailPropertiesDialogEx emailPropertiesDialogEx = new EmailPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        emailPropertiesDialogEx.initProperties(designObject);
                        emailPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.eTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ContactPropertiesDialogEx.this.eTable.getSelectedRow();
                    if (n != -1 && ContactPropertiesDialogEx.this.eList.size() > 0 && n < ContactPropertiesDialogEx.this.eList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.eList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        EmailPropertiesDialogEx emailPropertiesDialogEx = new EmailPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        emailPropertiesDialogEx.initProperties(designObject);
                        emailPropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddEmailDialog addEmailDialog = new AddEmailDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.eList);
                        addEmailDialog.show();
                        ContactPropertiesDialogEx.this.eTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ContactPropertiesDialogEx.this.eTable.getSelectedRow();
                        if (n != -1 && ContactPropertiesDialogEx.this.eList.size() > 0 && n < ContactPropertiesDialogEx.this.eList.size()) {
                            ContactPropertiesDialogEx.this.eList.remove(n);
                            ContactPropertiesDialogEx.this.eTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnEmails.add(jComponent);
        }
        return this.pnEmails;
    }

    private JPanel getLocationsPanel() {
        if (this.pnLocations == null) {
            JComponent jComponent;
            this.pnLocations = this.createPage(Messages.getString("ContactPropertiesDialogEx.Locations"));
            this.lList = new ArrayList();
            this.lTable = new JTable(new LocationTableModel());
            this.lTable.setSelectionMode(0);
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ContactPropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.lList.size() > 0 && n < ContactPropertiesDialogEx.this.lList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.lList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        LocationPropertiesDialogEx locationPropertiesDialogEx = new LocationPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        locationPropertiesDialogEx.initProperties(designObject);
                        locationPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.lTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ContactPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (n != -1 && ContactPropertiesDialogEx.this.lList.size() > 0 && n < ContactPropertiesDialogEx.this.lList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.lList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        LocationPropertiesDialogEx locationPropertiesDialogEx = new LocationPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        locationPropertiesDialogEx.initProperties(designObject);
                        locationPropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Add"));
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddLocationDialog addLocationDialog = new AddLocationDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.lList);
                        addLocationDialog.show();
                        ContactPropertiesDialogEx.this.lTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Remove"));
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ContactPropertiesDialogEx.this.lTable.getSelectedRow();
                        if (n != -1 && ContactPropertiesDialogEx.this.lList.size() > 0 && n < ContactPropertiesDialogEx.this.lList.size()) {
                            ContactPropertiesDialogEx.this.lList.remove(n);
                            ContactPropertiesDialogEx.this.lTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnLocations.add(jComponent);
        }
        return this.pnLocations;
    }

    private JPanel getPartiesPanel() {
        if (this.pnParties == null) {
            this.pnParties = this.createPage(Messages.getString("ContactPropertiesDialogEx.ResponsibleParties"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new PartyTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ContactPropertiesDialogEx.this.pTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.pList.size() > 0 && n < ContactPropertiesDialogEx.this.pList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.pList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.pTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ContactPropertiesDialogEx.this.pTable.getSelectedRow();
                    if (n != -1 && ContactPropertiesDialogEx.this.pList.size() > 0 && n < ContactPropertiesDialogEx.this.pList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.pList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnParties.add(jPanel2);
        }
        return this.pnParties;
    }

    private JPanel getPhonesPanel() {
        if (this.pnPhones == null) {
            JComponent jComponent;
            this.pnPhones = this.createPage(Messages.getString("ContactPropertiesDialogEx.Telephones"));
            this.tList = new ArrayList();
            this.tTable = new JTable(new PhoneTableModel());
            this.tTable.setSelectionMode(0);
            this.tTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ContactPropertiesDialogEx.this.tTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.tList.size() > 0 && n < ContactPropertiesDialogEx.this.tList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.tList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        PhonePropertiesDialogEx phonePropertiesDialogEx = new PhonePropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        phonePropertiesDialogEx.initProperties(designObject);
                        phonePropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.tTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ContactPropertiesDialogEx.this.tTable.getSelectedRow();
                    if (n != -1 && ContactPropertiesDialogEx.this.tList.size() > 0 && n < ContactPropertiesDialogEx.this.tList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.tList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        PhonePropertiesDialogEx phonePropertiesDialogEx = new PhonePropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        phonePropertiesDialogEx.initProperties(designObject);
                        phonePropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Add"));
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddPhoneDialog addPhoneDialog = new AddPhoneDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.tList);
                        addPhoneDialog.show();
                        ContactPropertiesDialogEx.this.tTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Remove"));
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ContactPropertiesDialogEx.this.tTable.getSelectedRow();
                        if (n != -1 && ContactPropertiesDialogEx.this.tList.size() > 0 && n < ContactPropertiesDialogEx.this.tList.size()) {
                            ContactPropertiesDialogEx.this.tList.remove(n);
                            ContactPropertiesDialogEx.this.tTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnPhones.add(jComponent);
        }
        return this.pnPhones;
    }

    private JPanel getUrlsPanel() {
        if (this.pnUrls == null) {
            JComponent jComponent;
            this.pnUrls = this.createPage(Messages.getString("ContactPropertiesDialogEx.Urls"));
            this.uList = new ArrayList();
            this.uTable = new JTable(new UrlTableModel());
            this.uTable.setSelectionMode(0);
            this.uTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ContactPropertiesDialogEx.this.uTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.uList.size() > 0 && n < ContactPropertiesDialogEx.this.uList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.uList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        UrlPropertiesDialogEx urlPropertiesDialogEx = new UrlPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        urlPropertiesDialogEx.initProperties(designObject);
                        urlPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.uTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ContactPropertiesDialogEx.this.uTable.getSelectedRow();
                    if (n != -1 && ContactPropertiesDialogEx.this.uList.size() > 0 && n < ContactPropertiesDialogEx.this.uList.size()) {
                        DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.uList.get(n);
                        designObject.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        UrlPropertiesDialogEx urlPropertiesDialogEx = new UrlPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), designObject);
                        urlPropertiesDialogEx.initProperties(designObject);
                        urlPropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Add"));
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddUrlDialog addUrlDialog = new AddUrlDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.uList);
                        addUrlDialog.show();
                        ContactPropertiesDialogEx.this.uTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Remove"));
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ContactPropertiesDialogEx.this.uTable.getSelectedRow();
                        if (n != -1 && ContactPropertiesDialogEx.this.uList.size() > 0 && n < ContactPropertiesDialogEx.this.uList.size()) {
                            ContactPropertiesDialogEx.this.uList.remove(n);
                            ContactPropertiesDialogEx.this.uTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 180));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnUrls.add(jComponent);
        }
        return this.pnUrls;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class UrlTableModel
    extends AbstractTableModel {
        private UrlTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.uList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Urls");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.uList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class PhoneTableModel
    extends AbstractTableModel {
        private PhoneTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.tList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Telephones");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.tList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class PartyTableModel
    extends AbstractTableModel {
        private PartyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ContactPropertiesDialogEx.ResponsibleParties");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.pList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class LocationTableModel
    extends AbstractTableModel {
        private LocationTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.lList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Locations");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.lList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class EmailTableModel
    extends AbstractTableModel {
        private EmailTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Emails");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ContactPropertiesDialogEx.this.eList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }
}

