/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public class TLConstraintEditor {
    private JTextField name = new JTextField();
    private JEditorPane rule = new JEditorPane();
    private JDialog dialog;
    private boolean result;
    private ApplicationView appView;
    private DesignPart designPart;
    private TableLevelConstraint newConstraint;
    private boolean readOnly = false;

    public TLConstraintEditor(ApplicationView applicationView, DesignPart designPart, boolean bl) {
        this.appView = applicationView;
        this.designPart = designPart;
        this.readOnly = bl;
    }

    public boolean showDialog() {
        JButton jButton;
        this.result = false;
        this.dialog = new JDialog((Frame)this.appView.getFrame(), Messages.getString("TLConstraintEditor.TableLevelConstraint"));
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("TLConstraintEditor.Name"));
        jPanel2.setBorder(titledBorder);
        this.name.setPreferredSize(new Dimension(405, 20));
        this.name.setEnabled(!this.readOnly);
        jPanel2.add(this.name);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        titledBorder = BorderFactory.createTitledBorder(Messages.getString("TLConstraintEditor.ValidationRule"));
        jPanel3.setBorder(titledBorder);
        this.rule.setPreferredSize(new Dimension(400, 150));
        this.rule.setEnabled(!this.readOnly);
        jPanel3.add(new JScrollPane(this.rule));
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        if (!this.readOnly) {
            jButton = new JButton(Messages.getString("TLConstraintEditor.OK"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TLConstraintEditor.this.result = TLConstraintEditor.this.check();
                    if (TLConstraintEditor.this.result) {
                        TLConstraintEditor.this.newConstraint = new TableLevelConstraint(TLConstraintEditor.this.designPart, TLConstraintEditor.this.getName(), TLConstraintEditor.this.getRule());
                        TLConstraintEditor.this.dialog.dispose();
                    }
                }
            });
            jPanel4.add(jButton);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        jButton = new JButton(!this.readOnly ? Messages.getString("TLConstraintEditor.Cancel") : Messages.getString("TLConstraintEditor.Close"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TLConstraintEditor.this.result = false;
                TLConstraintEditor.this.dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add((Component)jPanel4, "South");
        this.dialog.getContentPane().add(jPanel);
        this.dialog.pack();
        CommonUtil.centerOnScreen(this.dialog);
        this.dialog.setResizable(false);
        this.dialog.show();
        return this.result;
    }

    private boolean check() {
        if (!StringUtilities.isNotEmpty(this.name.getText())) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TLConstraintEditor.NameCcouldntBeEmpty"), Messages.getString("TLConstraintEditor.Warning"), 2);
            return false;
        }
        if (!StringUtilities.isNotEmpty(this.rule.getText())) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TLConstraintEditor.EnterValidationRule"), Messages.getString("TLConstraintEditor.Warning"), 2);
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name.getText();
    }

    public void setName(String string) {
        this.name.setText(string);
    }

    public String getRule() {
        return this.rule.getText();
    }

    public void setRule(String string) {
        this.rule.setText(string);
    }

    public void clear() {
        this.name.setText("");
        this.rule.setText("");
    }

    public TableLevelConstraint getNewConstraint() {
        return this.newConstraint;
    }

    public void setNewConstraint(TableLevelConstraint tableLevelConstraint) {
        this.newConstraint = tableLevelConstraint;
    }
}

