/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.StyledEditorKit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ddl.SyntaxDocument;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StringEditor
extends CustomDialog
implements AbstractEditorConstants {
    private JTextPane editorPane;
    private JPanel buttonPanel;
    private String oldText;
    private String newText;
    private String caption;
    public boolean cancel = true;
    private JDialog dialog;
    private boolean readOnly = false;
    private int width = 550;
    private int height = 450;
    private boolean syntaxHighlight = false;

    public StringEditor(ApplicationView applicationView, String string, String string2) {
        this(applicationView, string, string2, false);
    }

    public StringEditor(ApplicationView applicationView, String string, String string2, int n, int n2, boolean bl) {
        this(applicationView, string, string2, false, n, n2, bl);
    }

    public StringEditor(ApplicationView applicationView, String string, String string2, boolean bl) {
        this(applicationView, string, string2, bl, 550, 450, false);
    }

    public StringEditor(ApplicationView applicationView, String string, String string2, boolean bl, int n, int n2, boolean bl2) {
        super(applicationView);
        this.oldText = string;
        this.newText = string;
        this.readOnly = bl;
        this.caption = string2;
        this.width = n;
        this.height = n2;
        this.syntaxHighlight = bl2;
        this.editorPane = this.getEditorPane();
        this.initProperties();
        this.cancel = true;
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = this.getButtonPanel();
        this.add((Component)jPanel, "South");
    }

    public String getCaption() {
        return this.caption;
    }

    private void setProperties() {
        this.newText = this.editorPane.getText();
    }

    protected JTextPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JTextPane();
            if (this.syntaxHighlight) {
                this.editorPane.setEditorKit(new StyledEditorKit());
                this.editorPane.setDocument(new SyntaxDocument());
            }
            this.editorPane.setPreferredSize(new Dimension(this.width, this.height));
            this.editorPane.setEnabled(!this.readOnly);
        }
        return this.editorPane;
    }

    public void initProperties() {
        this.editorPane.setText(this.oldText);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton jButton;
            this.buttonPanel = new JPanel();
            if (!this.readOnly) {
                jButton = new JButton(Messages.getString("StringEditor.OK"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringEditor.this.setProperties();
                        StringEditor.this.cancel = false;
                        StringEditor.this.close();
                    }
                });
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(jButton);
            }
            jButton = new JButton(!this.readOnly ? Messages.getString("StringEditor.Cancel") : Messages.getString("StringEditor.Close"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringEditor.this.close();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
        }
        return this.buttonPanel;
    }

    public String getText() {
        return this.newText;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    StringEditor.this.editorPane.selectAll();
                }
            });
            this.setDefaultActions(this.dialog, false);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    public void setModal(boolean bl) {
        ((JDialog)this.getDialog()).setModal(bl);
    }
}

