/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectUsedInDialog
extends CustomDialog {
    private static final long serialVersionUID = 5298361036380201769L;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonHelp;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JPanel generalPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel containerPanel;
    private JDialog dialog;
    private JComboBox cbDesign;
    private List containersList = new ArrayList();
    private List availableItems = new ArrayList();
    private List selectedItems = new ArrayList();
    private Object selectedContainer;
    private JTable containersTable;
    private JTable availableItemsTable;
    private JTable selectedItemsTable;
    private List<DesignPart> designs;
    private Domain domain;
    private int selectModel;

    public SelectUsedInDialog(ApplicationView applicationView, Domain domain, int n) {
        super(applicationView);
        this.domain = domain;
        this.selectModel = n;
        this.initDesigns(applicationView);
        this.initGeneralPanel();
    }

    private void initGeneralPanel() {
        this.generalPanel = new JPanel(new BorderLayout());
        this.initLeftPanel();
        this.initRightPanel();
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.buttonOK = new JButton(this.createButtonOK());
        this.buttonOK.setMnemonic(79);
        this.buttonCancel = new JButton(this.createCancelButton());
        this.buttonCancel.setMnemonic(67);
        this.buttonHelp = new JButton(this.getHelpAction());
        this.buttonHelp.setMnemonic(72);
        jPanel.add(this.buttonOK);
        jPanel.add(this.buttonCancel);
        jPanel.add(this.buttonHelp);
        this.buttonOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.generalPanel.add((Component)this.leftPanel, "West");
        this.generalPanel.add((Component)this.rightPanel, "Center");
        this.generalPanel.add((Component)jPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.setPreferredSize(new Dimension(700, 500));
        this.cbDesign.setSelectedIndex(this.selectModel);
        if (!this.containersList.isEmpty()) {
            this.containersTable.changeSelection(0, 0, false, false);
            this.containersTable.updateUI();
        }
    }

    private void initDesigns(ApplicationView applicationView) {
        this.designs = new ArrayList<DesignPart>();
        LogicalDesign logicalDesign = this.domain.getDesign().getLogicalDesign();
        this.designs.add(logicalDesign);
        this.initLogicalDesign(logicalDesign);
        this.designs.addAll(this.domain.getDesign().getRelationalDesigns().getElementsList());
        this.designs.add(this.domain.getDesign().getDataTypesDesign());
    }

    private void initLeftPanel() {
        this.leftPanel = new JPanel(new BorderLayout());
        this.containerPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.TablesEntities")));
        this.containersTable = new JTable(new ContainersModel());
        this.containersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectUsedInDialog.this.initAvailableItems();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)new JLabel(Messages.getString("SelectUsedInDialog.Model")), "West");
        this.cbDesign = new JComboBox<Object>(this.designs.toArray());
        this.cbDesign.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelectUsedInDialog.this.containersList.clear();
                SelectUsedInDialog.this.availableItems.clear();
                Object object = itemEvent.getItem();
                if (object instanceof LogicalDesign) {
                    SelectUsedInDialog.this.initLogicalDesign((LogicalDesign)object);
                } else if (object instanceof RelationalDesign) {
                    SelectUsedInDialog.this.initRelationalDesign((RelationalDesign)object);
                } else if (object instanceof DataTypesDesign) {
                    SelectUsedInDialog.this.initDataTypesDesign((DataTypesDesign)object);
                }
                SelectUsedInDialog.this.containersTable.clearSelection();
                SelectUsedInDialog.this.containersTable.updateUI();
                SelectUsedInDialog.this.availableItemsTable.updateUI();
            }
        });
        jPanel2.add(this.cbDesign);
        jPanel.add((Component)jPanel2, "North");
        JScrollPane jScrollPane = new JScrollPane(this.containersTable);
        jScrollPane.setPreferredSize(new Dimension(220, 500));
        jPanel.add(jScrollPane);
        this.containerPanel.add((Component)jPanel, "Center");
        this.leftPanel.add(this.containerPanel);
    }

    private void initAvailableItems() {
        int n = this.containersTable.getSelectedRow();
        this.availableItems.clear();
        if (n > -1) {
            this.selectedContainer = this.containersList.get(n);
            if (this.selectedContainer instanceof Table) {
                for (Column column : (Column[])((ContainerWithKeyObject)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(column)) continue;
                    this.availableItems.add(column);
                }
            } else if (this.selectedContainer instanceof Entity) {
                for (Attribute attribute : (Attribute[])((ContainerWithKeyObject)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(attribute)) continue;
                    this.availableItems.add(attribute);
                }
            } else if (this.selectedContainer instanceof StructuredType) {
                for (TypeElement typeElement : ((StructuredType)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(typeElement)) continue;
                    this.availableItems.add(typeElement);
                }
            }
        } else {
            this.selectedContainer = null;
        }
        this.selectedItemsTable.updateUI();
        this.availableItemsTable.updateUI();
    }

    private void initRightPanel() {
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)this.createAvailableItemsPanel(), "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createAddRemoveButtonsPanel(), "North");
        jPanel.add((Component)this.createSelectedItemsPanel(), "Center");
        this.rightPanel.add((Component)jPanel, "Center");
    }

    private JPanel createAvailableItemsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.availableItemsTable = new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return Messages.getString("SelectUsedInDialog.Name");
                }
                if (n == 1) {
                    return Messages.getString("SelectUsedInDialog.Type");
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public int getRowCount() {
                return SelectUsedInDialog.this.availableItems.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                Object e = SelectUsedInDialog.this.availableItems.get(n);
                if (SelectUsedInDialog.this.availableItems != null) {
                    if (n2 == 0) {
                        if (e instanceof TypeElement) {
                            return ((TypeElement)e).getName();
                        }
                        return ((ContainedObjectWithDomain)e).getName();
                    }
                    if (n2 == 1) {
                        if (e instanceof TypeElement) {
                            return ((TypeElement)e).getDataType();
                        }
                        return ((ContainedObjectWithDomain)e).getGenericDatatypeString();
                    }
                    if (e instanceof TypeElement) {
                        if (((TypeElement)e).getDomain() != null) {
                            return "D";
                        }
                        return "L";
                    }
                    short s = ((ContainedObjectWithDomain)e).getUse();
                    if (s == 0) {
                        return "D";
                    }
                    if (s == 1) {
                        return "L";
                    }
                    if (s == 2) {
                        return "Ds";
                    }
                    if (s == 3) {
                        return "S";
                    }
                    if (s == 4) {
                        return "C";
                    }
                    return null;
                }
                return null;
            }
        });
        this.availableItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SelectUsedInDialog.this.availableItemsTable.getSelectedRow() == -1) {
                    SelectUsedInDialog.this.buttonAdd.setEnabled(false);
                } else {
                    SelectUsedInDialog.this.buttonAdd.setEnabled(true);
                }
            }
        });
        TableColumn tableColumn = this.availableItemsTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setMinWidth(20);
        JScrollPane jScrollPane = new JScrollPane(this.availableItemsTable);
        jScrollPane.setPreferredSize(new Dimension(280, 180));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.ColumnsAttributes")));
        return jPanel;
    }

    private JPanel createSelectedItemsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selectedItemsTable = new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return Messages.getString("SelectUsedInDialog.Model");
                }
                if (n == 1) {
                    return Messages.getString("SelectUsedInDialog.TableEntity");
                }
                if (n == 2) {
                    return Messages.getString("SelectUsedInDialog.Name");
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public int getRowCount() {
                return SelectUsedInDialog.this.selectedItems.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (SelectUsedInDialog.this.selectedItems != null) {
                    Object e = SelectUsedInDialog.this.selectedItems.get(n);
                    if (n2 == 0) {
                        if (e instanceof TypeElement) {
                            return ((TypeElement)e).getDesignPart().getName();
                        }
                        return ((ContainedObjectWithDomain)e).getDesignPart().getName();
                    }
                    if (n2 == 1) {
                        if (e instanceof TypeElement) {
                            return ((TypeElement)e).getStructuredType().getName();
                        }
                        return ((ContainedObjectWithDomain)e).getContainer();
                    }
                    if (n2 == 2) {
                        if (e instanceof TypeElement) {
                            return ((TypeElement)e).getDesignPart().getName();
                        }
                        return ((ContainedObjectWithDomain)e).getDesignPart().getName();
                    }
                    return null;
                }
                return null;
            }
        });
        this.selectedItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SelectUsedInDialog.this.selectedItemsTable.getSelectedRow() == -1) {
                    SelectUsedInDialog.this.buttonRemove.setEnabled(false);
                } else {
                    SelectUsedInDialog.this.buttonRemove.setEnabled(true);
                }
            }
        });
        TableColumn tableColumn = this.selectedItemsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        JScrollPane jScrollPane = new JScrollPane(this.selectedItemsTable);
        jScrollPane.setPreferredSize(new Dimension(280, 180));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.SelectedItems")));
        return jPanel;
    }

    private void initLogicalDesign(LogicalDesign logicalDesign) {
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            this.containersList.add(iterator.next());
        }
    }

    private void initRelationalDesign(RelationalDesign relationalDesign) {
        Iterator iterator = relationalDesign.getTableSet().iterator();
        while (iterator.hasNext()) {
            this.containersList.add(iterator.next());
        }
    }

    private void initDataTypesDesign(DataTypesDesign dataTypesDesign) {
        Iterator iterator = dataTypesDesign.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            this.containersList.add(iterator.next());
        }
    }

    private JPanel createAddRemoveButtonsPanel() {
        JPanel jPanel = new JPanel();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonAdd = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        this.buttonAdd.addActionListener(new AddItemActionListener());
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setToolTipText(Messages.getString("SelectUsedInDialog.Add"));
        this.buttonRemove = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonRemove.setToolTipText(Messages.getString("SelectUsedInDialog.Remove"));
        this.buttonAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRemove.setPreferredSize(this.buttonAdd.getPreferredSize());
        jPanel.add((Component)this.buttonAdd, "West");
        jPanel.add((Component)this.buttonRemove, "Center");
        return jPanel;
    }

    @Override
    protected String getHelpIndex() {
        return "CLASSIFICATION_TYPES_DIALOG";
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("SelectUsedInDialog.AddDomainColumnsAttributes"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.buttonOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action createCancelButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("SelectUsedInDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectUsedInDialog.this.close();
            }
        };
        return abstractAction;
    }

    public Action createButtonOK() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("SelectUsedInDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectUsedInDialog.this.setDomain();
                SelectUsedInDialog.this.close();
            }
        };
        return abstractAction;
    }

    public void setDomain() {
        for (Object e : this.selectedItems) {
            if (e instanceof ContainedObjectWithDomain) {
                ((ContainedObjectWithDomain)e).setUse((short)0);
                ((ContainedObjectWithDomain)e).setDomain(this.domain);
                continue;
            }
            if (!(e instanceof TypeElement)) continue;
            ((TypeElement)e).setType(this.domain);
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = SelectUsedInDialog.this.selectedItemsTable.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)SelectUsedInDialog.this.selectedItems.remove(nArray[i]);
                if (!containedObjectWithDomain.getContainer().equals(SelectUsedInDialog.this.selectedContainer)) continue;
                SelectUsedInDialog.this.availableItems.add(containedObjectWithDomain);
            }
            SelectUsedInDialog.this.selectedItemsTable.clearSelection();
            SelectUsedInDialog.this.selectedItemsTable.updateUI();
            SelectUsedInDialog.this.availableItemsTable.updateUI();
        }
    }

    private class AddItemActionListener
    implements ActionListener {
        private AddItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = SelectUsedInDialog.this.availableItemsTable.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                SelectUsedInDialog.this.selectedItems.add(SelectUsedInDialog.this.availableItems.remove(nArray[i]));
            }
            Collections.sort(SelectUsedInDialog.this.selectedItems, new Comparator(){

                public int compare(Object object, Object object2) {
                    DesignObject designObject;
                    String string = "";
                    String string2 = "";
                    if (object instanceof ContainedObjectWithDomain) {
                        designObject = (ContainedObjectWithDomain)object;
                        string = designObject.getDesignPart().getName() + ((ContainedObject)designObject).getContainer().getName() + ((ContainedObject)designObject).getName();
                    } else if (object instanceof TypeElement) {
                        designObject = (TypeElement)object;
                        string = designObject.getDesignPart().getName() + ((TypeElement)designObject).getStructuredType().getName() + designObject.getName();
                    }
                    if (object2 instanceof ContainedObjectWithDomain) {
                        designObject = (ContainedObjectWithDomain)object2;
                        string2 = designObject.getDesignPart().getName() + ((ContainedObject)designObject).getContainer().getName() + ((ContainedObject)designObject).getName();
                    } else if (object2 instanceof TypeElement) {
                        designObject = (TypeElement)object2;
                        string2 = designObject.getDesignPart().getName() + ((TypeElement)designObject).getStructuredType().getName() + designObject.getName();
                    }
                    return string.compareTo(string2);
                }
            });
            SelectUsedInDialog.this.availableItemsTable.clearSelection();
            SelectUsedInDialog.this.availableItemsTable.updateUI();
            SelectUsedInDialog.this.selectedItemsTable.updateUI();
        }
    }

    public class ContainersModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SelectUsedInDialog.this.containersList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SelectUsedInDialog.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return SelectUsedInDialog.this.containersList.get(n);
        }
    }
}

