/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectTypeDialog
extends CustomDialog {
    private static final String dialogName = Messages.getString("SelectTypeDialog.SetClassificationTypes");
    private final List allTypes = new ArrayList();
    private final List allContainers = new ArrayList();
    private final JButton buttonOK;
    private final JButton buttonApply;
    private final JButton buttonCancel;
    private final JButton buttonHelp;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private final JPanel generalPanel = new JPanel(new BorderLayout());
    private final JPanel leftPanel;
    private final JPanel rightPanel;
    private JPanel containerItem;
    private JPanel selectedItem;
    private JDialog dialog;
    private List containerList;
    private JTable eTable;
    private JList selectedList;
    private JList typeList;
    private DefaultListModel selectedModel;
    private DefaultListModel typeModel;

    public SelectTypeDialog(ApplicationView applicationView, Object[] objectArray, String string) {
        super(applicationView);
        this.allTypes.addAll(this.getDesign().getDLSettings().getClassificationTypeList());
        for (int i = 0; i < objectArray.length; ++i) {
            ContainerWithKeyObject containerWithKeyObject = (ContainerWithKeyObject)objectArray[i];
            this.allContainers.add(new ContainerType(containerWithKeyObject));
        }
        this.leftPanel = new JPanel(new BorderLayout());
        this.initContainerList(this.leftPanel, string);
        this.rightPanel = new JPanel(new BorderLayout());
        this.initTypeList(this.rightPanel);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.buttonOK = new JButton(this.createButtonOK());
        this.buttonOK.setMnemonic(79);
        this.buttonApply = new JButton(this.createButtonApply());
        this.buttonApply.setMnemonic(65);
        this.buttonCancel = new JButton(this.createCancelButton());
        this.buttonCancel.setMnemonic(67);
        this.buttonHelp = new JButton(this.getHelpAction());
        this.buttonHelp.setMnemonic(72);
        jPanel.add(this.buttonOK);
        jPanel.add(this.buttonApply);
        jPanel.add(this.buttonCancel);
        jPanel.add(this.buttonHelp);
        this.buttonOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.generalPanel.add((Component)this.leftPanel, "West");
        this.generalPanel.add((Component)this.rightPanel, "Center");
        this.generalPanel.add((Component)jPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.fillTypeList();
        this.generalPanel.setPreferredSize(new Dimension(600, 500));
        this.typeList.setSelectedIndex(0);
    }

    public void fillTypeList() {
        Iterator iterator = this.allTypes.iterator();
        while (iterator.hasNext()) {
            this.typeModel.addElement(iterator.next());
        }
    }

    private void initContainerList(JPanel jPanel, String string) {
        this.containerItem = new JPanel(new BorderLayout());
        this.initElementList(string);
        this.initAddRemoveButtons();
        jPanel.add(this.containerItem);
    }

    private void initElementList(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        this.containerList = new ArrayList();
        this.eTable = new JTable(new ElementsModel());
        this.eTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SelectTypeDialog.this.typeList.getSelectedIndex() == -1) {
                    SelectTypeDialog.this.buttonAdd.setEnabled(false);
                } else {
                    SelectTypeDialog.this.buttonAdd.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.eTable);
        jScrollPane.setPreferredSize(new Dimension(250, 500));
        jPanel.add(jScrollPane);
        this.containerItem.add((Component)jPanel, "Center");
    }

    private void initTypeList(JPanel jPanel) {
        this.selectedItem = new JPanel(new BorderLayout());
        this.typeModel = new DefaultListModel();
        this.selectedModel = new DefaultListModel();
        this.initType();
        this.initSelected();
        jPanel.add(this.selectedItem);
    }

    private void initType() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.typeList = new JList(this.typeModel);
        ListSelectionModel listSelectionModel = this.typeList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new TypeListener());
        JScrollPane jScrollPane = new JScrollPane(this.typeList);
        jScrollPane.setPreferredSize(new Dimension(280, 180));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectTypeDialog.ClassificationTypes")));
        this.selectedItem.add((Component)jPanel, "North");
    }

    private void initSelected() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selectedList = new JList(this.selectedModel);
        ListSelectionModel listSelectionModel = this.selectedList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectListener());
        JScrollPane jScrollPane = new JScrollPane(this.selectedList);
        jScrollPane.setPreferredSize(new Dimension(280, 240));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectTypeDialog.SelectedElements")));
        this.selectedItem.add((Component)jPanel, "South");
    }

    private void initAddRemoveButtons() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonAdd.addActionListener(new AddObjectActionListener());
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setToolTipText(Messages.getString("SelectTypeDialog.Add"));
        this.buttonRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonRemove.setToolTipText(Messages.getString("SelectTypeDialog.Remove"));
        this.buttonAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRemove.setPreferredSize(this.buttonAdd.getPreferredSize());
        jPanel3.add((Component)this.buttonAdd, "North");
        jPanel3.add((Component)this.buttonRemove, "Center");
        jPanel2.add(jPanel3);
        jPanel.add(new JPanel());
        jPanel.add(new JPanel());
        jPanel.add(jPanel2);
        jPanel.add(new JPanel());
        this.containerItem.add((Component)jPanel, "East");
    }

    @Override
    protected String getHelpIndex() {
        return "CLASSIFICATION_TYPES_DIALOG";
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), dialogName, false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.buttonOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action createCancelButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("SelectTypeDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTypeDialog.this.close();
            }
        };
        return abstractAction;
    }

    public Action createButtonApply() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("SelectTypeDialog.Apply")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTypeDialog.this.setType();
            }
        };
        return abstractAction;
    }

    public Action createButtonOK() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("SelectTypeDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTypeDialog.this.setType();
                SelectTypeDialog.this.close();
            }
        };
        return abstractAction;
    }

    public void setType() {
        for (int i = 0; i < this.allContainers.size(); ++i) {
            ContainerType containerType = (ContainerType)this.allContainers.get(i);
            containerType.applyType();
        }
        try {
            if (this.getApplicationView().getCurrentDPV() != null) {
                this.getApplicationView().getCurrentDPV().getWorkSpace().updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getSelectedType() {
        return ((ClassificationType)this.typeList.getSelectedValue()).getTypeName();
    }

    private class ContainerType {
        private ContainerWithKeyObject containerObject;
        private String classTypeName = "";
        private ClassificationType classType = null;

        public ContainerType(ContainerWithKeyObject containerWithKeyObject) {
            this.containerObject = containerWithKeyObject;
            this.classTypeName = SelectTypeDialog.this.getDesign().getDLSettings().getClassificationTypeNameByID(this.containerObject.getTypeID());
        }

        public ContainerWithKeyObject getContainerObject() {
            return this.containerObject;
        }

        public String getClassTypeName() {
            return this.classTypeName;
        }

        public void setClassTypeName(String string) {
            this.classTypeName = string;
        }

        public String toString() {
            return this.containerObject.getName();
        }

        public void applyType() {
            this.classType = SelectTypeDialog.this.getDesign().getDLSettings().getClassificationTypeByName(this.classTypeName);
            if (this.classType != null) {
                this.containerObject.setTypeID(this.classType.getTypeID());
                this.containerObject.setDirty(true);
            }
        }
    }

    private class TypeListener
    implements ListSelectionListener {
        private TypeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SelectTypeDialog.this.typeList.getSelectedIndex() != -1) {
                SelectTypeDialog.this.selectedModel.clear();
                SelectTypeDialog.this.containerList.clear();
                for (ContainerType containerType : SelectTypeDialog.this.allContainers) {
                    if (containerType.getClassTypeName().equals(SelectTypeDialog.this.getSelectedType())) {
                        SelectTypeDialog.this.selectedModel.addElement(containerType);
                        continue;
                    }
                    SelectTypeDialog.this.containerList.add(containerType);
                }
            }
            SelectTypeDialog.this.eTable.updateUI();
            SelectTypeDialog.this.eTable.clearSelection();
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SelectTypeDialog.this.selectedList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ContainerType containerType = (ContainerType)objectArray[i];
                if (SelectTypeDialog.this.containerList.contains(containerType)) continue;
                SelectTypeDialog.this.containerList.add(containerType);
                SelectTypeDialog.this.selectedModel.removeElement(containerType);
                containerType.setClassTypeName("");
                containerType.getContainerObject().setTypeID("");
            }
            SelectTypeDialog.this.eTable.updateUI();
            SelectTypeDialog.this.eTable.clearSelection();
        }
    }

    private class AddObjectActionListener
    implements ActionListener {
        private AddObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = SelectTypeDialog.this.eTable.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ContainerType containerType = (ContainerType)SelectTypeDialog.this.containerList.get(nArray[i]);
                if (SelectTypeDialog.this.selectedModel.contains(containerType)) continue;
                SelectTypeDialog.this.selectedModel.addElement(containerType);
                SelectTypeDialog.this.containerList.remove(containerType);
                containerType.setClassTypeName(SelectTypeDialog.this.getSelectedType());
            }
            SelectTypeDialog.this.eTable.updateUI();
            SelectTypeDialog.this.eTable.clearSelection();
        }
    }

    private class SelectListener
    implements ListSelectionListener {
        private SelectListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                if (SelectTypeDialog.this.selectedList.getSelectedIndex() == -1) {
                    SelectTypeDialog.this.buttonRemove.setEnabled(false);
                } else {
                    SelectTypeDialog.this.buttonRemove.setEnabled(true);
                }
            }
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectTypeDialog.this.containerList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SelectTypeDialog.Name");
            }
            if (n == 1) {
                return Messages.getString("SelectTypeDialog.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ContainerType containerType = (ContainerType)SelectTypeDialog.this.containerList.get(n);
            if (n2 == 0) {
                return containerType.toString();
            }
            if (n2 == 1) {
                return containerType.getClassTypeName();
            }
            return new Integer(n * n2);
        }
    }
}

