/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectDesignsDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private Design result = null;
    private JButton bnOK;
    private ApplicationView appView;
    private JComboBox cbDesigns;
    private JLabel jlabel;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectDesignsDialog.this.dispose();
        }
    };

    public SelectDesignsDialog(ApplicationView applicationView) {
        super(applicationView.getFrame(), Messages.getString("SelectDesignsDialog.SelectDesign"), true);
        this.appView = applicationView;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setResizable(false);
        this.updateLabel();
        CommonUtil.centerOnScreen(this);
    }

    private JPanel init() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(280, 70));
        jPanel2.add((Component)this.initDesignList(), "North");
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel initDesignList() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(Messages.getString("SelectDesignsDialog.SelectDesign"));
        jPanel.add((Component)jLabel, "North");
        this.cbDesigns = new JComboBox<Object>(this.appView.getDesigns().toArray());
        jPanel.add((Component)this.cbDesigns, "Center");
        this.jlabel = new JLabel();
        jPanel.add((Component)this.jlabel, "South");
        this.cbDesigns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectDesignsDialog.this.updateLabel();
            }
        });
        return jPanel;
    }

    private void updateLabel() {
        Design design = (Design)this.cbDesigns.getSelectedItem();
        if (design != null) {
            this.jlabel.setText(FileUtils.longToShortPath(design.getStoragePath(), 50));
        } else {
            this.jlabel.setText("");
        }
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("AbstractEditorConstants.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectDesignsDialog.this.result = (Design)SelectDesignsDialog.this.cbDesigns.getSelectedItem();
                if (SelectDesignsDialog.this.result != null) {
                    SelectDesignsDialog.this.appView.setCurrentDesign(SelectDesignsDialog.this.result);
                }
                SelectDesignsDialog.this.dispose();
            }
        });
        this.bnOK.setEnabled(this.cbDesigns.getSelectedItem() != null);
        this.getRootPane().setDefaultButton(this.bnOK);
        jPanel.add(this.bnOK);
        JButton jButton = new JButton(Messages.getString("AbstractEditor.Cancel"));
        jButton.setMnemonic(67);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectDesignsDialog.this.result = null;
                SelectDesignsDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    public Design getResult() {
        return this.result;
    }

    public static Design showDialog(ApplicationView applicationView) {
        SelectDesignsDialog selectDesignsDialog = new SelectDesignsDialog(applicationView);
        selectDesignsDialog.setVisible(true);
        return selectDesignsDialog.getResult();
    }
}

