/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;

public class NamingOptionsHolderPanel
extends JPanel {
    private static final String[] defaultValidPatterns = new String[]{"[a-z]", "[A-Z]", "[a-z][A-Z]", "[a-z][A-Z][0-9]", "[a-z][A-Z][0-9] _$"};
    private JPositiveIntegerField ifNameLength;
    private JComboBox cbValidChars;
    private JRadioButton btUpperCase;
    private JRadioButton btLowerCase;
    private JRadioButton btMixedCase;
    private JCheckBox chAllValid;
    private NamingOptionsHolder namingOptionsHolder;
    private boolean isLogicalObject = false;

    public NamingOptionsHolderPanel(NamingOptionsHolder namingOptionsHolder, boolean bl) {
        this.namingOptionsHolder = namingOptionsHolder;
        this.setLayout(new BorderLayout());
        this.isLogicalObject = bl;
        Dimension dimension = new Dimension(250, 20);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Messages.getString("NamingOptionsHolderPanel.MaxNameLength"));
        jLabel.setPreferredSize(dimension);
        this.ifNameLength = new JPositiveIntegerField();
        this.ifNameLength.setEnabled(this.isEditable());
        this.ifNameLength.setPreferredSize(new Dimension(40, 20));
        jPanel2.add(jLabel);
        jPanel2.add(this.ifNameLength);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JLabel jLabel2 = new JLabel(Messages.getString("NamingOptionsHolderPanel.CharacterCase"));
        jLabel2.setPreferredSize(dimension);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 10, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btUpperCase = new JRadioButton(Messages.getString("NamingOptionsHolderPanel.UpperCase"));
        this.btUpperCase.setEnabled(this.isEditable());
        buttonGroup.add(this.btUpperCase);
        this.btLowerCase = new JRadioButton(Messages.getString("NamingOptionsHolderPanel.LowerCase"));
        this.btLowerCase.setEnabled(this.isEditable());
        buttonGroup.add(this.btLowerCase);
        this.btMixedCase = new JRadioButton(Messages.getString("NamingOptionsHolderPanel.MixedCase"));
        this.btMixedCase.setEnabled(this.isEditable());
        buttonGroup.add(this.btMixedCase);
        jPanel4.add(this.btUpperCase);
        jPanel4.add(this.btLowerCase);
        jPanel4.add(this.btMixedCase);
        jPanel3.add(jLabel2);
        jPanel3.add(jPanel4);
        jPanel.add(jPanel3);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JLabel jLabel3 = new JLabel(Messages.getString("NamingOptionsHolderPanel.ValidCharacters"));
        jLabel3.setPreferredSize(dimension);
        this.cbValidChars = new JComboBox<String>(defaultValidPatterns);
        this.cbValidChars.setEditable(true);
        this.cbValidChars.setEnabled(this.isEditable());
        this.cbValidChars.setPreferredSize(new Dimension(220, 20));
        this.chAllValid = new JCheckBox(Messages.getString("NamingOptionsHolderPanel.AllValid"));
        this.chAllValid.setEnabled(this.isEditable());
        this.chAllValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamingOptionsHolderPanel.this.setFieldEnabled(NamingOptionsHolderPanel.this.chAllValid.isSelected());
            }
        });
        jPanel5.add(jLabel3);
        jPanel5.add(this.cbValidChars);
        jPanel5.add(this.chAllValid);
        jPanel.add(jPanel5);
        this.add((Component)jPanel, "North");
        this.setFieldEnabled(this.getChAllValid());
    }

    public void init() {
        if (this.namingOptionsHolder.getMaxNameLength() <= 254) {
            this.setNameLength(this.namingOptionsHolder.getMaxNameLength());
        } else {
            this.setNameLength(254);
        }
        this.setSelectedButton(this.namingOptionsHolder.getCaseType());
        this.cbValidChars.setSelectedItem(this.namingOptionsHolder.getValidChars());
        this.chAllValid.setSelected(this.namingOptionsHolder.getIsValid());
        this.setFieldEnabled(this.chAllValid.isSelected());
    }

    public NamingOptionsHolder getNamingOptionsHolder() {
        return this.namingOptionsHolder;
    }

    public void setHolderValues() {
        if (this.namingOptionsHolder != null) {
            this.namingOptionsHolder.setMaxNameLength(this.getNameLength());
            this.namingOptionsHolder.setCaseType(this.getSelectedButton());
            this.namingOptionsHolder.setValidChars(this.getTfValidCharsValue());
            this.namingOptionsHolder.setIsValid(this.getChAllValid());
        }
    }

    public int getNameLength() {
        return this.ifNameLength.getIntValue();
    }

    public void setNameLength(int n) {
        this.ifNameLength.setValue((long)n);
    }

    public String getTfValidCharsValue() {
        return (String)this.cbValidChars.getSelectedItem();
    }

    public int getSelectedButton() {
        if (this.btUpperCase.isSelected()) {
            return 0;
        }
        if (this.btLowerCase.isSelected()) {
            return 1;
        }
        if (this.btMixedCase.isSelected()) {
            return 2;
        }
        return -1;
    }

    public void setSelectedButton(int n) {
        if (n == 0) {
            this.btUpperCase.setSelected(true);
        } else if (n == 1) {
            this.btLowerCase.setSelected(true);
        } else if (n == 2) {
            this.btMixedCase.setSelected(true);
        }
    }

    public boolean getChAllValid() {
        return this.chAllValid.isSelected();
    }

    public void setFieldEnabled(boolean bl) {
        if (bl) {
            this.cbValidChars.setSelectedItem(null);
            this.cbValidChars.setEnabled(false);
        } else {
            this.cbValidChars.setEnabled(this.isEditable());
        }
    }

    protected boolean isEditable() {
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.isLogicalObject;
        }
        return true;
    }
}

