/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddDocumentDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPartyDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public class ModelPropertiesDialogEx
extends JDialog
implements AbstractEditorConstants {
    protected static final int FIELD_WIDTH = 150;
    protected static final int FIELD_HEIGHT = 20;
    public static final String BTN_PROPERTIES = Messages.getString("ModelPropertiesDialogEx.Properties");
    protected ApplicationView appView;
    protected ModelIDObject model;
    protected JTextField tfName;
    protected JTextField tfSchemaName;
    private JButton bnCancel;
    private JTree tree;
    private JPanel pnMain;
    protected CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnGeneral;
    private JPanel pnComments;
    private JPanel pnNotes;
    private JPanel pnSummary;
    protected JTextArea taComments;
    protected JTextArea taCommentsInRDBMS;
    protected JTextArea taNotes;
    private JPanel pnGeneralGrid;
    private Dimension defaultSize = new Dimension(150, 20);
    private int summaryPanelMinHeight = 400;
    private int summaryPanelMinWidth = 650;
    protected JPanel pnSummaryGrid;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    protected int summaryCount = 5;
    protected JPanel pnDataDictConnection;
    protected JPanel pnDDLFileName;
    protected JTextField tfDataDictConnection;
    protected JTextField tfDDLFileName;
    protected JPanel pnDataDictConnections;
    protected JPanel pnDDLFileNames;
    protected JComboBox cbDataDictConnections;
    protected JComboBox cbDDLFileNames;
    private JPanel pnResParties;
    private JPanel pnProcessOrder;
    protected JTable rpTable;
    protected List rpList;
    private JPanel pnDocuments;
    protected JTable docTable;
    protected List docList;
    protected boolean readonlyName = false;
    protected JCheckBox chbVisible;
    private DefaultListModel selectedColumnsModel;
    private JList selectedColumnsList;
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelPropertiesDialogEx.this.showHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelPropertiesDialogEx.this.bnCancel.doClick();
        }
    };
    private JButton btnUp;
    private JButton btnDown;

    public ModelPropertiesDialogEx(ApplicationView applicationView, ModelIDObject modelIDObject, boolean bl) {
        this(applicationView, modelIDObject);
        this.readonlyName = bl;
        this.tfName.setEnabled(!bl);
    }

    public ModelPropertiesDialogEx(ApplicationView applicationView, ModelIDObject modelIDObject) {
        super(applicationView.getFrame());
        this.appView = applicationView;
        this.model = modelIDObject;
        this.model.setDialogVisible(true, this);
        this.initCaption(modelIDObject.getName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ModelPropertiesDialogEx.this.model.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ModelPropertiesDialogEx.this.model.setDialogVisible(false, null);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = ModelPropertiesDialogEx.this.getWidth();
                int n2 = ModelPropertiesDialogEx.this.getHeight();
                n = Math.max(ModelPropertiesDialogEx.this.getMinimumWidth(), n);
                n2 = Math.max(ModelPropertiesDialogEx.this.getMinimumHeight(), n2);
                ModelPropertiesDialogEx.this.setSize(n, n2);
            }
        });
        this.initLayout();
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escapeAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, false);
        jComponent.getInputMap(n).put(keyStroke, "KEY_F1");
        jComponent.getActionMap().put("KEY_F1", this.actF1);
        this.pack();
        Rectangle rectangle = this.appView.getSettings().getDialogSettings(this.getClass().getName());
        if (rectangle == null) {
            int n2 = Math.max(this.getMinimumWidth(), this.summaryPanelMinWidth);
            int n3 = Math.max(this.getMinimumHeight(), this.summaryPanelMinHeight);
            this.setSize(n2, n3);
            CommonUtil.centerOnScreen(this);
        } else {
            this.setSize(rectangle.getSize());
            this.setLocation(rectangle.getLocation());
        }
    }

    protected void showHelp() {
        HelpManager.showTopic((Component)Ide.getMainWindow(), this.getHelpIndex());
    }

    public String getCaption() {
        if (this.model instanceof DesignPartViewPlaceHolder) {
            return Messages.getString("ModelPropertiesDialogEx.SubviewProperties");
        }
        return Messages.getString("ModelPropertiesDialogEx.ModelProperties");
    }

    public void initProperties(ModelIDObject modelIDObject) {
        this.model = modelIDObject;
        this.tfName.setText(this.model.getName());
        this.taComments.setText(this.model.getComment());
        this.taNotes.setText(this.model.getNotes());
        this.tfObjectID.setText(this.model.getObjectID());
        this.tfCreationTime.setText(this.model.getCreationTime());
        this.tfCreator.setText(this.model.getCreator().getName());
        this.tfLastChangedBy.setText(this.model.getChanger().getName());
        this.tfLastChangedTime.setText(this.model.getChangeTime());
        if (this.model instanceof DataFlowDesign) {
            this.initProcessOrder();
        }
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
            this.initResponsibleParties();
            this.initDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            this.chbVisible.setSelected(((DesignPartViewPlaceHolder)this.model).getVisible());
            SchemaObject schemaObject = ((DesignPartViewPlaceHolder)this.model).getDesignPartView().getSchemaObject();
            if (schemaObject != null) {
                this.tfSchemaName.setText(schemaObject.getName());
            }
        } else {
            this.chbVisible.setEnabled(false);
        }
    }

    private void initProcessOrder() {
        if (this.model instanceof DataFlowDesign) {
            this.selectedColumnsModel.removeAllElements();
            DataFlowDesign dataFlowDesign = (DataFlowDesign)this.model;
            Iterator iterator = dataFlowDesign.getProcessOrderList().iterator();
            while (iterator.hasNext()) {
                this.selectedColumnsModel.addElement(iterator.next());
            }
            this.selectedColumnsList.updateUI();
        }
    }

    protected void checkNameExists(String string) throws EmptyFieldException {
        if (this.model instanceof DesignPart) {
            ModelIDObjectSet modelIDObjectSet;
            ModelObject modelObject;
            DesignPart designPart = (DesignPart)this.model;
            if (designPart.getParent() instanceof ModelIDObjectSet && (modelObject = (modelIDObjectSet = (ModelIDObjectSet)designPart.getParent()).getByName(string)) != null && modelObject != this.model) {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.ModelExists"));
            }
        } else if (this.model instanceof DesignPartViewPlaceHolder) {
            DesignPartView designPartView;
            DesignPart designPart = ((DesignPartViewPlaceHolder)this.model).getDesignPart();
            DesignPartView designPartView2 = designPart.getSubViewByName(string);
            if (designPartView2 != null && designPartView2 != ((DesignPartViewPlaceHolder)this.model).getDesignPartView()) {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.SubViewExists"));
            }
            DesignPartView designPartView3 = ((DesignPartViewPlaceHolder)this.model).getDesignPartView();
            DesignPartView designPartView4 = designPartView3.getMasterDPV();
            if (designPartView4 != null && (designPartView = designPartView4.getDisplayByName(string)) != null && designPartView != designPartView3) {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.DisplayExists"));
            }
        }
    }

    protected void setProperties() throws EmptyFieldException {
        if (!this.readonlyName) {
            if (!"".equalsIgnoreCase(this.tfName.getText())) {
                this.checkNameExists(this.tfName.getText());
                this.model.setName(this.tfName.getText());
            } else {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("ModelPropertiesDialogEx.NameCanNotBeEmpty"));
            }
        }
        this.model.setComment(this.taComments.getText());
        this.model.setNotes(this.taNotes.getText());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            ((DesignPart)this.model).setMainViewVisible(this.chbVisible.isSelected());
            this.setResponsibleParties();
            this.setDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            ((DesignPartViewPlaceHolder)this.model).setVisible(this.chbVisible.isSelected());
        }
        if (this.model instanceof DataFlowDesign) {
            List list = ((DataFlowDesign)this.model).getProcessOrderList();
            for (int i = 0; i < this.selectedColumnsModel.getSize(); ++i) {
                Object e = this.selectedColumnsModel.get(i);
                if (!list.remove(e)) continue;
                list.add(i, e);
            }
        }
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null && ((DesignPart)this.model).getMainView().isVisible()) {
            ((DesignPart)this.model).getMainView().getWorkSpace().repaint();
        }
    }

    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        if (this.model instanceof DataFlowDesign) {
            this.addToTree(defaultMutableTreeNode, this.getProcessOrderPanel());
        }
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
            this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
            this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        }
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    protected String getHelpIndex() {
        if (this.model instanceof DesignPartViewPlaceHolder) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)this.model;
            if (designPartViewPlaceHolder.getObject() instanceof DPVLogicalSubView || designPartViewPlaceHolder.getObject() instanceof DPVRelationalSubView || designPartViewPlaceHolder.getObject() instanceof DPVDataTypesSubView) {
                return "SUB_VIEW_PROPERTIES_DIALOG";
            }
            if (designPartViewPlaceHolder.getObject() instanceof DesignPartView && !((DesignPartView)designPartViewPlaceHolder.getObject()).isMasterDPV()) {
                return "DISPLAY_PROPERTIES_DIALOG";
            }
        }
        return "";
    }

    protected void initCaption(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCaption()).append(" - ").append(string);
        this.setTitle(stringBuffer.toString());
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.model.showModal) {
            this.setModal(true);
        }
        super.show();
        this.selectName();
    }

    protected int getMinimumWidth() {
        return this.summaryPanelMinWidth;
    }

    protected int getMinimumHeight() {
        return this.summaryPanelMinHeight;
    }

    public JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected JPanel createPage(String string) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        jPanel.setName(string);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        jPanel2.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel("<html><body><b>" + string + "</b>" + "</body>" + "</html>");
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected Dimension getDefaultSize() {
        return this.defaultSize;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("ModelPropertiesDialogEx.General"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_NAME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.tfName.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(jLabel, this.tfName));
            JLabel jLabel2 = new JLabel(LB_VISIBLE);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.chbVisible = new JCheckBox();
            this.chbVisible.setPreferredSize(this.getDefaultSize());
            this.chbVisible.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(jLabel2, this.chbVisible));
            if (this.model instanceof DesignPartViewPlaceHolder) {
                JLabel jLabel3 = new JLabel(Messages.getString("ModelPropertiesDialogEx.SubviewFoSchema"));
                jLabel3.setPreferredSize(this.getDefaultSize());
                this.tfSchemaName = new JTextField();
                this.tfSchemaName.setPreferredSize(this.getDefaultSize());
                this.tfSchemaName.setEnabled(false);
                this.pnGeneralGrid.add(this.createRow(jLabel3, this.tfSchemaName));
            }
            jPanel.add((Component)this.pnGeneralGrid, "North");
            this.pnGeneral.add((Component)jPanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("ModelPropertiesDialogEx.Comments"));
            this.taComments = new JTextArea();
            this.taComments.setEnabled(this.isEditable());
            this.pnComments.add(new JScrollPane(this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("ModelPropertiesDialogEx.Notes"));
            this.taNotes = new JTextArea();
            this.taNotes.setEnabled(this.isEditable());
            this.pnNotes.add(new JScrollPane(this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("ModelPropertiesDialogEx.Summary"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnSummaryGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_OBJECT_ID);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel, this.tfObjectID));
            JLabel jLabel2 = new JLabel(LB_CREATOR);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel2, this.tfCreator));
            JLabel jLabel3 = new JLabel(LB_CREATION_TIME);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel3, this.tfCreationTime));
            JLabel jLabel4 = new JLabel(LB_LAST_CHANGED_BY);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel4, this.tfLastChangedBy));
            JLabel jLabel5 = new JLabel(LB_LAST_CHANGED_TIME);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(jLabel5, this.tfLastChangedTime));
            this.summaryCount = this.pnSummaryGrid.getComponentCount();
            JLabel jLabel6 = new JLabel(LB_SOURCE_DB_CONNECTION);
            jLabel6.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection = new JTextField();
            this.tfDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection.setEditable(false);
            this.pnDataDictConnection = this.createRow(jLabel6, this.tfDataDictConnection);
            JLabel jLabel7 = new JLabel(LB_SOURCE_DB_CONNECTIONS);
            jLabel7.setPreferredSize(this.getDefaultSize());
            this.cbDataDictConnections = new JComboBox();
            this.cbDataDictConnections.setMaximumRowCount(8);
            this.cbDataDictConnections.setEditable(false);
            this.pnDataDictConnections = this.createRow(jLabel7, this.cbDataDictConnections);
            JLabel jLabel8 = new JLabel(LB_SOURCE_DDL_FILE);
            jLabel8.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName = new JTextField();
            this.tfDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName.setEditable(false);
            this.pnDDLFileName = this.createRow(jLabel8, this.tfDDLFileName);
            JLabel jLabel9 = new JLabel(LB_SOURCE_DDL_FILES);
            jLabel9.setPreferredSize(this.getDefaultSize());
            this.cbDDLFileNames = new JComboBox();
            this.cbDDLFileNames.setMaximumRowCount(8);
            this.cbDDLFileNames.setEditable(false);
            this.pnDDLFileNames = this.createRow(jLabel9, this.cbDDLFileNames);
            jPanel.add((Component)this.pnSummaryGrid, "North");
            this.pnSummary.add((Component)jPanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel createRow(Component component, Component component2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "West");
        jPanel.add(component2, "Center");
        return jPanel;
    }

    protected void addToTree(DefaultMutableTreeNode defaultMutableTreeNode, JPanel jPanel) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(jPanel));
        this.getMainPanel().add((Component)jPanel, jPanel.getName());
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
            this.tree = new JTree(defaultMutableTreeNode);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(defaultMutableTreeNode);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        this.appView.getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dispose();
    }

    protected int getMinimumTreeWidth() {
        return 150;
    }

    protected void initLayout() {
        JButton jButton;
        JScrollPane jScrollPane = new JScrollPane(this.getTree());
        jScrollPane.setMinimumSize(new Dimension(150, 0));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.getMainPanel());
        jSplitPane.setDividerLocation(this.getMinimumTreeWidth());
        jSplitPane.setDividerSize(3);
        FlowLayout flowLayout = new FlowLayout(2);
        JPanel jPanel = new JPanel(flowLayout);
        if (this.isEditable()) {
            jButton = new JButton(new AbstractAction(Messages.getString("ModelPropertiesDialogEx.OK")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ModelPropertiesDialogEx.this.setProperties();
                        ModelPropertiesDialogEx.this.model.setDirty(true);
                        ModelPropertiesDialogEx.this.close();
                    }
                    catch (EmptyFieldException emptyFieldException) {
                        JOptionPane.showMessageDialog(ModelPropertiesDialogEx.this, emptyFieldException.getMessage(), Messages.getString("ModelPropertiesDialogEx.Error"), 0);
                    }
                }
            });
            jButton.setMnemonic(79);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.getRootPane().setDefaultButton(jButton);
            JButton jButton2 = new JButton(new AbstractAction(Messages.getString("ModelPropertiesDialogEx.Apply")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ModelPropertiesDialogEx.this.setProperties();
                        ModelPropertiesDialogEx.this.model.setDirty(true);
                    }
                    catch (EmptyFieldException emptyFieldException) {
                        JOptionPane.showMessageDialog(ModelPropertiesDialogEx.this, emptyFieldException.getMessage(), Messages.getString("ModelPropertiesDialogEx.Error"), 0);
                    }
                }
            });
            jButton2.setMnemonic(65);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        this.bnCancel = new JButton(new AbstractAction(this.isEditable() ? Messages.getString("ModelPropertiesDialogEx.Cancel") : Messages.getString("ModelPropertiesDialogEx.Close")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPropertiesDialogEx.this.close();
            }
        });
        this.bnCancel.setMnemonic(67);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton = new JButton(new AbstractAction(Messages.getString("ModelPropertiesDialogEx.Help")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPropertiesDialogEx.this.showHelp();
            }
        });
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnCancel);
        jPanel.add(jButton);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
    }

    protected void initResponsibleParties() {
        this.rpList.addAll(((DesignPart)this.model).getResponsibleParties());
    }

    protected void setResponsibleParties() {
        ((DesignPart)this.model).clearResponsibleParties();
        for (BIResponsibleParty bIResponsibleParty : this.rpList) {
            ((DesignPart)this.model).addResponsibleParty(bIResponsibleParty);
        }
    }

    protected JPanel getResPartiesPanel() {
        if (this.pnResParties == null) {
            this.pnResParties = this.createPage(Messages.getString("ModelPropertiesDialogEx.ResponsibleParties"));
            this.rpList = new ArrayList();
            this.rpTable = new JTable(new ResPartyModel());
            this.rpTable.setSelectionMode(0);
            this.rpTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ModelPropertiesDialogEx.this.rpTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && n < ModelPropertiesDialogEx.this.rpList.size()) {
                        DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.rpList.get(n);
                        designObject.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.rpTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ModelPropertiesDialogEx.this.rpTable.getSelectedRow();
                    if (n != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && n < ModelPropertiesDialogEx.this.rpList.size()) {
                        DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.rpList.get(n);
                        designObject.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        designObject.showPropertyDialog();
                    }
                }
            });
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_ADD);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddPartyDialog addPartyDialog = new AddPartyDialog(ModelPropertiesDialogEx.this.appView, ModelPropertiesDialogEx.this.model.getDesign(), ModelPropertiesDialogEx.this.rpList);
                    addPartyDialog.setVisible(true);
                    ModelPropertiesDialogEx.this.rpTable.updateUI();
                }
            });
            final JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton3.setToolTipText(BTN_REMOVE);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ModelPropertiesDialogEx.this.rpTable.getSelectedRow();
                    if (n != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && n < ModelPropertiesDialogEx.this.rpList.size()) {
                        ModelPropertiesDialogEx.this.rpList.remove(n);
                        ModelPropertiesDialogEx.this.rpTable.updateUI();
                    }
                }
            });
            this.rpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (ModelPropertiesDialogEx.this.rpList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            this.rpTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ModelPropertiesDialogEx.this.rpList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
            }
            jPanel.add(jToolBar);
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            this.pnResParties.add((Component)jPanel2, "Center");
            this.rpTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (keyEvent.getKeyCode() == 127 && (n = ModelPropertiesDialogEx.this.rpTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.rpList.size() > 0 && n < ModelPropertiesDialogEx.this.rpList.size()) {
                        ModelPropertiesDialogEx.this.rpList.remove(n);
                        ModelPropertiesDialogEx.this.rpTable.updateUI();
                    }
                }
            });
        }
        return this.pnResParties;
    }

    protected JPanel getProcessOrderPanel() {
        if (this.pnProcessOrder == null) {
            this.pnProcessOrder = this.createPage(Messages.getString("ModelPropertiesDialogEx.ProcessOrderNumber"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.selectedColumnsModel = new DefaultListModel();
            this.selectedColumnsList = new JList(this.selectedColumnsModel);
            JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
            jScrollPane.setPreferredSize(new Dimension(145, 220));
            jPanel.add(jScrollPane);
            this.selectedColumnsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndex()) != -1 && ModelPropertiesDialogEx.this.selectedColumnsModel.size() > 0 && n < ModelPropertiesDialogEx.this.selectedColumnsModel.size()) {
                        DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.rpList.get(n);
                        designObject.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        designObject.showPropertyDialog();
                    }
                }
            });
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndex();
                    if (n != -1 && ModelPropertiesDialogEx.this.selectedColumnsModel.size() > 0 && n < ModelPropertiesDialogEx.this.selectedColumnsModel.size()) {
                        DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.selectedColumnsModel.get(n);
                        designObject.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        designObject.showPropertyDialog();
                    }
                }
            });
            this.btnUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.btnUp.setToolTipText(Messages.getString("ModelPropertiesDialogEx.MoveUp"));
            this.btnUp.addActionListener(new MoveUpAction());
            this.btnDown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.btnDown.setToolTipText(Messages.getString("ModelPropertiesDialogEx.MoveDown"));
            this.btnDown.addActionListener(new MoveDownAction());
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(this.btnUp);
                jToolBar.add(this.btnDown);
            }
            jPanel2.add(jToolBar);
            jPanel3.add((Component)jPanel2, "North");
            jPanel3.add((Component)jPanel, "Center");
            this.pnProcessOrder.add((Component)jPanel3, "Center");
        }
        return this.pnProcessOrder;
    }

    protected void initDocuments() {
        this.docList.addAll(((DesignPart)this.model).getDocuments());
    }

    protected void setDocuments() {
        ((DesignPart)this.model).clearDocuments();
        for (BIDocument bIDocument : this.docList) {
            ((DesignPart)this.model).addDocument(bIDocument);
        }
    }

    protected JPanel getDocumentsPanel() {
        if (this.pnDocuments == null) {
            this.pnDocuments = this.createPage(Messages.getString("ModelPropertiesDialogEx.Documents"));
            this.docList = new ArrayList();
            this.docTable = new JTable(new DocumentTableModel());
            this.docTable.setSelectionMode(0);
            this.docTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ModelPropertiesDialogEx.this.docTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && n < ModelPropertiesDialogEx.this.docList.size()) {
                        DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.docList.get(n);
                        designObject.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.docTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ModelPropertiesDialogEx.this.docTable.getSelectedRow();
                    if (n != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && n < ModelPropertiesDialogEx.this.docList.size()) {
                        DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.docList.get(n);
                        designObject.showModal = ModelPropertiesDialogEx.this.model.showModal;
                        designObject.showPropertyDialog();
                    }
                }
            });
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_ADD);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddDocumentDialog addDocumentDialog = new AddDocumentDialog(ModelPropertiesDialogEx.this.appView, ModelPropertiesDialogEx.this.model.getDesign(), ModelPropertiesDialogEx.this.docList);
                    addDocumentDialog.setVisible(true);
                    ModelPropertiesDialogEx.this.docTable.updateUI();
                }
            });
            final JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton3.setToolTipText(BTN_REMOVE);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ModelPropertiesDialogEx.this.docTable.getSelectedRow();
                    if (n != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && n < ModelPropertiesDialogEx.this.docList.size()) {
                        ModelPropertiesDialogEx.this.docList.remove(n);
                        ModelPropertiesDialogEx.this.docTable.updateUI();
                    }
                }
            });
            this.docTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (ModelPropertiesDialogEx.this.docList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            this.docTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ModelPropertiesDialogEx.this.docList.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            this.pnDocuments.add((Component)jPanel2, "Center");
            this.docTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (keyEvent.getKeyCode() == 127 && (n = ModelPropertiesDialogEx.this.docTable.getSelectedRow()) != -1 && ModelPropertiesDialogEx.this.docList.size() > 0 && n < ModelPropertiesDialogEx.this.docList.size()) {
                        ModelPropertiesDialogEx.this.docList.remove(n);
                        ModelPropertiesDialogEx.this.docTable.updateUI();
                    }
                }
            });
        }
        return this.pnDocuments;
    }

    protected boolean isEditable() {
        if (this.model.isReadOnly()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.model instanceof LogicalDesign;
        }
        return true;
    }

    public boolean moveToIndex(Object object, int n) {
        if (this.selectedColumnsModel.contains(object) && this.selectedColumnsModel.size() > n && n >= 0) {
            this.selectedColumnsModel.removeElement(object);
            this.selectedColumnsModel.add(n, object);
            return true;
        }
        return false;
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndices();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < ModelPropertiesDialogEx.this.selectedColumnsModel.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = ModelPropertiesDialogEx.this.selectedColumnsModel.get(n);
                    ModelPropertiesDialogEx.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                ModelPropertiesDialogEx.this.selectedColumnsList.setSelectedIndices(nArray);
                ModelPropertiesDialogEx.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ModelPropertiesDialogEx.this.selectedColumnsList.getSelectedIndices();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = ModelPropertiesDialogEx.this.selectedColumnsModel.get(n);
                    ModelPropertiesDialogEx.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                ModelPropertiesDialogEx.this.selectedColumnsList.setSelectedIndices(nArray);
                ModelPropertiesDialogEx.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class DocumentTableModel
    extends AbstractTableModel {
        private DocumentTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ModelPropertiesDialogEx.this.docList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ModelPropertiesDialogEx.Documents");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.docList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class ResPartyModel
    extends AbstractTableModel {
        private ResPartyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ModelPropertiesDialogEx.this.rpList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ModelPropertiesDialogEx.ResponsibleParties");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ModelPropertiesDialogEx.this.rpList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ModelPropertiesDialogEx.this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Component) {
                ModelPropertiesDialogEx.this.cardLayout.show(ModelPropertiesDialogEx.this.getMainPanel(), ((Component)object).getName());
            }
        }
    }

    public class TreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(null);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof Component) {
                Component component = (Component)defaultMutableTreeNode.getUserObject();
                this.setText(component.getName());
            }
            return this;
        }
    }
}

