/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public class LegendPropertiesDialog
extends CustomDialog {
    private DesignPartView dpv;
    private JDialog dialog;
    private JPanel buttonPanel;
    private JPanel general;
    private JCheckBox chbAuthor;
    private JCheckBox chbCreatedOn;
    private JCheckBox chbModifiedOn;
    private JCheckBox chbChangedBy;
    private JCheckBox chbDesign;
    private JCheckBox chbModel;
    private JCheckBox chbApplyToAll;

    public LegendPropertiesDialog(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView);
        this.dpv = designPartView;
        JPanel jPanel = new JPanel();
        this.general = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(this.general);
        this.initGeneral();
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = this.getButtonPanel();
        this.add((Component)jPanel2, "South");
        this.general.setPreferredSize(new Dimension(450, 180));
        this.initProperties();
    }

    private void initGeneral() {
        this.chbAuthor = new JCheckBox(Messages.getString("LegendPropertiesDialog.ShowAuthor"));
        this.chbCreatedOn = new JCheckBox(Messages.getString("LegendPropertiesDialog.ShowCreatedOn"));
        this.chbModifiedOn = new JCheckBox(Messages.getString("LegendPropertiesDialog.ShowModifiedOn"));
        this.chbChangedBy = new JCheckBox(Messages.getString("LegendPropertiesDialog.ShowChangedBy"));
        this.chbDesign = new JCheckBox(Messages.getString("LegendPropertiesDialog.ShowDesignName"));
        this.chbModel = new JCheckBox(Messages.getString("LegendPropertiesDialog.ShowModelName"));
        this.general.add(this.chbAuthor);
        this.general.add(this.chbCreatedOn);
        this.general.add(this.chbModifiedOn);
        this.general.add(this.chbChangedBy);
        this.general.add(this.chbDesign);
        this.general.add(this.chbModel);
    }

    public void initProperties() {
        this.chbAuthor.setSelected((this.dpv.getLegendAttributes() & 2) != 0);
        this.chbCreatedOn.setSelected((this.dpv.getLegendAttributes() & 4) != 0);
        this.chbModifiedOn.setSelected((this.dpv.getLegendAttributes() & 8) != 0);
        this.chbChangedBy.setSelected((this.dpv.getLegendAttributes() & 0x10) != 0);
        this.chbDesign.setSelected((this.dpv.getLegendAttributes() & 0x20) != 0);
        this.chbModel.setSelected((this.dpv.getLegendAttributes() & 0x40) != 0);
    }

    private void setProperties() {
        if (this.chbApplyToAll.isSelected()) {
            Iterator iterator = this.dpv.getDesign().getAllDPVs().iterator();
            while (iterator.hasNext()) {
                this.setLegendProperties((DesignPartView)iterator.next());
            }
        } else {
            this.setLegendProperties(this.dpv);
        }
    }

    private void setLegendProperties(DesignPartView designPartView) {
        int n = 0;
        if (this.chbAuthor.isSelected()) {
            n |= 2;
        }
        if (this.chbCreatedOn.isSelected()) {
            n |= 4;
        }
        if (this.chbModifiedOn.isSelected()) {
            n |= 8;
        }
        if (this.chbChangedBy.isSelected()) {
            n |= 0x10;
        }
        if (this.chbDesign.isSelected()) {
            n |= 0x20;
        }
        if (this.chbModel.isSelected()) {
            n |= 0x40;
        }
        designPartView.setLegendAttributes(n);
        designPartView.updateLegendSize();
        designPartView.setDirty(true);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            JButton jButton = new JButton(Messages.getString("LegendPropertiesDialog.OK"));
            jButton.setMnemonic(79);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LegendPropertiesDialog.this.setProperties();
                    LegendPropertiesDialog.this.close();
                }
            });
            JButton jButton2 = new JButton(Messages.getString("LegendPropertiesDialog.Cancel"));
            jButton2.setMnemonic(67);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LegendPropertiesDialog.this.close();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            this.chbApplyToAll = new JCheckBox(Messages.getString("LegendPropertiesDialog.ApplyToAllDiagrams"));
            jPanel.add(this.chbApplyToAll);
            this.buttonPanel.add((Component)jPanel, "West");
            this.buttonPanel.add(jPanel2);
        }
        return this.buttonPanel;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)Ide.getMainWindow(), Messages.getString("LegendPropertiesDialog.LegendProperties"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }
}

