/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.design.undo.FormatLineEdit;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JLWComboBox;

public class FormatLineDialog
extends JDialog {
    private Object[] topViews;
    private JCheckBox chbUseDefault = new JCheckBox(MessageFormat.format(Messages.getString("FormatLineDialog.UseDefault"), "<html><body><b>", "</b></body></html>"));
    private JButton bnBackground;
    private Color backgroundColor = null;
    private JLWComboBox cbLineType;

    public FormatLineDialog(Object[] objectArray) {
        super(((TopView)objectArray[0]).getApplicationView().getFrame());
        this.topViews = objectArray;
        this.setTitle(Messages.getString("FormatLineDialog.FormatLine"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FormatLineDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new OKAction(Messages.getString("FormatLineDialog.OK")));
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(new ApplyAction(Messages.getString("FormatLineDialog.Apply")));
        jButton2.setMnemonic(65);
        JButton jButton3 = new JButton(new CancelAction(Messages.getString("FormatLineDialog.Cancel")));
        jButton3.setMnemonic(67);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.getContentPane().add((Component)this.initColorPanel(), "North");
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        CommonUtil.centerOnScreen(this);
    }

    private JPanel initColorPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel3 = new JPanel(new FlowLayout(3));
        this.chbUseDefault.setPreferredSize(new Dimension(160, 35));
        jPanel3.add(this.chbUseDefault);
        jPanel2.add(jPanel3);
        this.chbUseDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FormatLineDialog.this.bnBackground.setEnabled(false);
                    FormatLineDialog.this.cbLineType.setEnabled(false);
                } else {
                    FormatLineDialog.this.bnBackground.setEnabled(true);
                    FormatLineDialog.this.cbLineType.setEnabled(true);
                }
            }
        });
        this.cbLineType = new JLWComboBox();
        this.cbLineType.setPreferredSize(new Dimension(140, 20));
        JLabel jLabel = new JLabel(Messages.getString("FormatLineDialog.Width"));
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        jPanel4.add(jLabel);
        jPanel4.add(this.cbLineType);
        jPanel2.add(jPanel4);
        this.bnBackground = new JButton();
        this.bnBackground.setPreferredSize(new Dimension(140, 20));
        this.bnBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog colorChooserDialog = new ColorChooserDialog((Dialog)FormatLineDialog.this, Messages.getString("FormatLineDialog.SelectColor"), FormatLineDialog.this.bnBackground.getBackground());
                Color color = colorChooserDialog.showDialog();
                if (color != null) {
                    FormatLineDialog.this.backgroundColor = color;
                    FormatLineDialog.this.bnBackground.setBackground(FormatLineDialog.this.backgroundColor);
                }
            }
        });
        JLabel jLabel2 = new JLabel(Messages.getString("FormatLineDialog.Color"));
        jLabel2.setPreferredSize(jLabel.getPreferredSize());
        JPanel jPanel5 = new JPanel(new FlowLayout(1));
        jPanel5.add(jLabel2);
        jPanel5.add(this.bnBackground);
        jPanel2.add(jPanel5);
        jPanel2.add(new JPanel());
        jPanel2.add(new JPanel());
        this.chbUseDefault.setSelected(((TopView)this.topViews[0]).useDefaultColor());
        if (!this.chbUseDefault.isSelected()) {
            this.cbLineType.setSelectedIndex(((TopView)this.topViews[0]).getLineWidth() - 1);
            this.backgroundColor = ((TopView)this.topViews[0]).getBackgroundColor();
            if (this.backgroundColor != null) {
                this.bnBackground.setBackground(this.backgroundColor);
            }
        } else {
            this.cbLineType.setSelectedIndex(((TopView)this.topViews[0]).getDefaultLineWidth() - 1);
            this.backgroundColor = ((TopView)this.topViews[0]).getDefaultLineColor();
            if (this.backgroundColor != null) {
                this.bnBackground.setBackground(this.backgroundColor);
            }
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void setTopViews() {
        FormatLineEdit formatLineEdit = new FormatLineEdit(this.topViews, this.chbUseDefault.isSelected(), this.backgroundColor, this.cbLineType.getSelectedIndex() + 1);
        formatLineEdit.applyUpdates();
        formatLineEdit.end();
        ((TopView)this.topViews[0]).getModel().getDesignPart().postUndoableEdit(formatLineEdit);
        for (int i = 0; i < this.topViews.length; ++i) {
            TopView topView = (TopView)this.topViews[i];
            topView.getModel().setDirty(true);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FormatLineDialog.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FormatLineDialog.this.setTopViews();
            ((TopView)FormatLineDialog.this.topViews[0]).getCellView().getDiagram().repaint();
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FormatLineDialog.this.setTopViews();
            FormatLineDialog.this.dispose();
        }
    }
}

