/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AddChangeRequestDialog
extends JDialog
implements AbstractEditorConstants {
    private DesignObject desObject;
    private List sList;
    private JPanel generalPanel;
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;
    private int counter = 0;

    public AddChangeRequestDialog(ApplicationView applicationView, DesignObject designObject, List list) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.desObject = designObject;
        this.sList = list;
        this.setTitle(Messages.getString("AddChangeRequestDialog.AddChangeRequest"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddChangeRequestDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddChangeRequestDialog.SelectRequest")));
        RadioListener radioListener = new RadioListener();
        this.rbNew = new JRadioButton(Messages.getString("AddChangeRequestDialog.NewChangeRequest"));
        this.rbNew.addActionListener(radioListener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(Messages.getString("AddChangeRequestDialog.AvailableChangeRequests"));
        this.rbAll.addActionListener(radioListener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNew);
        buttonGroup.add(this.rbAll);
        jPanel.add(this.rbNew);
        jPanel.add(this.rbAll);
        this.generalPanel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddChangeRequestDialog.AllChangeRequests")));
        this.allList.addAll(this.getAllRequests());
        this.allTable = new JTable(new AllRequestsModel());
        this.allTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.allTable);
        jScrollPane.setPreferredSize(new Dimension(320, 220));
        jPanel2.add(jScrollPane);
        this.generalPanel.add(jPanel2);
        this.enableControls(!this.rbNew.isSelected());
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void enableControls(boolean bl) {
        this.allTable.setEnabled(bl);
        this.allTable.clearSelection();
        if (!bl) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    private List getAllRequests() {
        ArrayList<ChangeRequest> arrayList = new ArrayList<ChangeRequest>();
        int n = this.desObject.getDesign().getChangeRequestSet().size();
        for (int i = 0; i < n; ++i) {
            ChangeRequest changeRequest = (ChangeRequest)this.desObject.getDesign().getChangeRequestSet().getElement(i);
            if (this.sList.contains(changeRequest)) continue;
            arrayList.add(changeRequest);
        }
        return arrayList;
    }

    protected String generateRequestName() {
        String string = Messages.getString("AddChangeRequestDialog.Request");
        int n = 0;
        int n2 = this.sList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.requestExists(string2)) {
            n = ++this.counter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean requestExists(String string) {
        for (int i = 0; i < this.sList.size(); ++i) {
            ChangeRequest changeRequest = (ChangeRequest)this.sList.get(i);
            if (!string.equalsIgnoreCase(changeRequest.getName())) continue;
            return true;
        }
        return false;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddChangeRequestDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AddChangeRequestDialog.this.rbNew.isSelected()) {
                ChangeRequest changeRequest = AddChangeRequestDialog.this.desObject.getDesign().getChangeRequestSet().createChangeRequest(null);
                changeRequest.setObject(AddChangeRequestDialog.this.desObject);
                AddChangeRequestDialog.this.sList.add(changeRequest);
            } else {
                int n = AddChangeRequestDialog.this.allTable.getSelectedRow();
                if (n != -1 && AddChangeRequestDialog.this.allList.size() > 0 && n < AddChangeRequestDialog.this.allList.size()) {
                    ChangeRequest changeRequest = (ChangeRequest)AddChangeRequestDialog.this.allList.get(n);
                    AddChangeRequestDialog.this.sList.add(changeRequest);
                }
            }
            AddChangeRequestDialog.this.dispose();
        }
    }

    private class AllRequestsModel
    extends AbstractTableModel {
        private AllRequestsModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AddChangeRequestDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AddChangeRequestDialog.ChangeRequest");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ChangeRequest changeRequest = (ChangeRequest)AddChangeRequestDialog.this.allList.get(n);
            if (n2 == 0) {
                return changeRequest.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddChangeRequestDialog.this.enableControls(!AddChangeRequestDialog.this.rbNew.isSelected());
        }
    }
}

