/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.AddChangeRequestDialog;
import oracle.dbtools.crest.swingui.editor.ChangeRequestPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.CommonEditor;
import oracle.dbtools.crest.swingui.editor.MeasurementPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddDocumentDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPartyDialog;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public abstract class AbstractEditor
extends JDialog
implements AbstractEditorConstants,
CommonEditor {
    public static final String BTN_PROPERTIES = Messages.getString("AbstractEditor.Properties");
    public static final String BTN_ADD = Messages.getString("AbstractEditor.Add");
    public static final String BTN_REMOVE = Messages.getString("AbstractEditor.Remove");
    private ApplicationView appView;
    private JTabbedPane tpane;
    protected JPanel generalPanel = new JPanel(new GridLayout(0, 1));
    protected JPanel summaryPanel = new JPanel(new GridLayout(0, 1));
    protected JPanel mPanel = new JPanel();
    protected JPanel reqPanel = new JPanel();
    protected JPanel rpPanel = new JPanel();
    protected JPanel docPanel = new JPanel();
    protected JLabel lbName;
    protected JTextField tfName;
    protected static final int FIELD_WIDTH = 150;
    protected static final int FIELD_HEIGHT = 20;
    protected StorageDesign storageDesign;
    protected JLabel lbComment;
    protected JLabel lbObjectID;
    protected JLabel lbCreator;
    protected JLabel lbCreationTime;
    protected JLabel lbLastChangedBy;
    protected JLabel lbLastChangedTime;
    protected JLabel lbGeneratorName;
    protected JLabel lbDesign;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    protected JTextField tfGeneratorName;
    protected JTextField tfDesign;
    protected JButton btnComment;
    protected JButton btnCommentInRDBMS;
    protected JButton btnDefaultValue;
    protected JButton btnNotes;
    protected JButton btnSynonym;
    private DesignObject desObject;
    private JButton bnCancel;
    protected JTable mtable;
    protected List mList = new ArrayList();
    protected JScrollPane mpane;
    private int counter = 0;
    protected JTable reqTable;
    protected List reqList = new ArrayList();
    protected JScrollPane reqPane;
    public String commentField = "";
    public String notesField = "";
    public String synonymField = "";
    protected JTable docTable;
    protected List docList = new ArrayList();
    protected JTable rpTable;
    protected List rpList = new ArrayList();
    protected JScrollPane rpPane;
    protected JScrollPane docPane;
    protected boolean canExit = true;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractEditor.this.bnCancel.doClick();
        }
    };
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractEditor.this.showHelp();
        }
    };

    public AbstractEditor(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog);
        this.init(applicationView, designObject);
    }

    public AbstractEditor(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView.getFrame());
        this.init(applicationView, designObject);
    }

    private void init(ApplicationView applicationView, DesignObject designObject) {
        JButton jButton;
        this.desObject = designObject;
        this.appView = applicationView;
        this.setTitle(this.getCaption());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                AbstractEditor.this.desObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractEditor.this.desObject.setDialogVisible(false, null);
            }
        });
        this.tpane = new JTabbedPane();
        this.prepareTab(this.tpane, this.generalPanel, Messages.getString("AbstractEditor.General"), Messages.getString("AbstractEditor.GeneraPpropertiesForObject"));
        this.initGeneralView();
        this.initSummaryView();
        this.getContentPane().add((Component)this.tpane, "Center");
        JPanel jPanel = new JPanel();
        String string = Messages.getString("AbstractEditor.Close");
        if (this.isEditable()) {
            jButton = new JButton(BTN_OK);
            jButton.addActionListener(new OKAction());
            jButton.setMnemonic(79);
            this.getRootPane().setDefaultButton(jButton);
            JButton jButton2 = new JButton(BTN_APPLY);
            jButton2.addActionListener(new ApplyAction());
            jButton2.setMnemonic(65);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            string = Messages.getString("AbstractEditor.Cancel");
        }
        this.bnCancel = new JButton(string);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnCancel);
        jButton = new JButton(new AbstractAction(Messages.getString("AbstractEditor.Help")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractEditor.this.showHelp();
            }
        });
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, false);
        jComponent.getInputMap(n).put(keyStroke, "KEY_F1");
        jComponent.getActionMap().put("KEY_F1", this.actF1);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    public DesignObject getDesignObject() {
        return this.desObject;
    }

    protected void showHelp() {
        HelpManager.showTopic((Component)Ide.getMainWindow(), this.getHelpIndex());
    }

    protected String getHelpIndex() {
        return "";
    }

    protected void initTabs() {
    }

    private void initSummaryView() {
        this.lbObjectID = new JLabel(LB_OBJECT_ID);
        this.lbObjectID.setPreferredSize(new Dimension(150, 20));
        this.tfObjectID = new JTextField();
        this.tfObjectID.setPreferredSize(this.lbObjectID.getPreferredSize());
        JPanel jPanel = this.newRow(this.lbObjectID, this.tfObjectID);
        this.tfObjectID.setEditable(false);
        this.summaryPanel.add(jPanel);
        this.lbCreator = new JLabel(LB_CREATOR);
        this.lbCreator.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfCreator = new JTextField();
        this.tfCreator.setPreferredSize(this.lbObjectID.getPreferredSize());
        jPanel = this.newRow(this.lbCreator, this.tfCreator);
        this.tfCreator.setEditable(false);
        this.summaryPanel.add(jPanel);
        this.lbCreationTime = new JLabel(LB_CREATION_TIME);
        this.lbCreationTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfCreationTime = new JTextField();
        this.tfCreationTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        jPanel = this.newRow(this.lbCreationTime, this.tfCreationTime);
        this.tfCreationTime.setEditable(false);
        this.summaryPanel.add(jPanel);
        this.lbLastChangedBy = new JLabel(LB_LAST_CHANGED_BY);
        this.lbLastChangedBy.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfLastChangedBy = new JTextField();
        this.tfLastChangedBy.setPreferredSize(this.lbObjectID.getPreferredSize());
        jPanel = this.newRow(this.lbLastChangedBy, this.tfLastChangedBy);
        this.tfLastChangedBy.setEditable(false);
        this.summaryPanel.add(jPanel);
        this.lbLastChangedTime = new JLabel(LB_LAST_CHANGED_TIME);
        this.lbLastChangedTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfLastChangedTime = new JTextField();
        this.tfLastChangedTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        jPanel = this.newRow(this.lbLastChangedTime, this.tfLastChangedTime);
        this.tfLastChangedTime.setEditable(false);
        this.summaryPanel.add(jPanel);
        this.lbGeneratorName = new JLabel(LB_GENERATOR_NAME);
        this.lbGeneratorName.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfGeneratorName = new JTextField();
        this.tfGeneratorName.setPreferredSize(this.lbObjectID.getPreferredSize());
        jPanel = this.newRow(this.lbGeneratorName, this.tfGeneratorName);
        this.tfGeneratorName.setEditable(false);
        this.summaryPanel.add(jPanel);
        this.lbDesign = new JLabel(LB_DESIGN);
        this.lbDesign.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfDesign = new JTextField();
        this.tfDesign.setPreferredSize(this.lbObjectID.getPreferredSize());
        jPanel = this.newRow(this.lbDesign, this.tfDesign);
        this.tfDesign.setEditable(false);
        this.summaryPanel.add(jPanel);
    }

    private void initMeasurementsView() {
        MeasurementModel measurementModel = new MeasurementModel();
        this.mtable = new JTable(measurementModel);
        this.mtable.setSelectionMode(0);
        this.mtable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Measurement measurement;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = AbstractEditor.this.mtable.getSelectedRow()) != -1 && AbstractEditor.this.mList.size() > 0 && n < AbstractEditor.this.mList.size() && !(measurement = (Measurement)AbstractEditor.this.mList.get(n)).isDialogVisible()) {
                    MeasurementPropertiesDialog measurementPropertiesDialog = new MeasurementPropertiesDialog(AbstractEditor.this.getAppView(), measurement);
                    measurementPropertiesDialog.initProperties(measurement);
                    measurementPropertiesDialog.show();
                    AbstractEditor.this.mtable.updateUI();
                }
            }
        });
        this.mpane = new JScrollPane(this.mtable);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_PROPERTIES);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Measurement measurement;
                int n = AbstractEditor.this.mtable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.mList.size() > 0 && n < AbstractEditor.this.mList.size() && !(measurement = (Measurement)AbstractEditor.this.mList.get(n)).isDialogVisible()) {
                    MeasurementPropertiesDialog measurementPropertiesDialog = new MeasurementPropertiesDialog(AbstractEditor.this.getAppView(), measurement);
                    measurementPropertiesDialog.initProperties(measurement);
                    measurementPropertiesDialog.show();
                    AbstractEditor.this.mtable.updateUI();
                }
            }
        });
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        jButton2.setToolTipText(BTN_ADD);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Measurement measurement = new Measurement(AbstractEditor.this.desObject.getDesignPart());
                measurement.setName(AbstractEditor.this.generateMeasurementName());
                measurement.setDesign(AbstractEditor.this.desObject.getDesign());
                measurement.setObject(AbstractEditor.this.desObject);
                AbstractEditor.this.mList.add(measurement);
                AbstractEditor.this.mtable.updateUI();
            }
        });
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        jButton3.setToolTipText(BTN_REMOVE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractEditor.this.mtable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.mList.size() > 0 && n < AbstractEditor.this.mList.size()) {
                    AbstractEditor.this.mList.remove(n);
                    AbstractEditor.this.mtable.updateUI();
                }
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel.add(jToolBar);
        this.mPanel.add((Component)jPanel, "North");
        this.mPanel.add(this.mpane);
    }

    protected String generateMeasurementName() {
        String string = "Measurement";
        int n = 0;
        int n2 = this.mList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.measurementExists(string2)) {
            n = ++this.counter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean measurementExists(String string) {
        for (int i = 0; i < this.mList.size(); ++i) {
            Measurement measurement = (Measurement)this.mList.get(i);
            if (!string.equalsIgnoreCase(measurement.getName())) continue;
            return true;
        }
        return false;
    }

    public String getCaption() {
        return Messages.getString("AbstractEditor.Properties");
    }

    private void initChangeRequestsView() {
        this.reqList.addAll(this.desObject.getRequests());
        this.reqTable = new JTable(new ChangeRequestModel());
        this.reqTable.setSelectionMode(0);
        this.reqTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = AbstractEditor.this.reqTable.getSelectedRow()) != -1 && AbstractEditor.this.reqList.size() > 0 && n < AbstractEditor.this.reqList.size()) {
                    ChangeRequest changeRequest = (ChangeRequest)AbstractEditor.this.reqList.get(n);
                    ChangeRequestPropertiesDialog changeRequestPropertiesDialog = new ChangeRequestPropertiesDialog(AbstractEditor.this.getAppView(), changeRequest);
                    changeRequestPropertiesDialog.initProperties(changeRequest);
                    changeRequestPropertiesDialog.show();
                    AbstractEditor.this.reqTable.updateUI();
                }
            }
        });
        this.reqPane = new JScrollPane(this.reqTable);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(Messages.getString("AbstractEditor.Properties"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractEditor.this.reqTable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.reqList.size() > 0 && n < AbstractEditor.this.reqList.size()) {
                    ChangeRequest changeRequest = (ChangeRequest)AbstractEditor.this.reqList.get(n);
                    ChangeRequestPropertiesDialog changeRequestPropertiesDialog = new ChangeRequestPropertiesDialog(AbstractEditor.this.getAppView(), changeRequest);
                    changeRequestPropertiesDialog.initProperties(changeRequest);
                    changeRequestPropertiesDialog.show();
                    AbstractEditor.this.reqTable.updateUI();
                }
            }
        });
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        jButton2.setToolTipText(Messages.getString("AbstractEditor.Add"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddChangeRequestDialog addChangeRequestDialog = new AddChangeRequestDialog(AbstractEditor.this.getAppView(), AbstractEditor.this.desObject, AbstractEditor.this.reqList);
                addChangeRequestDialog.setVisible(true);
                AbstractEditor.this.reqTable.updateUI();
            }
        });
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        jButton3.setToolTipText(Messages.getString("AbstractEditor.Remove"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractEditor.this.reqTable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.reqList.size() > 0 && n < AbstractEditor.this.reqList.size()) {
                    AbstractEditor.this.reqList.remove(n);
                    AbstractEditor.this.reqTable.updateUI();
                }
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel.add(jToolBar);
        this.reqPanel.add((Component)jPanel, "North");
        this.reqPanel.add(this.reqPane);
    }

    private void initResPartiesView() {
        this.rpList.addAll(this.desObject.getResponsibleParties());
        this.rpTable = new JTable(new ResPartyModel());
        this.rpTable.setSelectionMode(0);
        this.rpTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = AbstractEditor.this.rpTable.getSelectedRow()) != -1 && AbstractEditor.this.rpList.size() > 0 && n < AbstractEditor.this.rpList.size()) {
                    DesignObject designObject = (DesignObject)AbstractEditor.this.rpList.get(n);
                    designObject.showPropertyDialog();
                }
            }
        });
        this.rpPane = new JScrollPane(this.rpTable);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(Messages.getString("AbstractEditor.Properties"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractEditor.this.rpTable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.rpList.size() > 0 && n < AbstractEditor.this.rpList.size()) {
                    DesignObject designObject = (DesignObject)AbstractEditor.this.rpList.get(n);
                    designObject.showPropertyDialog();
                }
            }
        });
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        jButton2.setToolTipText(Messages.getString("AbstractEditor.Add"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPartyDialog addPartyDialog = new AddPartyDialog(AbstractEditor.this.getAppView(), AbstractEditor.this.desObject.getDesign(), AbstractEditor.this.rpList);
                addPartyDialog.setVisible(true);
                AbstractEditor.this.rpTable.updateUI();
            }
        });
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        jButton3.setToolTipText(Messages.getString("AbstractEditor.Remove"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractEditor.this.rpTable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.rpList.size() > 0 && n < AbstractEditor.this.rpList.size()) {
                    AbstractEditor.this.rpList.remove(n);
                    AbstractEditor.this.rpTable.updateUI();
                }
            }
        });
        this.rpPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel.add(jToolBar);
        this.rpPanel.add((Component)jPanel, "North");
        this.rpPanel.add(this.rpPane);
    }

    private void initDocumentsTab() {
        this.docList.addAll(this.desObject.getDocuments());
        this.docTable = new JTable(new DocumentTableModel());
        this.docTable.setSelectionMode(0);
        this.docTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = AbstractEditor.this.docTable.getSelectedRow()) != -1 && AbstractEditor.this.docList.size() > 0 && n < AbstractEditor.this.docList.size()) {
                    DesignObject designObject = (DesignObject)AbstractEditor.this.docList.get(n);
                    designObject.showPropertyDialog();
                }
            }
        });
        this.docPane = new JScrollPane(this.docTable);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(Messages.getString("AbstractEditor.Properties"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractEditor.this.docTable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.docList.size() > 0 && n < AbstractEditor.this.docList.size()) {
                    DesignObject designObject = (DesignObject)AbstractEditor.this.docList.get(n);
                    designObject.showPropertyDialog();
                }
            }
        });
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        jButton2.setToolTipText(Messages.getString("AbstractEditor.Add"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddDocumentDialog addDocumentDialog = new AddDocumentDialog(AbstractEditor.this.getAppView(), AbstractEditor.this.desObject.getDesign(), AbstractEditor.this.docList);
                addDocumentDialog.setVisible(true);
                AbstractEditor.this.docTable.updateUI();
            }
        });
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        jButton3.setToolTipText(Messages.getString("AbstractEditor.Remove"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractEditor.this.docTable.getSelectedRow();
                if (n != -1 && AbstractEditor.this.docList.size() > 0 && n < AbstractEditor.this.docList.size()) {
                    AbstractEditor.this.docList.remove(n);
                    AbstractEditor.this.docTable.updateUI();
                }
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel.add(jToolBar);
        this.docPane.setPreferredSize(new Dimension(325, 180));
        this.docPanel = new JPanel();
        this.docPanel.add((Component)jPanel, "North");
        this.docPanel.add(this.docPane);
        this.getPane().addTab(Messages.getString("AbstractEditor.Documents"), this.docPanel);
    }

    public abstract void initProperties(DesignObject var1);

    protected abstract void setProperties();

    protected void removeIndexElements() {
    }

    protected void initGeneralView() {
        this.lbName = new JLabel(LB_NAME);
        this.lbName.setPreferredSize(new Dimension(150, 20));
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfName.setEnabled(this.isEditable());
        JPanel jPanel = this.newRow(this.lbName, this.tfName);
        this.generalPanel.add(jPanel);
        this.lbComment = new JLabel(LB_COMMENT);
        this.lbComment.setPreferredSize(this.lbName.getPreferredSize());
        this.btnComment = new JButton();
        this.btnComment.setPreferredSize(this.lbName.getPreferredSize());
        this.btnComment.setHorizontalAlignment(2);
        this.btnComment.setFont(new Font(this.btnComment.getFont().getName(), 0, this.btnComment.getFont().getSize()));
        jPanel = this.newRow(this.lbComment, this.btnComment);
        this.generalPanel.add(jPanel);
    }

    protected JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    public JTabbedPane getPane() {
        return this.tpane;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public void fillComboItems(Object[] objectArray, JComboBox jComboBox) {
        jComboBox.addItem(null);
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    public void fillComboItems(Object[] objectArray, JComboBox jComboBox, Object object) {
        jComboBox.addItem(null);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2.equals(object)) continue;
            jComboBox.addItem(objectArray[i]);
        }
    }

    public void setBG(Component component) {
        component.setBackground(Color.WHITE);
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    public void selectObject(JComboBox jComboBox, StorageObject storageObject) {
        jComboBox.setSelectedItem(storageObject);
    }

    protected void initCaption(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCaption()).append(" - ").append(string);
        this.setTitle(stringBuffer.toString());
    }

    protected void setHeight(int n) {
        this.getPane().setPreferredSize(new Dimension(350, n));
    }

    protected void prepareTab(JTabbedPane jTabbedPane, JPanel jPanel, String string, String string2) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        jPanel2.add((Component)new JPanel(), gridBagConstraints);
        jTabbedPane.addTab(string, null, new JScrollPane(jPanel2), string2);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public void addSummaryTab() {
        this.prepareTab(this.tpane, this.summaryPanel, Messages.getString("AbstractEditor.Summary"), Messages.getString("AbstractEditor.SummaryPropertiesForObject"));
    }

    public void addMeasurementTab(Dimension dimension) {
        this.initMeasurementsView();
        this.mpane.setPreferredSize(dimension);
        this.getPane().addTab(Messages.getString("AbstractEditor.Measurements"), this.mPanel);
    }

    public void addChangeRequestsTab(Dimension dimension) {
        this.initChangeRequestsView();
        this.reqPane.setPreferredSize(dimension);
        this.getPane().addTab(Messages.getString("AbstractEditor.ChangeRequests"), this.reqPanel);
    }

    protected void setChangeRequests() {
        this.desObject.clearRequests();
        for (ChangeRequest changeRequest : this.reqList) {
            this.desObject.addRequest(changeRequest);
        }
    }

    public void addResPartyTab(Dimension dimension) {
        this.initResPartiesView();
        this.rpPane.setPreferredSize(dimension);
        this.getPane().addTab(Messages.getString("AbstractEditor.ResponsibleParties"), this.rpPanel);
    }

    protected void setResParties() {
        this.desObject.clearResponsibleParties();
        for (BIResponsibleParty bIResponsibleParty : this.rpList) {
            this.desObject.addResponsibleParty(bIResponsibleParty);
        }
    }

    public void addDocumentsTab(Dimension dimension) {
        this.initDocumentsTab();
        this.docPane.setPreferredSize(dimension);
        this.getPane().addTab(Messages.getString("AbstractEditor.Documents"), this.docPanel);
    }

    protected void setDocuments() {
        this.desObject.clearDocuments();
        for (BIDocument bIDocument : this.docList) {
            this.desObject.addDocument(bIDocument);
        }
    }

    @Override
    public String getCommentField() {
        if (this.commentField.equalsIgnoreCase("")) {
            this.commentField = this.desObject.getComment();
        }
        return this.commentField;
    }

    @Override
    public void setCommentField(String string) {
        this.commentField = string;
        this.btnComment.setText(string);
    }

    @Override
    public String getNotesField() {
        if (this.notesField.equalsIgnoreCase("")) {
            this.notesField = this.desObject.getNotes();
        }
        return this.notesField;
    }

    @Override
    public void setNotesField(String string) {
        this.notesField = string;
        this.btnNotes.setText(string);
    }

    @Override
    public String getSynonymField() {
        if (this.synonymField.equalsIgnoreCase("")) {
            if (this.desObject instanceof AbstractProcessObject) {
                this.synonymField = ((AbstractProcessObject)this.desObject).getSynonym();
            } else if (this.desObject instanceof Entity) {
                this.synonymField = ((Entity)this.desObject).getSynonym();
            }
        }
        return this.synonymField;
    }

    @Override
    public void setSynonymField(String string) {
        this.synonymField = string;
        this.btnSynonym.setText(string);
    }

    protected void cleanGenerated() {
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.desObject.showModal) {
            this.setModal(true);
        }
        super.show();
        this.selectName();
        this.desObject.setDialogVisible(true, this);
    }

    protected boolean isEditable() {
        if (this.desObject.isReadOnly()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.desObject.getDesignPart() instanceof LogicalDesign;
        }
        return true;
    }

    protected String translate(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray2[i];
        }
        return "";
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractEditor.this.removeIndexElements();
            AbstractEditor.this.cleanGenerated();
            AbstractEditor.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractEditor.this.setProperties();
            AbstractEditor.this.desObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractEditor.this.setProperties();
            if (AbstractEditor.this.canExit) {
                AbstractEditor.this.desObject.setDirty(true);
                AbstractEditor.this.dispose();
            }
        }
    }

    private class DocumentTableModel
    extends AbstractTableModel {
        private DocumentTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.docList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractEditor.Documents");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)AbstractEditor.this.docList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class ResPartyModel
    extends AbstractTableModel {
        private ResPartyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.rpList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractEditor.ResponsibleParties");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)AbstractEditor.this.rpList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class ChangeRequestModel
    extends AbstractTableModel {
        private ChangeRequestModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.reqList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractEditor.ChangeRequest");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ChangeRequest changeRequest = (ChangeRequest)AbstractEditor.this.reqList.get(n);
            if (n2 == 0) {
                return changeRequest.getName();
            }
            return new Integer(n * n2);
        }
    }

    public class MeasurementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.mList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractEditor.Measurement");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Measurement measurement = (Measurement)AbstractEditor.this.mList.get(n);
            if (n2 == 0) {
                return measurement.getName();
            }
            return null;
        }
    }
}

