/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TableViewRenderer
extends ContainerRenderer {
    public static final int COLUMN_LEFT = 10;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(150, 255, 150);
    public static final Color DEFAULT_DATATYPE_COLOR = Color.BLUE;
    protected static final Icon ERROR_ICON = GUIConfiguration.getInstance().getIcon("ERROR_ICON");
    protected static final Icon WARNING_RED_ICON = GUIConfiguration.getInstance().getIcon("WARNING_RED_ICON");
    protected static final Icon WARNING_YELLOW_ICON = GUIConfiguration.getInstance().getIcon("WARNING_YELLOW_ICON");

    public TableViewRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Relational View");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackgroundColor();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Relational View");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getElementsColor() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_COLUMN).getColor();
        }
        return super.getElementsColor();
    }

    @Override
    protected Font getElementsFont() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_COLUMN).getFont();
        }
        return super.getElementsFont();
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        EditableFonts editableFonts = (EditableFonts)((Object)this.container);
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
        graphics.setColor(this.getBorderColor());
        graphics.drawRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
        Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        int n4 = Math.max(n3, font.getSize());
        int n5 = (n - fontMetrics.stringWidth(this.longName)) / 2;
        if (n5 < 20) {
            n5 = 20;
        }
        boolean bl = ((AbstractView)this.container).isValidSQL();
        boolean bl2 = ((AbstractView)this.container).isParsed();
        boolean bl3 = ((AbstractView)this.container).isIncorrectSQL();
        Icon icon = null;
        if (bl3) {
            icon = ERROR_ICON;
        } else if (!bl) {
            icon = WARNING_RED_ICON;
        } else if (!bl2) {
            icon = WARNING_YELLOW_ICON;
        }
        if (icon != null) {
            icon.paintIcon(this, graphics, 10, n4 - 8);
        }
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        BasicStroke basicStroke2 = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke2);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont());
        String[] stringArray = TableViewRenderer.wrapText(this.longName, TableViewRenderer.getMaxChars(this.longName, fontMetrics, n - 20 - 5));
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            graphics.drawString((String)object, n5, n4);
            n4 += n3;
        }
        n4 -= n3;
        DesignPartView designPartView = this.getDesignPartView();
        if (designPartView != null && !designPartView.clearDetails() && !designPartView.isShowNamesOnly()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getBorderColor());
            graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
            if (designPartView.showAllDetails() || designPartView.showElements()) {
                List list;
                int n6;
                DesignObject designObject;
                int n7;
                Object object22;
                Object object3;
                if (this.container.isBST()) {
                    object = this.container.getBasedOnStructuredType();
                    if (object != null) {
                        object3 = ((StructuredType)object).getElements();
                        object22 = this.getLongestTypeName((TypeElement[])object3);
                        graphics.setFont(this.getElementsFont());
                        fontMetrics = graphics.getFontMetrics();
                        n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                        for (n7 = 0; n7 < ((DesignObject[])object3).length; ++n7) {
                            designObject = object3[n7];
                            graphics.setColor(this.getElementsColor());
                            graphics.setFont(this.getElementsFont());
                            float f = this.getElementsFont().getSize2D();
                            graphics.drawString(designObject.getName(), 10, n4 += 3 + fontMetrics.getMaxAscent());
                            fontMetrics = graphics.getFontMetrics();
                            n6 = fontMetrics.stringWidth((String)object22) + 20;
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                            graphics.drawString(((TypeElement)designObject).getDataType(), n6, n4);
                            graphics.setColor(this.getForeground());
                        }
                    }
                } else {
                    graphics2D.setStroke(basicStroke2);
                    float f = this.getElementsFont().getSize2D();
                    object3 = ((TableView)this.container).getColumns();
                    object22 = this.getLongestName((ContainedObject[])object3);
                    graphics.setFont(this.getElementsFont());
                    fontMetrics = graphics.getFontMetrics();
                    n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                    for (n7 = 0; n7 < ((DesignObject[])object3).length; ++n7) {
                        designObject = (ColumnView)object3[n7];
                        n4 += 3 + fontMetrics.getMaxAscent();
                        String string = ((AbstractViewElement)designObject).getAlias();
                        if (string == null || "".equalsIgnoreCase(string)) {
                            string = ((AbstractViewElement)designObject).getReferencedName();
                        }
                        graphics.setFont(this.getElementsFont());
                        graphics.setColor(this.getElementsColor());
                        graphics.drawString(string, 10, n4);
                        fontMetrics = graphics.getFontMetrics();
                        n6 = fontMetrics.stringWidth((String)object22) + 20;
                        if (designPartView.showAllDetails() || designPartView.showDatatype()) {
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            String string2 = this.getDataType((ColumnView)designObject);
                            if ((string2 == null || "".equals(string2)) && (string2 = ((AbstractViewElement)designObject).getExpression()) == null) {
                                string2 = "";
                            }
                            graphics.drawString(string2, n6, n4);
                        }
                        graphics.setColor(this.getForegroundColor());
                        if (n4 <= n2) continue;
                        graphics.setColor(this.getBorderColor());
                        int n8 = n - 4;
                        int n9 = n8 - 8;
                        int n10 = n8 - 4;
                        int n11 = n2 - 4;
                        int n12 = n11 - 8;
                        int[] nArray = new int[]{n10, n9, n8};
                        int[] nArray2 = new int[]{n11, n12, n12};
                        graphics.fillPolygon(nArray, nArray2, 3);
                        break;
                    }
                }
                if (designPartView.showAllDetails() && (list = ((TableView)this.container).getUsedTablesAndViews()).size() > 0) {
                    graphics2D.setStroke(basicStroke);
                    graphics.setColor(this.getBorderColor());
                    graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
                    graphics.setFont(this.getElementsFont());
                    graphics.setColor(this.getElementsColor());
                    for (Object object22 : list) {
                        String string = ((SQLNameHelper)object22).getTableName();
                        graphics.drawString(string, 10, n4 += 3 + fontMetrics.getMaxAscent());
                    }
                }
            }
        }
    }

    @Override
    protected String getLongestTypeName(TypeElement[] typeElementArray) {
        String string = "";
        for (int i = 0; i < typeElementArray.length; ++i) {
            String string2 = typeElementArray[i].getName();
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }

    private String getDataType(ColumnView columnView) {
        if (columnView.getReferencedColumn() != null && ("Aggregate".equalsIgnoreCase(columnView.getReferencedColumn().getSourceType()) || "Derived".equalsIgnoreCase(columnView.getReferencedColumn().getSourceType()) && columnView.getReferencedColumn().getFormulaDesc() != null && columnView.getReferencedColumn().getFormulaDesc().length() > 0)) {
            return columnView.getReferencedColumn().getFormulaDesc();
        }
        return columnView.getDataType();
    }

    @Override
    protected String getLongestName(ContainedObject[] containedObjectArray) {
        String string = "";
        for (int i = 0; i < containedObjectArray.length; ++i) {
            String string2 = ((ColumnView)containedObjectArray[i]).getAlias();
            if (string2 == null || "".equalsIgnoreCase(string2)) {
                string2 = ((ColumnView)containedObjectArray[i]).getReferencedName();
            }
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }
}

