/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class FKEdge
extends DefaultEdge {
    private JPopupMenu menu = null;
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    public FKIndexAssociation getFK() {
        return (FKIndexAssociation)this.getTopView().getModel();
    }

    @Override
    public String getName() {
        return this.getFK().getName();
    }

    @Override
    public Object getUserObject() {
        if (this.getTopView() != null && this.getFK() != null) {
            return this.getName();
        }
        return null;
    }

    @Override
    public void showPopupMenu(Point point) {
        this.point.setLocation(point);
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
                if (this.selectedObjects.length > 1) {
                    this.menu.add(new AbstractAction(DELETE_OBJECTS){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DefaultDiagramCell.deleteObjects(FKEdge.this.selectedObjects, FKEdge.this.getDiagram().getAppView());
                        }
                    });
                } else {
                    this.menu.add(new AbstractAction(DELETE){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            FKEdge.this.deleteFK();
                        }
                    });
                }
                this.menu.addSeparator();
                this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FKEdge.this.straightenLine();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FKEdge.this.format();
                    }
                });
                this.menu.addSeparator();
                this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FKEdge.this.addBreakpoint(FKEdge.this.point);
                    }
                });
                this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FKEdge.this.removeBreakpoint(FKEdge.this.point);
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FKEdge.this.showProperty();
                }
            });
        }
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean bl = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!bl);
                this.miRemoveBP.setEnabled(bl);
            }
        }
        return this.menu;
    }

    private boolean isReadonly() {
        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.getTopView().getModel();
        return fKIndexAssociation.getContainerWithKeyObject() != null && fKIndexAssociation.getContainerWithKeyObject().isReadOnly();
    }

    public void deleteFK() {
        FKIndexAssociation fKIndexAssociation = this.getFK();
        ((RelationalDesign)fKIndexAssociation.getDesignPart()).postFKRemoveEdit(fKIndexAssociation);
        Index index = fKIndexAssociation.getLocalFKIndex();
        TVConnector tVConnector = (TVConnector)this.getTopView();
        if (tVConnector.remove(index)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("FKEdge.DeleteFKRelation"), index.getName()));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteFK();
    }
}

