/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcRenderer;

public class FKArcView
extends AbstractCellView {
    private FKArcRenderer renderer;
    protected Rectangle2D bounds;
    protected Rectangle2D groupBounds = DefaultDiagramCell.defaultBounds;
    protected Rectangle2D cachedBounds = null;

    public FKArcView(Object object, AbstractDiagram abstractDiagram, CellMapper cellMapper) {
        super(object, abstractDiagram, cellMapper);
        ((DefaultDiagramCell)object).setCellView(this);
    }

    @Override
    public CellViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new FKArcRenderer();
        }
        return this.renderer;
    }

    @Override
    public Rectangle2D getBounds() {
        FKArc fKArc = ((FKArcDiagramCell)this.getCell()).getArc();
        if (fKArc != null) {
            try {
                Rectangle rectangle = fKArc.getTable().getFirstViewForDPV(((FKArcDiagramCell)this.getCell()).getTopView().getDesignPartView()).getBounds();
                int n = fKArc.getSizeIndex();
                return new Rectangle(rectangle.x - n, rectangle.y - n, rectangle.width + n + n, rectangle.height + n + n);
            }
            catch (Exception exception) {
                return this.bounds;
            }
        }
        return this.bounds;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    protected void updateGroupBounds() {
        CellView[] cellViewArray = this.getChildViews();
        LinkedList<CellView> linkedList = new LinkedList<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!this.includeInGroupBounds(cellViewArray[i])) continue;
            linkedList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[linkedList.size()];
        linkedList.toArray(cellViewArray);
        this.groupBounds = FKArcView.getBounds(cellViewArray);
    }

    private boolean includeInGroupBounds(CellView cellView) {
        if (cellView instanceof EdgeView) {
            DiagramModel diagramModel = this.diagram.getModel();
            EdgeView edgeView = (EdgeView)cellView;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode treeNode;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)edgeView.getCell();
                if (diagramModel.getSource(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)diagramModel.getSource(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
                if (diagramModel.getTarget(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)diagramModel.getTarget(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void update() {
        super.update();
        this.bounds = DiagramConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            topView.setBounds(this.bounds.getBounds());
        }
    }

    @Override
    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    @Override
    public Point2D getCenterPoint() {
        Rectangle2D rectangle2D = this.getBounds();
        return DiagramConstants.createPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    @Override
    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2, boolean bl) {
        return ((FKArcRenderer)this.getRenderer()).getPerimeterPoint(this, point2D, point2D2, bl);
    }

    @Override
    public CellHandle getHandle(DiagramContext diagramContext) {
        return null;
    }
}

