/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcView;
import oracle.dbtools.crest.swingui.diagram.relational.FKEdge;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;

public class FKArcRenderer
extends JComponent
implements CellViewRenderer {
    private FKArc arc;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient FKArcView view;
    private static final int LEFT_SIDE = 0;
    private static final int TOP_SIDE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int BOTTOM_SIDE = 3;

    @Override
    public Color getBGColor() {
        return this.getBackground();
    }

    @Override
    public Color getFGColor() {
        return this.getForeground();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof FKArcView) {
            FKArcDiagramCell fKArcDiagramCell = (FKArcDiagramCell)cellView.getCell();
            this.arc = fKArcDiagramCell.getArc();
            this.view = (FKArcView)cellView;
            this.diagram = abstractDiagram;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setComponentOrientation(abstractDiagram.getComponentOrientation());
            if (cellView.isLeaf()) {
                this.installAttributes(cellView);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            return this;
        }
        return null;
    }

    void setView(CellView cellView) {
        if (cellView instanceof FKArcView) {
            this.view = (FKArcView)cellView;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    protected void installAttributes(CellView cellView) {
        Map map = cellView.getAllAttributes();
        Color color = DiagramConstants.getLineColor(map);
        this.setForeground(color != null ? color : this.defaultForeground);
        Color color2 = DiagramConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setFont(this.diagram.getFont());
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            Point point = this.getLocation();
            if (this.selected) {
                graphics.setColor(Color.BLUE);
            } else {
                graphics.setColor(Color.BLACK);
            }
            Rectangle rectangle = new Rectangle(point.x + 3, point.y + 3, n - 7, n2 - 7);
            if (this.view != null) {
                ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
                for (FKIndexAssociation fKIndexAssociation : this.arc.getFkeys()) {
                    Point2D point2D;
                    Point2D point2D2;
                    TVFKRelation tVFKRelation = (TVFKRelation)fKIndexAssociation.getViewFor(this.getDesignPartView());
                    if (tVFKRelation == null) continue;
                    EdgeView edgeView = (EdgeView)tVFKRelation.getCellView();
                    if (edgeView.getCell() != null && ((FKEdge)edgeView.getCell()).getCellView() != null) {
                        edgeView = (EdgeView)((FKEdge)edgeView.getCell()).getCellView();
                    }
                    if (rectangle.contains(point2D2 = edgeView.getPoint(0))) {
                        point2D = edgeView.getPoint(1);
                    } else {
                        int n3 = edgeView.getPointCount();
                        point2D2 = edgeView.getPoint(n3 - 1);
                        point2D = edgeView.getPoint(n3 - 2);
                    }
                    Point2D point2D3 = this.getRelationPoint(rectangle, point2D2, point2D);
                    if (point2D3 == null && edgeView.getPointCount() > 2) {
                        if (rectangle.contains(edgeView.getPoint(0))) {
                            point2D2 = edgeView.getPoint(1);
                            point2D = edgeView.getPoint(2);
                        } else {
                            int n4 = edgeView.getPointCount();
                            point2D2 = edgeView.getPoint(n4 - 2);
                            point2D = edgeView.getPoint(n4 - 3);
                        }
                        point2D3 = this.getRelationPoint(rectangle, point2D2, point2D);
                    }
                    if (point2D3 == null) continue;
                    arrayList.add(point2D3);
                    double d = 0.0;
                    double d2 = 0.0;
                    d = point2D3.getX() - (double)point.x - 2.0;
                    d2 = point2D3.getY() - (double)point.y - 2.0;
                    graphics.fillOval((int)d, (int)d2, 5, 5);
                }
                this.drawArc((Graphics2D)graphics, arrayList, rectangle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    private void drawArc(Graphics2D graphics2D, List list, Rectangle rectangle) {
        Point point = this.getLocation();
        GeneralPath generalPath = new GeneralPath();
        Rectangle rectangle2 = this.getBounds();
        Line2D line2D = this.getFirstAndLastPoints(list, rectangle2);
        Point2D point2D = line2D.getP1();
        Point2D point2D2 = line2D.getP2();
        float f = (float)point2D.getX() - (float)point.x;
        float f2 = (float)point2D.getY() - (float)point.y;
        float f3 = (float)point2D2.getX() - (float)point.x;
        float f4 = (float)point2D2.getY() - (float)point.y;
        int n = 14;
        int n2 = 10;
        float f5 = rectangle.width + 3;
        float f6 = rectangle.height + 3;
        int n3 = this.getPointSide(rectangle, point2D);
        int n4 = this.getPointSide(rectangle, point2D2);
        if (n3 == 2) {
            generalPath.moveTo(f - (float)n2, f2 - (float)(n2 * 2));
            generalPath.curveTo(f - (float)n2, f2 - (float)(n2 * 2), f, f2 - (float)(n2 * 2), f, f2 - (float)n2);
            if (n3 == n4) {
                generalPath.lineTo(f3, f4 + (float)n2);
                generalPath.curveTo(f3, f4 + (float)n2, f3, f4 + (float)(n2 * 2), f3 - (float)n2, f4 + (float)(n2 * 2));
            } else {
                generalPath.lineTo(f, f6 - (float)n);
                generalPath.curveTo(f, f6 - (float)n, f, f6, f - (float)n, f6);
                if (n4 == 3) {
                    generalPath.lineTo(f3 - (float)n2, f4);
                    generalPath.curveTo(f3 - (float)n2, f4, f3 - (float)(n2 * 2), f4, f3 - (float)(n2 * 2), f4 - (float)n2);
                } else if (n4 == 0) {
                    generalPath.lineTo(f3 + (float)n, f6);
                    generalPath.curveTo(f3 + (float)n, f6, f3, f6, f3, f6 - (float)n);
                    generalPath.lineTo(f3, f4 - (float)n2);
                    generalPath.curveTo(f3, f4 - (float)n2, f3, f4 - (float)(n2 * 2), f3 + (float)n2, f4 - (float)(n2 * 2));
                } else {
                    generalPath.lineTo(3 + n, f6);
                    generalPath.curveTo(3 + n, f6, 3.0f, f6, 3.0f, f6 - (float)n);
                    generalPath.lineTo(3.0f, 3 + n);
                    generalPath.curveTo(3.0f, 3 + n, 3.0f, 3.0f, 3 + n, 3.0f);
                    generalPath.lineTo(f3 + (float)n2, f4);
                    generalPath.curveTo(f3 + (float)n2, f4, f3 + (float)(n2 * 2), f4, f3 + (float)(n2 * 2), f4 + (float)n2);
                }
            }
        } else if (n3 == 3) {
            generalPath.moveTo(f + (float)(n2 * 2), f2 - (float)n2);
            generalPath.curveTo(f + (float)(n2 * 2), f2 - (float)n2, f + (float)(n2 * 2), f2, f + (float)n2, f2);
            if (n3 == n4) {
                generalPath.lineTo(f3 - (float)n2, f4);
                generalPath.curveTo(f3 - (float)n2, f4, f3 - (float)(n2 * 2), f4, f3 - (float)(n2 * 2), f4 - (float)n2);
            } else {
                generalPath.lineTo(n + 3, f6);
                generalPath.curveTo(n + 3, f6, 3.0f, f6, 3.0f, f6 - (float)n);
                if (n4 == 0) {
                    generalPath.lineTo(f3, f4 - (float)n2);
                    generalPath.curveTo(f3, f4 - (float)n2, f3, f4 - (float)(n2 * 2), f3 + (float)n2, f4 - (float)(n2 * 2));
                } else if (n4 == 1) {
                    generalPath.lineTo(3.0f, f4 + (float)n);
                    generalPath.curveTo(3.0f, f4 + (float)n, 3.0f, 3.0f, 3 + n, 3.0f);
                    generalPath.lineTo(f3 + (float)n2, f4);
                    generalPath.curveTo(f3 + (float)n2, f4, f3 + (float)(n2 * 2), f4, f3 + (float)(n2 * 2), f4 + (float)n2);
                } else {
                    generalPath.lineTo(3.0f, 3 + n);
                    generalPath.curveTo(3.0f, 3 + n, 3.0f, 3.0f, 3 + n, 3.0f);
                    generalPath.lineTo(f5 - (float)n, 3.0f);
                    generalPath.curveTo(f5 - (float)n, 3.0f, f5, 3.0f, f5, 3 + n);
                    generalPath.lineTo(f3, f4 + (float)n2);
                    generalPath.curveTo(f3, f4 + (float)n2, f3, f4 + (float)(n2 * 2), f3 - (float)n2, f4 + (float)(n2 * 2));
                }
            }
        } else if (n3 == 0) {
            generalPath.moveTo(f + (float)n2, f2 + (float)(n2 * 2));
            generalPath.curveTo(f + (float)n2, f2 + (float)(n2 * 2), f, f2 + (float)(n2 * 2), f, f2 + (float)n2);
            if (n3 == n4) {
                generalPath.lineTo(f3, f4 - (float)n2);
                generalPath.curveTo(f3, f4 - (float)n2, f3, f4 - (float)(n2 * 2), f3 + (float)n2, f4 - (float)(n2 * 2));
            } else {
                generalPath.lineTo(3.0f, n);
                generalPath.curveTo(3.0f, n, 3.0f, 3.0f, 3 + n, 3.0f);
                if (n4 == 1) {
                    generalPath.lineTo(f3 + (float)n2, f4);
                    generalPath.curveTo(f3 + (float)n2, f4, f3 + (float)(n2 * 2), f4, f3 + (float)(n2 * 2), f4 + (float)n2);
                } else if (n4 == 2) {
                    generalPath.lineTo(f5 - (float)n, 3.0f);
                    generalPath.curveTo(f5 - (float)n, 3.0f, f5, 3.0f, f5, 3 + n);
                    generalPath.lineTo(f3, f4 + (float)n2);
                    generalPath.curveTo(f3, f4 + (float)n2, f3, f4 + (float)(n2 * 2), f3 - (float)n2, f4 + (float)(n2 * 2));
                } else {
                    generalPath.lineTo(f5 - (float)n, 3.0f);
                    generalPath.curveTo(f5 - (float)n, 3.0f, f5, 3.0f, f5, 3 + n);
                    generalPath.lineTo(f5, f6 - (float)n);
                    generalPath.curveTo(f5, f6 - (float)n, f5, f6, f5 - (float)n, f6);
                    generalPath.lineTo(f3 - (float)n2, f4);
                    generalPath.curveTo(f3 - (float)n2, f4, f3 - (float)(n2 * 2), f4, f3 - (float)(n2 * 2), f4 - (float)n2);
                }
            }
        } else {
            generalPath.moveTo(f - (float)(n2 * 2), 3 + n2);
            generalPath.curveTo(f - (float)(n2 * 2), 3 + n2, f - (float)(n2 * 2), 3.0f, f - (float)n2, 3.0f);
            if (n3 == n4) {
                generalPath.lineTo(f3 + (float)n2, f4);
                generalPath.curveTo(f3 + (float)n2, f4, f3 + (float)(n2 * 2), f4, f3 + (float)(n2 * 2), f4 + (float)n2);
            } else {
                generalPath.lineTo(f5 - (float)n, 3.0f);
                generalPath.curveTo(f5 - (float)n, 3.0f, f5, 3.0f, f5, 3 + n);
                if (n4 == 2) {
                    generalPath.lineTo(f3, f4 + (float)n2);
                    generalPath.curveTo(f3, f4 + (float)n2, f3, f4 + (float)(n2 * 2), f3 - (float)n2, f4 + (float)(n2 * 2));
                } else if (n4 == 3) {
                    generalPath.lineTo(f5, f6 - (float)n);
                    generalPath.curveTo(f5, f6 - (float)n, f5, f6, f5 - (float)n, f6);
                    generalPath.lineTo(f3 - (float)n2, f4);
                    generalPath.curveTo(f3 - (float)n2, f4, f3 - (float)(n2 * 2), f4, f3 - (float)(n2 * 2), f4 - (float)n2);
                } else {
                    generalPath.lineTo(f5, f6 - (float)n);
                    generalPath.curveTo(f5, f6 - (float)n, f5, f6, f5 - (float)n, f6);
                    generalPath.lineTo(3 + n, f6);
                    generalPath.curveTo(3 + n, f6, 3.0f, f6, 3.0f, f6 - (float)n);
                    generalPath.lineTo(f3, f4 - (float)n2);
                    generalPath.curveTo(f3, f4 - (float)n2, f3, f4 - (float)(n2 * 2), f3 + (float)n2, f4 - (float)(n2 * 2));
                }
            }
        }
        graphics2D.draw(generalPath);
    }

    private Line2D getFirstAndLastPoints(List list, Rectangle rectangle) {
        Cloneable cloneable2;
        TreeMap<Double, Cloneable> treeMap = new TreeMap<Double, Cloneable>();
        for (Cloneable cloneable2 : list) {
            double d = this.getDegree((Point2D)cloneable2, rectangle);
            treeMap.put(new Double(d), cloneable2);
        }
        cloneable2 = new ArrayList();
        Iterator<Object> iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            cloneable2.add(iterator.next());
        }
        int n = 0;
        int n2 = cloneable2.size() - 1;
        Double d = (Double)cloneable2.get(n);
        Double d2 = (Double)cloneable2.get(n2);
        double d3 = d;
        double d4 = d2;
        int n3 = 361;
        while (d4 - d3 > 180.0) {
            ++n2;
            if (++n >= cloneable2.size()) {
                n = 0;
                --n3;
            }
            if (n2 >= cloneable2.size()) {
                n2 = 0;
            }
            d = (Double)cloneable2.get(n);
            d2 = (Double)cloneable2.get(n2);
            d3 = d;
            if (!(d3 > (d4 = d2.doubleValue()))) continue;
            d4 += (double)n3;
        }
        Point2D point2D = (Point2D)treeMap.get(d);
        Point2D point2D2 = (Point2D)treeMap.get(d2);
        return new Line2D.Float(point2D, point2D2);
    }

    private double getDegree(Point2D point2D, Rectangle rectangle) {
        double d = point2D.getX() - rectangle.getCenterX();
        double d2 = point2D.getY() - rectangle.getCenterY();
        double d3 = Math.atan2(d2, d);
        double d4 = Math.toDegrees(d3);
        if (d4 < 0.0) {
            return d4 + 360.0;
        }
        return d4;
    }

    private int getPointSide(Rectangle rectangle, Point2D point2D) {
        double d;
        double d2;
        double d3 = rectangle.getX();
        double d4 = rectangle.getY();
        double d5 = rectangle.getWidth();
        double d6 = rectangle.getHeight();
        double d7 = d3 + d5 / 2.0;
        double d8 = d4 + d6 / 2.0;
        double d9 = point2D.getX() - d7;
        double d10 = point2D.getY() - d8;
        double d11 = Math.atan2(d10, d9);
        if (d11 < -(d2 = Math.PI) + (d = Math.atan2(d6, d5)) || d11 > d2 - d) {
            return 0;
        }
        if (d11 < -d) {
            return 1;
        }
        if (d11 < d) {
            return 2;
        }
        return 3;
    }

    public Point2D getRelationPoint(Rectangle rectangle, Point2D point2D, Point2D point2D2) {
        double d;
        Line2D.Double double_;
        double d2 = rectangle.getX();
        double d3 = rectangle.getY();
        double d4 = rectangle.getWidth();
        double d5 = rectangle.getHeight();
        Line2D.Double double_2 = new Line2D.Double(d2, d3, d2, d3 + d5);
        if (!(double_2.intersectsLine(double_ = new Line2D.Double(point2D, point2D2)) || (double_2 = new Line2D.Double(d2, d3, d2 + d4, d3)).intersectsLine(double_) || (double_2 = new Line2D.Double(d2 + d4, d3, d2 + d4, d3 + d5)).intersectsLine(double_) || (double_2 = new Line2D.Double(d2, d3 + d5, d2 + d4, d3 + d5)).intersectsLine(double_))) {
            return null;
        }
        double d6 = double_2.getX1();
        double d7 = double_2.getY1();
        double d8 = double_2.getX2() - d6;
        double d9 = double_2.getY2() - d7;
        double d10 = double_.getX1();
        double d11 = double_.getY1();
        double d12 = double_.getX2() - d10;
        double d13 = d12 * d9 - (d = double_.getY2() - d11) * d8;
        if (d13 == 0.0) {
            return null;
        }
        double d14 = (d12 * (d11 - d7) + d * (d6 - d10)) / d13;
        if (d14 == 0.0 || d14 == 1.0) {
            return null;
        }
        return new Point2D.Double(d6 + d14 * d8, d7 + d14 * d9);
    }

    public Point2D getPerimeterPoint(FKArcView fKArcView, Point2D point2D, Point2D point2D2, boolean bl) {
        Rectangle2D rectangle2D = fKArcView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D2.getX() - d5;
        double d8 = point2D2.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = Math.atan2(d4, d3);
        if (d9 < -d12 + d13 || d9 > d12 - d13) {
            d10 = d;
            d11 = d6;
        } else if (d9 < -d13) {
            d11 = d2;
            d10 = d5;
        } else if (d9 < d13) {
            d10 = d + d3;
            d11 = d6;
        } else {
            d11 = d2 + d4;
            d10 = d5;
        }
        return DiagramConstants.createPoint(d10, d11);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public FKArc getArc() {
        return this.arc;
    }
}

