/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.TVTransformation;
import oracle.ide.Ide;

public class TransformationDiagramCell
extends DFDiagramCell {
    private JPopupMenu menu;

    public TransformationDiagramCell(AbstractProcessObject abstractProcessObject) {
        super(abstractProcessObject);
    }

    public TransformationDiagramCell(AbstractProcessObject abstractProcessObject, Map map) {
        super(abstractProcessObject, map);
    }

    private void showProperty() {
        this.getProcessObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TransformationDiagramCell.this.deleteProcess();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TransformationDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TransformationDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TransformationDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteProcess() {
        Diagram diagram = this.getDiagram();
        ApplicationView applicationView = diagram.getAppView();
        DesignPartView designPartView = applicationView.getCurrentDPV();
        Transformation transformation = (Transformation)this.getProcessObject();
        if (transformation.getDesignPart() == designPartView.getDesignPart()) {
            ApplicationView.log(MessageFormat.format(Messages.getString("TransformationDiagramCell.DeleteTransformation"), transformation.getName()));
            TVTransformation tVTransformation = (TVTransformation)this.getTopView();
            tVTransformation.remove(true);
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TransformationDiagramCell.TransformationNotCreatedAtThisLevel"));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteProcess();
    }
}

