/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class StoreRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(100, 205, 255);

    public StoreRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("Information Store");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.processObject.getDesign().getDLSettings().getDefaultFCObject("Information Store");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = n / 5;
        EditableFonts editableFonts = (EditableFonts)((Object)this.processObject);
        String string = "D" + String.valueOf(this.processObject.getDesignObjectSet().getIndexOf(this.processObject) + 1);
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.getBorderColor());
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.drawLine(n3, 0, n3, n2 - 1);
        Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = n2 / 2 + font.getSize() / 3;
        int n5 = (n - fontMetrics.stringWidth(this.title)) / 2;
        if (n5 < 20) {
            n5 = 20;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke);
        graphics.setFont(font);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_NUMBER).getColor());
        graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_NUMBER).getFont().deriveFont(font.getSize2D()));
        int n6 = (n3 - fontMetrics.stringWidth(string)) / 2;
        graphics.drawString(string, n6 + 1, n4);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont());
        n6 = n5 + n3 / 2;
        graphics.drawString(this.title, n6, n4);
    }
}

