/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.ide.Ide;

public class StoreDiagramCell
extends DFDiagramCell {
    private JPopupMenu menu;

    public StoreDiagramCell(AbstractProcessObject abstractProcessObject) {
        super(abstractProcessObject);
    }

    public StoreDiagramCell(AbstractProcessObject abstractProcessObject, Map map) {
        super(abstractProcessObject, map);
    }

    private void showProperty() {
        this.getProcessObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StoreDiagramCell.this.getProcessObject().getAppView().clearCopiedObjects();
                        StoreDiagramCell.access$002(StoreDiagramCell.this, StoreDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < StoreDiagramCell.this.selectedObjects.length; ++i) {
                            if (!(StoreDiagramCell.this.selectedObjects[i] instanceof ExternalAgent) && !(StoreDiagramCell.this.selectedObjects[i] instanceof Process) && !(StoreDiagramCell.this.selectedObjects[i] instanceof InfoStore)) continue;
                            StoreDiagramCell.this.getProcessObject().getAppView().addCopiedObject((DesignObject)StoreDiagramCell.this.selectedObjects[i]);
                        }
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StoreDiagramCell.this.deleteStore();
                    }
                });
                this.menu.add(new AbstractAction("Delete from DFD"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StoreDiagramCell.this.deleteStoreFromDFD();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StoreDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StoreDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StoreDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteStore() {
        Diagram diagram = this.getDiagram();
        ApplicationView applicationView = diagram.getAppView();
        if (applicationView.getCurrentDPV().getDesignPart() instanceof DataFlowDesign) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)applicationView.getCurrentDPV().getDesignPart();
            Process process = dataFlowDesign.getProcess();
            DataFlowDesign dataFlowDesign2 = dataFlowDesign.getParentDataFlowdesign();
            InfoStore infoStore = (InfoStore)this.getProcessObject();
            if (process == null || dataFlowDesign2 != null && dataFlowDesign2.getFirstFlowBetween(process, infoStore) == null && dataFlowDesign2.getFirstFlowBetween(infoStore, process) == null) {
                ApplicationView.log(MessageFormat.format(Messages.getString("StoreDiagramCell.DeleteInformationStore"), infoStore.getName()));
                TVInfoStore tVInfoStore = (TVInfoStore)this.getTopView();
                tVInfoStore.remove(true);
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("StoreDiagramCell.ConnectedToUpperLevel"), process.getName()));
            }
        } else {
            InfoStore infoStore = (InfoStore)this.getProcessObject();
            ApplicationView.log(MessageFormat.format(Messages.getString("StoreDiagramCell.DeleteInformationStore"), infoStore.getName()));
            TVInfoStore tVInfoStore = (TVInfoStore)this.getTopView();
            tVInfoStore.remove();
        }
    }

    public void deleteStoreFromDFD() {
        InfoStore infoStore = (InfoStore)this.getProcessObject();
        ApplicationView.log(MessageFormat.format(Messages.getString("StoreDiagramCell.DeleteInformationStore"), infoStore.getName()));
        TVInfoStore tVInfoStore = (TVInfoStore)this.getTopView();
        tVInfoStore.remove();
    }

    @Override
    public void deleteSelected() {
        this.deleteStore();
    }

    static /* synthetic */ Object[] access$002(StoreDiagramCell storeDiagramCell, Object[] objectArray) {
        storeDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }
}

