/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.TVAgent;
import oracle.ide.Ide;

public class AgentDiagramCell
extends DFDiagramCell {
    private JPopupMenu menu;

    public AgentDiagramCell(AbstractProcessObject abstractProcessObject) {
        super(abstractProcessObject);
    }

    public AgentDiagramCell(AbstractProcessObject abstractProcessObject, Map map) {
        super(abstractProcessObject, map);
    }

    private void showProperty() {
        this.getProcessObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AgentDiagramCell.this.getProcessObject().getAppView().clearCopiedObjects();
                        AgentDiagramCell.access$002(AgentDiagramCell.this, AgentDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < AgentDiagramCell.this.selectedObjects.length; ++i) {
                            if (!(AgentDiagramCell.this.selectedObjects[i] instanceof ExternalAgent) && !(AgentDiagramCell.this.selectedObjects[i] instanceof Process) && !(AgentDiagramCell.this.selectedObjects[i] instanceof InfoStore)) continue;
                            AgentDiagramCell.this.getProcessObject().getAppView().addCopiedObject((DesignObject)AgentDiagramCell.this.selectedObjects[i]);
                        }
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AgentDiagramCell.this.deleteAgent();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AgentDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AgentDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgentDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteAgent() {
        Diagram diagram = this.getDiagram();
        ApplicationView applicationView = diagram.getAppView();
        DataFlowDesign dataFlowDesign = (DataFlowDesign)applicationView.getCurrentDPV().getDesignPart();
        Process process = dataFlowDesign.getProcess();
        ExternalAgent externalAgent = (ExternalAgent)this.getProcessObject();
        DataFlowDesign dataFlowDesign2 = dataFlowDesign.getParentDataFlowdesign();
        if (process == null || dataFlowDesign2 != null && dataFlowDesign2.getFirstFlowBetween(process, externalAgent) == null && dataFlowDesign2.getFirstFlowBetween(externalAgent, process) == null) {
            ApplicationView.log(MessageFormat.format(Messages.getString("AgentDiagramCell.DeleteExternalAgent"), externalAgent.getName()));
            TVAgent tVAgent = (TVAgent)this.getTopView();
            tVAgent.remove(true);
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("AgentDiagramCell.ConnectedUpperLevel"), process.getName()));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteAgent();
    }

    static /* synthetic */ Object[] access$002(AgentDiagramCell agentDiagramCell, Object[] objectArray) {
        agentDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }
}

