/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class LevelRenderer
extends MDDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(228, 208, 253);
    private int MORE_ARROW_PADDING = 4;
    private int MORE_ARROW_WIDTH = 8;
    private int MORE_ARROW_HEIGHT = 8;
    private Icon icon;

    public LevelRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.icon = gUIConfiguration.getIcon("HIERARCHY_ICON", 16);
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getMdObject().getDesign().getDLSettings().getDefaultFCObject("Level");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getMdObject().getDesign().getDLSettings().getDefaultFCObject("Level");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        Level level;
        Level level2 = level = (Level)this.getMdObject();
        if (this.detailedView) {
            DesignObject designObject = level.getDefaultAttribute();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            graphics2D.setPaint(this.getBackgroundColor());
            if (level.isValueBasedHierarchy()) {
                graphics.fillRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
                graphics.setColor(this.getBorderColor());
                graphics.drawRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
                if (this.icon != null) {
                    this.icon.paintIcon(null, graphics2D, 8, 3);
                }
            } else {
                graphics.fillRect(0, 0, n - 1, n2 - 1);
                graphics.setColor(this.getBorderColor());
                graphics.drawRect(0, 0, n - 1, n2 - 1);
            }
            Font font = level2.getFontObject(EditableFonts.FO_TITLE).getFont();
            float f = font.getSize2D();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
            int n4 = Math.max(n3, font.getSize());
            int n5 = (n - fontMetrics.stringWidth(this.title)) / 2;
            if (level.isValueBasedHierarchy()) {
                if (n5 < 25) {
                    n5 = 25;
                }
            } else if (n5 < 20) {
                n5 = 20;
            }
            BasicStroke basicStroke = new BasicStroke(1.0f);
            BasicStroke basicStroke2 = new BasicStroke(this.borderWidth);
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getBorderColor());
            graphics.setFont(font);
            graphics.drawString(this.title, n5, n4);
            DesignPartView designPartView = this.getDesignPartView();
            if (designPartView != null && !designPartView.clearDetails() && !designPartView.isShowNamesOnly()) {
                Object object;
                if (designPartView.showAllDetails() || designPartView.showKeys()) {
                    ContainerObject containerObject;
                    graphics2D.setStroke(basicStroke2);
                    graphics.setColor(this.getBorderColor());
                    n4 = (int)((double)n4 + ((double)n4 - (double)n3 / 1.5));
                    graphics.drawLine(0, n4, n - 3, n4);
                    graphics2D.setStroke(basicStroke);
                    object = "";
                    if (level != null && (containerObject = level.getLevelEntity()) != null) {
                        object = containerObject.getName();
                    }
                    graphics.setColor(level2.getFontObject(EditableFonts.FO_LEVEL_ENTITY).getColor());
                    graphics.setFont(level2.getFontObject(EditableFonts.FO_LEVEL_ENTITY).getFont());
                    fontMetrics = graphics.getFontMetrics();
                    n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                    graphics.drawString((String)object, 30, n4 += 3 + fontMetrics.getMaxAscent());
                }
                if (designPartView.showAllDetails() || designPartView.showElements()) {
                    Object object2;
                    int n6;
                    int n7;
                    int n8;
                    Object object3;
                    int n9;
                    graphics.setColor(this.getBorderColor());
                    graphics2D.setStroke(basicStroke2);
                    graphics.drawLine(0, n4 += fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() * 2, n - 3, n4);
                    object = new ArrayList();
                    object.addAll(level.getLevelKey());
                    int n10 = object.size();
                    object.addAll(level.getDescriptiveAttributes());
                    object.addAll(level.getCalculatedAttributes());
                    Object[] objectArray = object.toArray();
                    Object object4 = "";
                    for (n9 = 0; n9 < objectArray.length; ++n9) {
                        object3 = ((DesignObject)objectArray[n9]).getName();
                        if (((String)object3).length() <= ((String)object4).length()) continue;
                        object4 = object3;
                    }
                    f = level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().getSize2D();
                    f = Math.max(f, level2.getFontObject(EditableFonts.FO_FUNCTION).getFont().getSize2D());
                    graphics.setFont(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(n10));
                    fontMetrics = graphics.getFontMetrics();
                    n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                    for (n9 = 0; n9 < objectArray.length; ++n9) {
                        int n11;
                        if ((n4 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) > n2 - 1) {
                            graphics.setColor(this.getBorderColor());
                            int n12 = n - this.MORE_ARROW_PADDING;
                            n11 = n12 - this.MORE_ARROW_WIDTH;
                            n8 = n12 - this.MORE_ARROW_WIDTH / 2;
                            n7 = n2 - this.MORE_ARROW_PADDING;
                            n6 = n7 - this.MORE_ARROW_HEIGHT;
                            object2 = new int[]{n8, n11, n12};
                            int[] nArray = new int[]{n7, n6, n6};
                            graphics.fillPolygon((int[])object2, nArray, 3);
                            break;
                        }
                        object3 = (DesignObject)objectArray[n9];
                        graphics2D.setStroke(basicStroke);
                        graphics.setColor(level2.getFontObject(EditableFonts.FO_TYPE).getColor());
                        graphics.setFont(level2.getFontObject(EditableFonts.FO_TYPE).getFont().deriveFont(f));
                        if (n9 < n10) {
                            if (object3 == designObject) {
                                graphics.drawString("KD", 5, n4);
                            } else {
                                graphics.drawString("K", 5, n4);
                            }
                        } else if (object3 instanceof CalculatedAttribute) {
                            if (object3 == designObject) {
                                graphics.drawString("CD", 5, n4);
                            } else {
                                graphics.drawString("C", 5, n4);
                            }
                        } else if (object3 == designObject) {
                            graphics.drawString("D", 5, n4);
                        }
                        fontMetrics = graphics.getFontMetrics();
                        n11 = fontMetrics.stringWidth("KD") + 10;
                        graphics.setColor(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                        graphics.setFont(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(f));
                        graphics.drawString(((DesignObject)object3).getName(), n11, n4);
                        if (!(object3 instanceof CalculatedAttribute)) continue;
                        graphics.setColor(this.getRedColor());
                        String string = ((CalculatedAttribute)object3).getFunction();
                        if (string == null) continue;
                        graphics.setColor(level2.getFontObject(EditableFonts.FO_FUNCTION).getColor());
                        graphics.setFont(level2.getFontObject(EditableFonts.FO_FUNCTION).getFont().deriveFont(f));
                        graphics.drawString(string, (n11 += fontMetrics.stringWidth((String)object4) + 20) + 120, n4);
                    }
                    n9 = 0;
                    boolean bl = false;
                    if (level.isValueBasedHierarchy()) {
                        Iterator iterator = level.getParentKey().iterator();
                        while (iterator.hasNext()) {
                            n9 = 1;
                            String string = ((DesignObject)iterator.next()).getName();
                            if (string.length() <= ((String)object4).length()) continue;
                            object4 = string;
                        }
                        if (n9 != 0) {
                            graphics.setColor(this.getBorderColor());
                            graphics2D.setStroke(basicStroke2);
                            graphics.drawLine(0, n4 += 3 + this.borderWidth, n, n4);
                            Object[] objectArray2 = level.getParentKey().toArray();
                            for (n7 = 0; n7 < objectArray2.length; ++n7) {
                                if ((n4 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) > n2 - 1) {
                                    graphics.setColor(this.getBorderColor());
                                    n6 = n - this.MORE_ARROW_PADDING;
                                    int n13 = n6 - this.MORE_ARROW_WIDTH;
                                    int n14 = n6 - this.MORE_ARROW_WIDTH / 2;
                                    int n15 = n2 - this.MORE_ARROW_PADDING;
                                    int n16 = n15 - this.MORE_ARROW_HEIGHT;
                                    int[] nArray = new int[]{n14, n13, n6};
                                    int[] nArray2 = new int[]{n15, n16, n16};
                                    graphics.fillPolygon(nArray, nArray2, 3);
                                    break;
                                }
                                ContainedObject containedObject = (ContainedObject)objectArray2[n7];
                                graphics2D.setStroke(basicStroke);
                                graphics.setColor(level2.getFontObject(EditableFonts.FO_TYPE).getColor());
                                graphics.setFont(level2.getFontObject(EditableFonts.FO_TYPE).getFont().deriveFont(f));
                                graphics.drawString("R", 5, n4);
                                fontMetrics = graphics.getFontMetrics();
                                int n17 = fontMetrics.stringWidth("KD") + 10;
                                graphics.setColor(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                                graphics.setFont(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(f));
                                graphics.drawString(containedObject.getName(), n17, n4);
                                graphics.setColor(this.getRedColor());
                            }
                        }
                    } else {
                        int[] nArray;
                        int[] nArray3;
                        int n18;
                        int n19;
                        int n20;
                        int n21;
                        Object[] objectArray3 = level.getOutgoingLinks().toArray();
                        if (objectArray3.length > 0) {
                            for (n8 = 0; n8 < objectArray3.length; ++n8) {
                                Link link = (Link)objectArray3[n8];
                                if (link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                                n9 = 1;
                                Iterator iterator = link.getRollupLink().getChildToParentAttributes().iterator();
                                while (iterator.hasNext()) {
                                    object2 = ((DesignObject)iterator.next()).getName();
                                    if (object2.length() <= ((String)object4).length()) continue;
                                    object4 = object2;
                                }
                            }
                            if (n9 != 0) {
                                graphics.setColor(this.getBorderColor());
                                graphics2D.setStroke(basicStroke2);
                                graphics.drawLine(0, n4 += 3 + this.borderWidth, n, n4);
                                block6: for (n8 = 0; n8 < objectArray3.length; ++n8) {
                                    RollupLink rollupLink = ((Link)objectArray3[n8]).getRollupLink();
                                    Level level3 = (Level)((Link)objectArray3[n8]).getTargetMDObject();
                                    object2 = rollupLink.getChildToParentAttributes().toArray();
                                    for (int i = 0; i < ((Object[])object2).length; ++i) {
                                        if ((n4 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) > n2 - 1) {
                                            graphics.setColor(this.getBorderColor());
                                            int n22 = n - this.MORE_ARROW_PADDING;
                                            n21 = n22 - this.MORE_ARROW_WIDTH;
                                            n20 = n22 - this.MORE_ARROW_WIDTH / 2;
                                            n19 = n2 - this.MORE_ARROW_PADDING;
                                            n18 = n19 - this.MORE_ARROW_HEIGHT;
                                            nArray3 = new int[]{n20, n21, n22};
                                            nArray = new int[]{n19, n18, n18};
                                            graphics.fillPolygon(nArray3, nArray, 3);
                                            continue block6;
                                        }
                                        ContainedObject containedObject = (ContainedObject)object2[i];
                                        graphics2D.setStroke(basicStroke);
                                        graphics.setColor(level2.getFontObject(EditableFonts.FO_TYPE).getColor());
                                        graphics.setFont(level2.getFontObject(EditableFonts.FO_TYPE).getFont().deriveFont(f));
                                        graphics.drawString("R", 5, n4);
                                        fontMetrics = graphics.getFontMetrics();
                                        n21 = fontMetrics.stringWidth("KD") + 10;
                                        graphics.setColor(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                                        graphics.setFont(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(f));
                                        graphics.drawString(containedObject.getName(), n21, n4);
                                        graphics.drawString(level3.getName(), n21 += fontMetrics.stringWidth((String)object4) + 40, n4);
                                    }
                                }
                            }
                        }
                        if ((objectArray3 = level.getRaggedHLinks().toArray()).length > 0) {
                            for (n8 = 0; n8 < objectArray3.length; ++n8) {
                                RaggedHLink raggedHLink = (RaggedHLink)objectArray3[n8];
                                if (raggedHLink.getChildToParentAttributes().size() <= 0) continue;
                                bl = true;
                                Iterator iterator = raggedHLink.getChildToParentAttributes().iterator();
                                while (iterator.hasNext()) {
                                    object2 = ((DesignObject)iterator.next()).getName();
                                    if (object2.length() <= ((String)object4).length()) continue;
                                    object4 = object2;
                                }
                            }
                            if (bl) {
                                if (n9 == 0) {
                                    graphics.setColor(this.getBorderColor());
                                    graphics2D.setStroke(basicStroke2);
                                    graphics.drawLine(0, n4 += 3 + this.borderWidth, n, n4);
                                }
                                block10: for (n8 = 0; n8 < objectArray3.length; ++n8) {
                                    RaggedHLink raggedHLink = (RaggedHLink)objectArray3[n8];
                                    Level level4 = raggedHLink.getParentLevel();
                                    object2 = raggedHLink.getChildToParentAttributes().toArray();
                                    for (int i = 0; i < ((Object)object2).length; ++i) {
                                        if ((n4 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) > n2 - 1) {
                                            graphics.setColor(this.getBorderColor());
                                            int n23 = n - this.MORE_ARROW_PADDING;
                                            n21 = n23 - this.MORE_ARROW_WIDTH;
                                            n20 = n23 - this.MORE_ARROW_WIDTH / 2;
                                            n19 = n2 - this.MORE_ARROW_PADDING;
                                            n18 = n19 - this.MORE_ARROW_HEIGHT;
                                            nArray3 = new int[]{n20, n21, n23};
                                            nArray = new int[]{n19, n18, n18};
                                            graphics.fillPolygon(nArray3, nArray, 3);
                                            continue block10;
                                        }
                                        ContainedObject containedObject = (ContainedObject)object2[i];
                                        graphics2D.setStroke(basicStroke);
                                        graphics.setColor(level2.getFontObject(EditableFonts.FO_TYPE).getColor());
                                        graphics.setFont(level2.getFontObject(EditableFonts.FO_TYPE).getFont().deriveFont(f));
                                        graphics.drawString("R", 5, n4);
                                        fontMetrics = graphics.getFontMetrics();
                                        n21 = fontMetrics.stringWidth("KD") + 10;
                                        graphics.setColor(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                                        graphics.setFont(level2.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(f));
                                        graphics.drawString(containedObject.getName(), n21, n4);
                                        graphics.drawString(level4.getName(), n21 += fontMetrics.stringWidth((String)object4) + 40, n4);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            int n24 = dimension.width;
            int n25 = dimension.height;
            graphics2D.setPaint(this.getBackgroundColor());
            if (level.isValueBasedHierarchy()) {
                graphics.fillRoundRect(0, 0, n24 - 1, n25 - 1, 20, 20);
                graphics.setColor(this.getBorderColor());
                graphics.drawRoundRect(0, 0, n24 - 1, n25 - 1, 20, 20);
                n = n24 / 6;
                graphics.drawLine(n24 - n, n25 - 1, n24 - 1, n25 - n);
                if (this.icon != null) {
                    this.icon.paintIcon(null, graphics2D, 3, 3);
                }
            } else {
                graphics.fillRect(0, 0, n24 - 1, n25 - 1);
                graphics.setColor(this.getBorderColor());
                graphics.drawRect(0, 0, n24 - 1, n25 - 1);
                n = n24 / 8;
                graphics.drawLine(n24 - n, n25 - 1, n24 - 1, n25 - n);
            }
            Font font = level2.getFontObject(EditableFonts.FO_TITLE).getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n26 = n25 / 2 + font.getSize() / 3;
            int n27 = (n24 - fontMetrics.stringWidth(this.title)) / 2;
            if (n27 < 20) {
                n27 = 20;
            }
            BasicStroke basicStroke = new BasicStroke(1.0f);
            graphics2D.setStroke(basicStroke);
            graphics.setColor(level2.getFontObject(EditableFonts.FO_TITLE).getColor());
            graphics.drawString(this.title, n27, n26);
        }
    }
}

