/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;

public class DimensionDiagramCell
extends MDDiagramCell {
    private JPopupMenu menu;

    public DimensionDiagramCell(AbstractMDObject abstractMDObject) {
        super(abstractMDObject);
    }

    public DimensionDiagramCell(AbstractMDObject abstractMDObject, Map map) {
        super(abstractMDObject, map);
    }

    private void showProperty() {
        this.getMDObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DimensionDiagramCell.this.deleteDimension();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DimensionDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DimensionDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteDimension() {
        Diagram diagram = this.getDiagram();
        ApplicationView applicationView = diagram.getAppView();
        ApplicationView.log(MessageFormat.format(Messages.getString("DimensionDiagramCell.DeleteDimension"), this.getMDObject().getName()));
        TVDimension tVDimension = (TVDimension)this.getTopView();
        tVDimension.remove(true);
    }

    @Override
    public void deleteSelected() {
        this.deleteDimension();
    }
}

