/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class CubeRenderer
extends MDDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 226, 198);
    private int MORE_ARROW_PADDING = 4;
    private int MORE_ARROW_WIDTH = 8;
    private int MORE_ARROW_HEIGHT = 8;

    public CubeRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getMdObject().getDesign().getDLSettings().getDefaultFCObject("Cube");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getMdObject().getDesign().getDLSettings().getDefaultFCObject("Cube");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        Cube cube;
        Cube cube2 = cube = (Cube)this.getMdObject();
        if (this.detailedView) {
            int n = this.borderWidth;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            int n2 = dimension.width - n;
            int n3 = dimension.height - n;
            int[] nArray = new int[]{6, n2, n2, 6};
            int[] nArray2 = new int[]{0, 0, n3 - 6, n3 - 6};
            Polygon polygon = new Polygon(nArray, nArray2, 4);
            graphics2D.setPaint(this.getBackgroundColor());
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getBorderColor());
            graphics2D.setStroke(new BasicStroke(n));
            graphics.drawPolygon(polygon);
            int[] nArray3 = new int[]{0, n2 - 3, n2 - 3, 0};
            int[] nArray4 = new int[]{3, 3, n3 - 3, n3 - 3};
            polygon = new Polygon(nArray3, nArray4, 4);
            graphics2D.setPaint(this.getBackgroundColor());
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getBorderColor());
            graphics.drawPolygon(polygon);
            Font font = cube2.getFontObject(EditableFonts.FO_TITLE).getFont();
            float f = font.getSize2D();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
            int n5 = Math.max(n4, font.getSize());
            int n6 = (n2 - fontMetrics.stringWidth(this.title)) / 2;
            if (n6 < 20) {
                n6 = 20;
            }
            BasicStroke basicStroke = new BasicStroke(1.0f);
            n5 = n4 + 3 + 3;
            BasicStroke basicStroke2 = new BasicStroke(this.borderWidth);
            graphics2D.setStroke(basicStroke);
            graphics.setColor(cube2.getFontObject(EditableFonts.FO_TITLE).getColor());
            graphics.setFont(font);
            graphics.drawString(this.title, n6, n5);
            DesignPartView designPartView = this.getDesignPartView();
            if (designPartView != null && !designPartView.clearDetails() && !designPartView.isShowNamesOnly()) {
                Object object;
                int n7;
                Object object2;
                Object object3;
                if (designPartView.showAllDetails() || designPartView.showKeys()) {
                    graphics2D.setStroke(basicStroke2);
                    graphics.setColor(this.getBorderColor());
                    n5 = (int)((double)n5 + ((double)n5 - (double)n4 / 1.5));
                    graphics.drawLine(0, n5, n2 - 3, n5);
                    graphics2D.setStroke(basicStroke);
                    object3 = "";
                    if (cube != null) {
                        object2 = cube.getFactEntities().iterator();
                        StringBuffer stringBuffer = new StringBuffer();
                        n7 = 1;
                        while (object2.hasNext()) {
                            object = (ContainerObject)object2.next();
                            if (n7 != 0) {
                                stringBuffer.append(((DesignObject)object).getName());
                                n7 = 0;
                                continue;
                            }
                            stringBuffer.append(", ").append(((DesignObject)object).getName());
                        }
                        object3 = stringBuffer.toString();
                    }
                    graphics.setColor(cube2.getFontObject(EditableFonts.FO_FACT_ENTITIES).getColor());
                    graphics.setFont(cube2.getFontObject(EditableFonts.FO_FACT_ENTITIES).getFont());
                    fontMetrics = graphics.getFontMetrics();
                    n4 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                    graphics.drawString((String)object3, 30, n5 += 3 + fontMetrics.getMaxAscent());
                }
                if (designPartView.showAllDetails() || designPartView.showElements()) {
                    Object[] objectArray;
                    Object object4;
                    int n8;
                    graphics.setColor(this.getBorderColor());
                    graphics2D.setStroke(basicStroke2);
                    graphics.drawLine(0, n5 += fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() * 2, n2 - 3, n5);
                    object3 = cube.getMeasures().toArray();
                    object2 = "";
                    for (n8 = 0; n8 < ((Object[])object3).length; ++n8) {
                        String string = ((Measure)object3[n8]).getName();
                        if (string.length() <= ((String)object2).length()) continue;
                        object2 = string;
                    }
                    f = cube2.getFontObject(EditableFonts.FO_MEASURE).getFont().getSize2D();
                    f = Math.max(f, cube2.getFontObject(EditableFonts.FO_MEASURE_TYPE).getFont().getSize2D());
                    f = Math.max(f, cube2.getFontObject(EditableFonts.FO_FUNCTION).getFont().getSize2D());
                    graphics.setFont(cube2.getFontObject(EditableFonts.FO_MEASURE).getFont().deriveFont(f));
                    fontMetrics = graphics.getFontMetrics();
                    n4 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                    for (n8 = 0; n8 < ((Object[])object3).length; ++n8) {
                        int n9;
                        int n10;
                        if ((n5 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) > n3 - 3) {
                            graphics.setColor(this.getBorderColor());
                            n7 = n2 - this.MORE_ARROW_PADDING;
                            int n11 = n7 - this.MORE_ARROW_WIDTH;
                            n10 = n7 - this.MORE_ARROW_WIDTH / 2;
                            n9 = n3 - this.MORE_ARROW_PADDING;
                            int n12 = n9 - this.MORE_ARROW_HEIGHT;
                            int[] nArray5 = new int[]{n10, n11, n7};
                            object4 = new int[]{n9, n12, n12};
                            graphics.fillPolygon(nArray5, (int[])object4, 3);
                            break;
                        }
                        Measure measure = (Measure)object3[n8];
                        graphics2D.setStroke(basicStroke);
                        graphics.setColor(cube2.getFontObject(EditableFonts.FO_MEASURE_TYPE).getColor());
                        graphics.setFont(cube2.getFontObject(EditableFonts.FO_MEASURE_TYPE).getFont().deriveFont(f));
                        object = measure.isFormula() ? "FX" : "A ";
                        graphics.drawString((String)object, 5, n5);
                        fontMetrics = graphics.getFontMetrics();
                        n10 = fontMetrics.stringWidth("FX") + 10;
                        graphics.setColor(cube2.getFontObject(EditableFonts.FO_MEASURE).getColor());
                        graphics.setFont(cube2.getFontObject(EditableFonts.FO_MEASURE).getFont().deriveFont(f));
                        graphics.drawString(measure.getName(), n10, n5);
                        fontMetrics = graphics.getFontMetrics();
                        n10 += fontMetrics.stringWidth((String)object2) + 20;
                        if (measure.getDefaultAggregationFunction() != null) {
                            graphics.setColor(cube2.getFontObject(EditableFonts.FO_FUNCTION).getColor());
                            graphics.setFont(cube2.getFontObject(EditableFonts.FO_FUNCTION).getFont().deriveFont(f));
                            n9 = measure.getDefaultAggregationFunction().name.length();
                            n9 = Math.min(n9, 5);
                            String string = measure.getDefaultAggregationFunction().name.substring(0, n9);
                            if (measure.getDefaultAggregationFunction().name.length() > 0) {
                                graphics.drawString(string, n10, n5);
                            }
                        }
                        fontMetrics = graphics.getFontMetrics();
                        n10 += fontMetrics.stringWidth("MMMMM");
                        if (!measure.isFormula() || measure.getFormula() == null) continue;
                        graphics.setColor(cube2.getFontObject(EditableFonts.FO_FORMULA).getColor());
                        graphics.setFont(cube2.getFontObject(EditableFonts.FO_FORMULA).getFont().deriveFont(f));
                        graphics.drawString(measure.getFormula(), n10, n5);
                    }
                    if ((objectArray = cube.getOutgoingLinks().toArray()).length > 0) {
                        int n13;
                        n7 = 0;
                        for (n13 = 0; n13 < objectArray.length; ++n13) {
                            Link link = (Link)objectArray[n13];
                            if (link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                            n7 = 1;
                            break;
                        }
                        if (n7 != 0) {
                            object3 = cube.getAllJoinAttributes().toArray();
                            for (n13 = 0; n13 < ((Object[])object3).length; ++n13) {
                                String string = ((DesignObject)object3[n13]).getName();
                                if (string.length() <= ((String)object2).length()) continue;
                                object2 = string;
                            }
                            graphics.setColor(this.getBorderColor());
                            graphics2D.setStroke(basicStroke2);
                            n5 += n5 / 16;
                            graphics.drawLine(0, n5, n2 - 2, n5);
                            block5: for (n13 = 0; n13 < objectArray.length; ++n13) {
                                int n14;
                                RollupLink rollupLink = ((Link)objectArray[n13]).getRollupLink();
                                oracle.dbtools.crest.model.design.multidimensional.Dimension dimension2 = (oracle.dbtools.crest.model.design.multidimensional.Dimension)((Link)objectArray[n13]).getTargetMDObject();
                                Object[] objectArray2 = rollupLink.getChildToParentAttributes().toArray();
                                object2 = "";
                                for (n14 = 0; n14 < objectArray2.length; ++n14) {
                                    object4 = ((ContainedObject)objectArray2[n14]).getName();
                                    if (((String)object4).length() <= ((String)object2).length()) continue;
                                    object2 = object4;
                                }
                                for (n14 = 0; n14 < objectArray2.length; ++n14) {
                                    int n15;
                                    f = cube2.getFontObject(EditableFonts.FO_CHILD_TO_PARENT).getFont().getSize2D();
                                    graphics.setColor(cube2.getFontObject(EditableFonts.FO_MEASURE_TYPE).getColor());
                                    graphics.setFont(cube2.getFontObject(EditableFonts.FO_MEASURE_TYPE).getFont().deriveFont(f));
                                    fontMetrics = graphics.getFontMetrics();
                                    if ((n5 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) > n3 - 3) {
                                        graphics.setColor(this.getBorderColor());
                                        int n16 = n2 - this.MORE_ARROW_PADDING;
                                        n15 = n16 - this.MORE_ARROW_WIDTH;
                                        int n17 = n16 - this.MORE_ARROW_WIDTH / 2;
                                        int n18 = n3 - this.MORE_ARROW_PADDING;
                                        int n19 = n18 - this.MORE_ARROW_HEIGHT;
                                        int[] nArray6 = new int[]{n17, n15, n16};
                                        int[] nArray7 = new int[]{n18, n19, n19};
                                        graphics.fillPolygon(nArray6, nArray7, 3);
                                        continue block5;
                                    }
                                    object4 = (ContainedObject)objectArray2[n14];
                                    graphics2D.setStroke(basicStroke);
                                    graphics.drawString("R", 5, n5);
                                    graphics.setColor(cube2.getFontObject(EditableFonts.FO_CHILD_TO_PARENT).getColor());
                                    graphics.setFont(cube2.getFontObject(EditableFonts.FO_CHILD_TO_PARENT).getFont());
                                    fontMetrics = graphics.getFontMetrics();
                                    n15 = fontMetrics.stringWidth("FX") + 10;
                                    graphics.drawString(((ContainedObject)object4).getName(), n15, n5);
                                    graphics.setColor(cube2.getFontObject(EditableFonts.FO_FUNCTION).getColor());
                                    graphics.setFont(cube2.getFontObject(EditableFonts.FO_FUNCTION).getFont().deriveFont(f));
                                    fontMetrics = graphics.getFontMetrics();
                                    n15 += fontMetrics.stringWidth((String)object2) + 10;
                                    if (rollupLink.isRolePlaying()) {
                                        graphics.drawString(rollupLink.getName(), n15, n5);
                                        continue;
                                    }
                                    graphics.drawString(dimension2.getName(), n15, n5);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            int n = this.borderWidth;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            int n20 = dimension.width - n;
            int n21 = dimension.width / 2;
            int[] nArray = new int[]{n21, n20 - 3, n21, 3};
            int[] nArray8 = new int[]{0, n21 - 3, n20, n21 - 3};
            Polygon polygon = new Polygon(nArray, nArray8, 4);
            graphics.setColor(this.getBackgroundColor());
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getBorderColor());
            graphics2D.setStroke(new BasicStroke(n));
            graphics.drawPolygon(polygon);
            int[] nArray9 = new int[]{6, n21 + 3, n20, n21 + 3};
            polygon = new Polygon(nArray, nArray9, 4);
            graphics2D.setPaint(this.getBackgroundColor());
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getBorderColor());
            graphics.drawPolygon(polygon);
            Font font = cube2.getFontObject(EditableFonts.FO_TITLE).getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n22 = n20 / 2 + 8;
            int n23 = (n20 - fontMetrics.stringWidth(this.title)) / 2;
            if (n23 < 20) {
                n23 = 20;
            }
            BasicStroke basicStroke = new BasicStroke(1.0f);
            graphics2D.setStroke(basicStroke);
            graphics.setColor(cube2.getFontObject(EditableFonts.FO_TITLE).getColor());
            graphics.drawString(this.title, n23, n22);
        }
    }
}

