/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class RelationEdge
extends DefaultEdge {
    private JPopupMenu menu = null;
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        this.point.setLocation(point);
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
                if (this.selectedObjects.length > 1) {
                    this.menu.add(new AbstractAction(DELETE_OBJECTS){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DefaultDiagramCell.deleteObjects(RelationEdge.this.selectedObjects, RelationEdge.this.getDiagram().getAppView());
                        }
                    });
                } else {
                    this.menu.add(new AbstractAction(DELETE){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            RelationEdge.this.deleteRelation();
                        }
                    });
                }
                this.menu.addSeparator();
                this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RelationEdge.this.straightenLine();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RelationEdge.this.format();
                    }
                });
                this.menu.addSeparator();
                this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RelationEdge.this.addBreakpoint(RelationEdge.this.point);
                    }
                });
                this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RelationEdge.this.removeBreakpoint(RelationEdge.this.point);
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RelationEdge.this.showProperty();
                }
            });
        }
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute() && this.onlyEdgesAreSelected());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean bl = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!bl);
                this.miRemoveBP.setEnabled(bl);
            }
        }
        return this.menu;
    }

    public Relation getRelation() {
        return (Relation)this.getTopView().getModel();
    }

    private boolean isReadonly() {
        Relation relation = (Relation)this.getTopView().getModel();
        return relation.getTargetEntity() != null && relation.getTargetEntity().isReadOnly() || relation.getSourceEntity() != null && relation.getSourceEntity().isReadOnly();
    }

    @Override
    public String getName() {
        if (this.getTopView() != null) {
            return this.getRelation().getName();
        }
        return "";
    }

    public void deleteRelation() {
        Relation relation = this.getRelation();
        TVConnector tVConnector = (TVConnector)this.getTopView();
        if (tVConnector.remove(relation)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("RelationEdge.RemoveRelation"), relation.getName()));
        }
    }

    public String getSourceCardinality() {
        return this.getRelation().getSourceCardinality().toString();
    }

    public String getSourceName() {
        return this.getRelation().getNameOnSource();
    }

    public String getTargetCardinality() {
        return this.getRelation().getTargetCardinality().toString();
    }

    public String getTargetName() {
        return this.getRelation().getNameOnTarget();
    }

    public String getSourceLabel() {
        return this.getSourceName() != null ? this.getSourceName() : "";
    }

    public String getTargetLabel() {
        return this.getTargetName() != null ? this.getTargetName() : "";
    }

    @Override
    public void deleteSelected() {
        this.deleteRelation();
    }
}

