/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class EntityViewRenderer
extends ContainerRenderer {
    public static final int COLUMN_LEFT = 10;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 155, 106);
    public static final Color DEFAULT_DATATYPE_COLOR = Color.BLUE;
    protected static final Icon ERROR_ICON = GUIConfiguration.getInstance().getIcon("ERROR_ICON");
    protected static final Icon WARNING_RED_ICON = GUIConfiguration.getInstance().getIcon("WARNING_RED_ICON");
    protected static final Icon WARNING_YELLOW_ICON = GUIConfiguration.getInstance().getIcon("WARNING_YELLOW_ICON");

    public EntityViewRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Logical View");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackgroundColor();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.container.getDesign().getDLSettings().getDefaultFCObject("Logical View");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getElementsColor() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_ATTRIBUTE).getColor();
        }
        return super.getElementsColor();
    }

    @Override
    protected Font getElementsFont() {
        if (this.container instanceof EditableFonts) {
            return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_ATTRIBUTE).getFont();
        }
        return super.getElementsFont();
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        EditableFonts editableFonts = (EditableFonts)((Object)this.container);
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
        graphics.setColor(this.getBorderColor());
        graphics.drawRoundRect(0, 0, n - 1, n2 - 1, 40, 40);
        Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        int n4 = Math.max(n3, font.getSize());
        int n5 = (n - fontMetrics.stringWidth(this.title)) / 2;
        if (n5 < 20) {
            n5 = 20;
        }
        boolean bl = ((AbstractView)this.container).isValidSQL();
        boolean bl2 = ((AbstractView)this.container).isParsed();
        boolean bl3 = ((AbstractView)this.container).isIncorrectSQL();
        Icon icon = null;
        if (bl3) {
            icon = ERROR_ICON;
        } else if (!bl) {
            icon = WARNING_RED_ICON;
        } else if (!bl2) {
            icon = WARNING_YELLOW_ICON;
        }
        if (icon != null) {
            icon.paintIcon(this, graphics, 10, n4 - 8);
        }
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        BasicStroke basicStroke2 = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke2);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont());
        String[] stringArray = EntityViewRenderer.wrapText(this.title, EntityViewRenderer.getMaxChars(this.title, fontMetrics, n - 20 - 5));
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            graphics.drawString((String)object, n5, n4);
            n4 += n3;
        }
        n4 -= n3;
        DesignPartView designPartView = this.getDesignPartView();
        if (designPartView != null && !designPartView.clearDetails() && !designPartView.isShowNamesOnly()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getBorderColor());
            graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
            if (designPartView.showAllDetails() || designPartView.showElements()) {
                List list;
                int n6;
                Object object2;
                Object object3;
                Object object42;
                Object object5;
                if (this.container.isBST() && this.container.getTypeSubstitution() != null) {
                    object = this.container.getTypeSubstitution();
                    object5 = ((TypeSubstitution)object).getParentContainerObject();
                    if (object5 != null) {
                        // empty if block
                    }
                    if ((object42 = this.container.getBasedOnStructuredType()) != null) {
                        object3 = ((StructuredType)object42).getElements();
                        object2 = this.getLongestTypeName((TypeElement[])object3);
                        graphics.setFont(this.getElementsFont());
                        fontMetrics = graphics.getFontMetrics();
                        n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                        for (int i = 0; i < ((TypeElement[])object3).length; ++i) {
                            TypeElement typeElement = object3[i];
                            graphics.setColor(this.getElementsColor());
                            graphics.setFont(this.getElementsFont());
                            float f = this.getElementsFont().getSize2D();
                            graphics.drawString(typeElement.getName(), 10, n4 += 3 + fontMetrics.getMaxAscent());
                            fontMetrics = graphics.getFontMetrics();
                            n6 = fontMetrics.stringWidth((String)object2) + 20;
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                            graphics.drawString(typeElement.getDataType(), n6, n4);
                            graphics.setColor(this.getForeground());
                        }
                    }
                } else {
                    graphics2D.setStroke(basicStroke2);
                    float f = this.getElementsFont().getSize2D();
                    object5 = ((EntityView)this.container).getElements();
                    object42 = this.getLongestName((ContainedObject[])object5);
                    graphics.setFont(this.getElementsFont());
                    fontMetrics = graphics.getFontMetrics();
                    n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                    for (int i = 0; i < ((ContainedObject[])object5).length; ++i) {
                        object2 = (AttributeView)object5[i];
                        n4 += 3 + fontMetrics.getMaxAscent();
                        String string = ((AbstractViewElement)object2).getAlias();
                        if (string == null || "".equalsIgnoreCase(string)) {
                            string = ((ContainedObject)object2).getName();
                        }
                        graphics.setFont(this.getElementsFont());
                        graphics.setColor(this.getElementsColor());
                        graphics.drawString(string, 10, n4);
                        fontMetrics = graphics.getFontMetrics();
                        int n7 = fontMetrics.stringWidth((String)object42) + 20;
                        if (designPartView.showAllDetails() || designPartView.showDatatype()) {
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            graphics.drawString(this.getDataType((AttributeView)object2), n7, n4);
                        }
                        graphics.setColor(this.getForegroundColor());
                        if (n4 <= n2) continue;
                        graphics.setColor(this.getBorderColor());
                        int n8 = n - 4;
                        n6 = n8 - 8;
                        int n9 = n8 - 4;
                        int n10 = n2 - 4;
                        int n11 = n10 - 8;
                        int[] nArray = new int[]{n9, n6, n8};
                        int[] nArray2 = new int[]{n10, n11, n11};
                        graphics.fillPolygon(nArray, nArray2, 3);
                        break;
                    }
                }
                if (designPartView.showAllDetails() && (list = ((EntityView)this.container).getUsedTablesAndViews()).size() > 0) {
                    graphics2D.setStroke(basicStroke);
                    graphics.setColor(this.getBorderColor());
                    graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
                    graphics.setFont(this.getElementsFont());
                    graphics.setColor(this.getElementsColor());
                    for (Object object42 : list) {
                        object3 = ((SQLNameHelper)object42).getTableName();
                        graphics.drawString((String)object3, 10, n4 += 3 + fontMetrics.getMaxAscent());
                    }
                }
            }
        }
    }

    @Override
    protected String getLongestTypeName(TypeElement[] typeElementArray) {
        String string = "";
        for (int i = 0; i < typeElementArray.length; ++i) {
            String string2 = typeElementArray[i].getName();
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }

    private String getDataType(AttributeView attributeView) {
        if (attributeView.getReferencedAttribute() != null && ("Aggregate".equalsIgnoreCase(attributeView.getReferencedAttribute().getSourceType()) || "Derived".equalsIgnoreCase(attributeView.getReferencedAttribute().getSourceType()) && attributeView.getReferencedAttribute().getFormulaDesc() != null && attributeView.getReferencedAttribute().getFormulaDesc().length() > 0)) {
            return attributeView.getReferencedAttribute().getFormulaDesc();
        }
        return attributeView.getDataType();
    }

    @Override
    protected String getLongestName(ContainedObject[] containedObjectArray) {
        String string = "";
        for (int i = 0; i < containedObjectArray.length; ++i) {
            String string2 = ((AttributeView)containedObjectArray[i]).getAlias();
            if (string2 == null || "".equalsIgnoreCase(string2)) {
                string2 = ((AttributeView)containedObjectArray[i]).getReferencedName();
            }
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }
}

