/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.logical.TVEntityView;

public class EntityViewDiagramCell
extends ContainerDiagramCell {
    private JMenuItem miDeleteView;

    public EntityViewDiagramCell(ContainerObject containerObject) {
        super(containerObject);
    }

    public EntityViewDiagramCell(ContainerObject containerObject, Map map) {
        super(containerObject, map);
    }

    private void showProperty() {
        this.getContainer().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (this.isEditable() && this.selectedObjects.length == 1) {
            if (this.getTopView().canRemove()) {
                this.miDeleteView.setEnabled(true);
            } else {
                this.miDeleteView.setEnabled(false);
            }
        }
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(CREATE_SYNONYM){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewDiagramCell.this.getTopView().createViewSynonim(EntityViewDiagramCell.this.getDiagram().getAppView().getCurrentDPV());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewDiagramCell.this.getContainer().getAppView().clearCopiedObjects();
                    EntityViewDiagramCell.access$002(EntityViewDiagramCell.this, EntityViewDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < EntityViewDiagramCell.this.selectedObjects.length; ++i) {
                        if (!(EntityViewDiagramCell.this.selectedObjects[i] instanceof DesignObject)) continue;
                        EntityViewDiagramCell.this.getContainer().getAppView().addCopiedObject((DesignObject)EntityViewDiagramCell.this.selectedObjects[i]);
                    }
                }
            });
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultDiagramCell.deleteObjects(EntityViewDiagramCell.this.selectedObjects, EntityViewDiagramCell.this.getDiagram().getAppView());
                    }
                });
                if (!this.getDiagram().getDesignPartView().isMainDiagram()) {
                    this.menu.add(new AbstractAction(DELETE_VIEWS){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            EntityViewDiagramCell.this.getDiagram().getDesignPartView().removeTopViewsWithUndo(EntityViewDiagramCell.this.getDiagram().getSelectionCells());
                        }
                    });
                }
            } else {
                this.menu.add(new AbstractAction(DELETE_OBJECT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EntityViewDiagramCell.this.deleteView();
                    }
                });
                this.miDeleteView = this.menu.add(new AbstractAction(DELETE_VIEW){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EntityViewDiagramCell.this.getTopView().getDesignPartView().postTopViewRemove(EntityViewDiagramCell.this.getTopView());
                        ((ContainerView)EntityViewDiagramCell.this.getTopView()).remove(false);
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewDiagramCell.this.getTopView().sendToBack();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESIZE_TO_VISIBLE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityViewDiagramCell.this.getTopView().getDesignPartView().resizeSelectedObjects();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityViewDiagramCell.this.showProperty();
            }
        });
        return this.menu;
    }

    public void deleteView() {
        TVEntityView tVEntityView = (TVEntityView)this.getTopView();
        ApplicationView.log(MessageFormat.format(Messages.getString("EntityViewDiagramCell.DeleteView"), tVEntityView.getModel().getName()));
        tVEntityView.remove();
    }

    @Override
    public void deleteSelected() {
        ((ContainerView)this.getTopView()).remove();
    }

    static /* synthetic */ Object[] access$002(EntityViewDiagramCell entityViewDiagramCell, Object[] objectArray) {
        entityViewDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }
}

