/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.logical.TVEntity;

public class EntityDiagramCell
extends ContainerDiagramCell {
    private JMenuItem miPaste;
    private JMenuItem miSelectNeighbors;
    private JMenuItem miDeleteView;
    private JMenuItem miDeleteObject;

    public EntityDiagramCell(ContainerObject containerObject) {
        super(containerObject);
    }

    public EntityDiagramCell(ContainerObject containerObject, Map map) {
        super(containerObject, map);
    }

    private void showProperty() {
        this.getContainer().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (this.isEditable() && this.selectedObjects.length == 1) {
            if (this.getTopView().canRemove()) {
                this.miDeleteView.setEnabled(true);
            } else {
                this.miDeleteView.setEnabled(false);
            }
        }
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(CREATE_SYNONYM){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.this.getTopView().createViewSynonim(EntityDiagramCell.this.getDiagram().getAppView().getCurrentDPV());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                }
            });
            this.menu.addSeparator();
            this.miSelectNeighbors = this.menu.add(new AbstractAction(SELECT_NEIGHBORS){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.this.getTopView().getDesignPartView().selectNeighbors(EntityDiagramCell.this.getContainer());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.this.getContainer().getAppView().clearCopiedObjects();
                    EntityDiagramCell.access$002(EntityDiagramCell.this, EntityDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < EntityDiagramCell.this.selectedObjects.length; ++i) {
                        if (!(EntityDiagramCell.this.selectedObjects[i] instanceof DesignObject)) continue;
                        EntityDiagramCell.this.getContainer().getAppView().addCopiedObject((DesignObject)EntityDiagramCell.this.selectedObjects[i]);
                    }
                }
            });
            this.miPaste = this.menu.add(new AbstractAction(PASTE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.access$402(EntityDiagramCell.this, EntityDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < EntityDiagramCell.this.selectedObjects.length; ++i) {
                        ((ContainerObject)EntityDiagramCell.this.selectedObjects[i]).paste();
                    }
                }
            });
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultDiagramCell.deleteObjects(EntityDiagramCell.this.selectedObjects, EntityDiagramCell.this.getDiagram().getAppView());
                    }
                });
                if (!this.getDiagram().getDesignPartView().isMainDiagram()) {
                    this.menu.add(new AbstractAction(DELETE_VIEWS){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            EntityDiagramCell.this.getDiagram().getDesignPartView().removeTopViewsWithUndo(EntityDiagramCell.this.getDiagram().getSelectionCells());
                        }
                    });
                }
            } else {
                this.miDeleteObject = this.menu.add(new AbstractAction(DELETE_OBJECT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EntityDiagramCell.this.deleteEntity();
                    }
                });
                this.miDeleteView = this.menu.add(new AbstractAction(DELETE_VIEW){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EntityDiagramCell.this.getTopView().getDesignPartView().postTopViewRemove(EntityDiagramCell.this.getTopView());
                        EntityDiagramCell.this.getTopView().getDesignPartView().unregisterFromTreemodel(EntityDiagramCell.this.getTopView());
                        ((ContainerView)EntityDiagramCell.this.getTopView()).remove(false);
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.this.getTopView().sendToBack();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESIZE_TO_VISIBLE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntityDiagramCell.this.getTopView().getDesignPartView().resizeSelectedObjects();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityDiagramCell.this.showProperty();
            }
        });
        if (this.isEditable()) {
            this.miPaste.setEnabled(this.getContainer().canPaste());
            this.miSelectNeighbors.setEnabled(this.enableSelectNeighbors());
            this.setEnabled(this.miDeleteObject, this.canDeleteModelObject());
        } else {
            this.setEnabled(this.miPaste, false);
            this.setEnabled(this.miDeleteObject, false);
        }
        return this.menu;
    }

    private boolean enableSelectNeighbors() {
        Entity entity = (Entity)this.getContainer();
        List list = entity.getRelations();
        for (Relation relation : list) {
            if (relation instanceof InheritanceRelation || relation.getSourceEntity() == relation.getTargetEntity()) continue;
            return true;
        }
        return false;
    }

    public void deleteEntity() {
        this.deleteSelected();
    }

    @Override
    public void deleteSelected() {
        ((TVEntity)this.getTopView()).remove(MessageFormat.format(Messages.getString("EntityDiagramCell.DeleteEntity"), this.getContainer().getName()));
    }

    static /* synthetic */ Object[] access$002(EntityDiagramCell entityDiagramCell, Object[] objectArray) {
        entityDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] access$402(EntityDiagramCell entityDiagramCell, Object[] objectArray) {
        entityDiagramCell.selectedObjects = objectArray;
        return objectArray;
    }
}

