/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class PortRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient AbstractDiagram diagram;
    protected transient PortView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;

    public PortRenderer() {
        this.setForeground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setBackground(UIManager.getColor("Tree.selectionBorderColor"));
    }

    @Override
    public Color getBGColor() {
        return this.getBackground();
    }

    @Override
    public Color getFGColor() {
        return this.getForeground();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof PortView && abstractDiagram != null) {
            this.diagram = abstractDiagram;
            this.view = (PortView)cellView;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            return this;
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.diagram.getBackground());
        graphics.setXORMode(this.diagram.getBackground());
        if (this.preview) {
            graphics.setColor(this.getBackground());
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
            graphics.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
        }
        boolean bl = DiagramConstants.getOffset(this.view.getAllAttributes()) != null;
        graphics.setColor(this.getForeground());
        if (bl) {
            graphics.fillRect(2, 2, dimension.width - 3, dimension.height - 3);
        } else if (!this.preview) {
            graphics.drawRect(1, 1, dimension.width - 4, dimension.height - 4);
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("text".equals(string)) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

