/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;

public class NoteDiagramCell
extends DefaultDiagramCell {
    private JPopupMenu menu;
    private Note note;

    public NoteDiagramCell(Note note) {
        this(note, DiagramConstants.createMap());
    }

    public NoteDiagramCell(Note note, Map map) {
        this.note = note;
        this.setAttributes(map);
        DiagramConstants.setValue(this.getAttributes(), note.getName());
    }

    private void showProperty() {
        this.getNote().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultDiagramCell.deleteObjects(NoteDiagramCell.this.selectedObjects, NoteDiagramCell.this.getDiagram().getAppView());
                    }
                });
            } else {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NoteDiagramCell.this.deleteNote();
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NoteDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NoteDiagramCell.this.showProperty();
            }
        });
        return this.menu;
    }

    public Note getNote() {
        return this.note;
    }

    public void deleteNote() {
        Note note = this.getNote();
        ApplicationView.log(MessageFormat.format(Messages.getString("NoteDiagramCell.DeleteNote"), note.getName()));
        note.getDesignPart().postNoteRemoveEdit(note);
        note.remove();
    }

    @Override
    public void deleteSelected() {
        this.deleteNote();
    }
}

