/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.BasicMarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.logical.ArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcDiagramCell;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;

public class MarqueeHandler
extends BasicMarqueeHandler {
    protected AbstractDiagram diagram;

    public MarqueeHandler(AbstractDiagram abstractDiagram) {
        this.diagram = abstractDiagram;
    }

    @Override
    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        Object object = this.diagram.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
        Diagram diagram = (Diagram)this.diagram;
        if (object != null) {
            if (diagram.getDrawnObjectID() == 6) {
                return true;
            }
            if (!(object instanceof DefaultEdge || object instanceof ArcDiagramCell || object instanceof FKArcDiagramCell)) {
                oracle.dbtools.crest.swingui.diagram.logical.EntityView entityView;
                this.diagram.getDiagramLayoutCache().toFront(new Object[]{object});
                if (object instanceof EntityDiagramCell && diagram.getDesignPartView().isBoxInBox() && (entityView = (oracle.dbtools.crest.swingui.diagram.logical.EntityView)((EntityDiagramCell)object).getCellView()).isParent()) {
                    entityView.toFront();
                }
            }
            if (!mouseEvent.isShiftDown() && !SwingUtilities.isRightMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent) && this.diagram.getSelectionCells().length <= 1) {
                if (((DefaultDiagramCell)object).getTopView() != null) {
                    ((DefaultDiagramCell)object).getTopView().makeSelected();
                }
                if (mouseEvent.getClickCount() == 2 && object instanceof DefaultDiagramCell) {
                    ((DefaultDiagramCell)object).doubleClick();
                }
            }
            diagram.LabelsToFront();
        } else if (diagram.getAppView().getCurrentDPV() != null) {
            diagram.getAppView().getCurrentDPV().setCurrentSelection(null);
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return true;
        }
        return super.isForceMarqueeEvent(mouseEvent);
    }

    private boolean drawLine() {
        Diagram diagram = (Diagram)this.diagram;
        return diagram.getDrawnObjectID() == 1 || diagram.getDrawnObjectID() == 3;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.start != null && !mouseEvent.isConsumed()) {
            Graphics graphics = this.diagram.getGraphics();
            this.paintConnector(Color.black, this.diagram.getBackground(), graphics);
            this.paintConnector(this.diagram.getBackground(), Color.black, graphics);
            mouseEvent.consume();
        }
        super.mouseDragged(mouseEvent);
    }

    public PortView getSourcePortAt(Point2D point2D) {
        Point2D point2D2 = this.diagram.fromScreen(DiagramConstants.createPoint(point2D));
        return this.diagram.getPortViewAt(point2D2.getX(), point2D2.getY());
    }

    protected PortView getTargetPortAt(Point2D point2D) {
        Object object = this.diagram.getFirstCellForLocation(point2D.getX(), point2D.getY());
        for (int i = 0; i < this.diagram.getModel().getChildCount(object); ++i) {
            Object object2 = this.diagram.getModel().getChild(object, i);
            object2 = this.diagram.getDiagramLayoutCache().getMapping(object2, false);
            if (!(object2 instanceof PortView) || object2 == this.firstPort) continue;
            return (PortView)object2;
        }
        return this.getSourcePortAt(point2D);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        Diagram diagram = (Diagram)this.diagram;
        if (!SwingUtilities.isRightMouseButton(mouseEvent) && diagram.getDrawnObjectID() == 6) {
            object = this.diagram.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (object instanceof DefaultDiagramCell && !ApplicationView.IS_VIEWER) {
                ((DefaultDiagramCell)object).deleteSelected();
            }
            mouseEvent.consume();
        } else if (!this.drawLine() && (object = this.diagram.fromScreen(DiagramConstants.createRect(this.marqueeBounds))) != null) {
            this.createObject(((RectangularShape)object).getBounds());
            mouseEvent.consume();
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            object = this.diagram.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (object != null && object instanceof DefaultDiagramCell) {
                ((DefaultDiagramCell)object).showPopupMenu(mouseEvent.getPoint());
            } else {
                ((Diagram)this.diagram).setDrawnObjectID(-1);
                ((Diagram)this.diagram).setCursor(new Cursor(0));
                ((Diagram)this.diagram).getDesignPartView().getController().select_SelectAction();
                ((Diagram)this.diagram).showPopupMenu(mouseEvent.getPoint());
            }
        }
        this.diagram.repaint();
        this.port = null;
        this.firstPort = null;
        this.current = null;
        this.start = null;
        super.mouseReleased(mouseEvent);
    }

    private void createObject(Rectangle rectangle) {
        Diagram diagram = (Diagram)this.diagram;
        ApplicationView applicationView = diagram.getAppView();
        switch (diagram.getDrawnObjectID()) {
            case 0: {
                this.addEntity(diagram, applicationView, rectangle);
                break;
            }
            case 19: {
                this.addEntityView(diagram, applicationView, rectangle);
                break;
            }
            case 2: {
                this.addTable(diagram, applicationView, rectangle);
                break;
            }
            case 4: {
                this.addView(diagram, applicationView, rectangle);
                break;
            }
            case 5: {
                this.addNote(diagram, applicationView, rectangle);
                break;
            }
            case 7: {
                this.addProcess(diagram, applicationView, rectangle);
                break;
            }
            case 15: {
                this.addTransformation(diagram, applicationView, rectangle);
                break;
            }
            case 8: {
                this.addAgent(diagram, applicationView, rectangle);
                break;
            }
            case 9: {
                this.addStore(diagram, applicationView, rectangle);
                break;
            }
            case 11: {
                this.addCube(diagram, applicationView, rectangle);
                break;
            }
            case 12: {
                this.addLevel(diagram, applicationView, rectangle);
                break;
            }
            case 13: {
                this.addDimension(diagram, applicationView, rectangle);
                break;
            }
            case 17: {
                this.addStructuredType(diagram, applicationView, rectangle);
            }
        }
    }

    private void addEntity(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateEntity"));
        Entity entity = ((LogicalDesign)applicationView.getCurrentDPV().getDesignPart()).createEntity();
        TopView topView = applicationView.getCurrentDPV().getViewFor(entity);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 170;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 110;
            }
            topView.getCellView().setNewBounds(rectangle, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        entity.showPropertyDialogOnNew();
    }

    private void addEntityView(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateView"));
        EntityView entityView = ((LogicalDesign)applicationView.getCurrentDPV().getDesignPart()).getEntityViewSet().createEntityView(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(entityView);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 170;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 110;
            }
            topView.getCellView().setNewBounds(rectangle, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        entityView.showPropertyDialogOnNew();
    }

    private void addTable(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateTable"));
        RelationalDesign relationalDesign = (RelationalDesign)applicationView.getCurrentDPV().getDesignPart();
        Table table = relationalDesign.createTable();
        TopView topView = applicationView.getCurrentDPV().getViewFor(table);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 170;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 110;
            }
            topView.getCellView().setNewBounds(rectangle, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        if (table.getDesign().getAppView().getSettings().showPropertiesDialogOnNew()) {
            table.showPropertyDialogOnNew();
        } else if (table.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
            relationalDesign.postTableCreateEdit(table);
        }
    }

    private void addView(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateView"));
        TableView tableView = ((RelationalDesign)applicationView.getCurrentDPV().getDesignPart()).getTableViewSet().createTableView(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(tableView);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 170;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 110;
            }
            topView.getCellView().setNewBounds(rectangle, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        tableView.showPropertyDialogOnNew();
    }

    private void addProcess(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateProcess"));
        Process process = ((DataFlowDesign)applicationView.getCurrentDPV().getDesignPart()).getProcessSet().createProcess(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(process);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 130;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 90;
            }
            topView.getCellView().setNewBounds(rectangle, false);
        }
        process.showPropertyDialogOnNew();
    }

    private void addTransformation(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateProcess"));
        Transformation transformation = ((TransformationTask)applicationView.getCurrentDPV().getDesignPart()).getTransformationSet().createTransformation(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(transformation);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 130;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 90;
            }
            topView.getCellView().setNewBounds(rectangle, false);
        }
        transformation.showPropertyDialogOnNew();
    }

    private void addAgent(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateExternalAgent"));
        ExternalAgent externalAgent = ((DataFlowDesign)applicationView.getCurrentDPV().getDesignPart()).getExternalAgentSet().createExternalAgent(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(externalAgent);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 80;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 80;
            }
            topView.getCellView().setNewBounds(rectangle, false);
        }
        externalAgent.showPropertyDialogOnNew();
    }

    private void addStore(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateInformationStore"));
        InfoStore infoStore = applicationView.getCurrentDPV().getDesignPart() instanceof TransformationTask ? ((TransformationTask)applicationView.getCurrentDPV().getDesignPart()).getInfoStoreSet().createInfoStore(null) : ((DataFlowDesign)applicationView.getCurrentDPV().getDesignPart()).getInfoStoreSet().createInfoStore(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(infoStore);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 140;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 30;
            }
            topView.getCellView().setNewBounds(rectangle, false);
        }
        infoStore.showPropertyDialogOnNew();
    }

    private void addCube(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateCube"));
        Cube cube = ((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).getCubeSet().createCube(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(cube);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 170;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 110;
            }
            topView.getCellView().setNewBounds(rectangle, false);
            if (!(applicationView.getCurrentDPV() instanceof DPVCompactMultidimentional)) {
                AbstractMDTV abstractMDTV = (AbstractMDTV)((ContainerView)topView).createViewSynonim(((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).getCompactDiagram(), false);
                if (abstractMDTV.getCellView() != null) {
                    int n;
                    Rectangle rectangle2 = abstractMDTV.getBounds();
                    rectangle2.width = n = Math.min(rectangle2.width, rectangle2.height);
                    rectangle2.height = n;
                    abstractMDTV.getCellView().setNewBounds(rectangle2);
                }
            } else {
                int n;
                Rectangle rectangle3 = topView.getBounds();
                rectangle3.width = n = Math.min(rectangle3.width, rectangle3.height);
                rectangle3.height = n;
                topView.getCellView().setNewBounds(rectangle3);
                TopView topView2 = cube.getFirstViewForDPV(cube.getDesign().getMultidimensionalDesign().getMainView());
                if (topView2 != topView && topView2.getCellView() != null) {
                    Rectangle rectangle4 = topView2.getBounds();
                    rectangle4.x = rectangle3.x;
                    rectangle4.y = rectangle3.y;
                    rectangle4.height = 110;
                    rectangle4.width = 170;
                    topView2.getCellView().setNewBounds(rectangle4);
                }
            }
        }
        cube.showPropertyDialogOnNew();
    }

    private void addLevel(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateLevel"));
        Level level = ((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).getLevelSet().createLevel(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(level);
        if (topView != null && topView.getCellView() != null) {
            if (applicationView.getCurrentDPV() instanceof DPVCompactMultidimentional) {
                if (rectangle.width <= 1) {
                    rectangle.width = 80;
                }
                if (rectangle.height <= 1) {
                    rectangle.height = 30;
                }
            } else {
                if (rectangle.width <= 1) {
                    rectangle.width = 170;
                }
                if (rectangle.height <= 1) {
                    rectangle.height = 110;
                }
            }
            topView.getCellView().setNewBounds(rectangle, false);
            if (!(applicationView.getCurrentDPV() instanceof DPVCompactMultidimentional)) {
                AbstractMDTV abstractMDTV = (AbstractMDTV)((ContainerView)topView).createViewSynonim(((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).getCompactDiagram(), false);
                if (abstractMDTV.getCellView() != null) {
                    Rectangle rectangle2 = abstractMDTV.getBounds();
                    rectangle2.height = 30;
                    rectangle2.width = 80;
                    abstractMDTV.getCellView().setNewBounds(rectangle2);
                }
            } else {
                TopView topView2 = level.getFirstViewForDPV(level.getDesign().getMultidimensionalDesign().getMainView());
                if (topView2 != topView && topView2.getCellView() != null) {
                    Rectangle rectangle3 = topView2.getBounds();
                    rectangle3.x = rectangle.x;
                    rectangle3.y = rectangle.y;
                    rectangle3.height = 110;
                    rectangle3.width = 170;
                    topView2.getCellView().setNewBounds(rectangle3);
                }
            }
        }
        level.showPropertyDialogOnNew();
    }

    private void addDimension(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateDimension"));
        Dimension dimension = ((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).getDimensionSet().createDimension(null);
        TopView topView = applicationView.getCurrentDPV().getViewFor(dimension);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 80;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 30;
            }
            topView.getCellView().setNewBounds(rectangle, false);
            if (!(applicationView.getCurrentDPV() instanceof DPVCompactMultidimentional)) {
                ((ContainerView)topView).createViewSynonim(((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).getCompactDiagram(), false);
            } else {
                TopView topView2 = dimension.getFirstViewForDPV(dimension.getDesign().getMultidimensionalDesign().getMainView());
                if (topView2 != topView) {
                    topView2.getCellView().setNewBounds(topView.getBounds());
                }
            }
        }
        dimension.showPropertyDialogOnNew();
    }

    private void addStructuredType(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateStructuredType"));
        StructuredType structuredType = ((DataTypesDesign)applicationView.getCurrentDPV().getDesignPart()).createStructuredType();
        TopView topView = applicationView.getCurrentDPV().getViewFor(structuredType);
        if (topView != null && topView.getCellView() != null) {
            if (rectangle.width <= 1) {
                rectangle.width = 170;
            }
            if (rectangle.height <= 1) {
                rectangle.height = 110;
            }
            topView.getCellView().setNewBounds(rectangle, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        structuredType.showPropertyDialogOnNew();
    }

    private void addNote(Diagram diagram, ApplicationView applicationView, Rectangle rectangle) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateNote"));
        Note note = null;
        TopView topView = null;
        if (applicationView.getCurrentDPV() instanceof DPVLogical) {
            note = ((LogicalDesign)applicationView.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(applicationView.getCurrentDPV());
            if (topView == null) {
                topView = ((LogicalDesign)applicationView.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (applicationView.getCurrentDPV() instanceof DPVRelational) {
            note = ((RelationalDesign)applicationView.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(applicationView.getCurrentDPV());
            if (topView == null) {
                topView = ((RelationalDesign)applicationView.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (applicationView.getCurrentDPV() instanceof DPVProcess) {
            note = ((DataFlowDesign)applicationView.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(applicationView.getCurrentDPV());
            if (topView == null) {
                topView = ((DataFlowDesign)applicationView.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (applicationView.getCurrentDPV() instanceof DPVTransformation) {
            note = ((TransformationTask)applicationView.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(applicationView.getCurrentDPV());
            if (topView == null) {
                topView = ((TransformationTask)applicationView.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (applicationView.getCurrentDPV() instanceof DPVMultidimensional) {
            note = ((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(applicationView.getCurrentDPV());
            if (topView == null) {
                topView = ((MultidimensionalDesign)applicationView.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (applicationView.getCurrentDPV() instanceof DPVDataTypes && (topView = (note = ((DataTypesDesign)applicationView.getCurrentDPV().getDesignPart()).createNote()).getFirstViewForDPV(applicationView.getCurrentDPV())) == null) {
            topView = ((DataTypesDesign)applicationView.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
        }
        if (note != null) {
            if (topView != null && topView.getCellView() != null) {
                if (rectangle.height == 0) {
                    rectangle.height = 40;
                }
                if (rectangle.width == 0) {
                    rectangle.width = 95;
                }
                topView.getCellView().setNewBounds(rectangle, false);
                topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
            }
            note.showPropertyDialogOnNew();
            if (note.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
                note.getDesignPart().postNoteCreateEdit(note);
            }
        }
    }

    public void connect(Port port, Port port2) {
        ConnectionSet connectionSet = new ConnectionSet();
        DefaultEdge defaultEdge = new DefaultEdge();
        connectionSet.connect((Object)defaultEdge, (Object)port, port2);
        Map map = DiagramConstants.createMap();
        DiagramConstants.setLineEnd(map, 2);
        DiagramConstants.setEndFill(map, true);
        Hashtable<DefaultEdge, Map> hashtable = new Hashtable<DefaultEdge, Map>();
        hashtable.put(defaultEdge, map);
        DiagramConstants.setDisconnectable(map, false);
        Object[] objectArray = new Object[]{defaultEdge};
        this.diagram.getDiagramLayoutCache().insert(objectArray, hashtable, connectionSet, null, null);
        this.diagram.getDiagramLayoutCache().toBack(objectArray);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent != null && this.getSourcePortAt(mouseEvent.getPoint()) != null && !mouseEvent.isConsumed() && this.diagram.isPortsVisible()) {
            this.diagram.setCursor(new Cursor(12));
            mouseEvent.consume();
        }
        super.mouseMoved(mouseEvent);
    }

    protected void paintConnector(Color color, Color color2, Graphics graphics) {
        graphics.setColor(color);
        graphics.setXORMode(color2);
        this.paintPort(this.diagram.getGraphics());
        if (this.firstPort != null && this.start != null && this.current != null) {
            graphics.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.current.getX(), (int)this.current.getY());
        }
    }

    protected void paintPort(Graphics graphics) {
        if (this.port != null) {
            boolean bl = DiagramConstants.getOffset(this.port.getAttributes()) != null;
            Rectangle2D rectangle2D = bl ? this.port.getBounds() : this.port.getParentView().getBounds();
            rectangle2D = this.diagram.toScreen(DiagramConstants.createRect(rectangle2D));
            rectangle2D.setFrame(rectangle2D.getX() - 3.0, rectangle2D.getY() - 3.0, rectangle2D.getWidth() + 6.0, rectangle2D.getHeight() + 6.0);
            this.diagram.getUI().paintCell(graphics, this.port, rectangle2D, true);
        }
    }
}

