/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LegendRenderer;

public class LegendView
extends AbstractCellView {
    private LegendRenderer renderer;
    protected Rectangle2D bounds;
    protected Rectangle2D groupBounds = DefaultDiagramCell.defaultBounds;
    public static transient int[] defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
    public static transient int[] xCursors = new int[]{10, 0, 11, 10, 11, 10, 0, 11};
    public static transient int[] yCursors = new int[]{8, 8, 8, 0, 0, 9, 9, 9};

    public LegendView(Object object, AbstractDiagram abstractDiagram, CellMapper cellMapper) {
        super(object, abstractDiagram, cellMapper);
        ((DefaultDiagramCell)object).setCellView(this);
    }

    @Override
    public void update() {
        super.update();
        this.bounds = DiagramConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
        ((Diagram)this.getDiagram()).getDesignPartView().updateLegendPosition();
    }

    @Override
    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return this.bounds;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    protected void updateGroupBounds() {
        CellView[] cellViewArray = this.getChildViews();
        LinkedList<CellView> linkedList = new LinkedList<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!this.includeInGroupBounds(cellViewArray[i])) continue;
            linkedList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[linkedList.size()];
        linkedList.toArray(cellViewArray);
        this.groupBounds = LegendView.getBounds(cellViewArray);
    }

    private boolean includeInGroupBounds(CellView cellView) {
        if (cellView instanceof EdgeView) {
            DiagramModel diagramModel = this.diagram.getModel();
            EdgeView edgeView = (EdgeView)cellView;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode treeNode;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)edgeView.getCell();
                if (diagramModel.getSource(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)diagramModel.getSource(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
                if (diagramModel.getTarget(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)diagramModel.getTarget(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public CellViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new LegendRenderer();
        }
        return this.renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext diagramContext) {
        return null;
    }

    @Override
    public Point2D getCenterPoint() {
        Rectangle2D rectangle2D = this.getBounds();
        return DiagramConstants.createPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    @Override
    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2, boolean bl) {
        return ((LegendRenderer)this.getRenderer()).getPerimeterPoint(this, point2D, point2D2, bl);
    }
}

