/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramUI;

public class DiagramViewView
extends AbstractCellView {
    private DiagramViewRenderer renderer;
    protected Rectangle2D bounds;
    protected Rectangle2D groupBounds = DefaultDiagramCell.defaultBounds;
    public static transient int[] defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
    public static transient int[] xCursors = new int[]{10, 0, 11, 10, 11, 10, 0, 11};
    public static transient int[] yCursors = new int[]{8, 8, 8, 0, 0, 9, 9, 9};

    public DiagramViewView(Object object, AbstractDiagram abstractDiagram, CellMapper cellMapper) {
        super(object, abstractDiagram, cellMapper);
        ((DefaultDiagramCell)object).setCellView(this);
    }

    @Override
    public void update() {
        super.update();
        this.bounds = DiagramConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
        TopView topView = ((DiagramViewDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            // empty if block
        }
    }

    @Override
    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return this.bounds;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    protected void updateGroupBounds() {
        CellView[] cellViewArray = this.getChildViews();
        LinkedList<CellView> linkedList = new LinkedList<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!this.includeInGroupBounds(cellViewArray[i])) continue;
            linkedList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[linkedList.size()];
        linkedList.toArray(cellViewArray);
        this.groupBounds = DiagramViewView.getBounds(cellViewArray);
    }

    private boolean includeInGroupBounds(CellView cellView) {
        if (cellView instanceof EdgeView) {
            DiagramModel diagramModel = this.diagram.getModel();
            EdgeView edgeView = (EdgeView)cellView;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode treeNode;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)edgeView.getCell();
                if (diagramModel.getSource(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)diagramModel.getSource(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
                if (diagramModel.getTarget(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)diagramModel.getTarget(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public CellViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new DiagramViewRenderer();
        }
        return this.renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext diagramContext) {
        if (DiagramConstants.isSizeable(this.getAllAttributes()) && diagramContext.getDiagram().isSizeable()) {
            return new SizeHandle(this, diagramContext);
        }
        return null;
    }

    @Override
    public Point2D getCenterPoint() {
        Rectangle2D rectangle2D = this.getBounds();
        return DiagramConstants.createPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    @Override
    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2, boolean bl) {
        return ((DiagramViewRenderer)this.getRenderer()).getPerimeterPoint(this, point2D, point2D2, bl);
    }

    public static class SizeHandle
    implements CellViewHandle,
    Serializable {
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient AbstractDiagram diagram;
        protected transient DiagramViewView vertex;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient DiagramContext context;
        protected transient Rectangle2D initialBounds;
        protected transient CellView[] contextViews;
        protected transient int index = -1;
        protected transient Rectangle2D[] r = new Rectangle2D[8];
        protected boolean firstOverlayInvocation = true;
        public transient int[] cursors = null;

        public SizeHandle(DiagramViewView diagramViewView, DiagramContext diagramContext) {
            this.diagram = diagramContext.getDiagram();
            this.vertex = diagramViewView;
            int n = DiagramConstants.getSizeableAxis(this.vertex.getAllAttributes());
            this.cursors = n == 1 ? xCursors : (n == 2 ? yCursors : defaultCursors);
            this.portViews = diagramContext.createTemporaryPortViews();
            this.initialBounds = DiagramConstants.createRect(this.vertex.getBounds());
            this.context = diagramContext;
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = DiagramConstants.createRect();
            }
            this.invalidate();
        }

        @Override
        public CellView getCellView() {
            return this.vertex;
        }

        public boolean isConstrainedSizeEvent(MouseEvent mouseEvent) {
            DiagramUI diagramUI = this.diagram.getUI();
            if (diagramUI instanceof DefaultDiagramUI) {
                return ((DefaultDiagramUI)diagramUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        @Override
        public void paint(Graphics graphics) {
            this.invalidate();
            graphics.setColor(this.diagram.getHandleColor());
            for (int i = 0; i < this.r.length; ++i) {
                if (this.cursors[i] == 0) continue;
                graphics.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rectangle = this.diagram.getBounds();
                this.offscreen = new BufferedImage(rectangle.width, rectangle.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, rectangle.width, rectangle.height);
                this.offgraphics.setColor(this.diagram.getBackground());
                this.offgraphics.fillRect(0, 0, rectangle.width, rectangle.height);
                this.diagram.getUI().paint(this.offgraphics, this.diagram);
            }
            catch (Error error) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        @Override
        public void overlay(Graphics graphics) {
            if (!this.firstOverlayInvocation) {
                if (this.cachedBounds != null) {
                    graphics.setColor(Color.black);
                    Rectangle2D rectangle2D = this.diagram.toScreen(DiagramConstants.createRect(this.cachedBounds));
                    graphics.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth() - 2, (int)rectangle2D.getHeight() - 2);
                } else if (!this.initialBounds.equals(this.vertex.getBounds())) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.scale(this.diagram.getScale(), this.diagram.getScale());
                    this.diagram.getUI().paintCell(graphics, this.vertex, this.vertex.getBounds(), true);
                    if (this.contextViews != null) {
                        for (int i = 0; i < this.contextViews.length; ++i) {
                            this.diagram.getUI().paintCell(graphics, this.contextViews[i], this.contextViews[i].getBounds(), true);
                        }
                    }
                    graphics2D.setTransform(affineTransform);
                    if (this.portViews != null && this.diagram.isPortsVisible()) {
                        this.diagram.getUI().paintPorts(graphics, this.portViews);
                    }
                }
            }
            this.firstOverlayInvocation = false;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.vertex != null) {
                for (int i = 0; i < this.r.length; ++i) {
                    if (!this.r[i].contains(mouseEvent.getPoint())) continue;
                    this.diagram.setCursor(new Cursor(this.cursors[i]));
                    mouseEvent.consume();
                    return;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.diagram.isSizeable()) {
                return;
            }
            for (int i = 0; i < this.r.length; ++i) {
                if (!this.r[i].contains(mouseEvent.getPoint()) || this.cursors[i] == 0) continue;
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.add(this.vertex.getCell());
                this.contextViews = this.context.createTemporaryContextViews(hashSet);
                CellView[] cellViewArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                if (cellViewArray.length >= DefaultDiagramUI.MAXHANDLES) {
                    this.cachedBounds = DiagramConstants.createRect(this.initialBounds);
                }
                mouseEvent.consume();
                this.index = i;
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Object object;
            Graphics graphics;
            if (this.firstDrag && this.diagram.isDoubleBuffered() && this.cachedBounds == null) {
                this.firstDrag = false;
            }
            Rectangle2D rectangle2D = null;
            Graphics graphics2 = graphics = this.offgraphics != null ? this.offgraphics : this.diagram.getGraphics();
            if (this.index == -1) {
                return;
            }
            Rectangle2D rectangle2D2 = this.computeBounds(mouseEvent);
            graphics.setColor(this.diagram.getForeground());
            graphics.setXORMode(this.diagram.getBackground().darker());
            this.overlay(graphics);
            if (this.offgraphics != null) {
                rectangle2D = this.diagram.toScreen(DiagramConstants.createRect(this.vertex.getBounds()));
                object = this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (object != null) {
                    rectangle2D.add((Rectangle2D)object);
                }
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = rectangle2D2;
            } else {
                object = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                for (n = 0; n < ((CellView[])object).length; ++n) {
                    CellView cellView = this.diagram.getDiagramLayoutCache().getMapping(object[n].getCell(), false);
                    Map map = DiagramConstants.cloneMap(cellView.getAllAttributes());
                    object[n].setAttributes(map);
                    object[n].refresh(false);
                }
                this.vertex.setBounds(rectangle2D2);
                if (this.vertex != null) {
                    this.diagram.getDiagramLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.diagram.getDiagramLayoutCache().update(this.contextViews);
                }
            }
            this.overlay(graphics);
            if (this.offscreen != null) {
                rectangle2D.add(this.diagram.toScreen(DiagramConstants.createRect(this.vertex.getBounds())));
                object = this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (object != null) {
                    rectangle2D.add((Rectangle2D)object);
                }
                n = 2;
                rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(n * 2), rectangle2D.getHeight() + (double)(n * 2));
                double d = DiagramConstants.NEGATIVE_ALLOWED ? rectangle2D.getX() : Math.max(0.0, rectangle2D.getX());
                double d2 = DiagramConstants.NEGATIVE_ALLOWED ? rectangle2D.getY() : Math.max(0.0, rectangle2D.getY());
                double d3 = d + rectangle2D.getWidth();
                double d4 = d2 + rectangle2D.getHeight();
                this.diagram.getGraphics().drawImage(this.offscreen, (int)d, (int)d2, (int)d3, (int)d4, (int)d, (int)d2, (int)d3, (int)d4, this.diagram);
            }
        }

        protected Rectangle2D computeBounds(MouseEvent mouseEvent) {
            double d = this.initialBounds.getX();
            double d2 = this.initialBounds.getX() + this.initialBounds.getWidth() - 1.0;
            double d3 = this.initialBounds.getY();
            double d4 = this.initialBounds.getY() + this.initialBounds.getHeight() - 1.0;
            Point2D point2D = this.diagram.fromScreen(this.diagram.snap(DiagramConstants.createPoint(mouseEvent.getPoint())));
            if (!DiagramConstants.NEGATIVE_ALLOWED) {
                point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
            }
            if (this.index > 4) {
                d4 = point2D.getY();
            } else if (this.index < 3) {
                d3 = point2D.getY();
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                d = point2D.getX();
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                d2 = point2D.getX();
            }
            double d5 = d2 - d;
            double d6 = d4 - d3;
            if (this.isConstrainedSizeEvent(mouseEvent)) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    d6 = d5;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    d5 = d6;
                } else {
                    d6 = d5;
                    d3 = d4 - d6;
                }
            }
            if (d5 < 0.0) {
                d += d5;
                d5 = Math.abs(d5);
            }
            if (d6 < 0.0) {
                d3 += d6;
                d6 = Math.abs(d6);
            }
            return DiagramConstants.createRect(d, d3, d5 + 1.0, d6 + 1.0);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(mouseEvent);
                this.vertex.setBounds(this.cachedBounds);
                Object[] objectArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map map = DiagramConstants.createAttributes(objectArray, null);
                this.diagram.getDiagramLayoutCache().edit(map, null, null, null);
            }
            mouseEvent.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
        }

        private void invalidate() {
            Rectangle2D rectangle2D = this.diagram.getCellBounds(this.vertex.getCell());
            if (rectangle2D != null) {
                rectangle2D = DiagramConstants.createRect(rectangle2D);
                this.diagram.toScreen(rectangle2D);
                int n = this.diagram.getHandleSize();
                int n2 = 2 * n;
                double d = rectangle2D.getX() - (double)n;
                double d2 = rectangle2D.getY() - (double)n;
                double d3 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - (double)n;
                double d4 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - (double)n;
                double d5 = rectangle2D.getX() + rectangle2D.getWidth() - (double)n;
                double d6 = rectangle2D.getY() + rectangle2D.getHeight() - (double)n;
                this.r[0].setFrame(d, d2, n2, n2);
                this.r[1].setFrame(d3, d2, n2, n2);
                this.r[2].setFrame(d5, d2, n2, n2);
                this.r[3].setFrame(d, d4, n2, n2);
                this.r[4].setFrame(d5, d4, n2, n2);
                this.r[5].setFrame(d, d6, n2, n2);
                this.r[6].setFrame(d3, d6, n2, n2);
                this.r[7].setFrame(d5, d6, n2, n2);
            }
        }
    }
}

