/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.DiagramViewPanel;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewView;

public class DiagramViewRenderer
extends JPanel
implements CellViewRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(159, 155, 251);
    public static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    protected transient Color bordercolor;
    protected transient Color defaultForeground = DEFAULT_FOREGROUND;
    protected transient Color defaultBackground = DEFAULT_BACKGROUND;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient AbstractDiagram diagram;
    protected transient int borderWidth;
    protected transient DiagramView diagramView;
    protected transient DiagramViewPanel overviewPanel = null;

    public DiagramViewRenderer() {
        this.bordercolor = DEFAULT_BORDER_COLOR;
        this.setLayout(new BorderLayout());
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof DiagramViewView) {
            DiagramViewDiagramCell diagramViewDiagramCell = (DiagramViewDiagramCell)cellView.getCell();
            this.diagramView = diagramViewDiagramCell.getDiagramView();
            this.diagram = abstractDiagram;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setComponentOrientation(abstractDiagram.getComponentOrientation());
            if (this.diagramView.isCompositeView() && this.overviewPanel == null && this.diagramView.getDesignPartView() != null) {
                this.overviewPanel = new DiagramViewPanel(this.diagramView.getDesignPartView().getWorkSpace(), this.diagramView.getDesignPartView().getWorkSpace().getScrollPane().getViewport());
                this.add(this.overviewPanel);
            }
            diagramViewDiagramCell.setRenderer(this);
            this.diagramView.setRenderer(this);
        }
        this.installAttributes(cellView);
        return this;
    }

    public void resetOverviewPanel() {
        if (this.overviewPanel != null) {
            this.remove(this.overviewPanel);
        }
        this.overviewPanel = null;
        if (this.diagramView.isCompositeView() && this.overviewPanel == null && this.diagramView.getDesignPartView() != null) {
            this.overviewPanel = new DiagramViewPanel(this.diagramView.getDesignPartView().getWorkSpace(), this.diagramView.getDesignPartView().getWorkSpace().getScrollPane().getViewport());
            this.add(this.overviewPanel);
            this.repaint();
        }
    }

    protected void installAttributes(CellView cellView) {
        Map map = cellView.getAllAttributes();
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground(this.getForegroundColor());
        Color color = DiagramConstants.getBackground(map);
        this.setBackground(color != null ? color : this.getBackgroundColor());
        this.setFont(this.diagram.getFont());
    }

    public Color getBackgroundColor() {
        if (this.diagramView.getTopView().useDefaultColor() || this.diagramView.getTopView().getBackgroundColor() == null) {
            return this.defaultBackground;
        }
        return this.diagramView.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.diagramView.getTopView().useDefaultColor() || this.diagramView.getTopView().getForegroundColor() == null) {
            return this.bordercolor;
        }
        return this.diagramView.getTopView().getForegroundColor();
    }

    public Color getBorderColor() {
        if (this.diagramView.getTopView().useDefaultColor() || this.diagramView.getTopView().getForegroundColor() == null) {
            return this.bordercolor;
        }
        return this.diagramView.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    @Override
    public void paintChildren(Graphics graphics) {
        this.overviewPanel.componentResized(null);
        super.paintChildren(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.diagramView.isCompositeView() || this.diagramView.getDesignPartView() == null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            graphics2D.setPaint(this.getBackgroundColor());
            int n3 = n / 3;
            int n4 = n / 15;
            int[] nArray = new int[]{0, n - n3, n - n3 + n4, n - n4, n - 1, n - 1, 0, 0};
            int[] nArray2 = new int[]{n4, n4, 0, 0, n4, n2 - 1, n2 - 1, n4};
            Polygon polygon = new Polygon(nArray, nArray2, 8);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getBorderColor());
            graphics.drawPolygon(polygon);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Font font = this.diagram.getFont();
            Font font2 = font.deriveFont(1);
            String string = "";
            int n5 = (n2 - font2.getSize() + 15) / 2;
            BasicStroke basicStroke = new BasicStroke(1.0f);
            DesignPartView designPartView = this.diagramView.getDesignPartView();
            if (this.diagramView.getDesignPartView() == null || !this.diagramView.getDesignPartView().getDesignPart().isLoaded()) {
                string = "(NOT OPENED)";
                int n6 = (n - fontMetrics.stringWidth(string)) / 2;
                graphics.drawString(string, n6, n5);
            } else {
                string = designPartView.canCreateDisplays() ? (designPartView.isMasterDPV() ? (designPartView.getSubordinateViews().size() > 0 ? designPartView.getName() + " ( main )" : designPartView.getName()) : designPartView.getMasterDPV().getName() + " ( " + designPartView.getName() + " )") : designPartView.getName();
                int n7 = (n - fontMetrics.stringWidth(string)) / 2;
                graphics2D.setStroke(basicStroke);
                graphics.setColor(this.getBorderColor());
                graphics.setFont(font2);
                graphics.drawString(string, n7, n5);
            }
        } else if (this.diagramView.getDesignPartView() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n8 = dimension.height;
            int n9 = n / 3;
            int n10 = n / 15;
            int[] nArray = new int[]{0, n - n9, n - n9 + n10, n - n10, n - 1, n - 1, 0, 0};
            int[] nArray3 = new int[]{n10, n10, 0, 0, n10, n8 - 1, n8 - 1, n10};
            graphics2D.setPaint(this.getBackgroundColor());
            Polygon polygon = new Polygon(nArray, nArray3, 8);
            graphics.fillPolygon(polygon);
            this.overviewPanel.hIndex = n10;
            graphics.translate(0, n10);
            super.paint(graphics);
            graphics.translate(0, -n10);
            graphics.setColor(this.getBorderColor());
            graphics.drawPolygon(polygon);
            Font font = this.diagram.getFont();
            int n11 = n10;
            Font font3 = font.deriveFont((float)n11 - 2.0f);
            String string = "";
            DesignPartView designPartView = this.diagramView.getDesignPartView();
            string = designPartView.canCreateDisplays() ? (designPartView.isMasterDPV() ? (designPartView.getSubordinateViews().size() > 0 ? designPartView.getName() + " ( main )" : designPartView.getName()) : designPartView.getMasterDPV().getName() + " ( " + designPartView.getName() + " )") : designPartView.getName();
            BasicStroke basicStroke = new BasicStroke(1.0f);
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getBorderColor());
            graphics.setFont(font3);
            graphics.drawString(string, 10, n10 - n10 / 4);
        }
    }

    public Point2D getPerimeterPoint(DiagramViewView diagramViewView, Point2D point2D, Point2D point2D2, boolean bl) {
        Rectangle2D rectangle2D = diagramViewView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D2.getX() - d5;
        double d8 = point2D2.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = Math.atan2(d4, d3);
        if (d9 < -d12 + d13 || d9 > d12 - d13) {
            d10 = d;
            d11 = d6;
        } else if (d9 < -d13) {
            d11 = d2;
            d10 = d5;
        } else if (d9 < d13) {
            d10 = d + d3;
            d11 = d6;
        } else {
            d11 = d2 + d4;
            d10 = d5;
        }
        return DiagramConstants.createPoint(d10, d11);
    }
}

