/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class DiagramContext
implements CellMapper {
    protected AbstractDiagram diagram;
    protected transient DiagramLayoutCache diagramLayoutCache;
    protected Object[] cells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public DiagramContext(AbstractDiagram abstractDiagram, Object[] objectArray) {
        DiagramModel diagramModel = abstractDiagram.getModel();
        this.cellSet = DefaultDiagramModel.getDescendants(diagramModel, objectArray);
        this.diagramLayoutCache = abstractDiagram.getDiagramLayoutCache();
        this.diagram = abstractDiagram;
        this.cells = objectArray;
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            if (diagramModel.isPort(iterator.next())) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public AbstractDiagram getDiagram() {
        return this.diagram;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object object) {
        return this.cellSet.contains(object);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViewArray = new CellView[this.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            cellViewArray[i] = this.getMapping(this.cells[i], true);
        }
        return cellViewArray;
    }

    public CellView[] createTemporaryPortViews() {
        Object object2;
        DiagramModel diagramModel = this.diagram.getModel();
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        for (Object object2 : this.cellSet) {
            if (!diagramModel.isPort(object2) || !this.diagram.getDiagramLayoutCache().isVisible(object2)) continue;
            arrayList.add(this.getMapping(object2, true));
        }
        object2 = new PortView[arrayList.size()];
        arrayList.toArray((T[])object2);
        return object2;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set set) {
        Object object2;
        Object[] objectArray = set.toArray();
        Set set2 = DefaultDiagramModel.getEdges(this.diagram.getModel(), objectArray);
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        for (Object object2 : set2) {
            if (set.contains(object2) || !this.diagramLayoutCache.isVisible(object2) || this.diagramLayoutCache.getMapping(object2, false) == null) continue;
            arrayList.add(this.createMapping(object2));
        }
        object2 = new CellView[arrayList.size()];
        arrayList.toArray((T[])object2);
        return object2;
    }

    @Override
    public CellView getMapping(Object object, boolean bl) {
        if (object != null) {
            CellView cellView = (CellView)this.views.get(object);
            if (cellView != null) {
                return cellView;
            }
            if (this.contains(object)) {
                return this.createMapping(object);
            }
            return this.diagramLayoutCache.getMapping(object, false);
        }
        return null;
    }

    public CellView createMapping(Object object) {
        CellView cellView = this.diagramLayoutCache.getMapping(object, false);
        CellView cellView2 = this.diagramLayoutCache.getFactory().createView(this.getDiagram(), this, object);
        if (cellView instanceof PortView) {
            Point2D point2D = ((PortView)cellView).getPoint();
            ((PortView)cellView2).setPoint(new Point2D.Double(point2D.getX(), point2D.getY()));
        }
        if (cellView != null) {
            cellView2.setAttributes(DiagramConstants.cloneMap(cellView.getAllAttributes()));
            cellView2.refresh(false);
        }
        return cellView2;
    }

    public ConnectionSet disconnect(CellView[] cellViewArray) {
        ConnectionSet connectionSet = new ConnectionSet();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof EdgeView)) continue;
            EdgeView edgeView = (EdgeView)cellViewArray[i];
            CellView cellView = edgeView.getSource();
            if (!DiagramConstants.isDisconnectable(edgeView.getAllAttributes())) continue;
            if (cellView != null && DiagramConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) && !this.contains(cellView.getCell())) {
                edgeView.setSource(null);
                connectionSet.disconnect(edgeView.getCell(), true);
            }
            if ((cellView = edgeView.getTarget()) == null || !DiagramConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) || this.contains(cellView.getCell())) continue;
            edgeView.setTarget(null);
            connectionSet.disconnect(edgeView.getCell(), false);
        }
        return connectionSet;
    }

    @Override
    public void putMapping(Object object, CellView cellView) {
        this.views.put(object, cellView);
    }
}

