/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class DiagramConstants {
    public static boolean NEGATIVE_ALLOWED = false;
    public static final Point dummyPoint = new Point();
    public static final Font defaultFont = UIManager.getFont("Tree.font");
    public static final float DEFAULTFONTSIZE = 12.0f;
    public static final int DEFAULTFONTSTYLE = 0;
    public static final int DEFAULTDECORATIONSIZE = 8;
    public static final int PERMILLE = 1000;
    protected static float[] dash = new float[]{8.0f, 8.0f};
    public static Stroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
    public static final int ARROW_NONE = 0;
    public static final int ARROW_CLASSIC = 1;
    public static final int ARROW_TECHNICAL = 2;
    public static final int ARROW_SIMPLE = 4;
    public static final int ARROW_CIRCLE = 5;
    public static final int ARROW_LINE = 7;
    public static final int ARROW_DOUBLELINE = 8;
    public static final int ARROW_DIAMOND = 9;
    public static final int STYLE_ORTHOGONAL = 11;
    public static final int STYLE_BEZIER = 12;
    public static final int STYLE_SPLINE = 13;
    public static final int ARROW_TECHNICAL_IDENT = 14;
    public static final int ARROW_CIRCLE_IDENT = 15;
    public static final int ARROW_TRIANGLE = 16;
    public static final int ARROW_TRIANGLE_IDENT = 17;
    public static final int ARROW_LINE_CIRCLE = 18;
    public static final int ARROW_TRIANGLE_CIRCLE = 19;
    public static final int ARROW_TRIANGLE_CIRCLE_NO_FILL = 20;
    public static final int ARROW_TRIANGLE_CROSS = 21;
    public static final int ARROW_LINE_CROSS = 22;
    public static final int ARROW_LINE_CIRCLE_NO_FILL = 23;
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final Edge.Routing ROUTING_SIMPLE = new DefaultEdge.DefaultRouting();
    public static final String SIZEABLEAXIS = "sizeableAxis";
    public static final String MOVEABLEAXIS = "moveableAxis";
    public static final String REPLACEATTRIBUTES = "replaceAttributes";
    public static final String REMOVEATTRIBUTES = "removeAttributes";
    public static final String REMOVEALL = "removeAll";
    public static final String ICON = "icon";
    public static final String FONT = "font";
    public static final String OPAQUE = "opaque";
    public static final String BORDER = "border";
    public static final String LINECOLOR = "linecolor";
    public static final String BORDERCOLOR = "bordercolor";
    public static final String LINEWIDTH = "linewidth";
    public static final String FOREGROUND = "foregroundColor";
    public static final String BACKGROUND = "backgroundColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    public static final String DASHPATTERN = "dashPattern";
    public static final String LINESTYLE = "lineStyle";
    public static final String LINEBEGIN = "lineBegin";
    public static final String LINEEND = "lineEnd";
    public static final String BEGINSIZE = "beginSize";
    public static final String ENDSIZE = "endsize";
    public static final String BEGINFILL = "beginFill";
    public static final String ENDFILL = "endFill";
    public static final String VALUE = "value";
    public static final String TRANSFERABLE = "transferable";
    public static final String EDITABLE = "editable";
    public static final String MOVEABLE = "moveable";
    public static final String SIZEABLE = "sizeable";
    public static final String AUTOSIZE = "autosize";
    public static final String BENDABLE = "bendable";
    public static final String CONNECTABLE = "connectable";
    public static final String DISCONNECTABLE = "disconnectable";
    public static final String BOUNDS = "bounds";
    public static final String POINTS = "points";
    public static final String ROUTING = "routing";
    public static final String LABELPOSITION = "labelposition";
    public static final String SOURCELABELPOSITION = "sourceLabelposition";
    public static final String TARGETLABELPOSITION = "targetLabelposition";
    public static final String LABELALONGEDGE = "labelAlongEdge";
    public static final String ABSOLUTE = "absolute";
    public static final String OFFSET = "offset";
    public static final String SIZE = "size";
    public static final String BEGIN_DASHED = "beginDashed";
    public static final String END_DASHED = "endDashed";

    public static Map createAttributes(Object object, Object object2, Object object3) {
        return DiagramConstants.createAttributes(new Object[]{object}, new Object[]{object2}, new Object[]{object3});
    }

    public static Map createAttributes(Object[] objectArray, Object object, Object object2) {
        return DiagramConstants.createAttributes(objectArray, new Object[]{object}, new Object[]{object2});
    }

    public static Map createAttributes(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        if (objectArray2 != null && objectArray3 != null && objectArray2.length != objectArray3.length) {
            throw new IllegalArgumentException(Messages.getString("DiagramConstants.KeysValuesSameLength"));
        }
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            Map map = DiagramConstants.createMap();
            for (int j = 0; j < objectArray2.length; ++j) {
                if (objectArray2[j] == null || objectArray3[j] == null) continue;
                map.put(objectArray2[j], objectArray3[j]);
            }
            hashtable.put(objectArray[i], map);
        }
        return hashtable;
    }

    public static Map createAttributes(Object[] objectArray, CellMapper cellMapper) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        for (int i = 0; i < objectArray.length; ++i) {
            CellView cellView = null;
            Object object = objectArray[i];
            if (object instanceof CellView) {
                cellView = (CellView)object;
                object = cellView.getCell();
            } else if (cellMapper != null) {
                cellView = cellMapper.getMapping(object, false);
            }
            if (cellView == null) continue;
            hashtable.put(object, DiagramConstants.cloneMap(cellView.getAllAttributes()));
        }
        return hashtable;
    }

    public static Map createAttributesFromModel(Object[] objectArray, DiagramModel diagramModel) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        for (int i = 0; i < objectArray.length; ++i) {
            Map map = diagramModel.getAttributes(objectArray[i]);
            if (map == null || map.size() <= 0) continue;
            hashtable.put(objectArray[i], DiagramConstants.cloneMap(map));
        }
        return hashtable;
    }

    public static Point2D createPoint() {
        return new SerializablePoint2D();
    }

    public static Point2D createPoint(Point2D point2D) {
        if (point2D != null) {
            return DiagramConstants.createPoint(point2D.getX(), point2D.getY());
        }
        return null;
    }

    public static Point2D createPoint(double d, double d2) {
        return new SerializablePoint2D(d, d2);
    }

    public static Rectangle2D createRect() {
        return new SerializableRectangle2D();
    }

    public static Rectangle2D createRect(double d, double d2, double d3, double d4) {
        return new SerializableRectangle2D(d, d2, d3, d4);
    }

    public static Rectangle2D createRect(Point2D point2D) {
        return DiagramConstants.createRect(point2D, 0.0);
    }

    public static Rectangle2D createRect(Point2D point2D, double d) {
        if (point2D != null) {
            return DiagramConstants.createRect(point2D.getX(), point2D.getY(), d, d);
        }
        return null;
    }

    public static Rectangle2D createRect(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            return DiagramConstants.createRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return null;
    }

    public static Rectangle2D createRect(double d, double d2, double d3, double d4, double d5, double d6) {
        return DiagramConstants.createRect(d - d5, d2 - d5, d3 + d5 + d6, d4 + d5 + d6);
    }

    public static Rectangle2D createRect(Rectangle2D rectangle2D, double d, double d2) {
        if (rectangle2D != null) {
            return DiagramConstants.createRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d, d2);
        }
        return null;
    }

    public static Map createMap() {
        return new Hashtable();
    }

    public static Map replaceKeys(Map map, Map map2) {
        Hashtable hashtable = new Hashtable();
        for (Map.Entry entry : map2.entrySet()) {
            Object v;
            if (!(entry.getValue() instanceof Map) || (v = map.get(entry.getKey())) == null) continue;
            Map map3 = DiagramConstants.cloneMap((Map)entry.getValue());
            hashtable.put(v, map3);
        }
        return hashtable;
    }

    public static Map cloneMap(Map map) {
        Point point;
        Point point2;
        Point point3;
        List list;
        Hashtable hashtable = new Hashtable(map);
        Rectangle2D rectangle2D = DiagramConstants.getBounds(hashtable);
        if (rectangle2D != null) {
            DiagramConstants.setBounds(hashtable, (Rectangle2D)rectangle2D.clone());
        }
        if ((list = DiagramConstants.getPoints(hashtable)) != null) {
            DiagramConstants.setPoints(hashtable, DiagramConstants.clonePoints(list));
        }
        if ((point3 = DiagramConstants.getLabelPosition(hashtable)) != null) {
            DiagramConstants.setLabelPosition(hashtable, new Point(point3));
        }
        if ((point2 = DiagramConstants.getSourceLabelPosition(hashtable)) != null) {
            DiagramConstants.setSourceLabelPosition(hashtable, new Point(point2));
        }
        if ((point = DiagramConstants.getTargetLabelPosition(hashtable)) != null) {
            DiagramConstants.setTargetLabelPosition(hashtable, new Point(point));
        }
        return hashtable;
    }

    public static List clonePoints(List list) {
        ArrayList arrayList = new ArrayList();
        for (Object object : list) {
            if (object instanceof PortView) {
                object = ((PortView)object).isAutoRoute() || ((PortView)object).getPoint() == null ? ((PortView)object).getLocation(null) : DiagramConstants.createPoint(((PortView)object).getPoint());
            } else if (object instanceof Point2D) {
                object = DiagramConstants.createPoint((Point2D)object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public static void translate(Collection collection, double d, double d2, AbstractDiagram abstractDiagram) {
        for (Object e : collection) {
            if (!(e instanceof Map)) continue;
            DiagramConstants.translate((Map)e, d, d2, abstractDiagram);
        }
    }

    public static void translate(Map map, double d, double d2, AbstractDiagram abstractDiagram) {
        if (DiagramConstants.isMoveable(map)) {
            List list;
            Rectangle2D rectangle2D = DiagramConstants.getBounds(map);
            if (rectangle2D != null) {
                int n = DiagramConstants.getMoveableAxis(map);
                if (n == 1) {
                    d2 = 0.0;
                } else if (n == 2) {
                    d = 0.0;
                }
                double d3 = rectangle2D.getX() + d;
                double d4 = rectangle2D.getY() + d2;
                if (abstractDiagram != null && abstractDiagram.isGridVisible()) {
                    double d5 = abstractDiagram.getGridSize();
                    d3 = Math.round((double)Math.round(d3 / d5) * d5);
                    d4 = Math.round((double)Math.round(d4 / d5) * d5);
                }
                rectangle2D.setFrame(d3, d4, rectangle2D.getWidth(), rectangle2D.getHeight());
                if (!NEGATIVE_ALLOWED) {
                    rectangle2D.setFrame(Math.max(0.0, rectangle2D.getX()), Math.max(0.0, rectangle2D.getY()), rectangle2D.getWidth(), rectangle2D.getHeight());
                }
            }
            if ((list = DiagramConstants.getPoints(map)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Point2D)) continue;
                    Point2D point2D = (Point2D)e;
                    point2D.setLocation(point2D.getX() + d, point2D.getY() + d2);
                    if (NEGATIVE_ALLOWED) continue;
                    point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
                }
            }
        }
    }

    public static void scale(Map map, double d, double d2, Point2D point2D, AbstractDiagram abstractDiagram) {
        Object object;
        Object object2;
        Rectangle2D rectangle2D = DiagramConstants.getBounds(map);
        if (rectangle2D != null) {
            object2 = DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY());
            object = (Point2D)((Point2D)object2).clone();
            int n = DiagramConstants.getSizeableAxis(map);
            if (n == 1) {
                d2 = 1.0;
            } else if (n == 2) {
                d = 1.0;
            }
            ((Point2D)object2).setLocation(point2D.getX() + (double)Math.round((((Point2D)object2).getX() - point2D.getX()) * d), point2D.getY() + (double)Math.round((((Point2D)object2).getY() - point2D.getY()) * d2));
            if (!((Point2D)object2).equals(object)) {
                DiagramConstants.translate(map, ((Point2D)object2).getX() - ((Point2D)object).getX(), ((Point2D)object2).getY() - ((Point2D)object).getY(), abstractDiagram);
            }
            double d3 = Math.max(1L, Math.round(rectangle2D.getWidth() * d));
            double d4 = Math.max(1L, Math.round(rectangle2D.getHeight() * d2));
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), d3, d4);
        }
        if ((object2 = DiagramConstants.getPoints(map)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (!(e instanceof Point2D)) continue;
                Point2D point2D2 = (Point2D)e;
                Point2D point2D3 = (Point2D)point2D2.clone();
                point2D3.setLocation(point2D.getX() + (double)Math.round((point2D3.getX() - point2D.getX()) * d), point2D.getY() + (double)Math.round((point2D3.getY() - point2D.getY()) * d2));
                point2D2.setLocation(point2D3);
            }
        }
    }

    public static void setFont(Map map, Font font) {
        map.put(FONT, font);
    }

    public static Font getFont(Map map) {
        Font font = (Font)map.get(FONT);
        if (font == null) {
            font = defaultFont;
        }
        return font;
    }

    public static final void setRemoveAttributes(Map map, Object[] objectArray) {
        map.put(REMOVEATTRIBUTES, objectArray);
    }

    public static final Object[] getRemoveAttributes(Map map) {
        return (Object[])map.get(REMOVEATTRIBUTES);
    }

    public static Map applyMap(Map map, Map map2) {
        Hashtable hashtable = new Hashtable();
        if (map != null) {
            Object[] objectArray;
            if (DiagramConstants.isRemoveAll(map)) {
                hashtable.putAll(map2);
                map2.clear();
            }
            if ((objectArray = DiagramConstants.getRemoveAttributes(map)) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Iterator iterator = map2.remove(objectArray[i]);
                    if (iterator == null) continue;
                    hashtable.put(objectArray[i], iterator);
                }
            }
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                if (k.equals(REMOVEALL) || k.equals(REMOVEATTRIBUTES)) continue;
                Object v = map2.put(k, entry.getValue());
                if (v == null) {
                    hashSet.add(k);
                    continue;
                }
                hashtable.put(k, v);
            }
            if (!hashSet.isEmpty()) {
                DiagramConstants.setRemoveAttributes(hashtable, hashSet.toArray());
            }
        }
        return hashtable;
    }

    public static final void setMoveableAxis(Map map, int n) {
        map.put(MOVEABLEAXIS, new Integer(n));
    }

    public static final int getMoveableAxis(Map map) {
        Integer n = (Integer)map.get(MOVEABLEAXIS);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setSizeableAxis(Map map, int n) {
        map.put(SIZEABLEAXIS, new Integer(n));
    }

    public static final int getSizeableAxis(Map map) {
        Integer n = (Integer)map.get(SIZEABLEAXIS);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setIcon(Map map, Icon icon) {
        map.put(ICON, icon);
    }

    public static final Icon getIcon(Map map) {
        return (Icon)map.get(ICON);
    }

    public static final void setOpaque(Map map, boolean bl) {
        map.put(OPAQUE, new Boolean(bl));
    }

    public static final boolean isOpaque(Map map) {
        Boolean bl = (Boolean)map.get(OPAQUE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setTransferable(Map map, boolean bl) {
        map.put(TRANSFERABLE, new Boolean(bl));
    }

    public static final boolean isTransferable(Map map) {
        Boolean bl = (Boolean)map.get(TRANSFERABLE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setBorder(Map map, Border border) {
        map.put(BORDER, border);
    }

    public static final Border getBorder(Map map) {
        return (Border)map.get(BORDER);
    }

    public static final void setLineColor(Map map, Color color) {
        map.put(LINECOLOR, color);
    }

    public static final Color getLineColor(Map map) {
        return (Color)map.get(LINECOLOR);
    }

    public static final void setBorderColor(Map map, Color color) {
        map.put(BORDERCOLOR, color);
    }

    public static final Color getBorderColor(Map map) {
        return (Color)map.get(BORDERCOLOR);
    }

    public static final void setLineWidth(Map map, float f) {
        map.put(LINEWIDTH, new Float(f));
    }

    public static final float getLineWidth(Map map) {
        Float f = (Float)map.get(LINEWIDTH);
        if (f != null) {
            return f.floatValue();
        }
        return 1.0f;
    }

    public static final void setForeground(Map map, Color color) {
        map.put(FOREGROUND, color);
    }

    public static final Color getForeground(Map map) {
        return (Color)map.get(FOREGROUND);
    }

    public static final void setBackground(Map map, Color color) {
        map.put(BACKGROUND, color);
    }

    public static final Color getBackground(Map map) {
        return (Color)map.get(BACKGROUND);
    }

    public static final void setVerticalAlignment(Map map, int n) {
        map.put(VERTICAL_ALIGNMENT, new Integer(n));
    }

    public static final int getVerticalAlignment(Map map) {
        Integer n = (Integer)map.get(VERTICAL_ALIGNMENT);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setHorizontalAlignment(Map map, int n) {
        map.put(HORIZONTAL_ALIGNMENT, new Integer(n));
    }

    public static final int getHorizontalAlignment(Map map) {
        Integer n = (Integer)map.get(HORIZONTAL_ALIGNMENT);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setVerticalTextPosition(Map map, int n) {
        map.put(VERTICAL_TEXT_POSITION, new Integer(n));
    }

    public static final int getVerticalTextPosition(Map map) {
        Integer n = (Integer)map.get(VERTICAL_TEXT_POSITION);
        if (n != null) {
            return n;
        }
        return 3;
    }

    public static final void setHorizontalTextPosition(Map map, int n) {
        map.put(HORIZONTAL_TEXT_POSITION, new Integer(n));
    }

    public static final int getHorizontalTextPosition(Map map) {
        Integer n = (Integer)map.get(HORIZONTAL_TEXT_POSITION);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setDashPattern(Map map, float[] fArray) {
        map.put(DASHPATTERN, fArray);
    }

    public static final float[] getDashPattern(Map map) {
        return (float[])map.get(DASHPATTERN);
    }

    public static final void setLineStyle(Map map, int n) {
        map.put(LINESTYLE, new Integer(n));
    }

    public static final int getLineStyle(Map map) {
        Integer n = (Integer)map.get(LINESTYLE);
        if (n != null) {
            return n;
        }
        return 11;
    }

    public static final void setBeginSize(Map map, int n) {
        map.put(BEGINSIZE, new Integer(n));
    }

    public static final int getBeginSize(Map map) {
        Integer n = (Integer)map.get(BEGINSIZE);
        if (n != null) {
            return n;
        }
        return 8;
    }

    public static final void setEndSize(Map map, int n) {
        map.put(ENDSIZE, new Integer(n));
    }

    public static final int getEndSize(Map map) {
        Integer n = (Integer)map.get(ENDSIZE);
        if (n != null) {
            return n;
        }
        return 8;
    }

    public static final void setLineBegin(Map map, int n) {
        map.put(LINEBEGIN, new Integer(n));
    }

    public static final int getLineBegin(Map map) {
        Integer n = (Integer)map.get(LINEBEGIN);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setLineEnd(Map map, int n) {
        map.put(LINEEND, new Integer(n));
    }

    public static final int getLineEnd(Map map) {
        Integer n = (Integer)map.get(LINEEND);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setValue(Map map, Object object) {
        map.put(VALUE, object);
    }

    public static final Object getValue(Map map) {
        return map.get(VALUE);
    }

    public static final void setLabelPosition(Map map, Point point) {
        map.put(LABELPOSITION, point);
    }

    public static final Point getLabelPosition(Map map) {
        return (Point)map.get(LABELPOSITION);
    }

    public static final void setSourceLabelPosition(Map map, Point point) {
        map.put(SOURCELABELPOSITION, point);
    }

    public static final Point getSourceLabelPosition(Map map) {
        return (Point)map.get(SOURCELABELPOSITION);
    }

    public static final void setTargetLabelPosition(Map map, Point point) {
        map.put(TARGETLABELPOSITION, point);
    }

    public static final Point getTargetLabelPosition(Map map) {
        return (Point)map.get(TARGETLABELPOSITION);
    }

    public static final void setLabelAlongEdge(Map map, boolean bl) {
        map.put(LABELALONGEDGE, new Boolean(bl));
    }

    public static final boolean isLabelAlongEdge(Map map) {
        Boolean bl = (Boolean)map.get(LABELALONGEDGE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setEditable(Map map, boolean bl) {
        map.put(EDITABLE, new Boolean(bl));
    }

    public static final boolean isEditable(Map map) {
        Boolean bl = (Boolean)map.get(EDITABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setMoveable(Map map, boolean bl) {
        map.put(MOVEABLE, new Boolean(bl));
    }

    public static final boolean isMoveable(Map map) {
        Boolean bl = (Boolean)map.get(MOVEABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setSizeable(Map map, boolean bl) {
        map.put(SIZEABLE, new Boolean(bl));
    }

    public static final boolean isSizeable(Map map) {
        Boolean bl = (Boolean)map.get(SIZEABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setAutoSize(Map map, boolean bl) {
        map.put(AUTOSIZE, new Boolean(bl));
    }

    public static final boolean isAutoSize(Map map) {
        Boolean bl = (Boolean)map.get(AUTOSIZE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setBendable(Map map, boolean bl) {
        map.put(BENDABLE, new Boolean(bl));
    }

    public static final boolean isBendable(Map map) {
        Boolean bl = (Boolean)map.get(BENDABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setConnectable(Map map, boolean bl) {
        map.put(CONNECTABLE, new Boolean(bl));
    }

    public static final boolean isConnectable(Map map) {
        Boolean bl = (Boolean)map.get(CONNECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setDisconnectable(Map map, boolean bl) {
        map.put(DISCONNECTABLE, new Boolean(bl));
    }

    public static final boolean isDisconnectable(Map map) {
        Boolean bl = (Boolean)map.get(DISCONNECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setPoints(Map map, List list) {
        map.put(POINTS, list);
    }

    public static final List getPoints(Map map) {
        return (List)map.get(POINTS);
    }

    public static final void setRouting(Map map, Edge.Routing routing) {
        map.put(ROUTING, routing);
    }

    public static final Edge.Routing getRouting(Map map) {
        return (Edge.Routing)map.get(ROUTING);
    }

    public static final void setBounds(Map map, Rectangle2D rectangle2D) {
        map.put(BOUNDS, rectangle2D);
    }

    public static final Rectangle2D getBounds(Map map) {
        return (Rectangle2D)map.get(BOUNDS);
    }

    public static final void setSize(Map map, Dimension dimension) {
        map.put(SIZE, dimension);
    }

    public static final Dimension getSize(Map map) {
        return (Dimension)map.get(SIZE);
    }

    public static final void setOffset(Map map, Point2D point2D) {
        map.put(OFFSET, point2D);
    }

    public static final Point2D getOffset(Map map) {
        return (Point2D)map.get(OFFSET);
    }

    public static final void setBeginFill(Map map, boolean bl) {
        map.put(BEGINFILL, new Boolean(bl));
    }

    public static final boolean isBeginFill(Map map) {
        Boolean bl = (Boolean)map.get(BEGINFILL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setBeginDashed(Map map, boolean bl) {
        map.put(BEGIN_DASHED, new Boolean(bl));
    }

    public static final boolean isBeginDashed(Map map) {
        Boolean bl = (Boolean)map.get(BEGIN_DASHED);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setEndDashed(Map map, boolean bl) {
        map.put(END_DASHED, new Boolean(bl));
    }

    public static final boolean isEndDashed(Map map) {
        Boolean bl = (Boolean)map.get(END_DASHED);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setEndFill(Map map, boolean bl) {
        map.put(ENDFILL, new Boolean(bl));
    }

    public static final boolean isEndFill(Map map) {
        Boolean bl = (Boolean)map.get(ENDFILL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setAbsolute(Map map, boolean bl) {
        map.put(ABSOLUTE, new Boolean(bl));
    }

    public static final boolean isAbsolute(Map map) {
        Boolean bl = (Boolean)map.get(ABSOLUTE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setRemoveAll(Map map, boolean bl) {
        map.put(REMOVEALL, new Boolean(bl));
    }

    public static final boolean isRemoveAll(Map map) {
        Boolean bl = (Boolean)map.get(REMOVEALL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static class SerializableRectangle2D
    extends Rectangle2D.Double
    implements Serializable {
        public SerializableRectangle2D() {
        }

        public SerializableRectangle2D(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new Double(this.getX()));
            objectOutputStream.writeObject(new Double(this.getY()));
            objectOutputStream.writeObject(new Double(this.getWidth()));
            objectOutputStream.writeObject(new Double(this.getHeight()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Double d = (Double)objectInputStream.readObject();
            Double d2 = (Double)objectInputStream.readObject();
            Double d3 = (Double)objectInputStream.readObject();
            Double d4 = (Double)objectInputStream.readObject();
            this.setFrame(d, d2, d3, d4);
        }
    }

    public static class SerializablePoint2D
    extends Point2D.Double
    implements Serializable {
        public SerializablePoint2D() {
        }

        public SerializablePoint2D(double d, double d2) {
            super(d, d2);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new Double(this.getX()));
            objectOutputStream.writeObject(new Double(this.getY()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Double d = (Double)objectInputStream.readObject();
            Double d2 = (Double)objectInputStream.readObject();
            this.setLocation(d, d2);
        }
    }
}

