/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.editor.FormatLineDialog;

public class DefaultEdge
extends DefaultDiagramCell
implements Edge {
    protected static final int center = 500;
    protected static final Point defaultLabel = new Point(500, 500);
    protected static final Point defaultSLabel = new Point(-1, -1);
    protected static final Point defaultTLabel = new Point(-1, -1);
    public static final ArrayList defaultPoints = new ArrayList();
    private int offset = 10;
    protected Object source;
    protected Object target;

    public DefaultEdge() {
        this(null);
    }

    public DefaultEdge(Object object) {
        this(object, false);
    }

    public DefaultEdge(Object object, boolean bl) {
        super(object, bl);
        DiagramConstants.setPoints(this.attributes, new ArrayList(defaultPoints));
        DiagramConstants.setLabelPosition(this.attributes, defaultLabel);
        DiagramConstants.setSourceLabelPosition(this.attributes, defaultSLabel);
        DiagramConstants.setTargetLabelPosition(this.attributes, defaultTLabel);
    }

    @Override
    public Map changeAttributes(Map map) {
        Map map2 = super.changeAttributes(map);
        List list = DiagramConstants.getPoints(this.attributes);
        if (list == null) {
            DiagramConstants.setPoints(this.attributes, new ArrayList(defaultPoints));
        }
        return map2;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public void setTarget(Object object) {
        this.target = object;
    }

    @Override
    public Object clone() {
        DefaultEdge defaultEdge = (DefaultEdge)super.clone();
        defaultEdge.source = null;
        defaultEdge.target = null;
        return defaultEdge;
    }

    public String getName() {
        return "";
    }

    @Override
    public void format() {
        if (this.getTopView() != null) {
            new FormatLineDialog(this.getTopView().getDesignPartView().getSelectedTVConnectors()).setVisible(true);
            this.getCellView().getDiagram().repaint();
        }
    }

    public void addBreakpoint(Point point) {
        try {
            Point2D.Double double_ = new Point2D.Double(point.getX(), point.getY());
            this.getDiagram().fromScreen(double_);
            AbstractCellView abstractCellView = this.getCellView();
            if (abstractCellView != null && abstractCellView instanceof EdgeView) {
                EdgeView edgeView = (EdgeView)abstractCellView;
                int n = 0;
                double d = Double.MAX_VALUE;
                double d2 = 0.0;
                for (int i = 0; i < edgeView.getPointCount() - 1; ++i) {
                    Point2D point2D;
                    Point2D point2D2 = edgeView.getPoint(i);
                    d2 = new Line2D.Double(point2D2, point2D = edgeView.getPoint(i + 1)).ptLineDistSq(double_);
                    if (!(d2 < d)) continue;
                    d = d2;
                    n = i + 1;
                }
                edgeView.addPoint(n, double_);
                edgeView.updatePoints();
                edgeView.getEdgeRenderer().repaint();
            }
        }
        catch (Exception exception) {
            System.out.println("Error: DefaultEdge.addBreakpoint");
        }
    }

    public void removeBreakpoint(Point point) {
        block3: {
            try {
                Point2D.Double double_ = new Point2D.Double(point.getX(), point.getY());
                this.getDiagram().fromScreen(double_);
                AbstractCellView abstractCellView = this.getCellView();
                if (abstractCellView == null || !(abstractCellView instanceof EdgeView)) break block3;
                EdgeView edgeView = (EdgeView)abstractCellView;
                int n = edgeView.getPointCount();
                int n2 = this.getDiagram().getHandleSize();
                if (n <= 2) break block3;
                for (int i = n - 2; i >= 1; --i) {
                    Point2D point2D = edgeView.getPoint(i);
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(point2D.getX() - (double)n2, point2D.getY() - (double)n2, 2 * n2, 2 * n2);
                    if (!double_2.contains(((Point2D)double_).getX(), ((Point2D)double_).getY())) continue;
                    edgeView.removePoint(i);
                    edgeView.updatePoints();
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Error: DefaultEdge.removeBreakpoint");
            }
        }
    }

    public boolean hasBreakpointAt(Point point) {
        Point2D.Double double_ = new Point2D.Double(point.getX(), point.getY());
        this.getDiagram().fromScreen(double_);
        AbstractCellView abstractCellView = this.getCellView();
        if (abstractCellView != null && abstractCellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)abstractCellView;
            int n = edgeView.getPointCount();
            int n2 = this.getDiagram().getHandleSize();
            if (n > 2) {
                for (int i = n - 2; i >= 1; --i) {
                    Point2D point2D = edgeView.getPoint(i);
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(point2D.getX() - (double)n2, point2D.getY() - (double)n2, 2 * n2, 2 * n2);
                    if (!double_2.contains(((Point2D)double_).getX(), ((Point2D)double_).getY())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void straightLine() {
        this.straightLine(true);
    }

    public void straightLine(boolean bl) {
        this.straightLine(bl, true);
    }

    public void straightLine(boolean bl, boolean bl2) {
        try {
            AbstractCellView abstractCellView;
            if (DiagramConstants.getRouting(this.getTopView().getCellView().getAllAttributes()) == null && (abstractCellView = this.getTopView().getCellView()) != null && abstractCellView instanceof EdgeView) {
                EdgeView edgeView = (EdgeView)abstractCellView;
                int n = edgeView.getPointCount();
                if (!bl2 && n > 2) {
                    return;
                }
                if (n > 2) {
                    for (int i = n - 2; i >= 1; --i) {
                        edgeView.removePoint(i);
                    }
                }
                CellView cellView = edgeView.getSource();
                CellView cellView2 = edgeView.getTarget();
                if (cellView != null && cellView2 != null && cellView != cellView2 && cellView instanceof PortView && cellView2 instanceof PortView) {
                    Rectangle2D rectangle2D = cellView.getParentView().getBounds();
                    Rectangle2D rectangle2D2 = cellView2.getParentView().getBounds();
                    if (rectangle2D.getY() <= rectangle2D2.getMaxY() && rectangle2D.getY() >= rectangle2D2.getY() || rectangle2D2.getY() <= rectangle2D.getMaxY() && rectangle2D2.getY() >= rectangle2D.getY()) {
                        double d = Math.max(rectangle2D.getY(), rectangle2D2.getY());
                        double d2 = Math.min(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
                        double d3 = (d + d2) / 2.0;
                        PortView portView = (PortView)cellView;
                        PortView portView2 = (PortView)cellView2;
                        Point2D point2D = portView.getPoint();
                        Point2D point2D2 = portView2.getPoint();
                        if (!bl || point2D.getY() != point2D2.getY() || point2D.getY() < d || point2D.getY() > d2) {
                            if (point2D == null) {
                                point2D = new Point2D.Double();
                            }
                            if (point2D2 == null) {
                                point2D2 = new Point2D.Double();
                            }
                            if (rectangle2D.getX() >= rectangle2D2.getX()) {
                                point2D.setLocation(rectangle2D.getX(), d3);
                            } else {
                                point2D.setLocation(rectangle2D.getMaxX(), d3);
                            }
                            if (rectangle2D2.getX() >= rectangle2D.getX()) {
                                point2D2.setLocation(rectangle2D2.getX(), d3);
                            } else {
                                point2D2.setLocation(rectangle2D2.getMaxX(), d3);
                            }
                            double d4 = d3;
                            double d5 = d3;
                            while (portView.getOtherPortAt(point2D) != null && d5 + (double)this.offset <= d2 && d4 - (double)this.offset >= d) {
                                point2D.setLocation(point2D.getX(), d5 + (double)this.offset);
                                d5 = point2D.getY();
                                if (portView.getOtherPortAt(point2D) == null) continue;
                                point2D.setLocation(point2D.getX(), d4 - (double)this.offset);
                                d4 = point2D.getY();
                            }
                            point2D2.setLocation(point2D2.getX(), point2D.getY());
                            d5 = d4 = point2D2.getY();
                            while (portView2.getOtherPortAt(point2D2) != null && d5 + (double)this.offset <= d2 && d4 - (double)this.offset >= d) {
                                point2D2.setLocation(point2D2.getX(), d5 + (double)this.offset);
                                d5 = point2D2.getY();
                                if (portView2.getOtherPortAt(point2D2) == null) continue;
                                point2D2.setLocation(point2D2.getX(), d4 - (double)this.offset);
                                d4 = point2D2.getY();
                            }
                            point2D.setLocation(point2D.getX(), point2D2.getY());
                            portView.setPoint(point2D);
                            portView2.setPoint(point2D2);
                        }
                    } else if (rectangle2D.getX() <= rectangle2D2.getMaxX() && rectangle2D.getX() >= rectangle2D2.getX() || rectangle2D2.getX() <= rectangle2D.getMaxX() && rectangle2D2.getX() >= rectangle2D.getX()) {
                        double d = Math.max(rectangle2D.getX(), rectangle2D2.getX());
                        double d6 = Math.min(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
                        double d7 = (d + d6) / 2.0;
                        PortView portView = (PortView)cellView;
                        PortView portView3 = (PortView)cellView2;
                        Point2D point2D = portView.getPoint();
                        Point2D point2D3 = portView3.getPoint();
                        if (!bl || point2D.getX() != point2D3.getX() || point2D.getX() < d || point2D.getX() > d6) {
                            if (point2D == null) {
                                point2D = new Point2D.Double();
                            }
                            if (point2D3 == null) {
                                point2D3 = new Point2D.Double();
                            }
                            if (rectangle2D.getY() >= rectangle2D2.getY()) {
                                point2D.setLocation(d7, rectangle2D.getY());
                            } else {
                                point2D.setLocation(d7, rectangle2D.getMaxY());
                            }
                            if (rectangle2D2.getY() >= rectangle2D.getY()) {
                                point2D3.setLocation(d7, rectangle2D2.getY());
                            } else {
                                point2D3.setLocation(d7, rectangle2D2.getMaxY());
                            }
                            double d8 = d7;
                            double d9 = d7;
                            while (portView.getOtherPortAt(point2D) != null && d9 + (double)this.offset <= d6 && d8 - (double)this.offset >= d) {
                                point2D.setLocation(d9 + (double)this.offset, point2D.getY());
                                d9 = point2D.getX();
                                if (portView.getOtherPortAt(point2D) == null) continue;
                                point2D.setLocation(d8 - (double)this.offset, point2D.getY());
                                d8 = point2D.getX();
                            }
                            point2D3.setLocation(point2D.getX(), point2D3.getY());
                            d9 = d8 = point2D3.getX();
                            while (portView3.getOtherPortAt(point2D3) != null && d9 + (double)this.offset <= d6 && d8 - (double)this.offset >= d) {
                                point2D3.setLocation(d9 + (double)this.offset, point2D3.getY());
                                d9 = point2D3.getX();
                                if (portView3.getOtherPortAt(point2D3) == null) continue;
                                point2D3.setLocation(d8 - (double)this.offset, point2D3.getY());
                                d8 = point2D3.getX();
                            }
                            point2D.setLocation(point2D3.getX(), point2D.getY());
                            portView.setPoint(point2D);
                            portView3.setPoint(point2D3);
                        }
                    } else {
                        PortView portView = (PortView)cellView;
                        PortView portView4 = (PortView)cellView2;
                        portView.setPoint(portView.getSimpleLocation(edgeView));
                        portView4.setPoint(portView4.getSimpleLocation(edgeView));
                    }
                }
                edgeView.updatePoints();
                edgeView.refreshLabels();
            }
        }
        catch (Exception exception) {
            System.out.println("Error: DefaultEdge.straightLine");
        }
    }

    protected boolean onlyEdgesAreSelected() {
        this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
        if (this.selectedObjects.length > 1) {
            for (int i = 0; i < this.selectedObjects.length; ++i) {
                Object object = this.selectedObjects[i];
                try {
                    if (object instanceof DesignObject && ((DesignObject)object).getTopView().getCellView().getCell() instanceof DefaultEdge) continue;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return true;
    }

    public void straightenLine() {
        String string = Messages.getString("DefaultEdge.StraightenLinesForGroupOfObjects");
        DesignPartView designPartView = this.getTopView().getDesignPartView();
        this.selectedObjects = designPartView.getSelectedObjects();
        if (this.selectedObjects.length == 1) {
            Object object = this.selectedObjects[0];
            string = MessageFormat.format(Messages.getString("DefaultEdge.StraightenLinesFor"), object.toString());
        }
        designPartView.startAutoLayoutEdit(string);
        if (this.selectedObjects.length > 1) {
            for (int i = 0; i < this.selectedObjects.length; ++i) {
                Object object = this.selectedObjects[i];
                try {
                    TopView topView;
                    if (!(object instanceof DesignObject) || (topView = ((DesignObject)object).getFirstViewForDPV(designPartView)) == null || !(topView.getCellView().getCell() instanceof DefaultEdge)) continue;
                    DefaultEdge defaultEdge = (DefaultEdge)topView.getCellView().getCell();
                    defaultEdge.straightLine();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            this.straightLine();
        }
        designPartView.stopAutoLayoutEdit();
    }

    public void clearLabels() {
        ((TVConnector)this.getTopView()).clearLabels();
    }

    static {
        defaultPoints.add(DiagramConstants.createPoint(10.0, 10.0));
        defaultPoints.add(DiagramConstants.createPoint(20.0, 20.0));
    }

    public static class DefaultRouting
    implements Edge.Routing {
        @Override
        public void route(EdgeView edgeView, List list) {
            Point2D[] point2DArray;
            Cloneable cloneable;
            int n = list.size();
            Point2D point2D = edgeView.getPoint(0);
            if (edgeView.getSource() instanceof PortView) {
                point2D = ((PortView)edgeView.getSource()).getLocation(null);
            } else if (edgeView.getSource() != null) {
                cloneable = edgeView.getSource().getBounds();
                point2D = DiagramConstants.createPoint(((RectangularShape)cloneable).getCenterX(), ((RectangularShape)cloneable).getCenterY());
            }
            cloneable = edgeView.getPoint(n - 1);
            if (edgeView.getTarget() instanceof PortView) {
                cloneable = ((PortView)edgeView.getTarget()).getLocation(null);
            } else if (edgeView.getTarget() != null) {
                point2DArray = edgeView.getTarget().getBounds();
                cloneable = DiagramConstants.createPoint(point2DArray.getCenterX(), point2DArray.getCenterY());
            }
            if (point2D != null && cloneable != null) {
                double d;
                point2DArray = null;
                if (edgeView.isSelfReference()) {
                    Rectangle2D rectangle2D = edgeView.getSource().getParentView().getBounds();
                    AbstractCellView abstractCellView = (AbstractCellView)edgeView.getSource().getParentView();
                    d = 25 * abstractCellView.getSelfRefPos(edgeView);
                    point2DArray = new Point2D[]{DiagramConstants.createPoint(rectangle2D.getX() + rectangle2D.getWidth() + d, rectangle2D.getY() + rectangle2D.getHeight() / 2.0), DiagramConstants.createPoint(rectangle2D.getX() + rectangle2D.getWidth() + d, rectangle2D.getY() + rectangle2D.getHeight() + d), DiagramConstants.createPoint(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() + d)};
                } else {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6 = Math.abs(point2D.getX() - ((Point2D)cloneable).getX());
                    d = Math.abs(point2D.getY() - ((Point2D)cloneable).getY());
                    Rectangle2D rectangle2D = null;
                    Rectangle2D rectangle2D2 = null;
                    if (edgeView.getSource() != null && edgeView.getTarget() != null) {
                        rectangle2D = edgeView.getSource().getParentView().getBounds();
                        rectangle2D2 = edgeView.getTarget().getParentView().getBounds();
                        d5 = rectangle2D.getX() + rectangle2D.getWidth() + (rectangle2D2.getX() - (rectangle2D.getX() + rectangle2D.getWidth())) / 2.0;
                        d4 = rectangle2D.getY() + rectangle2D.getHeight() + (rectangle2D2.getY() - (rectangle2D.getY() + rectangle2D.getHeight())) / 2.0;
                    } else {
                        d5 = point2D.getX() + (((Point2D)cloneable).getX() - point2D.getX()) / 2.0;
                        d4 = point2D.getY() + (((Point2D)cloneable).getY() - point2D.getY()) / 2.0;
                    }
                    point2DArray = new Point2D[2];
                    double d7 = Math.max(edgeView.getSourceOffcet(), edgeView.getTargetOffcet());
                    if (d6 > d) {
                        d3 = point2D.getY() + edgeView.getSourceOffcet();
                        d2 = ((Point2D)cloneable).getY() + edgeView.getTargetOffcet();
                        if (rectangle2D != null) {
                            if (d3 <= rectangle2D.getY()) {
                                d3 = rectangle2D.getY() + 1.0;
                            } else if (d3 >= rectangle2D.getY() + rectangle2D.getHeight()) {
                                d3 = rectangle2D.getY() + rectangle2D.getHeight() - 1.0;
                            }
                        }
                        if (rectangle2D2 != null) {
                            if (d2 <= rectangle2D2.getY()) {
                                d2 = rectangle2D2.getY() + 1.0;
                            } else if (d2 >= rectangle2D2.getY() + rectangle2D2.getHeight()) {
                                d2 = rectangle2D2.getY() + rectangle2D2.getHeight() - 1.0;
                            }
                        }
                        point2DArray[0] = DiagramConstants.createPoint(d5 - d7, d3);
                        point2DArray[1] = DiagramConstants.createPoint(d5 - d7, d2);
                    } else {
                        d3 = point2D.getX() + edgeView.getSourceOffcet();
                        d2 = ((Point2D)cloneable).getX() + edgeView.getTargetOffcet();
                        if (rectangle2D != null) {
                            if (d3 <= rectangle2D.getX()) {
                                d3 = rectangle2D.getX() + 1.0;
                            } else if (d3 >= rectangle2D.getX() + rectangle2D.getWidth()) {
                                d3 = rectangle2D.getX() + rectangle2D.getWidth() - 1.0;
                            }
                        }
                        if (rectangle2D2 != null) {
                            if (d2 <= rectangle2D2.getX()) {
                                d2 = rectangle2D2.getX() + 1.0;
                            } else if (d2 >= rectangle2D2.getX() + rectangle2D2.getWidth()) {
                                d2 = rectangle2D2.getX() + rectangle2D2.getWidth() - 1.0;
                            }
                        }
                        point2DArray[0] = DiagramConstants.createPoint(d3, d4 - d7);
                        point2DArray[1] = DiagramConstants.createPoint(d2, d4 - d7);
                    }
                }
                for (int i = 0; i < point2DArray.length; ++i) {
                    if (list.size() > i + 2) {
                        list.set(i + 1, point2DArray[i]);
                        continue;
                    }
                    list.add(i + 1, point2DArray[i]);
                }
                while (list.size() > point2DArray.length + 2) {
                    list.remove(list.size() - 2);
                }
            }
        }
    }
}

