/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.ParentMap;
import oracle.dbtools.crest.swingui.diagram.graph.Port;

public class DefaultDiagramModel
extends UndoableEditSupport
implements Serializable,
DiagramModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = new ArrayList();
    protected boolean asksAllowsChildren = false;
    protected Map attributes = new Hashtable();

    @Override
    public int getRootCount() {
        return this.roots.size();
    }

    @Override
    public Object getRootAt(int n) {
        return this.roots.get(n);
    }

    @Override
    public int getIndexOfRoot(Object object) {
        return this.roots.indexOf(object);
    }

    @Override
    public boolean contains(Object object) {
        Object object2 = null;
        while ((object2 = this.getParent(object)) != null) {
            object = object2;
        }
        return this.roots.contains(object);
    }

    @Override
    public Map getAttributes(Object object) {
        if (object instanceof DiagramCell) {
            return ((DiagramCell)object).getAttributes();
        }
        return this.attributes;
    }

    public Map getAttributes() {
        return this.getAttributes(null);
    }

    @Override
    public Object getSource(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getSource();
        }
        return null;
    }

    @Override
    public Object getTarget(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getTarget();
        }
        return null;
    }

    @Override
    public boolean acceptsSource(Object object, Object object2) {
        return true;
    }

    @Override
    public boolean acceptsTarget(Object object, Object object2) {
        return true;
    }

    @Override
    public Iterator edges(Object object) {
        if (object instanceof Port) {
            return ((Port)object).edges();
        }
        return this.emptyIterator;
    }

    @Override
    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    @Override
    public boolean isPort(Object object) {
        return object instanceof Port;
    }

    @Override
    public Map cloneCells(Object[] objectArray) {
        DiagramCell diagramCell;
        Hashtable<Object, Port> hashtable = new Hashtable<Object, Port>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        while (!arrayList.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object e = arrayList.remove(0);
            if (!(e instanceof DefaultDiagramCell)) continue;
            for (int i = 0; i < this.getChildCount(e); ++i) {
                arrayList.add(this.getChild(e, i));
            }
            Object object = (DefaultDiagramCell)e;
            diagramCell = (DefaultDiagramCell)((DefaultDiagramCell)object).clone();
            Object object2 = this.getParent(object);
            if (object2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)hashtable.get(object2)) != null) {
                defaultMutableTreeNode.add((MutableTreeNode)((Object)diagramCell));
            }
            hashtable.put(object, (Port)diagramCell);
        }
        for (Object object : hashtable.values()) {
            if (!(object instanceof Port) || (diagramCell = ((Port)object).getAnchor()) == null) continue;
            ((Port)object).setAnchor((Port)hashtable.get(diagramCell));
        }
        return hashtable;
    }

    @Override
    public Object getParent(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getParent();
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    @Override
    public Object getChild(Object object, int n) {
        try {
            if (object instanceof TreeNode) {
                return ((TreeNode)object).getChildAt(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (this.asksAllowsChildren && object instanceof TreeNode) {
            return !((TreeNode)object).getAllowsChildren();
        }
        return ((TreeNode)object).isLeaf();
    }

    @Override
    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        DiagramModelEdit diagramModelEdit = this.createInsertEdit(objectArray, map, connectionSet, parentMap, undoableEditArray);
        if (diagramModelEdit != null) {
            diagramModelEdit.execute();
            if (undoableEditArray != null) {
                for (int i = 0; i < undoableEditArray.length; ++i) {
                    if (!(undoableEditArray[i] instanceof DiagramModelEvent.ExecutableDiagramChange)) continue;
                    ((DiagramModelEvent.ExecutableDiagramChange)((Object)undoableEditArray[i])).execute();
                }
            }
            this.postEdit(diagramModelEdit);
        }
    }

    @Override
    public void remove(Object[] objectArray) {
        DiagramModelEdit diagramModelEdit = this.createRemoveEdit(objectArray);
        if (diagramModelEdit != null) {
            diagramModelEdit.execute();
            this.postEdit(diagramModelEdit);
        }
    }

    @Override
    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        this.edit(map, connectionSet, parentMap, undoableEditArray, true);
    }

    @Override
    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray, boolean bl) {
        if ((map == null || map.isEmpty()) && (connectionSet == null || connectionSet.isEmpty()) && parentMap == null && undoableEditArray != null && undoableEditArray.length == 1) {
            if (undoableEditArray[0] instanceof DiagramModelEvent.ExecutableDiagramChange) {
                ((DiagramModelEvent.ExecutableDiagramChange)((Object)undoableEditArray[0])).execute();
            }
            this.postEdit(undoableEditArray[0]);
        } else {
            DiagramModelEdit diagramModelEdit = this.createCellEdit(map, connectionSet, parentMap, undoableEditArray);
            if (diagramModelEdit != null) {
                diagramModelEdit.execute();
                if (undoableEditArray != null) {
                    for (int i = 0; i < undoableEditArray.length; ++i) {
                        if (!(undoableEditArray[i] instanceof DiagramModelEvent.ExecutableDiagramChange)) continue;
                        ((DiagramModelEvent.ExecutableDiagramChange)((Object)undoableEditArray[i])).execute();
                    }
                }
                if (bl) {
                    this.postEdit(diagramModelEdit);
                }
            }
        }
    }

    @Override
    public void toBack(Object[] objectArray) {
        DiagramModelLayerEdit diagramModelLayerEdit = this.createLayerEdit(objectArray, -2);
        if (diagramModelLayerEdit != null) {
            diagramModelLayerEdit.execute();
            this.postEdit(diagramModelLayerEdit);
        }
    }

    @Override
    public void toFront(Object[] objectArray) {
        DiagramModelLayerEdit diagramModelLayerEdit = this.createLayerEdit(objectArray, -1);
        if (diagramModelLayerEdit != null) {
            diagramModelLayerEdit.execute();
            this.postEdit(diagramModelLayerEdit);
        }
    }

    protected DiagramModelLayerEdit createLayerEdit(Object[] objectArray, int n) {
        return new DiagramModelLayerEdit(objectArray, n);
    }

    protected DiagramModelEdit createInsertEdit(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        DiagramModelEdit diagramModelEdit = this.createEdit(objectArray, null, map, connectionSet, parentMap);
        if (diagramModelEdit != null) {
            if (undoableEditArray != null) {
                for (int i = 0; i < undoableEditArray.length; ++i) {
                    diagramModelEdit.addEdit(undoableEditArray[i]);
                }
            }
            diagramModelEdit.end();
        }
        return diagramModelEdit;
    }

    protected DiagramModelEdit createRemoveEdit(Object[] objectArray) {
        ParentMap parentMap;
        ConnectionSet connectionSet = ConnectionSet.create(this, objectArray, false);
        DiagramModelEdit diagramModelEdit = this.createEdit(null, objectArray, null, connectionSet, parentMap = ParentMap.create(this, objectArray, true, false));
        if (diagramModelEdit != null) {
            diagramModelEdit.end();
        }
        return diagramModelEdit;
    }

    protected DiagramModelEdit createCellEdit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        DiagramModelEdit diagramModelEdit = this.createEdit(null, null, map, connectionSet, parentMap);
        if (diagramModelEdit != null) {
            if (undoableEditArray != null) {
                for (int i = 0; i < undoableEditArray.length; ++i) {
                    diagramModelEdit.addEdit(undoableEditArray[i]);
                }
            }
            diagramModelEdit.end();
        }
        return diagramModelEdit;
    }

    protected DiagramModelEdit createEdit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
        return new DiagramModelEdit(objectArray, objectArray2, map, connectionSet, parentMap);
    }

    protected Object[] handleInsert(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.getParent(objectArray[i]) != null) continue;
                this.roots.add(objectArray[i]);
            }
            objectArray2 = DefaultDiagramModel.getDescendants(this, objectArray).toArray();
        }
        return objectArray2;
    }

    protected Object[] handleRemove(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.getParent(objectArray[i]) != null || !this.roots.remove(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
        }
        return arrayList.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap parentMap2 = new ParentMap();
            Iterator iterator = parentMap.entries();
            while (iterator.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                Object object = entry.getChild();
                Object object2 = entry.getParent();
                parentMap2.addEntry(object, this.getParent(object));
                if (object2 == null) {
                    if (object instanceof MutableTreeNode) {
                        ((MutableTreeNode)object).removeFromParent();
                    }
                } else if (object2 instanceof DefaultMutableTreeNode && object instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object);
                }
                boolean bl = this.roots.contains(object);
                if (object2 == null && !bl) {
                    this.roots.add(object);
                    continue;
                }
                if (object2 == null || !bl) continue;
                this.roots.remove(object);
            }
            return parentMap2;
        }
        return null;
    }

    protected Map handleAttributes(Map map) {
        if (map != null) {
            Hashtable hashtable = new Hashtable();
            for (Map.Entry entry : map.entrySet()) {
                Map map2;
                Object k = entry.getKey();
                Map map3 = (Map)entry.getValue();
                if (k instanceof DiagramCell) {
                    map2 = ((DiagramCell)k).changeAttributes(map3);
                    hashtable.put(k, map2);
                    continue;
                }
                map2 = this.getAttributes(k);
                if (map2 == null) continue;
                Map map4 = DiagramConstants.applyMap(map3, map2);
                hashtable.put(k, map4);
            }
            return hashtable;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet connectionSet) {
        if (connectionSet != null) {
            ConnectionSet connectionSet2 = new ConnectionSet();
            Iterator iterator = connectionSet.connections();
            while (iterator.hasNext()) {
                ConnectionSet.Connection connection = (ConnectionSet.Connection)iterator.next();
                Object object = connection.getEdge();
                if (connection.isSource()) {
                    connectionSet2.connect(object, this.getSource(object), true);
                } else {
                    connectionSet2.connect(object, this.getTarget(object), false);
                }
                this.handleConnection(connection);
            }
            return connectionSet2;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection connection) {
        Object object = connection.getEdge();
        Object object2 = connection.isSource() ? this.getSource(object) : this.getTarget(object);
        Object object3 = connection.getPort();
        if (object3 != object2) {
            this.connect(object, object2, connection.isSource(), true);
            if (this.contains(object3) && this.contains(object)) {
                this.connect(object, object3, connection.isSource(), false);
            }
        }
    }

    protected void connect(Object object, Object object2, boolean bl, boolean bl2) {
        if (object2 instanceof Port) {
            if (bl2) {
                ((Port)object2).removeEdge(object);
            } else {
                ((Port)object2).addEdge(object);
            }
        }
        if (bl2) {
            object2 = null;
        }
        if (object instanceof Edge) {
            if (bl) {
                ((Edge)object).setSource(object2);
            } else {
                ((Edge)object).setTarget(object2);
            }
        }
    }

    @Override
    public void addDiagramModelListener(DiagramModelListener diagramModelListener) {
        this.listenerList.add(DiagramModelListener.class, diagramModelListener);
    }

    @Override
    public void removeDiagramModelListener(DiagramModelListener diagramModelListener) {
        this.listenerList.remove(DiagramModelListener.class, diagramModelListener);
    }

    protected void fireDiagramChanged(Object object, DiagramModelEvent.DiagramModelChange diagramModelChange) {
        Object[] objectArray = this.listenerList.getListenerList();
        DiagramModelEvent diagramModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DiagramModelListener.class) continue;
            if (diagramModelEvent == null) {
                diagramModelEvent = new DiagramModelEvent(object, diagramModelChange);
            }
            ((DiagramModelListener)objectArray[i + 1]).diagramChanged(diagramModelEvent);
        }
    }

    public DiagramModelListener[] getDiagramModelListeners() {
        return (DiagramModelListener[])this.listenerList.getListeners(DiagramModelListener.class);
    }

    public static Object getSourceVertex(DiagramModel diagramModel, Object object) {
        if (diagramModel != null) {
            return diagramModel.getParent(diagramModel.getSource(object));
        }
        return null;
    }

    public static Object getTargetVertex(DiagramModel diagramModel, Object object) {
        if (diagramModel != null) {
            return diagramModel.getParent(diagramModel.getTarget(object));
        }
        return null;
    }

    public static Object[] getRoots(DiagramModel diagramModel) {
        Object[] objectArray = null;
        if (diagramModel != null) {
            objectArray = new Object[diagramModel.getRootCount()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = diagramModel.getRootAt(i);
            }
        }
        return objectArray;
    }

    public static Set getEdges(DiagramModel diagramModel, Object[] objectArray) {
        HashSet hashSet = new HashSet();
        Set set = DefaultDiagramModel.getDescendants(diagramModel, objectArray);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = diagramModel.edges(iterator.next());
                while (iterator2.hasNext()) {
                    hashSet.add(iterator2.next());
                }
            }
            hashSet.removeAll(set);
        }
        return hashSet;
    }

    public static Set getDescendants(DiagramModel diagramModel, Object[] objectArray) {
        if (objectArray != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                stack.add(objectArray[i]);
            }
            HashSet hashSet = new HashSet();
            while (!stack.isEmpty()) {
                Object e = stack.pop();
                for (int i = 0; i < diagramModel.getChildCount(e); ++i) {
                    stack.add(diagramModel.getChild(e, i));
                }
                if (e == null) continue;
                hashSet.add(e);
            }
            return hashSet;
        }
        return null;
    }

    public static List getDescendantList(DiagramModel diagramModel, Object[] objectArray) {
        if (objectArray != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                stack.add(objectArray[i]);
            }
            LinkedList linkedList = new LinkedList();
            while (!stack.isEmpty()) {
                Object e = stack.pop();
                for (int i = diagramModel.getChildCount(e) - 1; i >= 0; --i) {
                    stack.add(diagramModel.getChild(e, i));
                }
                if (e == null) continue;
                linkedList.add(e);
            }
            return linkedList;
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public class DiagramModelLayerEdit
    extends DiagramLayoutCache.DiagramViewLayerEdit
    implements DiagramModelEvent.DiagramModelChange {
        protected Object[] parents;

        public DiagramModelLayerEdit(Object[] objectArray, int n) {
            super(DefaultDiagramModel.this, objectArray, n);
            HashSet<TreeNode> hashSet = new HashSet<TreeNode>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof TreeNode)) continue;
                hashSet.add(((TreeNode)objectArray[i]).getParent());
            }
            this.parents = hashSet.toArray();
        }

        @Override
        public Object getSource() {
            return DefaultDiagramModel.this;
        }

        @Override
        public Object[] getChanged() {
            return this.parents;
        }

        @Override
        public Object[] getInserted() {
            return null;
        }

        @Override
        public Object[] getRemoved() {
            return null;
        }

        @Override
        public Map getPreviousAttributes() {
            return null;
        }

        @Override
        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        @Override
        public ParentMap getPreviousParentMap() {
            return null;
        }

        public void addImplicitEdit(UndoableEdit undoableEdit) {
        }

        @Override
        public CellView[] getViews(DiagramLayoutCache diagramLayoutCache) {
            return null;
        }

        @Override
        public void putViews(DiagramLayoutCache diagramLayoutCache, CellView[] cellViewArray) {
        }

        @Override
        protected void updateListeners() {
            DefaultDiagramModel.this.fireDiagramChanged(DefaultDiagramModel.this, this);
        }

        @Override
        protected List getParentList(Object object) {
            List list = null;
            if (object instanceof DefaultMutableTreeNode) {
                TreeNode treeNode = ((DefaultMutableTreeNode)object).getParent();
                list = treeNode instanceof DefaultDiagramCell ? ((DefaultDiagramCell)treeNode).getChildren() : DefaultDiagramModel.this.roots;
            }
            return list;
        }
    }

    public class DiagramModelEdit
    extends CompoundEdit
    implements DiagramModelEvent.DiagramModelChange,
    DiagramModelEvent.ExecutableDiagramChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();
        boolean inProgress_ = true;
        boolean firstExecute = true;
        String presentation;

        public DiagramModelEdit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
            Iterator iterator;
            Iterator iterator2;
            this.insert = objectArray;
            this.remove = objectArray2;
            this.connectionSet = connectionSet;
            this.attributes = map;
            this.parentMap = parentMap;
            this.previousAttributes = map;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                iterator2 = new Hashtable();
                iterator = parentMap.entries();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                    Object object3 = entry.getChild();
                    if (DefaultDiagramModel.this.isPort(object3) || (object2 = DefaultDiagramModel.this.getParent(object3)) == (object = entry.getParent())) continue;
                    this.changeChildCount((Map)((Object)iterator2), object2, -1);
                    this.changeChildCount((Map)((Object)iterator2), object, 1);
                }
                this.handleEmptyGroups(this.filterParents((Map)((Object)iterator2), 0));
            }
            if (map != null && map.keySet().size() > 1) {
                this.presentation = Messages.getString("DefaultDiagramModel.MoveOfGroupOfObjects");
            } else if (map != null && map.keySet().size() == 1) {
                iterator2 = map.keySet().iterator();
                iterator = iterator2.next();
                this.presentation = iterator instanceof DefaultDiagramCell && ((DefaultDiagramCell)((Object)iterator)).getTopView() != null ? ((DefaultDiagramCell)((Object)iterator)).getTopView().toString() : iterator.toString();
            }
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (!this.inProgress_) {
                return false;
            }
            UndoableEdit undoableEdit2 = this.lastEdit();
            if (undoableEdit2 == null) {
                this.edits.addElement(undoableEdit);
            } else if (!undoableEdit2.addEdit(undoableEdit)) {
                if (undoableEdit.replaceEdit(undoableEdit2)) {
                    this.edits.removeElementAt(this.edits.size() - 1);
                }
                this.edits.addElement(undoableEdit);
            }
            return true;
        }

        @Override
        public void end() {
            super.end();
            this.inProgress_ = false;
        }

        public Object[] filterParents(Map map, int n) {
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != n) continue;
                arrayList.add(entry.getKey());
            }
            return arrayList.toArray();
        }

        protected void changeChildCount(Map map, Object object, int n) {
            if (object != null) {
                Integer n2 = (Integer)map.get(object);
                if (n2 == null) {
                    n2 = new Integer(DefaultDiagramModel.this.getChildCount(object));
                }
                int n3 = n2 + n;
                map.put(object, new Integer(n3));
            }
        }

        protected void handleEmptyGroups(Object[] objectArray) {
            if (objectArray != null && objectArray.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] objectArray2 = new Object[this.remove.length + objectArray.length];
                System.arraycopy(this.remove, 0, objectArray2, 0, this.remove.length);
                System.arraycopy(objectArray, 0, objectArray2, this.remove.length, objectArray.length);
                this.remove = objectArray2;
            }
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public Object getSource() {
            return DefaultDiagramModel.this;
        }

        @Override
        public Object[] getChanged() {
            return this.changed;
        }

        @Override
        public Object[] getContext() {
            return this.context;
        }

        @Override
        public Object[] getInserted() {
            return this.inserted;
        }

        @Override
        public Object[] getRemoved() {
            return this.removed;
        }

        @Override
        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        @Override
        public Map getAttributes() {
            return this.attributes;
        }

        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        @Override
        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        public ParentMap getParentMap() {
            return this.parentMap;
        }

        @Override
        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        @Override
        public void execute() {
            HashSet hashSet = new HashSet();
            if (this.attributes != null) {
                hashSet.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                hashSet.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                for (int i = 0; i < this.remove.length; ++i) {
                    hashSet.remove(this.remove[i]);
                }
            }
            this.changed = hashSet.toArray();
            Set set = DefaultDiagramModel.getEdges(DefaultDiagramModel.this, this.changed);
            if (this.firstExecute) {
                this.firstExecute = false;
                if (this.attributes != null && this.attributes.keySet().size() == 1) {
                    Object k = this.attributes.keySet().iterator().next();
                    Map map = (Map)this.attributes.get(k);
                    if (k instanceof DefaultEdge) {
                        List list = DiagramConstants.getPoints(map);
                        if (this.changed != null && this.changed.length == 1) {
                            map = ((DefaultDiagramCell)this.changed[0]).getAttributes();
                            List list2 = DiagramConstants.getPoints(map);
                            if (list != null && list2 != null) {
                                this.presentation = list.size() != list2.size() ? (list.size() > list2.size() ? MessageFormat.format(Messages.getString("DefaultDiagramModel.PointInserted"), this.presentation) : MessageFormat.format(Messages.getString("DefaultDiagramModel.PointDeleted"), this.presentation)) : MessageFormat.format(Messages.getString("DefaultDiagramModel.PointMoved"), this.presentation);
                            }
                        }
                    } else {
                        Rectangle2D rectangle2D = DiagramConstants.getBounds(map);
                        if (this.changed != null && this.changed.length == 1) {
                            map = ((DefaultDiagramCell)this.changed[0]).getAttributes();
                            Rectangle2D rectangle2D2 = DiagramConstants.getBounds(map);
                            if (rectangle2D != null && rectangle2D2 != null) {
                                this.presentation = rectangle2D.getWidth() != rectangle2D2.getWidth() || rectangle2D.getHeight() != rectangle2D2.getHeight() ? MessageFormat.format(Messages.getString("DefaultDiagramModel.Resize"), this.presentation) : MessageFormat.format(Messages.getString("DefaultDiagramModel.Move"), this.presentation);
                            }
                        }
                    }
                }
            }
            this.context = set.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultDiagramModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = DefaultDiagramModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = DefaultDiagramModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultDiagramModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = DefaultDiagramModel.this.handleAttributes(this.attributes);
            this.changed = hashSet.toArray();
            DefaultDiagramModel.this.fireDiagramChanged(DefaultDiagramModel.this, this);
        }

        @Override
        public void putViews(DiagramLayoutCache diagramLayoutCache, CellView[] cellViewArray) {
            if (diagramLayoutCache != null && cellViewArray != null) {
                this.cellViews.put(diagramLayoutCache, cellViewArray);
            }
        }

        @Override
        public CellView[] getViews(DiagramLayoutCache diagramLayoutCache) {
            return (CellView[])this.cellViews.get(diagramLayoutCache);
        }

        @Override
        public String toString() {
            int n;
            String string = new String();
            if (this.inserted != null) {
                string = string + Messages.getString("DefaultDiagramModel.Inserted");
                for (n = 0; n < this.inserted.length; ++n) {
                    string = string + "  " + this.inserted[n] + "\n";
                }
            } else {
                string = string + Messages.getString("DefaultDiagramModel.NoneInserted");
            }
            if (this.removed != null) {
                string = string + Messages.getString("DefaultDiagramModel.Removed");
                for (n = 0; n < this.removed.length; ++n) {
                    string = string + "  " + this.removed[n] + "\n";
                }
            } else {
                string = string + Messages.getString("DefaultDiagramModel.NoneRemoved");
            }
            if (this.changed != null && this.changed.length > 0) {
                string = string + Messages.getString("DefaultDiagramModel.Changed");
                for (n = 0; n < this.changed.length; ++n) {
                    string = string + "  " + this.changed[n] + "\n";
                }
            } else {
                string = string + Messages.getString("DefaultDiagramModel.NoneChanged");
            }
            string = this.parentMap != null ? string + this.parentMap.toString() : string + Messages.getString("DefaultDiagramModel.NoParentMap");
            return string;
        }

        public void setInProgress_(boolean bl) {
            this.inProgress_ = bl;
        }

        public String getPresentation() {
            return this.presentation;
        }

        public void setPresentation(String string) {
            this.presentation = string;
        }

        @Override
        public String getRedoPresentationName() {
            return MessageFormat.format(Messages.getString("DefaultDiagramModel.Redo"), this.presentation);
        }

        @Override
        public String getUndoPresentationName() {
            return MessageFormat.format(Messages.getString("DefaultDiagramModel.Undo"), this.presentation);
        }
    }
}

