/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.plaf.FontUIResource;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultRealEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;

public class DefaultDiagramCellEditor
implements ActionListener,
DiagramCellEditor,
DiagramSelectionListener,
Serializable {
    protected DiagramCellEditor realEditor;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offsetX;
    protected transient int offsetY;
    protected transient AbstractDiagram diagram;
    protected transient Object lastCell;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultDiagramCellEditor() {
        this(null);
    }

    public DefaultDiagramCellEditor(DiagramCellEditor diagramCellEditor) {
        this.realEditor = diagramCellEditor;
        if (this.realEditor == null) {
            this.realEditor = this.createDiagramCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Component getDiagramCellEditorComponent(AbstractDiagram abstractDiagram, Object object, boolean bl) {
        this.setDiagram(abstractDiagram);
        this.editingComponent = this.realEditor.getDiagramCellEditorComponent(abstractDiagram, object, bl);
        this.determineOffset(abstractDiagram, object, bl);
        this.canEdit = this.lastCell != null && object != null && this.lastCell.equals(object);
        CellView cellView = abstractDiagram.getDiagramLayoutCache().getMapping(object, false);
        if (cellView != null) {
            this.setFont(DiagramConstants.getFont(cellView.getAllAttributes()));
        }
        this.editingContainer.setFont(this.font);
        return this.editingContainer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        if (!this.realEditor.isCellEditable(eventObject)) {
            return false;
        }
        if (this.canEditImmediately(eventObject)) {
            bl = true;
        }
        if (bl) {
            this.prepareForEditing();
        }
        return bl;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.realEditor.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            if (this.editingComponent != null) {
                this.editingContainer.remove(this.editingComponent);
            }
            this.editingComponent = null;
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.removeCellEditorListener(cellEditorListener);
    }

    @Override
    public void valueChanged(DiagramSelectionEvent diagramSelectionEvent) {
        if (this.diagram != null) {
            this.lastCell = this.diagram.getSelectionCount() == 1 ? this.diagram.getSelectionCell() : null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.diagram != null) {
            this.diagram.startEditingAtCell(this.lastCell);
        }
    }

    protected void setDiagram(AbstractDiagram abstractDiagram) {
        if (this.diagram != abstractDiagram) {
            if (this.diagram != null) {
                this.diagram.removeDiagramSelectionListener(this);
            }
            this.diagram = abstractDiagram;
            if (this.diagram != null) {
                this.diagram.addDiagramSelectionListener(this);
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return eventObject == null;
    }

    protected boolean inHitRegion(double d, double d2) {
        Rectangle2D rectangle2D;
        return this.lastCell == null || this.diagram == null || (rectangle2D = this.diagram.getCellBounds(this.lastCell)) == null || !(d <= rectangle2D.getX() + (double)this.offsetX) || !(d2 <= rectangle2D.getY() + (double)this.offsetY) || !((double)this.offsetX < rectangle2D.getWidth() - 5.0);
    }

    protected void determineOffset(AbstractDiagram abstractDiagram, Object object, boolean bl) {
        this.editingIcon = null;
        this.offsetX = abstractDiagram.getHandleSize();
        this.offsetY = abstractDiagram.getHandleSize();
    }

    protected void prepareForEditing() {
        this.editingContainer.add(this.editingComponent);
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected DiagramCellEditor createDiagramCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultRealEditor defaultRealEditor = new DefaultRealEditor(new DefaultTextField(border)){

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                boolean bl = super.shouldSelectCell(eventObject);
                this.getComponent().requestFocus();
                return bl;
            }
        };
        defaultRealEditor.setClickCountToStart(1);
        return defaultRealEditor;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.realEditor instanceof Serializable) {
            vector.addElement("realEditor");
            vector.addElement(this.realEditor);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("realEditor")) {
            this.realEditor = (DiagramCellEditor)vector.elementAt(++n);
            ++n;
        }
    }

    public class EditorContainer
    extends Container {
        public EditorContainer() {
            this.setLayout(null);
        }

        @Override
        public void paint(Graphics graphics) {
            Color color;
            Dimension dimension = this.getSize();
            if (DefaultDiagramCellEditor.this.editingIcon != null) {
                int n = 0;
                int n2 = 0;
                DefaultDiagramCellEditor.this.editingIcon.paintIcon(this, graphics, n2, n);
            }
            if ((color = DefaultDiagramCellEditor.this.getBorderSelectionColor()) != null) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            super.paint(graphics);
        }

        @Override
        public void doLayout() {
            if (DefaultDiagramCellEditor.this.editingComponent != null) {
                Dimension dimension = this.getSize();
                int n = (int)DefaultDiagramCellEditor.this.editingComponent.getPreferredSize().getHeight();
                int n2 = 45;
                int n3 = (int)DefaultDiagramCellEditor.this.editingComponent.getPreferredSize().getWidth() + 5;
                int n4 = (int)DefaultDiagramCellEditor.this.editingComponent.getMaximumSize().getWidth();
                n3 = DefaultDiagramCellEditor.this.editingContainer.getParent() != null && n4 > DefaultDiagramCellEditor.this.editingContainer.getParent().getWidth() ? dimension.width - DefaultDiagramCellEditor.this.offsetX : Math.max(n2, Math.min(n3, n4));
                DefaultDiagramCellEditor.this.editingComponent.setBounds(DefaultDiagramCellEditor.this.offsetX, DefaultDiagramCellEditor.this.offsetY, n3, n);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (DefaultDiagramCellEditor.this.editingComponent != null) {
                Dimension dimension = DefaultDiagramCellEditor.this.editingComponent.getPreferredSize();
                dimension.width += DefaultDiagramCellEditor.this.offsetX + 2;
                dimension.height += DefaultDiagramCellEditor.this.offsetY + 2;
                int n = 50;
                if (DefaultDiagramCellEditor.this.editingIcon != null) {
                    n = Math.max(DefaultDiagramCellEditor.this.editingIcon.getIconWidth(), n);
                }
                dimension.height = Math.max(dimension.height, 24);
                dimension.width = Math.max(dimension.width + 5, n);
                return dimension;
            }
            return new Dimension(0, 0);
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            this.border = border;
        }

        @Override
        public Border getBorder() {
            return this.border;
        }

        @Override
        public Font getFont() {
            Container container;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (container = this.getParent()) != null && container.getFont() != null) {
                font = container.getFont();
            }
            return font;
        }
    }
}

