/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class BasicMarqueeHandler {
    protected Point start;
    protected Point current;
    protected Rectangle bounds;
    protected PortView port;
    protected PortView firstPort;
    protected PortView lastPort;
    protected transient Cursor previousCursor = null;
    protected Rectangle2D marqueeBounds;
    protected Point2D startPoint;
    protected Point2D currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && this.marqueeBounds != null) {
                if (!(mouseEvent.getSource() instanceof AbstractDiagram)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
                }
                AbstractDiagram abstractDiagram = (AbstractDiagram)mouseEvent.getSource();
                Rectangle2D rectangle2D = abstractDiagram.fromScreen(DiagramConstants.createRect(this.marqueeBounds));
                CellView[] cellViewArray = abstractDiagram.getDiagramLayoutCache().getRoots(rectangle2D);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < cellViewArray.length; ++i) {
                    if (!rectangle2D.contains(cellViewArray[i].getBounds())) continue;
                    arrayList.add(cellViewArray[i].getCell());
                }
                Object[] objectArray = arrayList.toArray();
                abstractDiagram.getUI().selectCellsForEvent(abstractDiagram, objectArray, mouseEvent);
                abstractDiagram.setCursor(this.previousCursor);
                Rectangle rectangle = new Rectangle((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth() + 1, (int)this.marqueeBounds.getHeight() + 1);
                ++rectangle.width;
                ++rectangle.height;
                abstractDiagram.repaint(rectangle);
                if (abstractDiagram instanceof Diagram) {
                    ((Diagram)abstractDiagram).getAppView().getCurrentDPV().fireSelectionChanged();
                }
            }
        }
        finally {
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
    }

    private boolean drawLine(Diagram diagram) {
        return diagram.getDrawnObjectID() == 1 || diagram.getDrawnObjectID() == 3;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.startPoint != null && !this.drawLine((Diagram)mouseEvent.getSource())) {
            if (!(mouseEvent.getSource() instanceof AbstractDiagram)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
            }
            AbstractDiagram abstractDiagram = (AbstractDiagram)mouseEvent.getSource();
            Graphics graphics = abstractDiagram.getGraphics();
            Color color = abstractDiagram.getBackground();
            Color color2 = abstractDiagram.getMarqueeColor();
            graphics.setColor(color2);
            graphics.setXORMode(color);
            this.overlay(graphics);
            this.currentPoint = mouseEvent.getPoint();
            this.marqueeBounds = DiagramConstants.createRect(this.startPoint);
            this.marqueeBounds.add(this.currentPoint);
            graphics.setColor(color);
            graphics.setXORMode(color2);
            this.overlay(graphics);
        }
    }

    public void paint(Graphics graphics) {
        this.overlay(graphics);
    }

    public void overlay(Graphics graphics) {
        if (this.marqueeBounds != null) {
            graphics.drawRect((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth(), (int)this.marqueeBounds.getHeight());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!(mouseEvent.getSource() instanceof AbstractDiagram)) {
            throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
        }
        AbstractDiagram abstractDiagram = (AbstractDiagram)mouseEvent.getSource();
        this.startPoint = mouseEvent.getPoint();
        this.marqueeBounds = DiagramConstants.createRect(this.startPoint);
        this.previousCursor = abstractDiagram.getCursor();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public Rectangle2D getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public Cursor getPreviousCursor() {
        return this.previousCursor;
    }

    public Point2D getStartPoint() {
        return this.startPoint;
    }

    public void setCurrentPoint(Point2D point2D) {
        this.currentPoint = point2D;
    }

    public void setMarqueeBounds(Rectangle2D rectangle2D) {
        this.marqueeBounds = rectangle2D;
    }

    public void setPreviousCursor(Cursor cursor) {
        this.previousCursor = cursor;
    }

    public void setStartPoint(Point2D point2D) {
        this.startPoint = point2D;
    }
}

